
/*
* aud_gio_dbus_ecnr_proxy.h
*
*  Created on: Apr 5, 2016
*      Author: pmh7kor
*/

#ifndef AUD_GIO_DBUS_ECNR_PROXY_H_
#define AUD_GIO_DBUS_ECNR_PROXY_H_

#include "aud_gio_dbus_bus_watcher.h"

//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>

#include <string>
#include <vector>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



#include <stdint.h>
#include <gio/gio.h>

#include "fc_audiomanager_trace_input.h"
#include "fc_audiomanager_main.h"



#include "InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/Diag/ID_CCA_GetDiagResult.h"

#include "../LoopBack/aud_loopback_if.h"

class aud_gio_dbus_ecnr_proxy : public aud_gio_dbus_bus_watcher_IF, public fc_audiomanager_tclTraceInput, public IF_MessageObserver<PO_MessageConfig::enID>
{
private:
  aud_gio_dbus_ecnr_proxy();// : IF_MessageObserver<PO_MessageConfig::enID>("BeepController Observer"){};
  aud_gio_dbus_ecnr_proxy(const aud_gio_dbus_ecnr_proxy&);

  static aud_gio_dbus_ecnr_proxy* _thisProxyInstance;
  /**
  * Pointer to hold gobject
  */
  GDBusProxy*    m_poProxy;

  aud_gio_dbus_bus_watcher*   m_pWatcher;
  std::string         m_busname;
  std::string        m_objpath;
  GBusType           m_bus_type;

  // Create the data object for result list
  tTestResultList m_oFiTestResultObject;

  tVoid vSaveTestResult(tU16 u16TroubleCode, tS16 sResult);

  tVoid vSendTestResultToDiaglog(tVoid);
  tVoid vProcessAsyncCall();
protected:
  virtual void vOnServerAvailable(std::string sBusName);
  virtual void vOnServerUnAvailable(std::string sBusName);

public:
  virtual ~aud_gio_dbus_ecnr_proxy();
  aud_gio_dbus_ecnr_proxy(aud_gio_dbus_bus_watcher* pWatcher, fc_audiomanager_tclApp* poMainAppl, GBusType bus_type);
  virtual tVoid vTraceRx(tU32 /*size*/, tPCUChar /*pcu8Data*/) {}// for handling loopback messages

  void audEcnrStartITCTest_method_call_Async(tU16 ITCValue);

  static void audEcnrStartITCTest_method_call_finish(GDBusProxy  *proxy, GAsyncResult *res, gpointer user_data);

  virtual void MessageNotification(PO_MessageConfig::enID msgID);

  IF_DiagResultHandler* poResultHandler;
  aud_async_call_handler*  m_asynccall;
};

#endif
