/*
* aud_gio_dbus_ecnr_proxy.cpp
*
*  Created on: Apr 5, 2016
*      Author: rjk2kor
*/


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AUDIOMANAGER_AUDPROCPROXY
#include "trcGenProj/Header/aud_gio_dbus_ecnr_proxy.cpp.trc.h"
#endif

#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ITC_RNAIVI
#include "vd_diaglog_itc_definition.h"
#endif
#include "aud_gio_dbus_ecnr_proxy.h"
using namespace std;

#define ECNR_BUS_NAME     "org.bosch.ecnr.service"
#define ECNR_INTERFACE_NAME     "org.bosch.ecnr.service"
#define ECNR_OBJECT_PATH  "/"



aud_gio_dbus_ecnr_proxy *aud_gio_dbus_ecnr_proxy::_thisProxyInstance = NULL;

/********************************************************************************************
*
* FUNCTION:    aud_gio_dbus_ecnr_proxy::aud_gio_dbus_ecnr_proxy()
* Constructor
*
**********************************************************************************************/
aud_gio_dbus_ecnr_proxy::aud_gio_dbus_ecnr_proxy(aud_gio_dbus_bus_watcher* pWatcher, fc_audiomanager_tclApp* poMainAppl, GBusType bus_type) :
  IF_MessageObserver<PO_MessageConfig::enID>("ECNR Proxy")
  , m_poProxy(NULL)
  , m_pWatcher(pWatcher)
  , m_busname(ECNR_BUS_NAME)
  , m_objpath(ECNR_OBJECT_PATH)
  , m_bus_type(bus_type)
  , m_asynccall(poMainAppl->poAsyncCall())
{
  //initialising ,Coverity fix
  poResultHandler=NULL;

  ETG_TRACE_USR4(("aud_gio_dbus_ecnr_proxy() constructor called"));
  if (_thisProxyInstance == NULL)
    _thisProxyInstance = this;


  if (m_pWatcher)
  {
    //Register for notifications with bus name watcher
    if (!m_pWatcher->bRegisterNotifyBusName(m_busname.c_str(), this))
      NORMAL_M_ASSERT_ALWAYS();
  }
  fc_audiomanager_tclApp::theServer()->vRegisterTraceInputs(TRC::enECNRProxy, this);//for sync with arkamys

  // register for diagnosis request and result
  if (InternalCommunicationAdapter::POMessages)
  {
    InternalCommunicationAdapter::POMessages->AddObserver(this, PO_MessageConfig::ID_CCA_GetDiagResult);
  }

}

/********************************************************************************************
*
* FUNCTION:    aud_gio_dbus_ecnr_proxy::~aud_gio_dbus_ecnr_proxy()
* Destructor
*
**********************************************************************************************/
aud_gio_dbus_ecnr_proxy::~aud_gio_dbus_ecnr_proxy()
{
  if (m_pWatcher)
  {
    //Unregister for notifications
    m_pWatcher->vUnRegisterNotifyBusName(m_busname.c_str());
    m_pWatcher = NULL;
  }
  //Delete proxy object
  if (m_poProxy)
  {
    g_object_unref(m_poProxy);//Drop the reference to proxy
    m_poProxy = NULL;
  }

  if (_thisProxyInstance)
  {
    delete _thisProxyInstance;
    _thisProxyInstance = NULL;
  }
  InternalCommunicationAdapter::POMessages->DeRegisterObserver(this);
}

/********************************************************************************************
*
* FUNCTION:    aud_gio_dbus_ecnr_proxy::vOnServerAvailable(string sBusName)
* Function which gets triggered by watcher on service available
*
**********************************************************************************************/
void aud_gio_dbus_ecnr_proxy::vOnServerAvailable(string sBusName)
{
  ETG_TRACE_USR4(("ECNR Server is available now : %s", sBusName.c_str()));

  GError* error = NULL;
  m_poProxy = g_dbus_proxy_new_for_bus_sync(
    m_bus_type,
    G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES,// configured as in audio process proxy for now
    NULL,
    m_busname.c_str(), // bus name  same as interface name
    m_objpath.c_str(), // object path
    ECNR_INTERFACE_NAME, //interface name
    NULL, &error);
  if (m_poProxy == NULL)
  {
    ETG_TRACE_FATAL(("Failed to create a proxy : %s", error->message));
    //Free error
    g_error_free(error);
  }
  else
  {
    ETG_TRACE_USR4(("Proxy to ECNR created successfully"));
  }
}

/********************************************************************************************
*
* FUNCTION:    aud_gio_dbus_ecnr_proxy::vOnServerUnAvailable(string sBusName)
* Function triggered by watcher when service gets unavailable
*
**********************************************************************************************/

void aud_gio_dbus_ecnr_proxy::vOnServerUnAvailable(string sBusName)
{
  ETG_TRACE_USR4(("Server is not available now : %s", sBusName.c_str()));
  if (m_poProxy)
  {
    ETG_TRACE_USR4(("Dropped reference to proxy"));
    g_object_unref(m_poProxy);//Drop the reference to proxy
    m_poProxy = NULL;
  }
}

/********************************************************************************************
*
* FUNCTION:    aud_gio_dbus_ecnr_proxy::MessageNotification(PO_MessageConfig::enID enMsgID)
* Notification function
*
**********************************************************************************************/

/* virtual */ void aud_gio_dbus_ecnr_proxy::MessageNotification(PO_MessageConfig::enID enMsgID)
{
  ETG_TRACE_USR3(("MessageNotification received for MsgID %u", enMsgID))

  switch (enMsgID)
  {
    case PO_MessageConfig::ID_CCA_GetDiagResult:
    {
      // request DTC / ITC from ECNR
      const ID_CCA_GetDiagResult* poMsg
        = InternalCommunicationAdapter::POMessages->QueryMessage<ID_CCA_GetDiagResult>(enMsgID);
      if (NULL == poMsg)
      {
        ETG_TRACE_FATAL(("MessageNotification - could not retrieve message pointer for ID_CCA_GetDiagResult"))
          return;
      }
      poResultHandler = &(poMsg->roResultHandler);
      if (!poMsg->roRequestedITCs.empty())
      {
        ETG_TRACE_USR4(("Requested %d specific results", poMsg->roRequestedITCs.size()));
        for (tU16 i = 0; i < poMsg->roRequestedITCs.size(); i++)
        {
          audEcnrStartITCTest_method_call_Async(poMsg->roRequestedITCs[i]);
        }
      }
        break;
    }
    default:
      break;
  }
}

/********************************************************************************************
*
* FUNCTION:    aud_gio_dbus_ecnr_proxy::audEcnrStartITCTest_method_call_Async(tU16 ITCValue)
* This method gets called when ID_CCA_GetDiagResult PO msg is received
*
**********************************************************************************************/

void aud_gio_dbus_ecnr_proxy::audEcnrStartITCTest_method_call_Async(tU16 ITCValue)
{
  ETG_TRACE_USR4(("audEcnrStartITCTest_method_call_Async() called : %x", ITCValue));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ITC_RNAIVI
  switch (ITCValue)
  {
    // requesting results only for ECNR ITCs like PHONE_ECNR_NBS, PHONE_ECNR_WBS, CARPLAY_PHONE_ECNR_NBS, CARPLAY_PHONE_ECNR_WBS,
    // CARPLAY_FACETIME_ECNR_SWB, VOICE_RECOG_PARAM, BT_VOICE_ECNR_NBS, BT_VOICE_ECNR_WBS, BT_SIRI_ECNR_WBS, CARPLAY_SIRI_ECNR_WBS,
      // ANDROIDAUTO_VR_ECNR_WBS, VPA_ECNR_WBS, WUW_ECNR_WBS
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_01:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_02:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_03:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_04:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_05:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_06:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_09:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0A:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0B:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0C:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0D:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0E:
    case ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0F:
    {
      if (m_poProxy)
      {
        GError* error = NULL;
        gchar* data = NULL;
        g_dbus_proxy_call(m_poProxy, "ecnrStartItcTest", g_variant_new("(i)", ITCValue), G_DBUS_CALL_FLAGS_NONE, -1, NULL, (GAsyncReadyCallback)audEcnrStartITCTest_method_call_finish, NULL);//method call to retrieve ITC Results from ECNR

      }
      else
      {
        ETG_TRACE_USR3(("Proxy object for server not created yet !!"));
      }
      break;
    }
    default:
      break;
  }
#endif
}

/********************************************************************************************
*
* FUNCTION:    aud_gio_dbus_ecnr_proxy::audEcnrStartITCTest_method_call_finish()
*  Gets called when method call is finished, retrieves the response and sends it to diaglog component
*
**********************************************************************************************/

void aud_gio_dbus_ecnr_proxy::audEcnrStartITCTest_method_call_finish(GDBusProxy  *proxy, GAsyncResult *res, gpointer user_data)
{
    ETG_TRACE_USR4(("audEcnrStartITCTest_method_call_finish() called"));
    (void)user_data;
    GError* error = NULL;
    GVariant *_ret;
    gint32 resITCValue;
    guchar resTestResult;
    gint32 resTestErrorCode;

    _ret = g_dbus_proxy_call_finish(proxy, res, &error);
    if (_ret != NULL)
    {
      g_variant_get(_ret, "(iyi)", &resITCValue, &resTestResult, &resTestErrorCode);
      g_variant_unref(_ret);

      ETG_TRACE_USR4((" Received Response from ECNR Server : %d, %d, %d", resITCValue, resTestResult, resTestErrorCode));

      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_thisProxyInstance);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_thisProxyInstance->m_asynccall);

      _thisProxyInstance->m_asynccall->vCall<aud_gio_dbus_ecnr_proxy, tU16, tS16>(_thisProxyInstance, &aud_gio_dbus_ecnr_proxy::vSaveTestResult, (tU16)resITCValue, resTestResult);
      _thisProxyInstance->m_asynccall->vCall<aud_gio_dbus_ecnr_proxy>(_thisProxyInstance, &aud_gio_dbus_ecnr_proxy::vSendTestResultToDiaglog);
    }
    else
    {
      ETG_TRACE_USR3(("Error received on method call finish : %s ", error->message));
      g_error_free(error);
    }

}

/********************************************************************************************
*
* FUNCTION:    aud_gio_dbus_ecnr_proxy::vSaveTestResult(tU16 u16TroubleCode, tS16 sResult)
* To save the test results in TestResult List
*
**********************************************************************************************/

tVoid aud_gio_dbus_ecnr_proxy::vSaveTestResult(tU16 u16TroubleCode, tS16 sResult)
{
  ETG_TRACE_USR3(("vSaveTestResult():=> Trouble code : %x, Result : %i", u16TroubleCode, sResult));
  tTestResult oTestData;

  oTestData.u16ID = u16TroubleCode;
  oTestData.enResult = (tenTestResult)sResult;

  tTestResultList::iterator it = m_oFiTestResultObject.begin();

  for (; it != m_oFiTestResultObject.end(); ++it)
  {
    if (it->u16ID == u16TroubleCode)
    {
      it->enResult = (tenTestResult)sResult;
      break;
    }
  }
  //add the testData to the TestResultList
  if (it == m_oFiTestResultObject.end())
    m_oFiTestResultObject.push_back(oTestData);
}


/*******************************************************************************
** FUNCTION:  aud_gio_dbus_ecnr_proxy::vSendTestResultToDiaglog()
* Send all the Test Results to Diaglog (1 CCA Msg for all results together)  (Method of this application)
*******************************************************************************/

tVoid aud_gio_dbus_ecnr_proxy::vSendTestResultToDiaglog(tVoid)
{
  if (NULL == poResultHandler)
  {
    ETG_TRACE_FATAL(("DiagLog result handler not set"))
      return;
  }

  ETG_TRACE_USR3(("vSendTestResultToDiaglog - sending %u results", m_oFiTestResultObject.size()))
  if (m_oFiTestResultObject.size())
  {
    poResultHandler->vSaveDiagResult(m_oFiTestResultObject);
    m_oFiTestResultObject.clear();
  }
}


