/*
 * aud_gio_dbus_audproc_proxy.h
 *
 *  Created on: Apr 5, 2016
 *      Author: rjk2kor
 */

#ifndef AUD_GIO_DBUS_AUDPROC_PROXY_H_
#define AUD_GIO_DBUS_AUDPROC_PROXY_H_

#include "audioprocess.h"
#include "aud_gio_dbus_bus_watcher.h"

//#define SYSTEM_S_IMPORT_INTERFACE_STRING
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>


#include <string>
#include <vector>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



#include <stdint.h>

#include "fc_audiomanager_trace_input.h"
#include "fc_audiomanager_main.h"

enum AudProc_Error_e
{
  AUDPROC_ERR_OK = 0,
  AUDPROC_ERR_NULL_POINTER = 13,
  AUDPROC_ERR_UNKNOWN = 0xFF
};

enum AudprocSourceSelectMode
{
  AUDPROC_SELECT_SRC_PER_DEV = 1,
  AUDPROC_SELECT_SRC_PER_ID = 2,
  AUDPROC_SELECT_SRC_PER_MDW_SRC_DEF = 3
};

enum AudprocSourceActivity
{
  AUDPROC_SA_PREPARE = 1,
  AUDPROC_SA_ON      = 2,
  AUDPROC_SA_OFF     = 3,
  AUDPROC_SA_PAUSE   = 4,
  AUDPROC_SA_ACTIVATE = 5,
    AUDPROC_SA_DEACTIVATE = 6
};

enum AudprocSourceId
{
  AUD_PROC_SRC_DEFAULT = 0,
  AUD_PROC_SRC_MP = 1,
  AUD_PROC_SRC_BTA = 2,
  AUD_PROC_SRC_AM = 3,
  AUD_PROC_SRC_FM = 4,
  AUD_PROC_SRC_FM_TA = 17,
  AUD_PROC_SRC_DAB = 5,
  AUD_PROC_SRC_DAB_TA = 18,
  AUD_PROC_SRC_HD = 6,
  AUD_PROC_SRC_DRM = 7,
  AUD_PROC_SRC_AUX = 8,
  AUD_PROC_SRC_MICIN_1 = 9,
  AUD_PROC_SRC_MICIN_2 = 10,
  AUD_PROC_SRC_SDS_MICIN = 11,
  AUD_PROC_SRC_VPA = 12,
  AUD_PROC_SRC_XM = 13,
  AUD_PROC_SRC_ECORE_MAIN_1 = 14,
  AUD_PROC_SRC_ECORE_MAIN_2 = 15,
  AUD_PROC_SRC_SPI_MAIN = 16,
  AUD_PROC_SRC_ALL = 33
};

enum AudProcAmbience
{
  AUD_PROC_AMB_PRESET_NATURAL = 0,
  AUD_PROC_AMB_PRESET_LIVE = 1,
  AUD_PROC_AMB_PRESET_CLUB = 2,
  AUD_PROC_AMB_PRESET_LOUNGE = 3
};

enum AudprocSelectMode
{
  AUDPROC_DBUG_DEFAULT = 0,
  AUDPROC_DBUG_PRINT_CURRENT_SERV_STATE = 1,
  AUDPROC_DBUG_PRINT_AUDIO_STATISTIC = 2,
  AUDPROC_DBUG_SET_MIC_LVL_300_MS = 3
};

enum AudprocParamType
{
  AUDPROC_TYPE_UNDEF = 0,
  AUDPROC_TYPE_U8 = 1,
  AUDPROC_TYPE_I8 = 2,
  AUDPROC_TYPE_U16 = 3,
  AUDPROC_TYPE_I16 = 4,
  AUDPROC_TYPE_U32 = 5,
  AUDPROC_TYPE_I32 = 6,
  AUDPROC_TYPE_ARRAY_U8 = 7,
  AUDPROC_TYPE_ARRAY_I8 = 8,
  AUDPROC_TYPE_ARRAY_U16 = 9,
  AUDPROC_TYPE_ARRAY_I16 = 10,
  AUDPROC_TYPE_ARRAY_U32 = 11,
  AUDPROC_TYPE_ARRAY_I32 = 12
};

enum AudprocSrcState
{
  S_SERV_SRC_ON  = 0,
  S_SERV_SRC_OFF = 1
};

#define AUD_PROC_AUTO_VOLUME_OFF    (0)
#define AUD_PROC_AUTO_VOLUME_ON      (1)

#define AUD_PROC_BY_PASS_ACTIVATE_OFF  (0)
#define AUD_PROC_BY_PASS_ACTIVATE_ON  (1)

class aud_gio_dbus_audproc_proxy: public aud_gio_dbus_bus_watcher_IF, public fc_audiomanager_tclTraceInput
{
private:
  aud_gio_dbus_audproc_proxy();
  aud_gio_dbus_audproc_proxy(const aud_gio_dbus_audproc_proxy&);

  /**
   * Pointer to hold gobject
   */
  OrgBoschAudprocService*   m_poProxy;

  aud_gio_dbus_bus_watcher*   m_pWatcher;
  std::string         m_busname;
  std::string            m_objpath;
  GBusType           m_bus_type;

protected:
  virtual void vOnServerAvailable(std::string sBusName);
  virtual void vOnServerUnAvailable(std::string sBusName);

  virtual void vRegisterNotifications();
  virtual void vUnRegisterNotifications();

public:
  virtual ~aud_gio_dbus_audproc_proxy();
  aud_gio_dbus_audproc_proxy(aud_gio_dbus_bus_watcher* pWatcher,GBusType bus_type);
   virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);// for handling loopback messages

  /*
  * Synchronous method calls
  */
  bool get_version_sync(std::vector<tU32>& rfOutVersion,std::string& rfOutVersionString, std::string& rfOutVersionComment);
  bool AudprocGetStatus_sync();
  bool AudprocTerminate_sync();
  bool AudprocSetupDebug(tU8 u8AudprocSelectMode);
  bool AudprocCreate_sync();
  bool AudprocInitialize_sync(tU8 u8AudprocSourceId,const char* AudprocConfigurationFile);
  bool AudprocSetConfiguration_sync(tU8 u8AudprocSourceId,const char* AudprocConfigurationFile);
  bool AudprocDestroy_sync(tU8 u8AudprocSourceId);
  bool AudprocSetParam_sync(tU8 u8AudprocSourceId, tU32 ParameterId, tU8 ParamType,tU32 uParameter,tS32 sParameter);
  AudProc_Error_e AudprocWriteData_sync(tU8 u8AudprocSourceId,tU32 ParameterId,const tU8* ptrdata, tU32 datalength, tU8*& rfOutdata);
  AudProc_Error_e AudprocReadData_sync(tU8 u8AudprocSourceId,tU32 ParameterId,const tU8* ReadInfos, tU32 readinfo_len, tU8*& rfOutdata, tU32 &outdata_len);
  bool AudprocGetAudprocConfiguration_sync(std::string& rfOutDatasetName, std::vector<tU32>& rfOutAudprocProperties);
  bool AudprocStartAudio_sync(tU8 AudprocSourceId);
  bool AudprocStopAudio_sync(tU8 AudprocSourceId);
  bool AudprocMute_sync();
  bool AudprocSourceActivity_sync(tU8 AudprocSourceMapId,tU8 u8AudprocSourceActivity);
  bool AudprocSourceSelect(tU8 u8AudprocSourceSelectMode, tU8 u8AudprocSourceId, const char* AudprocAlsaDev);
  /**
  * TODO: Asynchronous method calls
  */

  /**
  * Properties
  */

  //Setters
  bool    set_aplArkamysAvcActivate(tS32 value);
  bool    set_aplArkamysByPassActivate(tS32 value);
  bool    set_aplArkamysInputLevelDeviation(tS32 value);
  bool    set_aplArkamysCurrentSpeed(tS32 value);
  bool    set_aplArkamysCurrentVolumeStep(tS32 value);
  bool    set_aplArkamysAmbienceSelect(tS32 value);
  bool    set_aplArkamysLevelLoss(tS32 value);
  bool    set_aplArkamysLibraryVersion(std::vector<tS32> value);
  bool    set_aplArkamysCurrentVolumeAttenuation(tS32 value);
  bool    set_aplMicLvlWatchRefInt(tU32 value);
  bool    set_aplMicLvl(tS32 value);
  bool        set_aplAudioMode(tU32 value);
  bool    set_aplArkamysFlush(tS32 value);

  //Getters
  tS32    get_aplArkamysAvcActivate();
  tS32    get_aplArkamysByPassActivate();
  tS32    get_aplArkamysInputLevelDeviation();
  tS32    get_aplArkamysCurrentSpeed();
  tS32    get_aplArkamysCurrentVolumeStep();
  tS32        get_aplArkamysAmbienceSelect();
  tS32    get_aplArkamysLevelLoss();
  std::vector<tS32>  get_aplArkamysLibraryVersion();
  tS32    get_aplArkamysCurrentVolumeAttenuation();
  tU32      get_aplMicLvlWatchRefInt();
  tS32    get_aplMicLvl();
  tU32      get_aplAudioMode();
  tS32        get_aplArkamysFlush();
};



#endif /* AUD_GIO_DBUS_AUDPROC_PROXY_H_ */
