/**
 * @file ArkamysEolInterfaceRNAIVI2.h
 * @author pau4kor
 * @copyright (c) 2019 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSEOLINTERFACE_RNAIVI2_H_
#define ARKAMYSEOLINTERFACE_RNAIVI2_H_
#include <netinet/in.h>

#include "ArkamysConfigRNAIVI2.h"
#include "Arkamys/ArkamysDefines.h"
#include "Arkamys/ArkamysADRInterface.h"
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_DP_FC_AUDIOMANAGER
#include "fc_audiomanager_if.h"
#include "InternalComponentCommunication/Messages/Sound/ID_ArkamysParameter.h"

/**
 * @description member functions are virtual, so that they can be mocked for unit testing
 */
class ArkamysEolInterfaceRNAIVI2
{
public:
   /*
    * Singleton pattern
    */
   static ArkamysEolInterfaceRNAIVI2 *getInstance();
   virtual ~ArkamysEolInterfaceRNAIVI2();

   /*
    * Initialization
    */
   virtual tBool loadEolData();
   virtual tBool checkEOLContent(tS32 s32FileSize);
   virtual void setArkamysAudioMode(tenArkamysMode enArkamysMode);

   virtual tBool isDataFromDatapool();

   // From Lib 1.0.0
   virtual tU32 getEOLArkamysLibVersion();
   virtual tU32 getEolFileGenerationDate();
   virtual tU32 getEOLLibType();
   virtual tU32 getEOLSteeringConfigurationType();
   virtual tU32 getEOLFileSize();

   /*
    * Feature control
    */
   virtual tBool SendFlush();
   virtual tBool setVirtualSubwoofer(tU8 u8State);
   virtual tBool requestLibVersion();
   virtual tBool setArkamysMode(tU8 u8ArkamysMode);
   virtual tBool setArkamysSrcGrp(tU8 u8ArkamysSrc);
   /*
    * For Debug purposes: Write contents of EOL Datapool to /tmp/EOL.bin
    */
   virtual void DebugWriteEol();

   virtual tBool bLoadEOLDataFromFile(tS32 &s32Size);

private:
#ifdef __AUDIO_UNIT_TESTING__
   FRIEND_TEST(ArkamysTestsRNAIVI2, EOLInvalidDataLoad);
   FRIEND_TEST(ArkamysTestsRNAIVI2, EOLDataLoad);
   FRIEND_TEST(ArkamysTestsRNAIVI2, SendFlush);
   FRIEND_TEST(ArkamysTestsRNAIVI2, SendMode);
#endif
   ArkamysEolInterfaceRNAIVI2();

   /*
    *  Persistent R/O Data (Stored in Datapool by Diagnosis or Default setting)
    */

   tU8  m_u8EolData[ARKAMYS_EOL_MAX_DP_SIZE];

   tU8 *m_pEolData;
   tBool m_bDataLoadedFromDatapool;

   tenArkamysMode m_enArkamysMode;

   /*
    *  Helper functions
    */
   virtual void vSendDataToASPP(tU16 u16BlockID, tU16 u16ParamID, tU32 u32length, tU32 u32Data);
   virtual void RequestDataFromASPP(tU32 address, tU32 length);

};

#endif /* ARKAMYSEOLINTERFACE_RNAIVI2_H_ */
