/**
 * @file ArkamysConfigRNAIVI2.h
 * @author pau4kor
 * @copyright (c) 2019 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSCONFIG_RNAIVI2_H_
#define ARKAMYSCONFIG_RNAIVI2_H_

#include "system_types.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3SourceType.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3ArkamysDefines.h"
#include "Arkamys/ArkamysDefines.h"

#ifndef ASSERT_STATIC
#define ASSERT_STATIC(_b) { switch(1){ default: case false:break; case (_b):break; }; }
#endif


#define ARKAMYS_LIB_MIN_VERSION   (0x00010100)
#define ARKAMYS_LIB_MAX_VERSION   (0x00010202)

#define ARKAMYS_LIBTYPE_CLASSIC 0x434C4153

#define ARKAMYS_LIB_ACK_ADDR  0xEEEEEEEE//spl. handling for ACK msgs

#define ARKAMYS_EOL_HEADER_SIZE_BYTE_IVI2 (sizeof(ArkamysConfigRNAIVI2::tArkamysEolHeader))

class ArkamysConfigRNAIVI2
{
private:
   //lint --e{1704} Constructor 'ArkamysConfigRNAIVI2::ArkamysConfigRNAIVI2(void)' has private access specification
   ArkamysConfigRNAIVI2();
#ifdef __AUDIO_UNIT_TESTING__
   FRIEND_TEST(ArkamysTestsRNAIVI2, ConfigCheck);
   FRIEND_TEST(ArkamysTestsRNAIVI2, ArkamysSourceGrps);
#endif
public:
   virtual ~ArkamysConfigRNAIVI2();
   static void ArkamysInit();

   typedef enum
   {
      ARK_LIB_BYPASS = 0x00,
      ARK_BASS_ENHANCER,
      ARK_LIB_VERSION,
      ARK_EOL_DATA,
      ARK_LIB_FLUSH,
      ARK_LIB_SOURCE,
      ARK_PARAM_MAX
   } tenArkamysParam;

   typedef struct
   {
       tenArkamysParam arkIdentifier;
       tU16 arkblockid;
       tU16 arkparamid;
       tU32 size;
   }tArkParamList;
   static tArkParamList oArkamysParamList[];

//ToDO : adapt to latest EOL format
   typedef struct {
    tU32 EolFileGenerationDate;
    tU32 CarManufacturer;
    tU32 RadioManufacturer;
    tU32 RadioProject[2];
    tU32 VehicleID[5];
    tU32 TuningDate;
    tU32 TuningPlace[2];
    tU32 TuningVersion;
    tU32 TuningTargetVersion;
    tU32 SpeakerConfiguration;
    tU32 LibType;
    tU32 ArkamysLibVersion;
    tU32 ArkamysSATVersion;
    tU32 RadioSWVersion[2];
    tU32 ConfigurationType;
    tU32 DataSize;
    tU32 GlobalCRC;
    tU32 reserved;
   } tArkamysEolHeader;

   typedef enum
   {
      ARKAMYS_SOURCE_PRIMARY,
      ARKAMYS_SOURCE_SECONDARY,
      ARKAMYS_SOURCE_OTHER,
      ARKAMYS_SOURCE_INVALID = 0xFF
   } tenSrcSetting;

   typedef enum
   {
      ARKAMYS_GRP_ANALOG_TUNER,
      ARKAMYS_GRP_DIGITAL_TUNER,
      ARKAMYS_GRP_ANALOG_OTHER,
      ARKAMYS_GRP_DIGITAL_OTHER,
      ARKAMYS_GRP_ANNOUNCEMENT = 0xFE,
      ARKAMYS_GRP_UNDEFINED = 0xFF,
   } tenSrcGrpSetting;

   typedef enum
   {
      ARKAMYS_FEATURE_VIRTUAL_SUBWOOFER,
      ARKAMYS_FEATURE_INVALID = 0xFF
   } tenArkamysFeature;


   typedef enum
   {
      ARKAMYS_AMP_INTERNAL_AMPLIFIER,
      ARKAMYS_AMP_PREMIUM_1,
      ARKAMYS_AMP_PREMIUM_2,
      ARKAMYS_AMP_INVALID = 0xFF
   } tenArkamysAmplifier;

   typedef enum
   {
      ARKAMYS_DEV_CLASSIC_ONLY,
      ARKAMYS_DEV_ALL_OTHER,
      ARKAMYS_DEV_INVALID = 0xFF
   } tenArkamysDeviceVariant;


   typedef enum
   {
      ARKAMYS_EOL_CLASSIC = 1,
      ARKAMYS_EOL_INVALID = 0xFF
   } tenArkamysEOLLib;

    typedef enum
    {
      STATE_OFF = 0,
      STATE_ON = 1,
      STATE_LINEAR = 2,
      STATE_UNKNOWN = 0xFF
    }tenArkamysFeatureState;

   static tenSrcSetting getArkamysSource(tenStream stream, tenSourceType sourceType);
   static tArkParamList* getArkamysParamConfig(tenArkamysParam enArkamysParam);
   static tenSrcGrpSetting getArkamysSourceGrp(tenInternalSource enIntSource);
};

#endif /* ARKAMYSCONFIG_RNAIVI2_H_ */
