/* **** Note on AkActionQueueRNAIVI2 ****
 * With AkActionQueueRNAIVI2.Add, a new Action is added to the Action Queue.
 * Actions will be performed in the order they were added.
 * When a "Wait" Action is reached, the queue stops until the designated event occurs (i.e. Muted/Demuted, ...)
 * To start the Queue, the "Continue" event is sent.
 * The queue automatically sets the ArkamysFeatureHandlerRNAIVI2 state to busy as first item and to idle when all items are ready
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ARKAMYS
#include "trcGenProj/Header/AkActionQueueRNAIVI2.cpp.trc.h"
#endif
#include "AkActionQueueRNAIVI2.h"
#include "ArkamysFeatureHandlerRNAIVI2.h"

void AkActionQueueRNAIVI2::Event(AkActionRNAIVI2::tenAkEvent akEvent)
{
   if (m_qActions.empty())
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI2::Event(%i): Queue empty. Nothing to do.", ETG_CENUM(AkActionRNAIVI2::tenAkEvent, akEvent)));
      AkActionRNAIVI2(AkActionRNAIVI2::ARKAMYS_ACTION_SET_SM_STATE, ArkamysFeatureHandlerRNAIVI2::ARKAMYS_FEATURE_STATE_IDLE).Perform();
      return;
   }
   if (akEvent == AkActionRNAIVI2::ARKAMYS_EVENT_CONTINUE || m_qActions.front().IsEventValid(akEvent))
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI2::Event(%i)", ETG_CENUM(AkActionRNAIVI2::tenAkEvent, akEvent)));
      if (m_qActions.front().IsEventValid(akEvent)) // wait or timeout event
      {
         m_qActions.pop();
         ArkamysFeatureHandlerRNAIVI2::getInstance() -> vStopTimer();
      }
      bool cont = true;
      while (cont && !m_qActions.empty())
      {
         cont = m_qActions.front().Perform();
         if (cont)
         {
            m_qActions.pop();
         }
      }

      if (!m_qActions.empty())
      {
         ETG_TRACE_USR4(("Queue stopped. Items left: %i", m_qActions.size()));
      } else
      {
         AkActionRNAIVI2(AkActionRNAIVI2::ARKAMYS_ACTION_SET_SM_STATE, ArkamysFeatureHandlerRNAIVI2::ARKAMYS_FEATURE_STATE_IDLE).Perform();
         ETG_TRACE_USR4(("Queue empty."));
      }
   }
   else if (akEvent == AkActionRNAIVI2::ARKAMYS_EVENT_TIMEOUT)
   {
      ETG_TRACE_ERR(("AkActionQueueRNAIVI2 received timeout. Cancelling queue."));
      Cancel();
   }
   else
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI2::Nothing to do for Event(%i).", ETG_CENUM(AkActionRNAIVI2::tenAkEvent, akEvent)));
   }
}

void AkActionQueueRNAIVI2::Cancel()
{
   queue<AkActionRNAIVI2>::size_type itemCount = Size();
   queue<AkActionRNAIVI2> empty;
   swap(m_qActions, empty);
   //demute added to prevent system getting stuck in mute state
   AkActionRNAIVI2(AkActionRNAIVI2::ARKAMYS_ACTION_DEMUTE, ArkamysFeatureHandlerRNAIVI2::ARKAMYS_FEATURE_STATE_INIT).Perform();
   AkActionRNAIVI2(AkActionRNAIVI2::ARKAMYS_ACTION_SET_SM_STATE, ArkamysFeatureHandlerRNAIVI2::ARKAMYS_FEATURE_STATE_IDLE).Perform();
   ETG_TRACE_USR4(("AkActionQueueRNAIVI2::Cancel() - %i items removed.", itemCount));
}

queue<AkActionRNAIVI2>::size_type AkActionQueueRNAIVI2::Size()
{
   return m_qActions.size();
}

bool AkActionQueueRNAIVI2::IsEmpty()
{
   return m_qActions.empty();
}

void AkActionQueueRNAIVI2::Add(AkActionRNAIVI2 a)
{
   if (IsEmpty())
   {
      m_qActions.push(AkActionRNAIVI2(AkActionRNAIVI2::ARKAMYS_ACTION_SET_SM_STATE, ArkamysFeatureHandlerRNAIVI2::ARKAMYS_FEATURE_STATE_BUSY));
   }
   if (a.m_Action == AkActionRNAIVI2::ARKAMYS_ACTION_WAIT_EVENT)
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI2::Add(%i, %i)", ETG_CENUM(AkActionRNAIVI2::tenAkAction, a.m_Action), ETG_CENUM(AkActionRNAIVI2::tenAkEvent, a.m_Parameter)));
   } else
   {
      ETG_TRACE_USR4(("AkActionQueueRNAIVI2::Add(%i, %i)", ETG_CENUM(AkActionRNAIVI2::tenAkAction, a.m_Action), a.m_Parameter));
   }
   m_qActions.push(a);
}


