/**
 * @file ArkamysStateCalculatorRNAIVI.h
 * @author pau4kor
 * @copyright (c) 2015 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSSTATECALCULATOR_RNAIVI_H_
#define ARKAMYSSTATECALCULATOR_RNAIVI_H_

#include "system_types.h"
#include "ArkamysConfigRNAIVI.h"

class ArkamysStateCalculatorRNAIVI
{
public:

   static tenArkamysMode enCalculateArkamysMode(ArkamysConfigRNAIVI::tenArkamysAmplifier enAmplifier,
                                              ArkamysConfigRNAIVI::tenArkamysEOLLib enLibType,
                          tBool bLibraryMatch,
                          ArkamysConfigRNAIVI::tenArkamysDeviceVariant enDevice);

   //classic related settings
   static tU8 u8CalculateVirtualSubwooferState(tBool bEngineeringMode, ArkamysConfigRNAIVI::tenSrcSetting enSource, tBool bRequestedMode
                                             , tenArkamysMode enArkamysMode);
   static tU8 u8CalculateSSS4State(tBool bEngineeringMode, ArkamysConfigRNAIVI::tenSrcSetting enSource , tenArkamysMode enArkamysMode);

   //auditorium related settings
   static ArkamysConfigRNAIVI::tenAuditoriumAmbiance enCalculateAmbianceState(tBool bEnginieeringMode,
                                                                         ArkamysConfigRNAIVI::tenAuditoriumAmbiance enUserSetting,
                                       ArkamysConfigRNAIVI::tenSrcSetting enSource
                                       , tenArkamysMode enArkamysMode);

   static tU8 u8CalculateFMEnhancer2State(tBool bEngineeringMode, tBool bRequestedMode , tBool bDiagAudMode, tenArkamysMode enArkamysMode);
   static tU8 u8CalculateAGCState(tBool bEngineeringMode, tBool bRequestedMode , tenArkamysMode enArkamysMode);

   //common setting
   static tU8 u8CalculateFMEnhancerState(tBool bEngineeringMode, ArkamysConfigRNAIVI::tenSrcSetting enSource, tBool bDiagAudMode, tenArkamysMode enArkamysMode);

};

#endif /* ARKAMYSSTATECALCULATOR_RNAIVI_H_ */
