/**
 * @file ArkamysFeatureHandlerRNAIVI.h
 * @author pau4kor
 * @copyright (c) 2015 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSFEATUREHANDLER_RNAIVI_H_
#define ARKAMYSFEATUREHANDLER_RNAIVI_H_

#include "Arkamys/ArkamysADRInterface.h"
#include "ArkamysEolInterfaceRNAIVI.h"
#include "ArkamysConfigRNAIVI.h"
#include "Arkamys/ArkamysCommInterface.h"
#include "AkActionQueueRNAIVI.h"
#include "InternalComponentCommunication/Messages/Sound/ID_ArkamysParameter.h"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeOffsetData.h"
#include "InternalComponentCommunication/Messages/mute/IDSetMute.h"
#include "InternalComponentCommunication/Messages/Volume/IDSetVolumeOffset.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "fc_audiomanager_main.h"
#include "mute/stream/StreamMuteNotify_IF.h"
#include "InternalComponentCommunication/Messages/Diag/ID_CCA_GetDiagResult.h"

class ArkamysFeatureHandlerRNAIVI: public StreamMuteNotify_IF, public IF_MessageObserver<PO_MessageConfig::enID>
{
   friend class AkActionRNAIVI;
   friend class AkActionQueueRNAIVI;
   friend class ArkamysEolInterfaceRNAIVI;
   friend class ArkamysTuningHandlerRNAIVI;

public:
   static ArkamysFeatureHandlerRNAIVI* getInstance();
   ~ArkamysFeatureHandlerRNAIVI();

   tBool bStartup(fc_audiomanager_tclApp* poMainAppl);

   void setLinearMode(tBool bLinearModeEnable);
   void setSource(ArkamysConfigRNAIVI::tenSrcSetting enSource);

   void setVirtualSubwoofer(tBool bOn);
   void setFMEnhancer(tBool bOn);

   void Mute();
   void Demute();

   void MessageNotification(PO_MessageConfig::enID MsgId);
   void AdrMessageRx(ID_ArkamysParameter arkamysParameter);

   static void vTimerCallback(tPVoid pvArg);
   void timerExpired(tPVoid pvArg);
   void vAdrOkCallback();
   void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink=1);

   void TraceStatus();
   void SetArkamysCommInterface(ArkamysCommInterface *pArkamysCommInterface);
   void SetArkamysADRInterface(ArkamysADRInterface *pArkamysADRInterface);

   tenArkamysMode enGetAudioMode();

   //auditorium related settings
   void ArkamysInputLevelDeviation(tU8 *u8Data, tU16 length);
   void ArkamysLevelLoss(tS16 levelLoss);
   tVoid vSendArkamysCurrentSpeedToAudProc(tS16 speedValue);
   tVoid vSendAGCModeToAudProc(tBool bOn);
   tVoid vSendAmbianceToAudProc(ArkamysConfigRNAIVI::tenAuditoriumAmbiance enAmbianceMode);
   tVoid vSendArkamysBypassModeToAudProc(tBool bBypassMode);
private:
#ifdef __AUDIO_UNIT_TESTING__
   FRIEND_TEST(ArkamysTests, Startup);
   FRIEND_TEST(ArkamysTests, EOLInterface);
   FRIEND_TEST(ArkamysTests, SSS4StateChangeToAllPassengers);
   FRIEND_TEST(ArkamysTests, BassExciter);
   FRIEND_TEST(ArkamysTests, FMEnhancer);
   FRIEND_TEST(ArkamysTests, LinearMode);
   FRIEND_TEST(ArkamysTests, DiagLinearMode);
   FRIEND_TEST(ArkamysTests, DiagAudioMode);
   FRIEND_TEST(ArkamysTests, OtherSources);
   FRIEND_TEST(ArkamysTests, RoomEffect_Natural);
   FRIEND_TEST(ArkamysTests, RoomEffect_Live);
   FRIEND_TEST(ArkamysTests, RoomEffect_Club);
   FRIEND_TEST(ArkamysTests, RoomEffect_Lounge);
   FRIEND_TEST(ArkamysTests, AGC);
   FRIEND_TEST(ArkamysTests, FMEnhancer2);
   FRIEND_TEST(ArkamysTests, LinearModeAud);
   FRIEND_TEST(ArkamysTests, OtherSourcesAud);
   FRIEND_TEST(ArkamysTests, StatesCheck_PrimarySource);
   FRIEND_TEST(ArkamysTests, StatesCheck_SecondarySource);
   FRIEND_TEST(ArkamysTests, StatesCheck_OtherSource);
   FRIEND_TEST(ArkamysTests, StatesCheck_InvalidLibVersion);
   FRIEND_TEST(ArkamysTests, StatesCheck_InvalidSource);
   FRIEND_TEST(ArkamysTests, StatesCheck_UnavailableAudioProc);
   FRIEND_TEST(ArkamysTests, MuteStatus);
   FRIEND_TEST(ArkamysTests, Others);
   FRIEND_TEST(ArkamysTests, AudProc_others);
   FRIEND_TEST(ArkamysTests, CoverageTests);
#endif
   ArkamysFeatureHandlerRNAIVI();
   ArkamysFeatureHandlerRNAIVI(const ArkamysFeatureHandlerRNAIVI&);              // Prohibit use of copy constructor    (Rule of three)
   ArkamysFeatureHandlerRNAIVI& operator =(const ArkamysFeatureHandlerRNAIVI&);  // Prohibit use of assignment operator (Rule of three)

   /*
    * Busy state
    */
   typedef enum {
      ARKAMYS_FEATURE_STATE_INIT,
      ARKAMYS_FEATURE_STATE_IDLE,
      ARKAMYS_FEATURE_STATE_BUSY
   } tenArkamysHandlerState;
   tenArkamysHandlerState m_enState;

   /*
    * Pointers
    */

   InternalCommunicationAdapter  *m_pPO; // Pointer for post office access
   fc_audiomanager_tclApp        *m_poMainAppl;
   ArkamysCommInterface          *m_pArkamysCommInterface;
   tBool                         m_bDeleteArkamysCommInterface;
   ArkamysEolInterfaceRNAIVI     *m_pEolInterface;
   ArkamysADRInterface           *m_pADRInterface;
   tBool                         m_bDeleteArkamysADRInterface;
   AkActionQueueRNAIVI           m_ActionQueue;
   IF_DiagResultHandler*         m_poResultHandler;

   /*
    * System Settings
    */
   tU32  m_u32ReportedArkamysLib;      // Library version reported by ADR
   tU8   m_u8MuteRegId;
   tenArkamysMode   m_enArkamysMode;              //update to HMI -> Audio mode
   tBool m_bAudioProcAvailable;
   /*
    * Feature State relevant settings
    */
   tBool m_bEngModeActive;
   tU8 m_u8SoundStageMode;

   ArkamysConfigRNAIVI::tenSrcSetting           m_enCurSourceSetting;

   /*
    * Current Feature Settings
    */
   tU8    m_u8FMEnhancerEnabled;
   tBool  m_bFMEnhancerAvailable;
   tU8    m_u8VirtualSubEnabled;
   tBool  m_bVirtualSubAvailable;
   tBool  m_bFMEnhancerLinearMode;
   void addSSS4ToActionQueue(tBool bOn);

   void addVirtualSubwooferToActionQueue(tBool bOn);
   void addFMEnhancerToActionQueue(tU8 u8On);

   OSAL_tTimerHandle m_hTimer;
   void vStartTimer(OSAL_tMSecond milliseconds);
   void vStopTimer();

   tBool bUpdateVirtualSubwooferState();
   tBool bUpdateSSS4State();
   tBool bUpdateFMEnhancerState();

   void vUpdateStatesAndApply();

   void vResetArkamysSettingsFlags();
   void vSetArkamysMode();

   ArkamysConfigRNAIVI::tenArkamysAmplifier enGetKDSAmplifierInformation();
   ArkamysConfigRNAIVI::tenArkamysDeviceVariant enGetKDSLibInformation();
   ArkamysConfigRNAIVI::tenArkamysEOLLib enGetArkamysEOLLibType();

   void vSetAudioProcAudioMode(tenArkamysMode enArkamysMode);

   /*
    * Auditorium related settings
    */
   ArkamysConfigRNAIVI::tenAuditoriumAmbiance           m_enRequestedAuditoriumAmbianceMode; // the mode chosen by the user
   ArkamysConfigRNAIVI::tenAuditoriumAmbiance           m_enCurAuditoriumAmbianceMode;
   tU8   m_u8FMEnhancer2Enabled;
   tBool m_bFMEnhancer2Available;

   tU8   m_u8AGCEnabled;
   tBool m_bAGCAvailable;

   tS16 m_s16InputLeveDeviation;
   tBool m_bEntStreamMuted;
   tBool bUpdateAmbianceState();
   tBool bUpdateFMEnhancer2State();
   tBool bUpdateAGCState();

   tVoid vSetAmbiance(ArkamysConfigRNAIVI::tenAuditoriumAmbiance enAmbMode);
   tVoid vSetFMEnhancer2(tenSourceType enSourceType);
   tVoid vSetAGCMode(tBool bOn);

   void addAmbianceAudProcToActionQueue(ArkamysConfigRNAIVI::tenAuditoriumAmbiance enAmbianceMode);
   void addAmbianceToActionQueue(ArkamysConfigRNAIVI::tenAuditoriumAmbiance enAmbianceMode);
   void addFMEnhancer2ToActionQueue(tBool bOn);
   void addAGCAudProcToActionQueue(tBool bOn);
   tU32 u32GetIMXLibVersion();
   //Diaglog Related
   void vHandleGetDiagResult();
};

#endif /* ARKAMYSFEATUREHANDLER_RNAIVI_H_ */
