/**
 * @file ArkamysEolInterfaceRNAIVI.h
 * @author pau4kor
 * @copyright (c) 2015 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSEOLINTERFACE_RNAIVI_H_
#define ARKAMYSEOLINTERFACE_RNAIVI_H_
#include <netinet/in.h>

#include "ArkamysConfigRNAIVI.h"
#include "Arkamys/ArkamysDefines.h"
#include "Arkamys/ArkamysADRInterface.h"
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_DP_FC_AUDIOMANAGER
#include "fc_audiomanager_if.h"
#include "InternalComponentCommunication/Messages/Sound/ID_ArkamysParameter.h"
#include "InternalComponentCommunication/Messages/Equ_Filter/IDSetFilter.h"

#include "Sound/ArkamysTuningHandlerRNAIVI.h"

#define FM_ENHANCER_MSG_LENGTH (21)
#define FM_ENHANCER_FILTERS (3)
/**
 * @description member functions are virtual, so that they can be mocked for unit testing
 */
class ArkamysEolInterfaceRNAIVI
{
public:
   /*
    * Singleton pattern
    */
   static ArkamysEolInterfaceRNAIVI *getInstance();
   virtual ~ArkamysEolInterfaceRNAIVI();

   /*
    * Initialization
    */
   virtual tBool loadEolData();
   virtual tBool checkEOLHeader();
   virtual tBool checkEOLFileSize(tS32 s32FileSize);
   //virtual void setRightSteering(tBool bRightSteering);
   virtual void setArkamysAudioMode(tenArkamysMode enArkamysMode);
   //virtual tBool getRightSteering();

   virtual tBool isDataFromDatapool();

   // From Lib 1.2.0
   virtual tU32 getEOLADR3LibVersion();
   virtual tU32 getEOLIMXLibVersion();
 //  virtual tU32 getEOLPreProcAddress();
 //  virtual tU32 getEOLBypassFunc();
 //  virtual tU32 getEOLResetFunc();
   virtual tU32 getEolFileGenerationDate();
   virtual tU32 getEOLLibType();
   virtual tU32 getEOLSteeringConfigurationType();
 //  virtual tU32 getEOLBassExciterOffOffset();
 //  virtual tU32 getEOLSoundStagingOffset();
 //  virtual tU32 getEOLFMEnhancerOffset();
   virtual tU32 getEOLFileSize();

   /*
    * Feature control
    */
   virtual tBool setSSS4(tBool bOn, tUInt uiDataSetIdx);
   virtual tBool SendResetPreProc();
   virtual tBool setVirtualSubwoofer(tU8 u8State, tUInt uiDataSetIdx);
   virtual tBool setFMEnhancer(tBool bOn);
   virtual tBool requestLibVersion();
   virtual tBool setArkamysMode(tU8 u8ArkamysMode);

   /*
    * Auditorium features
    */
   virtual tBool setAmbiance(ArkamysConfigRNAIVI::tenAuditoriumAmbiance enAkAmbiance, tUInt uiDataSetIdx);
   virtual tBool setFMEnhancer2(tBool bOn, tUInt uiDataSetIdx);

   /*
    * Retrieve number of datasets in flat config for given feature
    * @param enFeature Feature to retrieve flat config dataset count
    * @return Count of datasets (may be 0 if feature has no flat configuration)
    */
  // virtual tU32 GetFlatDataCount(ArkamysConfigRNAIVI::tenArkamysFeature enFeature);

   /*
    * For Debug purposes: Write contents of EOL Datapool to /tmp/EOL.bin
    */
   virtual void DebugWriteEol();

   virtual tBool bLoadEOLDataFromFile(tS32 &s32Size);
private:
#ifdef __AUDIO_UNIT_TESTING__
   FRIEND_TEST(ArkamysTests, EOLFileSize_PositiveTestCases);
   FRIEND_TEST(ArkamysTests, EOLFileSize_NegativeTestCases);
   FRIEND_TEST(ArkamysTests, SendMode);
   FRIEND_TEST(ArkamysTests, EOLDataLoad);
   FRIEND_TEST(ArkamysTests, EOLInvalidDataLoad);
   FRIEND_TEST(ArkamysTests, SendDataToADR);
   FRIEND_TEST(ArkamysTests, SetFeatures);
   FRIEND_TEST(ArkamysTests, AudProc_others);
#endif
   ArkamysEolInterfaceRNAIVI();

   /*
    *  Persistent R/O Data (Stored in Datapool by Diagnosis or Default setting)
    */

   tU8  m_u8EolData[ARKAMYS_EOL_MAX_DP_SIZE];

   tU8 *m_pEolData;
   tBool m_bDataLoadedFromDatapool;

   /*
    *  Persistent Data (Stored in Datapool)
    */
   //tBool m_bRightSteering;
   tenArkamysMode m_enArkamysMode;


   /*
    * Non-Persistent Data (Holds the values from the "flat" addresses for later restoring)
    */

  // tU32 m_VirtualSubwooferNonFlatConfig[ARKAMYS_VIRTUALSUBWOOFER_FLAT_DATA_SIZE_WORDS];
//   tU32 m_SSS4NonFlatConfig[ARKAMYS_SSS4_FLAT_DATA_SIZE_WORDS];

   /*
    *  Helper functions
    */
   virtual tBool WriteDataToADR(const tU32* pData, tU32 length);
   virtual tU16 FillMessageQueue(std::queue<ArkamysStaticMessage> *msgQueue, const tU32* pData, tU32 length);
   virtual void RequestDataFromADR(tU32 address, tU32 length);
   virtual void ResetSSS4(); // Sets a large area to 0 in order to reset SSS4 upon switching from/to flat
   virtual tBool bSetFMEnhancer(const tU8 *u8Data, tU32 u32Length);
   virtual void vUpdateSDHP();
   virtual void vSendMultipleDataToADR(const tU8* pu8Data, tUInt iterations);
   /*
    * Helper Iterator Class
    * (use tU32 or const tU32 as type)
    */
   template <class T> class FlatConfigIterator
   {
   public:
     void Reset(T* flatCfg, tUInt length)         { m_pFlatCfg = flatCfg; m_length = length; m_Cwp = 0; };
     FlatConfigIterator(T* flatCfg, tUInt length) { Reset(flatCfg, length); };
      bool HasMoreDataSets()              { return m_Cwp < m_length && m_pFlatCfg[m_Cwp] != 0; };
      bool Next()                         { if (HasMoreDataSets()) { m_Cwp += 3 + LenHost(); return true; } return false; };
      tU32 LeftAddress()                  { return  m_pFlatCfg[m_Cwp    ]; };
      tU32 RightAddress()                 { return  m_pFlatCfg[m_Cwp + 1]; };
      tU32 Len()                          { return  m_pFlatCfg[m_Cwp + 2]; };
      tU32 LenHost()                      { return  Len(); };
      T*   Data()                         { return &m_pFlatCfg[m_Cwp + 3]; };
      T*   GetCurPointer()                { return &m_pFlatCfg[m_Cwp]; };
      tU32 GetCwp()                       { return  m_Cwp; };
   private:
      FlatConfigIterator();
      tU32  m_Cwp;
      T*    m_pFlatCfg;
      tUInt m_length;
   };

   /*
    * Auditorium features
    */
   ArkamysConfigRNAIVI::tenAuditoriumAmbiance m_enCurAmbiance;

};

#endif /* ARKAMYSEOLINTERFACE_RNAIVI_H_ */
