#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#include "../fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ARKAMYS
#include "trcGenProj/Header/AkActionRNAIVI.cpp.trc.h"
#endif

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_audio_if.h"

#include "ArkamysFeatureHandlerRNAIVI.h"
#include "Arkamys/ArkamysADRInterface.h"
#include "AkActionRNAIVI.h"

bool AkActionRNAIVI::m_bError = false;

AkActionRNAIVI::AkActionRNAIVI(tenAkAction action, tU32 param)
{
  m_Action = action;
  m_Parameter = param;
}

bool AkActionRNAIVI::Perform()
{
   if (m_Action != ARKAMYS_ACTION_WAIT_EVENT)
   {
      m_bError = false;
   }
   ETG_TRACE_USR4(("AkActionRNAIVI::Perform %i Param: %i", ETG_CENUM(AkActionRNAIVI::tenAkAction, m_Action), m_Parameter));
    switch (m_Action)
    {
      case ARKAMYS_ACTION_WAIT_EVENT:
         if (!m_bError)
         {
            // start timeout timer
            ArkamysFeatureHandlerRNAIVI::getInstance() -> vStartTimer(m_waitTimeoutMs);
            return false; // wait
         }
         else
         {
            ETG_TRACE_ERR(("Previous action returned error. Will continue without wait."));
            m_bError = false;
            return true; // continue on error
         }
      case ARKAMYS_ACTION_MUTE:
         ArkamysFeatureHandlerRNAIVI::getInstance() -> Mute();
         return true; // continue
      case ARKAMYS_ACTION_DEMUTE:
         ArkamysFeatureHandlerRNAIVI::getInstance() -> Demute();
         return true; // continue
      case ARKAMYS_ACTION_DEMUTE_FRONT:
         ArkamysFeatureHandlerRNAIVI::getInstance() -> Demute();
         return true; // continue
      case ARKAMYS_ACTION_WAIT_TIMEOUT:
         ArkamysFeatureHandlerRNAIVI::getInstance() -> vStartTimer(static_cast<OSAL_tMSecond>(m_Parameter));
         return false; // wait
      case ARKAMYS_ACTION_SET_SSS4:
      {
         tU16 u16enMode = (tU16)(m_Parameter >> 16);
         tU16 u16Part = (m_Parameter & 0xFFFF);
         m_bError = !ArkamysFeatureHandlerRNAIVI::getInstance() -> m_pEolInterface -> setSSS4(u16enMode != 0, u16Part);//static_cast<tBool>(u16enMode)
         return true; // continue
      }

      case ARKAMYS_ACTION_SET_VIRTUAL_SUB:
      {
         tU16 u16enMode = (tU16)(m_Parameter >> 16);
         tU16 u16Part = (m_Parameter & 0xFFFF);
     ETG_TRACE_USR4(("ARKAMYS_ACTION_SET_VIRTUAL_SUB::u16enMode %i u16Part: %i", u16enMode, u16Part));
         m_bError = !ArkamysFeatureHandlerRNAIVI::getInstance() -> m_pEolInterface -> setVirtualSubwoofer((tU8)u16enMode, u16Part);
         return true; // continue
      }

      case ARKAMYS_ACTION_SET_FM_ENHANCER:
      {
          ETG_TRACE_USR4(("ARKAMYS_ACTION_SET_FM_ENHANCER:: set value %i", m_Parameter));
          m_bError = !ArkamysFeatureHandlerRNAIVI::getInstance() -> m_pEolInterface -> setFMEnhancer(m_Parameter != 0);
          return true; // continue
      }

      case ARKAMYS_ACTION_GET_LIBVERSION:
         m_bError = !ArkamysFeatureHandlerRNAIVI::getInstance() -> m_pEolInterface -> requestLibVersion();
         return true; // continue

      case ARKAMYS_ACTION_SET_SM_STATE:
         ETG_TRACE_USR4(("AkActionRNAIVI: Set State: %i", ETG_CENUM(ArkamysFeatureHandlerRNAIVI::tenArkamysHandlerState, m_Parameter)));
         ArkamysFeatureHandlerRNAIVI::getInstance() -> m_enState = static_cast<ArkamysFeatureHandlerRNAIVI::tenArkamysHandlerState>(m_Parameter);
         return true; // continue
      case ARKAMYS_ACTION_SEND_RESET_CMD:
        m_bError = !ArkamysEolInterfaceRNAIVI::getInstance() -> SendResetPreProc();
         return true;
      case ARKAMYS_ACTION_SET_MODE:
        m_bError = !ArkamysEolInterfaceRNAIVI::getInstance() -> setArkamysMode((tU8)m_Parameter);
         return true;

     //auditorium related features
      case ARKAMYS_ACTION_SET_FM_ENHANCER2:
      {
          tU16 u16enMode = (tU16)(m_Parameter >> 16);
          tU16 u16Part = (m_Parameter & 0xFFFF);
          ETG_TRACE_USR4(("ARKAMYS_ACTION_SET_FM_ENHANCER::u16enMode %i u16Part: %i", u16enMode, u16Part));
          m_bError = !ArkamysFeatureHandlerRNAIVI::getInstance() -> m_pEolInterface -> setFMEnhancer2(u16enMode != 0, u16Part);
          return true; // continue
      }

      case ARKAMYS_ACTION_SET_AMBIANCE:
      {
         tU16 u16enMode = (tU16)(m_Parameter >> 16);
         tU16 u16Part = (m_Parameter & 0xFFFF);
         m_bError = !ArkamysFeatureHandlerRNAIVI::getInstance() -> m_pEolInterface -> setAmbiance(static_cast<ArkamysConfigRNAIVI::tenAuditoriumAmbiance>(u16enMode), u16Part);
         return true; // continue
      }

      case ARKAMYS_ACTION_SET_AMBIANCE_AUD_PROC:
      {
         ArkamysFeatureHandlerRNAIVI::getInstance() -> vSendAmbianceToAudProc(static_cast<ArkamysConfigRNAIVI::tenAuditoriumAmbiance>(m_Parameter));
         return true; // continue
      }

      case ARKAMYS_ACTION_SET_AGC_AUD_PROC:
      {
          ArkamysFeatureHandlerRNAIVI::getInstance() -> vSendAGCModeToAudProc(m_Parameter != 0);
          return true; // continue
      }

      case ARKAMYS_ACTION_SET_BYPASS_AUD_PROC:
      {
       ArkamysFeatureHandlerRNAIVI::getInstance() -> vSendArkamysBypassModeToAudProc(m_Parameter != 0);
         return true;
      }
      default:
         return true; // continue
    }
    return true; // continue
}

bool AkActionRNAIVI::IsEventValid(tenAkEvent akEvent)
{
   if (m_Action == ARKAMYS_ACTION_WAIT_EVENT && m_Parameter == akEvent)
   {
      return true;
   }

   if (m_Action == ARKAMYS_ACTION_WAIT_TIMEOUT && akEvent == ARKAMYS_EVENT_TIMEOUT)
   {
      return true;
   }

  return false;
}
