/**
 * @file ArkamysFeatInterface.h
 * @author pau4kor
 * @copyright (c) 2019 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

#ifndef ARKAMYSFEATINTERFACE_H_
#define ARKAMYSFEATINTERFACE_H_

#include "system_types.h"
#include "fc_audiomanager_main.h"
#include "InternalComponentCommunication/Messages/Sound/ID_ArkamysParameter.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/ADR3ArkamysDefines.h"
class ArkamysFeatInterface
{
public:
    static ArkamysFeatInterface* getInstance();
    virtual ~ArkamysFeatInterface();

    tBool bStartup(fc_audiomanager_tclApp* poMainAppl);
    tVoid timerExpired(tPVoid pvArg);
    tVoid AdrMessageRx(ID_ArkamysParameter arkamysParameter);
    tVoid TraceStatus();
    tenArkamysMode enGetAudioMode();
private:
    ArkamysFeatInterface();
    ArkamysFeatInterface(const ArkamysFeatInterface&);
    ArkamysFeatInterface& operator = (const ArkamysFeatInterface&);

    tBool m_bSBRVariant;
    tVoid vCheckSBRConfig();
};

#endif /* ARKAMYSFEATINTERFACE_H_ */
