/**
 * @file ArkamysFeatInterface.cpp
 * @author pau4kor
 * @copyright (c) 2019 RBEI
 * @addtogroup fc_audiomanager
 * @{
 */

//#include "../mute/stream/StreamMute.h"
#include <sys/stat.h>
#include <errno.h>
#include "ArkamysFeatInterface.h"
#include "fc_audiomanager_trace_input.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
#include "Arkamys/RNAIVI/ArkamysFeatureHandlerRNAIVI.h"
#include "Arkamys/RNAIVI2/ArkamysFeatureHandlerRNAIVI2.h"
//#include "Sound/ArkamysTuningHandlerRNAIVI.h"
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
#include "Arkamys/PSA/ArkamysFeatureHandler.h"
//#include "Sound/ArkamysTuningHandler.h"
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_ARKAMYS
#include "trcGenProj/Header/ArkamysFeatInterface.cpp.trc.h"
#endif

#define SINK_DEV_WITHOUT_ADR (tU8)42
#define SINK_DEV_PASSTHRU_ADR (tU8)43

ArkamysFeatInterface::ArkamysFeatInterface()
                      :m_bSBRVariant(false)
{

}

ArkamysFeatInterface::~ArkamysFeatInterface()
{
}

/**
 * @method ArkamysFeatInterface* GetInstance()
 * @description Singleton pattern
 */

ArkamysFeatInterface* ArkamysFeatInterface::getInstance()
{
   static ArkamysFeatInterface theInstance;
   return &theInstance;
}

/**
 * @method tBool ArkamysFeatInterface::vCheckSBRConfig()
 * @description Function to determine ADR/SBR variant
 */
tVoid ArkamysFeatInterface::vCheckSBRConfig()
{
    tU8 u8KDSParam = 0; //initializing with internal amplifier

    if((DP_S32_NO_ERR == DP_s32GetConfigItem("GenericTunerParameter","MuteOrAttenuationForAbsoluteStationChangeAMFM", &u8KDSParam, 1)))
    {
       ETG_TRACE_USR4(("GenericTunerParameter value  : %d", u8KDSParam));
       if((u8KDSParam == SINK_DEV_WITHOUT_ADR) || (u8KDSParam == SINK_DEV_PASSTHRU_ADR))
         m_bSBRVariant = true;
    }
    else
    {
        ETG_TRACE_ERR(("Error in diagnosis read "));
    }

    if(m_bSBRVariant)
    {
        if (mkdir("/tmp/audiomanager/", 0777) == -1)
            ETG_TRACE_FATAL(("failed to create arkamys folder inside tmp %s",strerror(errno)));
    }
}

tBool ArkamysFeatInterface::bStartup(fc_audiomanager_tclApp* poMainAppl)
{

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
    vCheckSBRConfig();
    if(m_bSBRVariant)
        ArkamysFeatureHandlerRNAIVI2::getInstance() -> bStartup(poMainAppl);
    else
        ArkamysFeatureHandlerRNAIVI::getInstance() -> bStartup(poMainAppl);
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
    ArkamysFeatureHandler::getInstance() -> bStartup(poMainAppl);
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA


   return true;
}

tVoid ArkamysFeatInterface::timerExpired(tPVoid pvArg)
{
    (void)pvArg;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
    if(m_bSBRVariant)
        ArkamysFeatureHandlerRNAIVI2::getInstance() -> timerExpired(OSAL_NULL);
    else
        ArkamysFeatureHandlerRNAIVI::getInstance() -> timerExpired(OSAL_NULL);
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
    ArkamysFeatureHandler::getInstance() -> timerExpired(OSAL_NULL);
#endif

}

tVoid ArkamysFeatInterface::AdrMessageRx(ID_ArkamysParameter arkamysParameter)
{
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
    if(m_bSBRVariant)
        ArkamysFeatureHandlerRNAIVI2::getInstance() -> AsppMessageRx(arkamysParameter);
    else
        ArkamysFeatureHandlerRNAIVI::getInstance() -> AdrMessageRx(arkamysParameter);
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
        ArkamysFeatureHandler::getInstance() -> AdrMessageRx(arkamysParameter);
#endif
}

tVoid ArkamysFeatInterface::TraceStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
    if(m_bSBRVariant)
        ArkamysFeatureHandlerRNAIVI2::getInstance() -> TraceStatus();
    else
        ArkamysFeatureHandlerRNAIVI::getInstance() -> TraceStatus();
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
        ArkamysFeatureHandler::getInstance() -> TraceStatus();
#endif
}

tenArkamysMode ArkamysFeatInterface::enGetAudioMode()
{
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
    if(m_bSBRVariant)
        return ArkamysFeatureHandlerRNAIVI2::getInstance() -> enGetAudioMode();
    else
        return ArkamysFeatureHandlerRNAIVI::getInstance() -> enGetAudioMode();
#else
    return EN_ARKAMYS_BYPASS;
#endif
}
