/**
 * @file ArkamysEOLConverter.h
 * @author CM-AI wie1hi
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 * @{
 */

#ifndef ARKAMYSEOLCONVERTER_H_
#define ARKAMYSEOLCONVERTER_H_

#include "system_types.h"
#include "util/Macro.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
#include "PSA/ArkamysConfig.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
#include "RNAIVI/ArkamysConfigRNAIVI.h"
#endif

class ArkamysEOLConverter
{
public:
   ~ArkamysEOLConverter();

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
   static tU32 GetInflatedDatasetSize(const tU8 *pDataset, tU32 command);
   static tU32 InflateDataset(const tU8 *pDataset, tU8 *pTargetBuffer, tU32 targetBufferSize, tU32 command);
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
   #define FPR_COEFFICIENTS_LENGTH 0x02
   #define OTHER_COEFFICIENTS_LENGTH 0x03
   static tU32 GetInflatedDatasetSizeRNAIVI(const tU8 *pDataset);
   static tU32 InflateDatasetRNAIVI(const tU8 *pDataset, tU8 *pTargetBuffer, tU32 targetBufferSize);
#endif
private:
   ArkamysEOLConverter();
};

#endif /* ARKAMYSEOLCONVERTER_H_ */
