#include "eamp-plugin-send.h"

// Includes all header files for FI of DP-component
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_audio_if.h"

#include <iostream>

#include "eamp-plugin_Trace.h"
#define S2S 0x00
#define S4S 0x01
#define S2S_CONVERTIBLE 0x02
#define DISABLE 0x00
#define ENABLE 0x01


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_EAMP_PLUGIN_SENDER
#include "trcGenProj/Header/eamp-plugin-send.cpp.trc.h"
#endif

//using namespace std;
using namespace std;
/********************************
 * PLUGIN Entry function
 */
#ifdef __cplusplus
extern "C"
{
  vdamp_plugin_sender* getpluginpointer()
  {
    return new eamp_plugin_management_interface();
  }
}
#endif

eamp_plugin_management_interface::eamp_plugin_management_interface()
:m_pluginID(0),
 m_ptrReceiver(NULL),
 m_senderinterface()
{
//Doing nothing, will create instances in bOnInit
}

eamp_plugin_management_interface::~eamp_plugin_management_interface()
{
  m_ptrReceiver = NULL;
}

bool eamp_plugin_management_interface::bInitPlugin(vdamp_pluginID_t pluginID, vdamp_plugin_receiver* ptrReceiver)
{
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)

  if(ptrReceiver != NULL)
  {
    //Copy plugin ID locally
    m_pluginID = pluginID;
    //Copy the receiver for local reference
    m_ptrReceiver = ptrReceiver;
    //reading the amplifier configuration from the KDS datapool
    tU8 u8ExtAmpConfig=DISABLE;//by default amplifier to be disabled
    if((DP_S32_NO_ERR == DP_s32GetConfigItem("codingswitches","EXTAmplifier", &u8ExtAmpConfig, 1)))
    {
        ETG_TRACE_USR4((" eamp-plugin :: External amplifier value  %d ",u8ExtAmpConfig));
      switch(u8ExtAmpConfig)
      {
        case DISABLE:
        {
          m_ptrReceiver->vAmp_SetADRSoundConfigItem((tU8)SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1);
        }
          break;
        case ENABLE:
        {
          m_ptrReceiver->vAmp_SetADRSoundConfigItem((tU8)SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM3);
        }
        break;
       default:
       {
           ETG_TRACE_USR4(("eamp-plugin :: Received invalid External amplifier value,No sound config item sent"));
       }
       break;
      }
    }

    tU8 u8CarModelType[2];

    if((DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation","CarModel", &u8CarModelType[0], 2)))
    {
        ETG_TRACE_USR4(("eamp-plugin :: Car model value  %d ",u8CarModelType[1]));
        if (u8CarModelType[1] == S2S || u8CarModelType[1]==S2S_CONVERTIBLE )
        {
           //send 2 speaker front
           m_ptrReceiver->vAmp_SetADRSpeakerSoundConfigItem(SOUND_CONFIG_ITEM_VALUE_2SPEAKER_FRONT);
        }
        else if (u8CarModelType[1] == S4S)
        {
         //send 4speaker
              m_ptrReceiver->vAmp_SetADRSpeakerSoundConfigItem(SOUND_CONFIG_ITEM_VALUE_4SPEAKER);
        }
        else
        {
          ETG_TRACE_USR4(("eamp-plugin :: Received invalid carmodel value,No speaker config item sent"));
        }
    }
    return true;
  }
  return false;
  #else
      return false;
  #endif
}

void eamp_plugin_management_interface::vDeInitPlugin()
{
  //cout<<"vDeInitPlugin invoked for plugin : "<<m_pluginID<<endl;
  //Free all memory allocated, in general, disable any running threads first before deleting the resources

  m_ptrReceiver = NULL;
}

vdamp_plugin_sender_interfaces eamp_plugin_management_interface::oGetInterfaceData()
{
  //cout<<"Sending Interface data for plugin : "<<m_pluginID<<endl;
  return m_senderinterface;
}

vdamp_plugin_amplifierdata eamp_plugin_management_interface::oGetAmplifierInfo()
{
  //cout<<"Sending Amplifier info for plugin : "<<m_pluginID<<endl;
  vdamp_plugin_amplifierdata temp;
  temp.m_ampname = "smart external amplifier";
  temp.m_u32Major = 1;
  temp.m_u32Minor = 0;

  return temp;
}

/**
 * Will take care of this later
 */
void eamp_plugin_management_interface::vAmp_Rx_FromCCAThread (uint8_t* /*ptrStream*/ , size_t /*length*/ )
{

}
