/*
 * arl_tclISource_AILBase.cpp
 *
 *  Created on: Jul 5, 2012
 *      Author: vo84hi
 */

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

/* Inclusion of OSAL Interface */
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ETRACE_S_IMPORT_INTERFACE_ERRMEM
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ARL_BASE_CLIENT
#include "trcGenProj/Header/arl_tclISource_AILBase.cpp.trc.h"
#endif

#include "arl_Trace.h"
#include "arl_tclISource_AILBase.h"



arl_tclISource_AILBase::arl_tclISource_AILBase(ail_tclAppInterface* pAilAppInterface,
                                               tU16 u16ServiceID,
                                               tU16 ,
                                               tU16 ,
                                               tU16 ) :
                                               arl_tclISourceIF(pAilAppInterface, u16ServiceID),
                                               _u16ServerAppID(0),
                                               _bServiceAvailableAllowedOnAppstate     (FALSE),
                                               _bServiceAvailableAllowedOnPrivateReason(TRUE),
                                               _bServiceAvailable                      (FALSE),
                                               _clProperties(),
                                               _tclRegisterPair(AMT_C_U32_STATE_INVALID, AMT_C_U32_STATE_OFF),
                                               _tclUnregisterPair(AMT_C_U32_STATE_INVALID, AMT_C_U32_STATE_OFF)
{


   _tclRegisterPair.bSetDefault(AHL_PAIRLIST_DEFAULT_SERVICE_AVAILABLE);
   _tclUnregisterPair.bSetDefault(AHL_PAIRLIST_DEFAULT_SERVICE_UNAVAILABLE);

   // TODO Auto-generated constructor stub
   _clProperties._oNotificationTable.bInit(_pAilAppInterface->u16GetAppId(),
                                              _u16ServiceID,
                                              _u16ServiceMajorVersion,
                                              _u16ServiceMinorVersion,
                                              _u16ServicePatchVersion);

}



tVoid arl_tclISource_AILBase::vOnNewMessage(amt_tclBaseMessage* poMessage)
{
   if (poMessage != NULL)
   {
      /* ---  check if the received message is a AMT Service data message  --- */
      if (poMessage->u8GetType() == AMT_C_U8_CCAMSGTYPE_SVCDATA)
      {
         /* ---
          cast the received message to a AMT Service data message so we
          can access the standard members
          --- */

         amt_tclServiceData oServiceData(poMessage);
         tU16 u16ServiceId   = oServiceData.u16GetServiceID();
         tU16 u16TargetSubId = oServiceData.u16GetTargetSubID();

         ETG_TRACE_USR3(("%x AudioRoutingLib::vOnNewMessage for Service %x and SubId %d",
                     ETG_ENUM(ail_u16AppId, (tU16)_u16AppID),
                     ETG_ENUM(ail_u16ServiceId, (tU16) u16ServiceId),
                     u16TargetSubId));
         if (oServiceData.u16GetServiceID() == _u16ServiceID)
         {
            vMyDispatchMessage(&oServiceData);
            if (  (poMessage->bIsValid() == TRUE)
                &&(poMessage->bDelete()  != TRUE))
            {
               ETG_TRACE_SYS_MIN(("%x AudioRoutingLib::vOnNewMessage: message could not be deleted ... !? ", ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) ));
            }
         }
         /* --- alsways delete incoming message and free the ressources --- */
      }
      else
      {
         /* ---
          we have received a message with an unknown format.
          this is an error so make a trace or assert here
          --- */
         ETG_TRACE_ERRMEM(("%x AudioRoutingLib::vOnNewMessage: received a message with an unknown format ... !? ", ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) ));
         /* --- alsways delete incoming message and free the ressources --- */
         if ((poMessage->bIsValid() == TRUE) && (poMessage->bDelete() != TRUE))
         {
            ETG_TRACE_SYS_MIN(("%x AudioRoutingLib::vOnNewMessage: message could not be deleted ... !? ", ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) ));
         }
      }
   }
}

tVoid arl_tclISource_AILBase::vMyDispatchMessage(amt_tclServiceData *pServiceDataMessage)
{
    tU16 u16FunctionId = pServiceDataMessage->u16GetFunctionID();
    tU8  u8OpType = pServiceDataMessage->u8GetOpCode();
    tU16 u16ServiceID = pServiceDataMessage->u16GetServiceID();

    if (u16ServiceID != _u16ServiceID)
    {
        ETG_TRACE_USR4(("%x vMyDispatchMessage: ServiceID not matching %x != %x",
                         ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) ,
                         ETG_ENUM(ail_u16ServiceId, (tU16)u16ServiceID),
                         ETG_ENUM(ail_u16ServiceId, (tU16)_u16ServiceID) ));
        return;
    }

    OSAL_tMSecond msStart, msEnd;
    msStart = OSAL_ClockGetElapsedTime();

      switch (u8OpType)
      {
          case AMT_C_U8_CCAMSG_OPCODE_UPREG:
             vOnUpReg(u16FunctionId, pServiceDataMessage);
          break;
          case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
             vOnRelUpReg(u16FunctionId, pServiceDataMessage);
          break;
          case AMT_C_U8_CCAMSG_OPCODE_GET:
             vOnGet(u16FunctionId, pServiceDataMessage);
          break;
          case AMT_C_U8_CCAMSG_OPCODE_SET:
             vOnSet(u16FunctionId, pServiceDataMessage);
          break;
          case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
             vOnMethodStart(u16FunctionId, pServiceDataMessage);
          break;
          case AMT_C_U8_CCAMSG_OPCODE_METHODABORT:
//             vOnMethodAbort(u16FunctionId, pServiceDataMessage);
             ETG_TRACE_ERR(("%x vDispatchMessage: AMT_C_U8_CCAMSG_OPCODE_METHODABORT is not supported",
                                                 ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)));
          break;
          case AMT_C_U8_CCAMSG_OPCODE_INCREMENT:
//             vOnIncrement(u16FunctionId, pServiceDataMessage);
             ETG_TRACE_ERR(("%x vDispatchMessage: AMT_C_U8_CCAMSG_OPCODE_INCREMENT is not supported",
                                                 ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)));
          break;
          case AMT_C_U8_CCAMSG_OPCODE_DECREMENT:
//             vOnDecrement(u16FunctionId, pServiceDataMessage);
             ETG_TRACE_ERR(("%x vDispatchMessage: AMT_C_U8_CCAMSG_OPCODE_DECREMENT is not supported",
                                                 ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)));
          break;
          case AMT_C_U8_CCAMSG_OPCODE_PURESET:
//             vOnPureSet(u16FunctionId, pServiceDataMessage);
             ETG_TRACE_ERR(("%x vDispatchMessage: AMT_C_U8_CCAMSG_OPCODE_PURESET is not supported",
                                    ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)));
          break;
          default:
             ETG_TRACE_ERR(("%x vDispatchMessage: Unknown OPCODE",
                                    ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)));
             //Do not call Unknown Message because it calls bDelete() of the ServiceDataMessage
             //which has a copy of the shared memory pointer of the BaseMessage.
             //By deleting the copy, the shared memory gets freed and causes error when the
             //original base message destructor (or bDelete()) is called. -The shared Mem would get
             //deleted another time, it may be allocated already by some other message

             //vOnUnknownMessage(pServiceDataMessage);
      }
      msEnd = OSAL_ClockGetElapsedTime();
      if ((msEnd - msStart) > ARL_MAX_FUNCTION_TIME)
      {
         ETG_TRACE_ERR(("%x AudioRoutingLib::vDispatchMessage: needs a long time (%d ms)",
                        ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) ,
                        msEnd - msStart));
      }
}

tVoid arl_tclISource_AILBase::vOnUpReg(tU16 u16FunctionId, amt_tclServiceData* poMessage)
{
   if (_clProperties._oNotificationTable.bAddNotification(poMessage) == TRUE)
   {
      // create a status message answer
      vOnGet(u16FunctionId, poMessage);
   }
   else
   {
      amt_tclServiceDataError oError(*poMessage, AMT_C_U16_ERROR_UPREG_FAILURE);

      ETG_TRACE_ERRMEM(("%x AudioRoutingLib::vOnUpReg: Notification for function ID %x could not be added",
                       ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) ,  u16FunctionId ));
      //ePostMessage(&oError);
      vMyPostMessage(&oError);
   }
}

tVoid arl_tclISource_AILBase::vOnRelUpReg(tU16 u16FunctionId, amt_tclServiceData* poMessage)
{
   tU16 u16RegisterID = poMessage->u16GetRegisterID();

   if (_clProperties._oNotificationTable.bRemoveNotification(u16FunctionId, u16RegisterID) == TRUE)
   {
      // create an status message answer
      vOnGet(u16FunctionId, poMessage);
   }
   else
   {
      amt_tclServiceDataError oError(*poMessage, CCA_C_U16_ERROR_RELUPREG_FAILURE);

      ETG_TRACE_ERRMEM(("%x AudioRoutingLib::vOnRelUpReg: Notification for function ID %x could not be removed  ",
                       ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , u16FunctionId ));
      //ePostMessage(&oError);
      vMyPostMessage(&oError);
   }
}


tVoid arl_tclISource_AILBase::vOnGet(tU16 u16FunctionId, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("%x vOnGet for function id %x", ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , u16FunctionId ));

   if (bIfServiceAvailable())
   {
      // tBool mm_tclMessageTarget::bDefaultSvcDataHandler(mm_tclMessageTarget *pThis, amt_tclServiceData *poMessage)
      if(!(bDefaultSvcDataHandler(this, poMessage)))
      {
         ail_tenCommunicationError enResult = eUpdateRequestingClient(poMessage);
         if (enResult != AIL_EN_N_NO_ERROR)
         {
            ETG_TRACE_FATAL(("%x vOnGet: eUpdateRequestingClient returns error %x function ID %x",
                             ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , enResult, u16FunctionId ));
         }
      }
   }
   else
   {
      ETG_TRACE_SYS_MIN(("%x vOnGet Service %x not available, send error message",
                         ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , ETG_ENUM(ail_u16ServiceId, (tU16)u16GetServiceID()) ));

      amt_tclServiceDataError oErrorMsg(*poMessage, AMT_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE);
      //ePostMessage(&oErrorMsg);
      vMyPostMessage(&oErrorMsg);
   }
}



tVoid arl_tclISource_AILBase::vOnSet(tU16 u16FunctionId, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("%x vOnSet for function id %d", ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , u16FunctionId ));

   if (bIfServiceAvailable())
   {
      if(!(bDefaultSvcDataHandler(this, poMessage)))
      {
//         if (_bAutoHandleSet)
         {
            vGenericSetHandler(u16FunctionId, poMessage, AMT_C_U8_CCAMSG_OPCODE_SET);
         }
//         else
//         {
//            vOnUnknownMessage(poMessage);
//         }
      }
   }
   else
   {
      ETG_TRACE_SYS_MIN(("%x vOnSet %x Service not available, send error message",
                         ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , ETG_ENUM(ail_u16ServiceId, (tU16)u16GetServiceID()) ));

      amt_tclServiceDataError oErrorMsg(*poMessage, AMT_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE);
      vMyPostMessage(&oErrorMsg);
   }
}

tVoid arl_tclISource_AILBase::vGenericSetHandler(tU16 u16FunctionId, amt_tclServiceData* poMessage, tU8 u8OpType)
{
   tU16 u16Error  = 0xFFFF;

   switch (u8OpType)
   {
      case AMT_C_U8_CCAMSG_OPCODE_SET:
         //   bSuccess = bProcessSet(poMessage, bPropertyChanged, u16Error);
         // ************************************
         // NEED FEATURE IMPLEMENTATION SET MUTE
         // ************************************
         ETG_TRACE_ERR(("%x AudioRoutingLib::vGenericSetHandler: AMT_C_U8_CCAMSG_OPCODE_SET not implemented. Should set correct value _MuteReqState[src]._tenMuteState",
                        ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)));
      break;
      case AMT_C_U8_CCAMSG_OPCODE_INCREMENT:
         ETG_TRACE_ERR(("%x AudioRoutingLib::vGenericSetHandler: AMT_C_U8_CCAMSG_OPCODE_INCREMENT not implemented",
                                 ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)));
      break;
      case AMT_C_U8_CCAMSG_OPCODE_DECREMENT:
         ETG_TRACE_ERR(("%x AudioRoutingLib::vGenericSetHandler: AMT_C_U8_CCAMSG_OPCODE_DECREMENT not implemented",
                                          ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)));
      break;
      case AMT_C_U8_CCAMSG_OPCODE_PURESET:
         ETG_TRACE_ERR(("%x AudioRoutingLib::vGenericSetHandler: AMT_C_U8_CCAMSG_OPCODE_PURESET not implemented",
                                          ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)));
      break;
      default:
         ETG_TRACE_ERRMEM(("%x vGenericSetHandler: unknown u8OpType %0d for function ID %x",
                          ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , u8OpType, u16FunctionId ));
      break;
   }

   // Create AMT error message and set ErrorCode
   amt_tclServiceDataError oErrorMsg(*poMessage, u16Error);
   // NOTE: The constructor of amt_tclServiceDataError is re-using the
   // received message 'poMessage' It will collect all necessary Service
   // Information (Source-, Target AppID, RegID, ..) and exchange the
   // Source- and Target AppID and even set the Opcode to ERROR.
   // Additionally the ErrorCode value is set to the second provided
   // parameter. For the new message new memory is allocated, i.e. the
   // received message 'poMessage' is not re-used in terms of memory and the
   // implicite call of 'poMessage->bDelete();' by the framework after
   // leaving this handler function does not harm.

   // Post message
   vMyPostMessage(&oErrorMsg);

   // NOTE: There is no need to call 'poMessage->bDelete();' here, as the
   // incoming message will be deleted by the CCX framework automatically when
   // leaving this function.
}

   tVoid arl_tclISource_AILBase::vOnMethodStart(tU16 u16FunctionId, amt_tclServiceData* poMessage)
   {
      ETG_TRACE_USR1(("%x vOnMethodStart for function id %d", ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , u16FunctionId ));

      if (bIfServiceAvailable())
      {
         if(!(bDefaultSvcDataHandler(this, poMessage)))
         {
            ETG_TRACE_FATAL(("%x AudioRoutingLib::vOnMethodStart: bDefaultSvcDataHandler returns FALSE function ID %x",
                                          ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , u16FunctionId ));
            //Do not call Unknown Message because it calls bDelete() of the ServiceDataMessage
            //which has a copy of the shared memory pointer of the BaseMessage.
            //By deleting the copy, the shared memory gets freed and causes error when the
            //original base message destructor (or bDelete()) is called. -The shared Mem would get
            //deleted another time, it may be allocated already by some other message

            //vOnUnknownMessage(pServiceDataMessage);
         }
      }
      else
      {
         ETG_TRACE_SYS_MIN(("%x AudioRoutingLib::vOnMethodStart Service %x not available, send error message",
                            ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , ETG_ENUM(ail_u16ServiceId, (tU16)u16GetServiceID()) ));

         amt_tclServiceDataError oErrorMsg(*poMessage, AMT_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE);
         vMyPostMessage(&oErrorMsg);
      }
   }

tVoid arl_tclISource_AILBase::vMyPostMessage(amt_tclServiceData* poMessage)
{
   ail_tenCommunicationError enResult = AIL_EN_N_NO_ERROR;
   if (poMessage != NULL)
   {
      tU16 u16MsgFctID = poMessage->u16GetCmdCounter();
      if (_pAilAppInterface != NULL)
      {
         // In case Message could not be send it is deleted by Framework
         // This is done by using second Parameter = TRUE
         enResult = _pAilAppInterface->enPostMessage(poMessage, TRUE);
      }
      else
      {
         poMessage->bDelete();
         ETG_TRACE_ERRMEM(("arl_tclISource_AILBase::vMyPostMessage: _pAilAppInterface is NULL"));
         NORMAL_M_ASSERT_ALWAYS();
         return;
      }

      if (enResult != AIL_EN_N_NO_ERROR)
      {
         // We can come here e.g. if the client has changed his application
         // state to OFF in the meantime. Therefore we don't throw an assert.
         // NORMAL_M_ASSERT_ALWAYS();

         // But do a Trace
         ETG_TRACE_ERR(("%x arl_tclISource_AILBase::vGenericSetHandler: send error message returns error %x function ID %x",
                     ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) , enResult, u16MsgFctID ));
      }
   }else{
      ETG_TRACE_ERR(("%x arl_tclISource_AILBase::vGenericSetHandler: passed Msg Pointer is null",ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) ));
   }
}

tVoid arl_tclISource_AILBase::vDestroyFactoryStatusMessage(amt_tclServiceData* poMessage)
{
   delete poMessage;
}



tVoid arl_tclISource_AILBase::vUpdateAllProperties()
{
   for(tFunctionMap::const_iterator it = _clProperties._oNotificationTable.m_FktIdMap.begin(); it != _clProperties._oNotificationTable.m_FktIdMap.end(); ++it)
   {
      tU16 nFID = it->first;
      if (it->second != 0)
      {
         eUpdateClients(nFID);
      }
   }
}

tVoid arl_tclISource_AILBase::vSetPrivateServiceAvailableAllowed(tBool fServiceAvailableAllowed)
{
   _bServiceAvailableAllowedOnPrivateReason = fServiceAvailableAllowed;
   vSetServiceState();
}

tVoid arl_tclISource_AILBase::vSetServiceState()
{
   if ((_bServiceAvailableAllowedOnAppstate == TRUE) && (_bServiceAvailableAllowedOnPrivateReason == TRUE))
     {
        if (_bServiceAvailable != TRUE)
        {
           /* --- set service available --- */
           //@todo Service availability trigger, this is important for UnitTest

           _pAilAppInterface->vServiceAvailabilityChanged(u16GetServiceID(), AMT_C_U8_SVCSTATE_AVAILABLE);
           _bServiceAvailable = TRUE;
           vUpdateAllProperties();

           // Inform the derived user classes about the change
           vOnServiceAvailable();
        }
     }
     else
     {
        if (_bServiceAvailable == TRUE)
        {
           // Inform the derived user classes about the change
           vOnServiceUnavailable();

           /* --- set service unavailable --- */
           //@todo Service availability trigger, this is important for UnitTest
           //_poMainAppl->vServiceAvailabilityChanged(u16GetServiceID(), AMT_C_U8_SVCSTATE_NOT_AVAILABLE);
           _pAilAppInterface->vServiceAvailabilityChanged(u16GetServiceID(), AMT_C_U8_SVCSTATE_NOT_AVAILABLE);
           _bServiceAvailable = FALSE;
        }
     }
}

/*************************************************************************
*
* FUNCTION: tVoid vOnNewAppState( tU32 u32OldAppState, tU32 u32AppState )
*
* DESCRIPTION: handles state change messages form the spm
*
* PARAMETER: old state, new state
*
* RETURNVALUE: void
*
*************************************************************************/

tVoid arl_tclISource_AILBase::vOnNewAppState(tU32 u32OldAppState,  tU32 u32AppState)
{
   ETG_TRACE_USR1(("%x Service->vOnNewAppState %d -> %d ",
                   ETG_ENUM(ail_u16AppId, (tU16)_u16AppID),
                   ETG_ENUM(ail_u32CCAState, (tU16)u32OldAppState),
                   ETG_ENUM(ail_u32CCAState, (tU16)u32AppState)  ));

   if( u32OldAppState == u32AppState )
   {
      return; // switching to the same state -> do nothing
   }

   if ( _tclRegisterPair.bIfPairIncluded(u32OldAppState, u32AppState) == TRUE)
   {
      _bServiceAvailableAllowedOnAppstate = TRUE;

      ETG_TRACE_USR1(("%x Service->vOnNewAppState set ServiceAvailableAllowedOnAppstate of service %x to %d ",
                      ETG_ENUM(ail_u16AppId, (tU16)_u16AppID),
                      ETG_ENUM(ail_u16ServiceId, (tU16)u16GetServiceID()), _bServiceAvailableAllowedOnAppstate  ));

      vSetServiceState();
   }

   if ( _tclUnregisterPair.bIfPairIncluded(u32OldAppState, u32AppState) == TRUE)
   {
      _bServiceAvailableAllowedOnAppstate = FALSE;

      ETG_TRACE_USR1(("%x Service->vOnNewAppState set ServiceAvailableAllowedOnAppstate of service %x to %d ",
                      ETG_ENUM(ail_u16AppId, (tU16)_u16AppID),
                      ETG_ENUM(ail_u16ServiceId, (tU16)u16GetServiceID()), _bServiceAvailableAllowedOnAppstate  ));

      vSetServiceState();
   }

   vOnNewAppStateNotify(u32OldAppState, u32AppState);
}

ail_tenCommunicationError arl_tclISource_AILBase::eUpdateClients(tU16 u16FunctionId, amt_tclServiceData* )
{
   ail_tenCommunicationError enCommunicationError = AIL_EN_N_NO_ERROR;

   if (_clProperties._oNotificationTable.bLock() == TRUE)
   {
      ETG_TRACE_USR1(("0x%x eUpdateClients called for service %x and FID %d",
                       ETG_ENUM(ail_u16AppId, (tU16)_u16AppID), ETG_ENUM(ail_u16ServiceId, (tU16)_u16ServiceID), u16FunctionId  ));

      ahl_tNotification* poNextNotify = _clProperties._oNotificationTable.poGetNextNotification(u16FunctionId);
      if (poNextNotify != NULL)
      {
         // new type of factory
//         amt_tclServiceData oFactoryMessage;
         amt_tclServiceData* poFactoryMessage;

         poFactoryMessage = pStatusMessageFactory(poNextNotify->u16AppID, u16FunctionId, poNextNotify->u16RegisterID, poNextNotify->u16CmdCounter);

         if (poFactoryMessage != NULL)
         {
            ahl_tNotification* poCurrentNotify;
            while (poNextNotify != NULL)
            {
               {
                  amt_tclServiceData* poCurrentMessage;
                  amt_tclServiceData oCurrentMessage;
                  poCurrentNotify = poNextNotify;
                  poNextNotify = _clProperties._oNotificationTable.poGetNextNotification(u16FunctionId, poNextNotify);

                  // only clone if this is not the last message
                  if (poNextNotify != NULL)
                  {
                     if (oCurrentMessage.bCloneMessageContent(poFactoryMessage) == TRUE)
                     {
                        poCurrentMessage = &oCurrentMessage;
                     }
                     else
                     {
                        ETG_TRACE_ERRMEM(("%x eUpdateClients: bCloneMessageContent returns false", ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)  ));
                        poCurrentMessage = NULL;
                     }
                  }
                  else
                  {
                     // it is the last message, use origin factory message
                     poCurrentMessage = poFactoryMessage;
                  }

                  if (poCurrentMessage != NULL)
                  {
                      tU16 AppID = poCurrentNotify->u16AppID;
                      tU16 RegID = poCurrentNotify->u16RegisterID;
                      tU16 CmdCnt = poCurrentNotify->u16CmdCounter;
                      vInitServiceData(*poCurrentMessage, AppID, RegID, CmdCnt, u16FunctionId, AMT_C_U8_CCAMSG_OPCODE_STATUS, poCurrentNotify->u16SubID);
                      ail_tenCommunicationError enPostCommunicationError = _pAilAppInterface->enPostMessage(poCurrentMessage);

                      // preserve error code
                      if (enCommunicationError == AIL_EN_N_NO_ERROR)
                      {
                         enCommunicationError = enPostCommunicationError;
                      }
                   }
                   else
                   {
                      enCommunicationError = AIL_EN_N_NOT_ALL_INFORMED;
                   }
                }
            }

//            vDestroyFactoryStatusMessage(poFactoryMessage);
         }
         else
         {
            ETG_TRACE_FATAL(("%x eUpdateClients: the StatusMessageFactory of service %x does not return a valid message for FID %d",
                             ETG_ENUM(ail_u16AppId, (tU16)_u16AppID), ETG_ENUM(ail_u16ServiceId, (tU16)_u16ServiceID), u16FunctionId  ));
         }
      }
      _clProperties._oNotificationTable.vUnlock();
   }
   else
   {
      ETG_TRACE_ERRMEM(("%x eUpdateClients: could not lock notification table", ETG_ENUM(ail_u16AppId, (tU16)_u16AppID)  ));
      enCommunicationError = AIL_EN_N_UNDEFINED_ABORT;
   }
   return enCommunicationError;
}

tVoid arl_tclISource_AILBase::vInitServiceData(amt_tclServiceData& rServiceDataMessage, tU16 u16TargetAppID, tU16 u16RegisterID, tU16 u16CmdCounter, tU16 u16FunctionId, tU8 u8Opcode, tU16 u16TargetSubID) const
{
   rServiceDataMessage.vInitServiceData(
                 _u16AppID,                            // Source AppID
                 u16TargetAppID,                       // Target AppID
                 AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    // StreamType
                 0,                                    // StreamCounter
                 u16RegisterID,                        // RegisterID
                 u16CmdCounter,                        // CmdCounter,
                 _u16ServiceID,                        // ServiceID,
                 u16FunctionId,                        // Function ID
                 u8Opcode                              // Opcode STATUS
                 );

   rServiceDataMessage.vSetTargetSubID(u16TargetSubID);
}

tBool arl_tclISource_AILBase::bGetServiceVersion (tU16 u16ServiceID, tU16 &rfu16MajorVersion, tU16 &rfu16MinorVersion, tU16 &rfu16PatchVersion)
{
   if(u16ServiceID != _u16ServiceID)
   {
      return false;
   }
   rfu16MajorVersion = _u16ServiceMajorVersion;
   rfu16MinorVersion = _u16ServiceMinorVersion;
   rfu16PatchVersion = _u16ServicePatchVersion;
   return TRUE;
}

ail_tenCommunicationError arl_tclISource_AILBase::eUpdateRequestingClient(amt_tclServiceData* poMessage)
{
   tBool bSendError = TRUE;
   tU16 u16FunctionId = poMessage->u16GetFunctionID();
   tU16 u16SourceAppID = poMessage->u16GetSourceAppID(); // AppID of client (we return the new status data to the sender)
   tU16 u16RegisterID = poMessage->u16GetRegisterID();
   tU16 u16CmdCounter = poMessage->u16GetCmdCounter();
   ail_tenCommunicationError enCommunicationError;

//   amt_tclServiceData oFactoryMessage;
   amt_tclServiceData* pMsg;

   // Create a status message by using our own 'Status Message Factory'
   // The factory will create a 'related' CCA status message with the 'relevant' member variables.


   // only for backward compability
   pMsg = pStatusMessageFactory(u16SourceAppID, u16FunctionId, u16RegisterID, u16CmdCounter);

   // Send message
   if ( (pMsg != NULL) &&  pMsg->bIsValid() )
   {
      enCommunicationError = _pAilAppInterface->enPostMessage(pMsg);
      if (enCommunicationError == AIL_EN_N_NO_ERROR)
      {
         bSendError = FALSE;
      }
      else
      {
         ETG_TRACE_ERRMEM(("%x eUpdateRequestingClient: enPostMessage() to app %x for service %x failed with error %x.",
                      ETG_ENUM(ail_u16AppId, (tU16)_u16AppID), ETG_ENUM(ail_u16AppId, (tU16)u16SourceAppID), ETG_ENUM(ail_u16ServiceId, (tU16)_u16ServiceID), enCommunicationError  ));
      }
   }
   else
   {
        enCommunicationError = AIL_EN_N_NOT_SEND;
        ETG_TRACE_FATAL(("%x eUpdateRequestingClient: the StatusMessageFactory of service %x does not return a valid message for FID %d",
                         ETG_ENUM(ail_u16AppId, (tU16)_u16AppID), ETG_ENUM(ail_u16ServiceId, (tU16)_u16ServiceID), u16FunctionId  ));
   }

   // Note: The message sent was created via "OSAL_NEW" (see creation of status message in the
   //       StatusMessageFactory) and therefore has to be deleted here explictly. Otherwise you will
   //       create a memory leak.
   if (bSendError)
   {
      if ((pMsg!=NULL) && (pMsg->bIsValid() == TRUE) && (pMsg->bDelete() != TRUE))
      {
         ETG_TRACE_SYS_MIN(("%x AudioRoutingLib::vDestroyFactoryStatusMessage: message could not be deleted ... !? ", ETG_ENUM(ail_u16AppId, (tU16)_u16AppID) ));
      }
      vDestroyFactoryStatusMessage(pMsg);
   }

   return enCommunicationError;
}

arl_tclISource_AILBase::~arl_tclISource_AILBase()
{
   // TODO Auto-generated destructor stub
}

