/*!
*******************************************************************************
* \file              arl_tclISource_AIL.cpp
*******************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:    Implements the ISource interface.
*  - COPYRIGHT:      &copy; 2010 - 2012 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 25.08.2011 \version 1.2 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Removed the overriden eUpdateClients() from FWK.
*
* \date 28.04.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Bug fix for JIRA ticket GMNGA-9383: Correction for handling with property
* notification.
*
* \date 15.12.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include <generic_msgs_if.h>


#include "arl_tclISource_AIL.h"
#include "arl_tclISrcVFsm.h"
#include "arl_LookupTable.h"
#include "arl_Trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ARL_ISOURCE
#include "trcGenProj/Header/arl_tclISource_AIL.cpp.trc.h"
#endif

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| Utilizing the Framework for message map abstraction.
|----------------------------------------------------------------------------*/

BEGIN_MSG_MAP(arl_tclISource_AIL, ahl_tclBaseWork)

   ON_MESSAGE_SVCDATA(ARL_EN_ALLOCATE,       AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)
   ON_MESSAGE_SVCDATA(ARL_EN_DEALLOCATE,     AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)
   ON_MESSAGE_SVCDATA(ARL_EN_SOURCEACTIVITY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)

   ON_MESSAGE_SVCDATA(ARL_EN_LOOPBACK, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)
   ON_MESSAGE_SVCDATA(ARL_EN_SRCACTTIMEREXPIRY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vOnMsISource)

   ON_MESSAGE_SVCDATA(ARL_EN_MUTE_REQ, AMT_C_U8_CCAMSG_OPCODE_GET,   vCCA_OnUpRegMuteReq)
   ON_MESSAGE_SVCDATA(ARL_EN_MUTE_REQ, AMT_C_U8_CCAMSG_OPCODE_UPREG, vCCA_OnUpRegMuteReq)

   ON_MESSAGE_SVCDATA(ARL_EN_ROUTEREQUEST, AMT_C_U8_CCAMSG_OPCODE_GET,   vCCA_OnUpRegRouteReq)
   ON_MESSAGE_SVCDATA(ARL_EN_ROUTEREQUEST, AMT_C_U8_CCAMSG_OPCODE_UPREG, vCCA_OnUpRegRouteReq)

   ON_MESSAGE_SVCDATA(ARL_EN_MUTE_STATE, AMT_C_U8_CCAMSG_OPCODE_SET, vCCA_OnMuteState)

   ON_MESSAGE_SVCDATA(ARL_EN_AUDIOROUTEREQUESTREJECT, AMT_C_U8_CCAMSG_OPCODE_SET, vCCA_OnAudioRouteRequestReject)

   // Loopback handler function.
   ON_MESSAGE_SVCDATA(ARL_EN_SOURCEACTIVITY, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vOnMrISource)

END_MSG_MAP()

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  arl_tclISource_AIL::arl_tclISource_AIL(ahl_tclBaseOneThreadApp* co...
******************************************************************************/

arl_tclISource_AIL::arl_tclISource_AIL(ail_tclAppInterface* pAilAppInterface) :
   arl_tclISource_AILBase(pAilAppInterface, CCA_C_U16_SRV_AUD_SRC_ROUTE),
   m_bSrcAvailable(FALSE)
{
   m_poISourceVFsm   =  OSAL_NEW arl_tclISrcVFsm(_pAilAppInterface, this);
   NORMAL_M_ASSERT(OSAL_NULL != m_poISourceVFsm);
   vSetPrivateServiceAvailableAllowed(FALSE);
} // arl_tclISource_AIL::arl_tclISource_AIL(ahl_tclBaseOneThreadApp *const cpoApp, t..

/******************************************************************************
** FUNCTION:  virtual arl_tclISource_AIL::~arl_tclISource_AIL()
******************************************************************************/

/*virtual*/
arl_tclISource_AIL::~arl_tclISource_AIL()
{
   try
   {
      OSAL_DELETE m_poISourceVFsm;
   }
   catch(...)
   {
   }

   m_poISourceVFsm   =  OSAL_NULL;

} // arl_tclISource_AIL::~arl_tclISource_AIL()

tVoid arl_tclISource_AIL::vOnServiceState( tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, tU8  u8ServiceState, tU16 u16SubId)
{
   if(m_poISourceVFsm != NULL)
   {
      m_poISourceVFsm->vOnServiceState( u16ServiceId, u16ServerId, u16RegisterId, u8ServiceState, u16SubId);
   }
}

tVoid arl_tclISource_AIL::vOnAsyncRegisterConf(tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId)
{
   if(m_poISourceVFsm != NULL)
   {
      m_poISourceVFsm->vOnAsyncRegisterConf( u16RegisterId,  u16ServerAppId,  u16ServiceId,  u16TargetSubId);
   }
}

tVoid arl_tclISource_AIL::vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState)
{
   if(m_poISourceVFsm != NULL)
      {
      m_poISourceVFsm->vOnNewAppStateNotify(u32OldAppState,u32AppState);
      }
}

tVoid arl_tclISource_AIL::vOnNewMessage(amt_tclBaseMessage* poMessage)
{
   if (poMessage != NULL)
   {
      /* ---  check if the received message is a AMT Service data message  --- */
      tU16 msgType = poMessage->u8GetType();
      amt_tclServiceData oServiceData(poMessage);
      tU16 u16ServiceId = oServiceData.u16GetServiceID();

      if (msgType == AMT_C_U8_CCAMSGTYPE_SVCDATA)
      {
         if (u16ServiceId == CCA_C_U16_SRV_STREAMROUTER)
         {
           if(m_poISourceVFsm != NULL)
           {
             if (m_poISourceVFsm->m_poStrRouClientAIL != NULL)
             {
                m_poISourceVFsm->m_poStrRouClientAIL->vMyDispatchMessage(&oServiceData);
             }
           }
         }
         if (u16ServiceId == CCA_C_U16_SRV_AUD_SRC_ROUTE)
         {
           arl_tclISource_AILBase::vOnNewMessage(poMessage);
         }
      }
   }
}

/******************************************************************************
** FUNCTION:  tBool arl_tclISource_AIL::bSendMessage( const amt_tclSe..
******************************************************************************/

tBool arl_tclISource_AIL::bSendMessage
(
   const amt_tclServiceData& rfcoServiceData
   , const fi_tclMessageBase& rfcoMsgBase
)
{
   tU16 u16ServMajVer   =  1;

   // Create the Visitor Message
   fi_tclVisitorMessage oOutVisitorMsg(rfcoMsgBase.corfoGetTypeBase(), u16ServMajVer);

   // Set the CCA message information
   vInitServiceData
   (
      oOutVisitorMsg                               // Visitor msg reference.
      , rfcoServiceData.u16GetSourceAppID()        // Dest. app-ID
      , rfcoServiceData.u16GetRegisterID()         // Register ID
      , rfcoServiceData.u16GetCmdCounter()         // Command counter
      , rfcoMsgBase.u16GetFunctionID()             // Function-ID
      , rfcoMsgBase.u8GetOpCode()                  // OpCode
   );
   if(m_poISourceVFsm != NULL)
   {
      ETG_TRACE_USR4(("%d: Sending message with Opcode: %d, Version: %d, ServiceId: %d, \
                      RegId: %d, FID: %x, SrcAppId: %d, TargAppId: %d, CmdCntr: %d"
                      , ETG_ENUM(ail_u16AppId,     m_poISourceVFsm->u16GetAppId())
                      , (tU8)oOutVisitorMsg.u8GetOpCode()
                      , oOutVisitorMsg.u16GetVersion(), oOutVisitorMsg.u16GetServiceID()
                      , oOutVisitorMsg.u16GetRegisterID()
                      , oOutVisitorMsg.u16GetFunctionID()
                      , ETG_ENUM(ail_u16AppId, oOutVisitorMsg.u16GetSourceAppID())
                      , ETG_ENUM(ail_u16AppId, oOutVisitorMsg.u16GetTargetAppID())
                      , oOutVisitorMsg.u16GetCmdCounter()
                      ));
   }else{
      ETG_TRACE_ERR(("arl_tclISource_AIL::bSendMessage: m_poISourceVFsm == NULL "));
   }

   // Post the message to message Queue.
   tBool bRetVal     =  TRUE;

   if (FALSE != oOutVisitorMsg.bIsValid())
   {
      // Post the message to message queue
      ail_tenCommunicationError enCommError =
         _pAilAppInterface->enPostMessage(&oOutVisitorMsg);

      if (AIL_EN_N_NO_ERROR != enCommError)
      {
         bRetVal  =  FALSE;
         if(m_poISourceVFsm != NULL)
         {
               ETG_TRACE_ERR(("%d: Communication Error : %d, could not post message"
                     , ETG_ENUM(ail_u16AppId,     m_poISourceVFsm->u16GetAppId())
                     , ETG_ENUM(AIL_ERROR, enCommError)));
         }else{
               ETG_TRACE_ERR(("arl_tclISource_AIL::bSendMessage: m_poISourceVFsm == NULL "));
               ETG_TRACE_ERR(("Communication Error : %d, could not post message"
                                    , ETG_ENUM(AIL_ERROR, enCommError)));
            }
      }  // if (AIL_EN_N_NO_ERROR != enCommError)

      //set Service state accordingly
      vSetServiceState();

   }  //if( FALSE != oOutVisitorMsg.bIsValid())
   else
   {
      bRetVal  =  FALSE;
      if(m_poISourceVFsm != NULL)
      {
         ETG_TRACE_ERR(("%d: Invalid message!!!",
               ETG_ENUM(ail_u16AppId,     m_poISourceVFsm->u16GetAppId())));
      }else{
         ETG_TRACE_ERR(("arl_tclISource_AIL::bSendMessage: m_poISourceVFsm == NULL "));
         ETG_TRACE_ERR(("Invalid message!!!"));
      }
   }  //End of if-else; if (FALSE != oOutVisitorMsg.bIsValid())

   return bRetVal;

}  // tBool arl_tclISource_AIL::bSendMessage(const amt_tclServiceData &rf..

/******************************************************************************
** FUNCTION:    amt_tclServiceData* arl_tclISource_AIL::pStatusMessageFactory(t..
******************************************************************************/

/*virtual*/

/******************************************************************************
** FUNCTION:  virtual tBool arl_tclISource_AIL::bSrcAvailable() const
******************************************************************************/

/*virtual*/
tBool arl_tclISource_AIL::bSrcAvailable() const
{
   return m_bSrcAvailable;
}  // tBool arl_tclISource_AIL::bSrcAvailable() const

/******************************************************************************
** FUNCTION:  virtual tVoid arl_tclISource_AIL::vSetSrcAvailable(tBool bSrcAvail)
******************************************************************************/

/*virtual*/
tVoid arl_tclISource_AIL::vSetSrcAvailable(tBool bSrcAvail)
{
   // Check if Source availability has changed?
   if (m_bSrcAvailable != bSrcAvail)
   {
      if(m_poISourceVFsm != NULL)
      {
         ETG_TRACE_USR1(("%d: Source availability set to: %d"
               , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())
               , bSrcAvail));
      }else{
         ETG_TRACE_ERR(("arl_tclISource_AIL::vSetSrcAvailable: m_poISourceVFsm == NULL "));
         ETG_TRACE_USR1(("Source availability set to: %d"
                       , bSrcAvail));
      }

      m_bSrcAvailable   =  bSrcAvail;

      // Update the clients about Source availability change.
      if (AIL_EN_N_NO_ERROR != eUpdateClients((tU16)ARL_EN_SOURCEAVAILABLE))
      {
         if(m_poISourceVFsm != NULL)
         {
            ETG_TRACE_ERR(("%d: Error: Updating Source availability info failed!!!"
                        , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())));
         }else{
            ETG_TRACE_ERR(("Error: Updating Source availability info failed!!!"));
         }
      }  // if (AIL_EN_N_NO_ERROR != eUpdateClients(ARL_EN_SOURCEAVAILABLE))

      vSetPrivateServiceAvailableAllowed(bSrcAvail);

   }  //if (m_bSrcAvailable != bSrcAvail)

}  // tVoid arl_tclISource_AIL::vSetSrcAvailable(tBool bSrcAvail)

/******************************************************************************
* FUNCTION:  tVoid arl_tclISource_AIL::vOnMsISource(amt_tclServiceData* poMessage)
******************************************************************************/

tVoid arl_tclISource_AIL::vOnMsISource(amt_tclServiceData* poMessage)
{
   if (OSAL_NULL != m_poISourceVFsm)
   {
      tBool bRetVal  =  m_poISourceVFsm->bOnMessage(poMessage);
      NORMAL_M_ASSERT(FALSE != bRetVal);

   }  // if (OSAL_NULL != m_poISourceVFsm)

}  // tVoid arl_tclISource_AIL::vOnMsISource(amt_tclServiceData* poMessage)

/******************************************************************************
* FUNCTION:  tVoid arl_tclISource_AIL::vOnMrISource(amt_tclServiceData* poMessage)
******************************************************************************/

tVoid arl_tclISource_AIL::vOnMrISource(amt_tclServiceData* poMessage)
{
   if(m_poISourceVFsm != NULL)
      {
         ETG_TRACE_USR4(("%d: Recieved a loopback result message with Opcode: %d, \
                ServiceId: %d, RegId: %d, FID: %x, SrcAppId: %d, TargAppId: %d"
                , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())
                , ETG_ENUM(OP_CODES, poMessage->u8GetOpCode())
                , poMessage->u16GetServiceID(), poMessage->u16GetRegisterID()
                , poMessage->u16GetFunctionID(), ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID())
                , ETG_ENUM(ail_u16AppId, poMessage->u16GetTargetAppID())));
      }else{
        // Just print out the message information.
        ETG_TRACE_USR4(("Recieved a loopback result message with Opcode: %d, \
           ServiceId: %d, RegId: %d, FID: %x, SrcAppId: %d, TargAppId: %d"
           , ETG_ENUM(OP_CODES, poMessage->u8GetOpCode())
           , poMessage->u16GetServiceID(), poMessage->u16GetRegisterID()
           , poMessage->u16GetFunctionID(), ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID())
           , ETG_ENUM(ail_u16AppId, poMessage->u16GetTargetAppID())));
      }
}  //lint !e1762 !e818 Info 1762, Info 818



/******************************************************************************
** FUNCTION:  tVoid arl_tclISource_AIL::bOnAllocate(..
******************************************************************************/
tBool arl_tclISource_AIL::bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& )
{
   if(m_poISourceVFsm != NULL)
   {
      ETG_TRACE_USR1(("%d: bOnAllocate: DefaultImplementation, Source: 0x%x(%d)"
            , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())
            , enSrcNum, enSrcNum));
   }else{
      ETG_TRACE_ERR(("arl_tclISource_AIL::vSetSrcAvailable: m_poISourceVFsm == NULL "));
      ETG_TRACE_USR1(("ARL_AIL::bOnAllocate: DefaultImplementation, Source: 0x%x(%d)",
            enSrcNum, enSrcNum));
   }
   return FALSE;
}

/******************************************************************************
** FUNCTION:  tVoid arl_tclISource_AIL::vOnFGGraphCmdResult(..
******************************************************************************/
tVoid arl_tclISource_AIL::vOnFGGraphCmdResult(arl_tenFGGraphCmd_Result enErrorCode)
{
   if(m_poISourceVFsm != NULL)
      {
         ETG_TRACE_USR1(("%d: ARL_AIL::vOnFGGraphCmdResult: DefaultImplementation, Result: 0x%d"
               , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())
               , ETG_ENUM(arl_tenFGGraphCmd_Result, enErrorCode)));
      }else{
         ETG_TRACE_ERR(("arl_tclISource_AIL::vOnFGGraphCmdResult: m_poISourceVFsm == NULL "));
         ETG_TRACE_USR1(("ARL_AIL::vOnFGGraphCmdResult: DefaultImplementation, Result: 0x%d",
               ETG_ENUM(arl_tenFGGraphCmd_Result, enErrorCode)));
      }
}

/******************************************************************************
** FUNCTION:  tVoid arl_tclISource_AIL::bOnDeAllocate(..
******************************************************************************/
tBool arl_tclISource_AIL::bOnDeAllocate(arl_tenSource enSrcNum)
{
   if(m_poISourceVFsm != NULL)
      {
         ETG_TRACE_USR1(("%d: ARL_AIL::bOnDeAllocate: DefaultImplementation, Source: 0x%x(%d)"
               , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())
               , enSrcNum, enSrcNum));
      }else{
         ETG_TRACE_ERR(("arl_tclISource_AIL::vSetSrcAvailable: m_poISourceVFsm == NULL "));
         ETG_TRACE_USR1(("ARL_AIL::bOnDeAllocate: DefaultImplementation, Source: 0x%x(%d)",
                  enSrcNum, enSrcNum));
      }
   return FALSE;
}

/******************************************************************************
** FUNCTION:  tVoid arl_tclISource_AIL::bOnSrcActivity(..
******************************************************************************/

tBool arl_tclISource_AIL::bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& )
{
   if(m_poISourceVFsm != NULL)
   {
      ETG_TRACE_USR1(("%d: ARL_AIL::bOnSrcActivity: DefaultImplementation, Source: 0x%x(%d)"
            , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())
            , enSrcNum, enSrcNum));
   }else{
     ETG_TRACE_ERR(("arl_tclISource_AIL::vSetSrcAvailable: m_poISourceVFsm == NULL "));
     ETG_TRACE_USR1(("ARL_AIL::bOnSrcActivity: DefaultImplementation, Source: 0x%x(%d)",
              enSrcNum, enSrcNum));
   }
   return FALSE;
}

tBool arl_tclISource_AIL::bOnSrcActivity(arl_tenSource enSrcNum, tU16 SubSource, const arl_tSrcActivity& )
{
   if(m_poISourceVFsm != NULL)
   {
      ETG_TRACE_USR1(("%d: ARL_AIL::bOnSrcActivity: DefaultImplementation, Source: 0x%x(%d), SubSource=%d"
            , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())
            , enSrcNum, enSrcNum,SubSource));
   }else{
     ETG_TRACE_ERR(("arl_tclISource_AIL::vSetSrcAvailable: m_poISourceVFsm == NULL "));
     ETG_TRACE_USR1(("ARL_AIL::bOnSrcActivity: DefaultImplementation, Source: 0x%x(%d), SubSource=%d",
              enSrcNum, enSrcNum, SubSource));
   }
   return FALSE;
}

tBool arl_tclISource_AIL::bOnSrcActivity(arl_tenSource enSrcNum, tU16 SubSource, arl_tenSource enPosNextSrc, const arl_tSrcActivity& )
{
   if(m_poISourceVFsm != NULL)
   {
      ETG_TRACE_USR1(("%d: ARL_AIL::bOnSrcActivity: DefaultImplementation, Source: 0x%x(%d), SubSource=%d , PosNextSrc=%d"
            , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())
            , enSrcNum, enSrcNum,SubSource, enPosNextSrc));
   }else{
     ETG_TRACE_ERR(("arl_tclISource_AIL::vSetSrcAvailable: m_poISourceVFsm == NULL "));
     ETG_TRACE_USR1(("ARL_AIL::bOnSrcActivity: DefaultImplementation, Source: 0x%x(%d), SubSource=%d , PosNextSrc=%d",
              enSrcNum, enSrcNum, SubSource, enPosNextSrc));
   }
   return FALSE;
}
/******************************************************************************
** FUNCTION:  tVoid arl_tclISource_AIL::bOnMuteState(..
******************************************************************************/
tBool arl_tclISource_AIL::bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState)
{
   if(m_poISourceVFsm != NULL)
   {
      ETG_TRACE_USR1(("%d: bOnMuteState: DefaultImplementation, Source: 0x%x(%d)"
               , ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())
               , enSrcNum, enSrcNum));
   }else{
     ETG_TRACE_ERR(("arl_tclISource_AIL::vSetSrcAvailable: m_poISourceVFsm == NULL "));
     ETG_TRACE_USR1(("bOnMuteState: DefaultImplementation, Source: 0x%x(%d)",
                 enSrcNum, enSrcNum));
   }
   return FALSE;
}

/******************************************************************************
** FUNCTION:  tBool arl_tclISource_AIL::bHandleLoopbackInThreadMismatch(arl_tenSource ..
******************************************************************************/
tBool arl_tclISource_AIL::bTriggerSrcActivityLoopback(arl_tenSource enSrc, arl_tenActivity enAct)
{
  tBool bRet = false;

  //Check for thread ID
  if(m_s32MyThreadID != OSAL_ThreadWhoAmI()) // check for calls with wrong thread context
  {
    tPU8 pu8DataCpy = new tU8[3];

    if ( OSAL_NULL != pu8DataCpy )
    {
      *(pu8DataCpy+0) = (tU8)ARL_EN_LOOPBACK_SRCACTRESULT;  //FunctionID for SrcActivity Result
      *(pu8DataCpy+1) = (tU8)enSrc;
      *(pu8DataCpy+2) = (tU8)enAct;

      vRxFromOtherThreads(3, pu8DataCpy);
      OSAL_DELETE []pu8DataCpy;
      bRet = true;
    }
  }
  return bRet;
}

/******************************************************************************
** FUNCTION:  tBool arl_tclISource::vSourceActivityResult(arl_tenSource ..
******************************************************************************/
tVoid arl_tclISource_AIL::vSourceActivityResult(arl_tenSource enSrcNum, const arl_tSrcActivity& enActivityAck, tU16 SubSource)
{
  (void)SubSource; //LINT
  arl_tenActivity act = static_cast<arl_tenActivity>(enActivityAck.enType);

  if(false == bTriggerSrcActivityLoopback(enSrcNum, act))
  {
    m_poISourceVFsm->vOnSrcActResult(enSrcNum,  act);
  }
};

/******************************************************************************
** FUNCTION:  tBool arl_tclISource::vSourceActivityResult(arl_tenSource ..
******************************************************************************/
tVoid arl_tclISource_AIL::vSourceActivityResult(arl_tenSource enSrcNum, arl_tenActivity enActivityAck, tU16 SubSource)
{
  (void)SubSource; //LINT
  if(false == bTriggerSrcActivityLoopback(enSrcNum, enActivityAck))
  {
    m_poISourceVFsm->vOnSrcActResult(enSrcNum,  enActivityAck);
  }
};

/******************************************************************************
** FUNCTION:  tVoid arl_tclISource_AIL::vOnLoopback(tU16 u16ServiceID, am..
******************************************************************************/

/*virtual*/
tVoid arl_tclISource_AIL::vOnLoopback
(
   tU16 u16ServiceID
   , amt_tclServiceData* poMessage
)
{
   if(m_poISourceVFsm != NULL)
   {
      ETG_TRACE_USR1(("%d: vOnLoopback() Service entered.",
      ETG_ENUM(ail_u16AppId,  m_poISourceVFsm->u16GetAppId())));
   }else{
      ETG_TRACE_ERR(("arl_tclISource_AIL::vSetSrcAvailable: m_poISourceVFsm == NULL "));
      ETG_TRACE_USR1(("vOnLoopback() Service entered."));
   }

   if(FALSE == bDefaultSvcDataHandler(this, poMessage))
   {
      // No default handler found, check for get/upreg/relupreg messages.
      switch (poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            ail_tenCommunicationError enResult = eUpdateRequestingClient(poMessage);

            if (AIL_EN_N_NO_ERROR != enResult)
            {
               ETG_TRACE_ERR(("GET with Function id:%d resulted in error"
                  , ETG_ENUM(AUDCU_FID, poMessage->u16GetFunctionID())));
            }
         }
         break;

         default:
         {
            // Trace: Nothing else to do since it is a loopback message.
            // Message will be deleted by the framework.
            // No error message to be sent back if loop back could not find a
            // mapping function - just perform the trace.
            ETG_TRACE_ERR(("vOnLoopback() could not find a mapping function."));
            ETG_TRACE_ERR(("Opcode: %d, FID: %d", ETG_ENUM(OP_CODES
               , poMessage->u8GetOpCode()), ETG_ENUM(AUDCU_FID
               , poMessage->u16GetFunctionID())));
         }
         break;
      }

   }  // if(FALSE == ahl_tclBaseOneThreadService::bDefaultSvcDataHandler(this,..

   // Avoid Lint - Parameter needs to be neglected without LINT objection.
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(u16ServiceID);
}  // tVoid audcu_tclAudCueService::vOnLoopback(tU16 u16ServiceID, am..


////////////////////////////////////////////////////////////////////////////////

// <EOF>
