#include "arl_tclISourceIF.h"
#include "arl_tclISourceVFsm.h"
#include "arl_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ARL_ISOURCE
#include "trcGenProj/Header/arl_tclISourceIF.cpp.trc.h"
#endif


#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include <generic_msgs_if.h>

arl_tclISourceIF::arl_tclISourceIF(ahl_tclBaseOneThreadApp* pAhlAppInterface,tU16 u16ServiceID) :
      _u16AppID(0),
      _u16ServiceID(u16ServiceID),
      _u16ServiceMajorVersion(1),
      _u16ServiceMinorVersion(0),
      _u16ServicePatchVersion(0),
      m_poISourceVFsm(NULL),
      _pAilAppInterface(NULL),
      _pAhlAppInterface(pAhlAppInterface)

{
   m_s32MyThreadID = OSAL_ThreadWhoAmI(); //moved to here because of possible early return below
   if(pAhlAppInterface == NULL)
      {
         ETG_TRACE_ERRMEM(("arl_tclISourceIF: pAhlAppInterface is NULL for AHL Variant, check constructor call"));
         FATAL_M_ASSERT_ALWAYS();
         return;
      }
   _u16AppID = pAhlAppInterface->u16GetAppId();
}

arl_tclISourceIF::arl_tclISourceIF(ail_tclAppInterfaceRestricted* pAilAppInterface,tU16 u16ServiceID) :
   _u16AppID(0),
   _u16ServiceID(u16ServiceID),
   _u16ServiceMajorVersion(1),
   _u16ServiceMinorVersion(0),
   _u16ServicePatchVersion(0),
   m_poISourceVFsm(NULL),
   _pAilAppInterface(pAilAppInterface),
   _pAhlAppInterface(NULL)

{
   m_s32MyThreadID = OSAL_ThreadWhoAmI();
   // For AIL based Application we need to have this
   // AIL App Pointer
   if(_pAilAppInterface == NULL)
   {
      ETG_TRACE_ERRMEM(("arl_tclISourceIF: AILAppInterface is NULL for AIL Variant, check constructor call"));
      FATAL_M_ASSERT_ALWAYS();
      return;
   }
   _u16AppID = _pAilAppInterface->u16GetAppId();
}


tBool arl_tclISourceIF::bSetMuteState(arl_tenSource, arl_tenMuteState)
{
   if(m_poISourceVFsm != NULL)
   {
      ETG_TRACE_ERRMEM(("%d: OBSOLETE INTERFACE USAGE OF AUDIO-ROUTING-LIB",
            ETG_ENUM(ail_u16AppId, m_poISourceVFsm->u16GetAppId())));
   }
   return FALSE;
}


tVoid arl_tclISourceIF::vOnNewAppStateNotify(tU32 u32OldAppState,tU32 u32AppState)
{
   ETG_TRACE_USR4(("[%d] arl_tclISourceIF::vOnNewAppStateNotify ",
            ETG_ENUM(ail_u16AppId, _u16AppID)));
   if(m_poISourceVFsm != NULL)
   {
      m_poISourceVFsm->vOnNewAppStateNotify(u32OldAppState, u32AppState);
   }
}


/******************************************************************************
** FUNCTION:  tBool arl_tclISource::bSetMuteState(arl_tenSource enSrcNum..
******************************************************************************/
tBool arl_tclISourceIF::bSetMuteState(arl_tenSource enSrcNum, arl_tenMuteAction enMuteAction, audioroutinglib::arl_tclBitmask<arl_enMuteReason> muteReason)
{
    ETG_TRACE_USR4(("[%d] arl_tclISourceIF::bSetMuteState called for source: %d", ETG_ENUM(ail_u16AppId, _u16AppID), enSrcNum));

   if(m_poISourceVFsm == NULL)
   {
      ETG_TRACE_ERR(("Thread %d: m_poISourceVFsm is NULL", OSAL_ThreadWhoAmI()));
      NORMAL_M_ASSERT_ALWAYS();
      return FALSE;
   }

    if( (m_s32MyThreadID != OSAL_ThreadWhoAmI()) && (TRUE == bIsArlServiceAvailable()) ) // check for different thread context
  {
     tPU8 pu8DataCpy = new tU8[7];

    if ( OSAL_NULL != pu8DataCpy )
    {
      *(pu8DataCpy+0) = (tU8)ARL_EN_LOOPBACK_SETMUTESTATE;  //MuteFunctionId
      *(pu8DataCpy+1) = (tU8)enSrcNum;
      *(pu8DataCpy+2) = (tU8)enMuteAction;
      *(pu8DataCpy+3) = (tU8)((muteReason.getValue() & 0xFF000000)>>24);
      *(pu8DataCpy+4) = (tU8)((muteReason.getValue() & 0x00FF0000)>>16);
      *(pu8DataCpy+5) = (tU8)((muteReason.getValue() & 0x0000FF00)>>8);
      *(pu8DataCpy+6) = (tU8)(muteReason.getValue() & 0x000000FF);

      vRxFromOtherThreads(7, pu8DataCpy);
      OSAL_DELETE []pu8DataCpy;
      return TRUE;
    }
    return FALSE;
  }
  else
  {
    m_poISourceVFsm->vSetMuteState(enSrcNum, enMuteAction, muteReason);

    if(eUpdateClients(ARL_EN_MUTE_REQ) == AIL_EN_N_NO_ERROR)
    {
      return TRUE;
    }
    return FALSE;
  }
}

/******************************************************************************
 ** FUNCTION:  tBool arl_tclISourceIF::bIsArlServiceAvailable() ..
 ******************************************************************************/
tBool arl_tclISourceIF::bIsArlServiceAvailable()
{
  tBool bArlServiceAvailable = FALSE;
  if(_pAhlAppInterface != NULL)
  {
    if(AMT_C_U8_SVCSTATE_AVAILABLE == _pAhlAppInterface->u8GetServiceAvailability(u16GetServiceID()))
    {
      bArlServiceAvailable = TRUE;
    }
  }
  else if(_pAilAppInterface != NULL)
  {
    if(AMT_C_U8_SVCSTATE_AVAILABLE == _pAilAppInterface->u8GetServiceAvailability(u16GetServiceID()))
    {
      bArlServiceAvailable = TRUE;
    }
  }
  return bArlServiceAvailable;
}

/******************************************************************************
** FUNCTION:  tVoid arl_tclISource::vRxFromOtherThreads(tU32 ..
******************************************************************************/
tVoid arl_tclISourceIF::vRxFromOtherThreads (tU32 size, tPCUChar pcu8Data)
{
   // validate preconditions
   if (NULL == pcu8Data)
   {
      ETG_TRACE_FATAL(("arl_tclISource::vRxFromOtherThreads() - invalid message pointer"));
      return;
   }
   else if (size < 1)  //Minimum buffer size is 1
   {
      ETG_TRACE_FATAL(("arl_tclISource::vRxFromOtherThreads() - Message too short; only %u bytes.", size));
      return;
   }

   // Create a Stream message and fill with data.
   tU16 u16MyAppID = u16GetAppID();
   tU16 u16MyServiceID = u16GetServiceID();

   gm_tclStreamMessage oMsg
      (    u16MyAppID                 // Source app-ID
         , u16MyAppID                 // Dest. app-ID
         , 0                                 // Reg ID
         , 0                                 // Command counter
         , u16MyServiceID             // ServiceId
         , ARL_EN_LOOPBACK  // FID
         , CCA_C_U8_OPCODE_METHODSTART       // Opcode
         , size                              // Buffer Size
      );

   // Deliver the loopback message
   if (oMsg.bIsValid())
   {
    oMsg.vSetData((const tChar*)pcu8Data);    // Set the data from trace into the stream.

    ail_tenCommunicationError enCommError = AIL_EN_N_NOT_SEND;

    if(NULL != _pAhlAppInterface)
      enCommError = _pAhlAppInterface->enPostMessage(&oMsg, TRUE);
    else if(NULL != _pAilAppInterface)
      enCommError = _pAilAppInterface->enPostMessage(&oMsg, TRUE);
    else
    {
      ETG_TRACE_ERR(("arl_tclISource::vRxFromOtherThreads() - Loopback message not posted error, CCA interface pointer is NULL"));
    }

      if (AIL_EN_N_NO_ERROR == enCommError)
      {
         ETG_TRACE_USR3(("arl_tclISource::vRxFromOtherThreads()"
             " - successfully streamed %u bytes in Loopback message"
             , size));

         ETG_TRACE_USR4(("Streamed: %02x", ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));
      }
      else
      {
         ETG_TRACE_ERR(("arl_tclISource::vRxFromOtherThreads()"
            " - Streaming %u bytes in Loopback message returned  E R R O R  %u"
            , size, ETG_ENUM(AIL_ERROR, enCommError)));
      }
   }
   else
   {
      ETG_TRACE_ERR(("arl_tclISource::vRxFromOtherThreads()"
         " - Streaming Loopback message  F A I L E D  delivering %u bytes"
         " - Message invalid", size));
   }
}

/******************************************************************************
** FUNCTION:  tBool arl_tclISource::bSetMuteState(arl_tenSource enSrcNum..
******************************************************************************/
// daw2hi: adapted 1st param, where SourceID has source and subsource
tBool arl_tclISourceIF::bSetAudioRouteRequest(SourceID SrcId, arl_tenActivity enRequest, audioroutinglib::arl_tclBitmask<arl_enRouteReqReason> Reason)
{
   if(m_poISourceVFsm == NULL)
   {
      ETG_TRACE_ERR(("Thread %d: m_poISourceVFsm is NULL",OSAL_ThreadWhoAmI()));
      NORMAL_M_ASSERT_ALWAYS();
      return FALSE;
   }

  if( (m_s32MyThreadID != OSAL_ThreadWhoAmI()) && (TRUE == bIsArlServiceAvailable()) ) // check for different thread context
  {
    tPU8 pu8DataCpy = new tU8[9];

    if ( OSAL_NULL != pu8DataCpy )
    {
      *(pu8DataCpy+0) = (tU8)ARL_EN_LOOPBACK_SETAUDIOROUTEREQUEST;
      *(pu8DataCpy+1) = (tU8)SrcId.enSourceClass;
      *(pu8DataCpy+2) = (tU8)((SrcId.u16SubSource & 0xFF00)>>8);
      *(pu8DataCpy+3) = (tU8)(SrcId.u16SubSource & 0x00FF);
      *(pu8DataCpy+4) = (tU8)enRequest;
      *(pu8DataCpy+5) = (tU8)((Reason.getValue() & 0xFF000000)>>24);
      *(pu8DataCpy+6) = (tU8)((Reason.getValue() & 0x00FF0000)>>16);
      *(pu8DataCpy+7) = (tU8)((Reason.getValue() & 0x0000FF00)>>8);
      *(pu8DataCpy+8) = (tU8)(Reason.getValue() & 0x000000FF);

      vRxFromOtherThreads(9, pu8DataCpy);
      OSAL_DELETE []pu8DataCpy;
      return TRUE;
    }
    return FALSE;
  }
   else
   {
     m_poISourceVFsm->vSetRouteRequest(SrcId, enRequest, Reason);

     if(eUpdateClients(ARL_EN_ROUTEREQUEST) == AIL_EN_N_NO_ERROR)
     {
       return TRUE;
     }
     return FALSE;
   }
}

/******************************************************************************
** FUNCTION:  tBool arl_tclISource::bSetSourceAvailability(arl_tenSource ...
******************************************************************************/
tBool arl_tclISourceIF::bSetSourceAvailability(arl_tenSrcAvailability srcAvailability, arl_tenAvailabilityReason availabilityReason, arl_tenSource enSource, tU16 u16SubSource)
{
   if(m_poISourceVFsm == NULL)
   {
      ETG_TRACE_ERR(("Thread %d: m_poISourceVFsm is NULL",OSAL_ThreadWhoAmI()));
      NORMAL_M_ASSERT_ALWAYS();
      return FALSE;
   }

  if( (m_s32MyThreadID != OSAL_ThreadWhoAmI()) && (TRUE == bIsArlServiceAvailable()) ) // check for different thread context
  {
    tPU8 pu8DataCpy = new tU8[6];

    if ( OSAL_NULL != pu8DataCpy )
    {
      *(pu8DataCpy+0) = (tU8)ARL_EN_LOOPBACK_SETSOURCEAVAILABILITY;
      *(pu8DataCpy+1) = (tU8)srcAvailability;
      *(pu8DataCpy+2) = (tU8)availabilityReason;
      *(pu8DataCpy+3) = (tU8)enSource;
      *(pu8DataCpy+4) = (tU8)((u16SubSource & 0xFF00)>>8);
      *(pu8DataCpy+5) = (tU8)(u16SubSource & 0x00FF);

      vRxFromOtherThreads(6, pu8DataCpy);
      OSAL_DELETE []pu8DataCpy;
      return TRUE;
    }
    return FALSE;
  }
   else
   {
     m_poISourceVFsm->vSetSourceAvailability(srcAvailability, availabilityReason, enSource, u16SubSource);

     if(eUpdateClients(ARL_EN_SOURCEAVAILABLE) == AIL_EN_N_NO_ERROR)
     {
       return TRUE;
     }
     return FALSE;
   }
}
/******************************************************************************
** FUNCTION:  tBool arl_tclISource::bSetAudioProperty(arl_tenSource enSrcNum..
******************************************************************************/
tBool arl_tclISourceIF::bSetAudioProperty(arl_tenSource enSrcNum,  arl_tenSourcePropType PropType, tS32 PropValue, tU16 SubSource)
{
  ETG_TRACE_USR4(("bSetAudioProperty is entered"));
   if(m_poISourceVFsm == NULL)
   {
      ETG_TRACE_ERR(("Thread %d: m_poISourceVFsm is NULL",OSAL_ThreadWhoAmI()));
      NORMAL_M_ASSERT_ALWAYS();
      return FALSE;
   }

  if( (m_s32MyThreadID != OSAL_ThreadWhoAmI()) && (TRUE == bIsArlServiceAvailable()) ) // check for different thread context
  {
    tPU8 pu8DataCpy = new tU8[9];

    if ( OSAL_NULL != pu8DataCpy )
    {
      *(pu8DataCpy+0) = (tU8)ARL_EN_LOOPBACK_SETAUDIOPROPERTY;
      *(pu8DataCpy+1) = (tU8)enSrcNum;
      *(pu8DataCpy+2) = (tU8)PropType;
      *(pu8DataCpy+3) = (tU8)((PropValue & 0xFF000000)>>24);
      *(pu8DataCpy+4) = (tU8)((PropValue & 0x00FF0000)>>16);
      *(pu8DataCpy+5) = (tU8)((PropValue & 0x0000FF00)>>8);
      *(pu8DataCpy+6) = (tU8)(PropValue & 0x000000FF);
      *(pu8DataCpy+7) = (tU8)((SubSource & 0xFF00)>>8);
      *(pu8DataCpy+8) = (tU8)(SubSource & 0x00FF);

      vRxFromOtherThreads(9, pu8DataCpy);
      OSAL_DELETE []pu8DataCpy;
      return TRUE;
    }
    return FALSE;
  }
   else
   {
     m_poISourceVFsm->vSetAudioProperty(enSrcNum, PropType, PropValue, SubSource);
      if(eUpdateClients(ARL_EN_AUDIOPROPERTY) == AIL_EN_N_NO_ERROR)
      {
         return TRUE;
      }
      return FALSE;
   }
}
/******************************************************************************
** FUNCTION:  tBool arl_tclISource::bSendFGGraphCmd(arl_tenSource enSrcNum..
******************************************************************************/
tBool arl_tclISourceIF::bSendFGGraphCmd(arl_tenSource enSrcNum, arl_tenFGCommand enFGCmd)
{
   ETG_TRACE_USR4(("[%d] bSendFGGraphCmd(%d,%d)",
            ETG_ENUM(ail_u16AppId, _u16AppID),
            ETG_ENUM(arl_tenSource, enSrcNum),
            ETG_ENUM(arl_tenFGCommand, enFGCmd)));
   if(m_poISourceVFsm == NULL)
   {
      ETG_TRACE_ERR(("[%d] m_poISourceVFsm == NULL",
                  ETG_ENUM(ail_u16AppId, _u16AppID)));
      return FALSE;
   }

  if( (m_s32MyThreadID != OSAL_ThreadWhoAmI()) && (TRUE == bIsArlServiceAvailable()) ) // check for different thread context
  {
    tPU8 pu8DataCpy = new tU8[3];

    if ( OSAL_NULL != pu8DataCpy )
    {
      *(pu8DataCpy+0) = (tU8)ARL_EN_LOOPBACK_SENDFGGRAPHCMD;
      *(pu8DataCpy+1) = (tU8)enSrcNum;
      *(pu8DataCpy+2) = (tU8)enFGCmd;

      vRxFromOtherThreads(3, pu8DataCpy);
      OSAL_DELETE []pu8DataCpy;
      return TRUE;
    }
    return FALSE;
  }
   else
   {
     return m_poISourceVFsm->bSendFGGraphCmd(enSrcNum, enFGCmd);
   }
}

/******************************************************************************
** FUNCTION:  tBool arl_tclISource::bSendFGGraphCmd(arl_tenSource enSrcNum..
******************************************************************************/
amt_tclServiceData* arl_tclISourceIF::pStatusMessageFactory
(
   tU16 u16Target
   , tU16 u16FunctionId
   , tU16 u16RegisterID
   , tU16 u16CmdCounter
)
{
   fi_tclVisitorMessage* poStatusMsg = OSAL_NULL;

   tU16 u16SerMajVer   =  1;

   if(m_poISourceVFsm != NULL)
   {
      ETG_TRACE_USR1(("[%d] pStatusMessageFactory called for FID:%d, Target:0x%x",
         ETG_ENUM(ail_u16AppId, m_poISourceVFsm->u16GetAppId()),
         u16FunctionId,
         u16Target));
   }else{
      ETG_TRACE_ERR(("AudioRoutingLib: m_poISourceVFsm is NULL"));
      return NULL;
   }
   switch (u16FunctionId)
   {
      case ARL_EN_SOURCEAVAILABLE:
            {
               midw_aud_src_routefi_tclMsgSourceAvailabilityStatus oMsgSrcAvailabilityList;
               //Get collection and Iterator
               std::map<SourceID,  arl_stSrcAvailabilityTuple> const  srcAvailMap = m_poISourceVFsm->tGetSourceAvailabilityMap();
               std::map<SourceID,  arl_stSrcAvailabilityTuple>::const_iterator srcAvailMapIter = srcAvailMap.begin();
               //Add MidwFI Element for every Item
               while( srcAvailMapIter != srcAvailMap.end())
               {
                  //get data from map
                  midw_fi_tcl_SourceAvailablityItem oMsgSrcAvailability;
                  oMsgSrcAvailability.u8Source.enType       = static_cast<midw_fi_tcl_e8_AudSource::tenType>       ((*srcAvailMapIter).first.enSourceClass);
                  oMsgSrcAvailability.u16SubSource          = static_cast<midw_fi_tcl_e8_AudSource::tenType>       ((*srcAvailMapIter).first.u16SubSource);
                  oMsgSrcAvailability.e8Availability.enType = static_cast<midw_fi_tcl_e8_SrcAvailability::tenType> ((*srcAvailMapIter).second.availability);
                  oMsgSrcAvailability.e8Reason.enType       = static_cast<midw_fi_tcl_e8_SrcAvailabilityReason::tenType> ((*srcAvailMapIter).second.reason);

                  ETG_TRACE_USR4(("[%d] pStatusMessageFactory: PushBack ARL_EN_SOURCEAVAILABLE: Src: %d subID: %d Availability: %d, Reason %d",
                        ETG_ENUM(ail_u16AppId, m_poISourceVFsm->u16GetAppId()),
                        ETG_ENUM(arl_tenSource,     (*srcAvailMapIter).first.enSourceClass),
                        (*srcAvailMapIter).first.u16SubSource,
                        ETG_ENUM(arl_tenSrcAvailability, (*srcAvailMapIter).second.availability),
                        ETG_ENUM(arl_tenAvailabilityReason, (*srcAvailMapIter).second.reason)));
                  //push back to list
                  oMsgSrcAvailabilityList.SourceAvailabilityList.push_back(oMsgSrcAvailability);
                  //step to next item
                  ++srcAvailMapIter;
               }
               poStatusMsg =  OSAL_NEW fi_tclVisitorMessage(oMsgSrcAvailabilityList, u16SerMajVer);
               NORMAL_M_ASSERT(OSAL_NULL != poStatusMsg);
            }
            break;

      case ARL_EN_ROUTEREQUEST:
      {
      // daw2hi: adapted to the new map with SourceID
        midw_aud_src_routefi_tclMsgRequestAudioRouteStatus oMsgRouteReqList;
         //Get collection and Iterator
    std::map<SourceID,  arl_tenActivity> const  routeReqMap = m_poISourceVFsm->tGetRouteRequestMap();
    std::map<SourceID,  arl_tenActivity>::const_iterator routeReqMapIter = routeReqMap.begin();
         //Add MidwFI Element for every Item
         while( routeReqMapIter != routeReqMap.end())
         {
            //get data from map
            midw_fi_tcl_RequestAudioRouteItem oMsgRouteReq;

      oMsgRouteReq.u8Source.enType    = static_cast<midw_fi_tcl_e8_AudSource::tenType>   ((*routeReqMapIter).first.enSourceClass);
      oMsgRouteReq.u16SubSource    =    ((*routeReqMapIter).first.u16SubSource);
            oMsgRouteReq.e8Activity.enType  = static_cast<midw_fi_tcl_e8_SrcActivity::tenType> ((*routeReqMapIter).second);

      ETG_TRACE_USR4(("%d: pStatusMessageFactory: PushBack ARL_EN_ROUTEREQUEST: Src: %d SubSrc: %d Act: %d",
        ETG_ENUM(ail_u16AppId, m_poISourceVFsm->u16GetAppId()),
        ETG_ENUM(arl_tenSource,     (*routeReqMapIter).first.enSourceClass),
        (*routeReqMapIter).first.u16SubSource,
        ETG_ENUM(arl_tenActivity, (*routeReqMapIter).second)));
            //push back to list
            oMsgRouteReqList.RequestAudioRouteList.push_back(oMsgRouteReq);
            //step to next item
            ++routeReqMapIter;
         }
         poStatusMsg =  OSAL_NEW fi_tclVisitorMessage(oMsgRouteReqList, u16SerMajVer);
         NORMAL_M_ASSERT(OSAL_NULL != poStatusMsg);
      }
      break;
      case ARL_EN_MUTE_REQ:
      {
         //MidwFI Container
         midw_aud_src_routefi_tclMsgMuteRequestStatus oMsgMuteReqList;

         //Get collection and Iterator
         std::map<arl_tenSource, arl_stSetMuteTuple * > const  muteMap = m_poISourceVFsm->tGetMuteStateMap();
         std::map<arl_tenSource, arl_stSetMuteTuple * >::const_iterator muteMapIter = muteMap.begin();

         //Add MidwFI Element for every Item
         while( muteMapIter != muteMap.end())
         {
            //Check if there're mute requests
            if((*muteMapIter).second != NULL)
            {
               //get data from map
               midw_fi_tcl_MuteRequestItem oMsgMuteReq;
               oMsgMuteReq.u8Source.enType    = static_cast<midw_fi_tcl_e8_AudSource::tenType> ((*muteMapIter).first);
               oMsgMuteReq.u8Action.enType    = static_cast<midw_fi_tcl_e8MuteAction::tenType> ((*muteMapIter).second->muteAction);
               oMsgMuteReq.u32Reason.u32Value     = static_cast<tU32> ((*muteMapIter).second->muteReason.getValue());

               //@todo Mute Reason is not filled
               //oMsgMuteReq.u32Reason  = static_cast<midw_fi_tcl_e8MuteAction::EN_TYPE> ((*muteMapIter).second);
               ETG_TRACE_USR4(("%d: pStatusMessageFactory: PushBack ARL_EN_MUTE_REQ: Src: %d Act: %d Reason: 0x%x",
                     ETG_ENUM(ail_u16AppId, m_poISourceVFsm->u16GetAppId()),
                     ETG_ENUM(arl_tenSource, (*muteMapIter).first),
                     ETG_ENUM(arl_tenMuteAction, (*muteMapIter).second->muteAction),
                     (*muteMapIter).second->muteReason.getValue() ));
               //push back to list
               oMsgMuteReqList.MuteRequestList.push_back(oMsgMuteReq);
            }
            //step to next item
            ++muteMapIter;
         }
         poStatusMsg =  OSAL_NEW fi_tclVisitorMessage(oMsgMuteReqList, u16SerMajVer);
         NORMAL_M_ASSERT(OSAL_NULL != poStatusMsg);
      }
      break;
      case ARL_EN_MUTE_STATE:
      {
         ETG_TRACE_USR1(("%d: pStatusMessageFactory: There is no Status Message ARL_EN_MUTE_STATE as per design",
               ETG_ENUM(ail_u16AppId, m_poISourceVFsm->u16GetAppId())));
      }
      break;
    case ARL_EN_AUDIOPROPERTY:
      {
         ETG_TRACE_USR4(("ARL_EN_AUDIOPROPERTY is entered"));
         midw_aud_src_routefi_tclMsgSetAudioPropertyStatus oMsgSrcSetAudioPropStatusList;
               //Get collection and Iterator
               std::map<SourceID,  arl_stSrcAudioPropertyTuple> const  srcAudioPropMap = m_poISourceVFsm->tGetSrcAudioProperty();
               std::map<SourceID,  arl_stSrcAudioPropertyTuple>::const_iterator srcAudioPropMapIter = srcAudioPropMap.begin();
               while( srcAudioPropMapIter != srcAudioPropMap.end())
               {
                  //arl_tISrcAvailabilityItem oMsgSrcAvailability;
                   //get data from map
                  midw_fi_tcl_SetAudioPropertyItem oMsgSrcSetAudioPropStatus;
                  oMsgSrcSetAudioPropStatus.u8Source.enType       = static_cast<midw_fi_tcl_e8_AudSource::tenType>       ((*srcAudioPropMapIter).first.enSourceClass);
                  oMsgSrcSetAudioPropStatus.u16SubSource          = static_cast<midw_fi_tcl_e8_AudSource::tenType>       ((*srcAudioPropMapIter).first.u16SubSource);
                  oMsgSrcSetAudioPropStatus.u8Property.enType = static_cast<midw_fi_tcl_e8_AudioProperty::tenType> ((*srcAudioPropMapIter).second.PropType);
                  oMsgSrcSetAudioPropStatus.s32PropValue       = static_cast<midw_fi_tcl_e8_AudioProperty::tenType> ((*srcAudioPropMapIter).second.PropValue);
          ETG_TRACE_USR4(("Audio Property: source = %d, sub source = %d, PropType = %d, PropValue = %d",
          oMsgSrcSetAudioPropStatus.u8Source.enType, oMsgSrcSetAudioPropStatus.u16SubSource, oMsgSrcSetAudioPropStatus.u8Property.enType,
          oMsgSrcSetAudioPropStatus.s32PropValue));
                  //push back to list
          oMsgSrcSetAudioPropStatusList.SetAudioPropertyList.push_back(oMsgSrcSetAudioPropStatus);
                  //step to next item
                  ++srcAudioPropMapIter;
               }
               poStatusMsg =  OSAL_NEW fi_tclVisitorMessage(oMsgSrcSetAudioPropStatusList, u16SerMajVer);
               NORMAL_M_ASSERT(OSAL_NULL != poStatusMsg);
      }
      break;
      default:
      {
      }  // default:
      break;
   }  // switch (u16FunctionId)

   // Service data is filled in by CCX Framework, hence nothing to do.
   if(( OSAL_NULL != poStatusMsg ))
   {
      // Initialize Service Message
      poStatusMsg->vInitServiceData( m_poISourceVFsm->u16GetAppId()       // Source AppID
         , u16Target                            // Target AppID
         , AMT_C_U8_CCAMSG_STREAMTYPE_NODATA    // StreamType
         , 0                                    // StreamCounter
         , u16RegisterID                        // RegisterID
         , u16CmdCounter                        // CmdCounter,
         , _u16ServiceID                        // ServiceID,
         , u16FunctionId                        // Function ID
         , AMT_C_U8_CCAMSG_OPCODE_STATUS );     // Opcode
   }

   return poStatusMsg;

}  // amt_tclServiceData* arl_tclISource_AIL::pStatusMessageFactory(tU16 u16T..

tVoid arl_tclISourceIF::vCCA_OnUpRegRouteReq(amt_tclServiceData* poMessage)
{
   if(m_poISourceVFsm!= NULL)
      {
         ETG_TRACE_USR1(("%d: vOnUpRegRouteReq",
               ETG_ENUM(ail_u16AppId, m_poISourceVFsm->u16GetAppId())));
      }
   eUpdateClients(ARL_EN_ROUTEREQUEST, poMessage);
}


tVoid arl_tclISourceIF::vCCA_OnUpRegMuteReq(amt_tclServiceData* poMessage)
{
   if(m_poISourceVFsm!= NULL)
   {
      ETG_TRACE_USR1(("%d: vOnUpRegMuteReq",
            ETG_ENUM(ail_u16AppId, m_poISourceVFsm->u16GetAppId())));
   }
   eUpdateClients(ARL_EN_MUTE_REQ, poMessage);
}

tVoid arl_tclISourceIF::vCCA_OnMuteState(amt_tclServiceData* poMessage)
{
   if(m_poISourceVFsm == NULL)
   {
      NORMAL_M_ASSERT_ALWAYS();
      ETG_TRACE_ERR(("m_poISourceVFsm == NULL"));
      return;
   }
   //Xtract Data
   midw_aud_src_routefi_tclMsgMuteStateSet oMsgMuteState;
   fi_tclVisitorMessage(poMessage).s32GetData(oMsgMuteState);
   arl_tenSource src = static_cast<arl_tenSource>(oMsgMuteState.u8Source.enType);
   arl_tenMuteState state = static_cast<arl_tenMuteState>(oMsgMuteState.u8MuteState.enType);

   ETG_TRACE_USR1(("%d: Received MuteState: Source %d, MuteState %d",
         ETG_ENUM(ail_u16AppId,     m_poISourceVFsm->u16GetAppId()) ,
         ETG_ENUM(arl_tenSource,    src),
         ETG_ENUM(arl_tenMuteState, state)));

   //call Players' Interface
   bOnMuteState(src, state);
}

tBool arl_tclISourceIF::bSendMessage(amt_tclServiceData &rfcoServiceData)
{
   ETG_TRACE_USR4(("bSendMessage FctID %d", rfcoServiceData.u16GetFunctionID()));
   if(_pAilAppInterface != NULL)
   {
      ETG_TRACE_USR4(("bSendMessage: AIL Posting Message to %d, FctID: %d"
            , rfcoServiceData.u16GetTargetAppID()
            , rfcoServiceData.u16GetFunctionID()));
      ail_tenCommunicationError ret = _pAilAppInterface->enPostMessage(&rfcoServiceData, TRUE);
      if(ret == AIL_EN_N_NO_ERROR)
      {
         return TRUE;
      }
   }
   if(_pAhlAppInterface != NULL)
   {
      ETG_TRACE_USR4(("bSendMessage: AHL Posting Message to %d, FctID: %d"
            , rfcoServiceData.u16GetTargetAppID()
            , rfcoServiceData.u16GetFunctionID()));
      ail_tenCommunicationError ret = _pAhlAppInterface->enPostMessage(&rfcoServiceData, TRUE);
      if(ret == AIL_EN_N_NO_ERROR)
      {
         return TRUE;
      }
   }
   ETG_TRACE_USR1(("bSendMessage Send FAILED"));
   return FALSE;
}


tBool arl_tclISourceIF::bOnAudioRouteRequestReject(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("arl_tclISourceIF::bOnAudioRouteRequestReject"));
  bool bRet = false;
  //extract Source and SubSource and call Application
  fi_tclVisitorMessage oVisitorMsg(poMessage);
  midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet oFiDataObject1;


  if(oVisitorMsg.s32GetData(oFiDataObject1) != OSAL_ERROR)
  {
    arl_tenSource enSource = static_cast<arl_tenSource>(oFiDataObject1.u8Source.enType);
    tU16 u16SubSource = oFiDataObject1.u16SubSource;
    if(bOnAudioRouteRequestReject(enSource,u16SubSource))
    {
      ETG_TRACE_USR4(("bOnAudioRouteRequestReject() handled by App OK"));
      bRet = true;
    }
    else
    {
      ETG_TRACE_USR4(("App does not handle bOnAudioRouteRequestReject ??"));
      bRet = false;
    }

  }
  else
  {
    ETG_TRACE_USR4(("Error extracting midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet"));
    bRet = false;
  }

  // do we need this??
  //oFiDataObject1.vDestroy();

  return bRet;
}
