/*!
********************************************************************************
* \file              arl_tclBaseClienthandler.cpp
********************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:
*  - COPYRIGHT:      &copy; 2010 - 2012 Robert Bosch Car Multimedia Gmbh
********************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
* \date 31.01.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "arl_tclBaseClienthandler.h"
#include "arl_tclISourceVFsm.h"
#include "arl_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ARL_BASE_CLIENT
#include "trcGenProj/Header/arl_tclBaseClienthandler.cpp.trc.h"
#endif

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/


/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  arl_tclBaseClienthandler::arl_tclBaseClienthandler(ahl_tclBaseO..
******************************************************************************/

arl_tclBaseClienthandler::arl_tclBaseClienthandler
(
   ahl_tclBaseOneThreadApp* const cpoApp
   , arl_tclISourceVFsm* const cpoISourceVFsm
   , tU16 u16ServiceID
   , tU16 u16SrvMajVer
   , tU16 u16SrvMinVer
   , tU16 u16ServerAppID
   , tU16 u16OwnSubID) :
         ahl_tclBaseOneThreadClientHandler(cpoApp, u16ServiceID, u16SrvMajVer, u16SrvMinVer, u16ServerAppID, u16OwnSubID),
        m_u16SrvMajVer(u16SrvMajVer),
        m_cpoISourceVFsm(cpoISourceVFsm)
{
   ETG_TRACE_COMP(("Created client handler for AppId: 0x%x(%d), Service Id: 0x%x(%d), Service Version:%d.%d"
      , cpoApp->u16GetAppId(), cpoApp->u16GetAppId(), u16ServiceID
      , u16ServiceID, m_u16SrvMajVer, u16SrvMinVer));
} // arl_tclBaseClienthandler::arl_tclBaseClienthandler(ahl_tclBaseOneThreadA..

/******************************************************************************
** FUNCTION:  virtual arl_tclBaseClienthandler::~arl_tclBaseClienthandler()
******************************************************************************/

/*virtual*/
arl_tclBaseClienthandler::~arl_tclBaseClienthandler()
{
   try
   {
      ETG_TRACE_COMP(("Destroyed Client for AppId: 0x%x(%d), Service Id: 0x%x(%d)."
         , _poMainAppl->u16GetAppId(), _poMainAppl->u16GetAppId()
         , u16GetServiceID(), u16GetServiceID()));
   }
   catch(...)
   {
   }
} // arl_tclBaseClienthandler::~arl_tclBaseClienthandler()

/******************************************************************************
** FUNCTION:  virtual tVoid arl_tclBaseClienthandler::vOnServiceAvailable()
******************************************************************************/

/*virtual*/
tVoid arl_tclBaseClienthandler::vOnServiceAvailable()
{
   ETG_TRACE_COMP(("Service Available for AppId: 0x%x(%d), Service Id: 0x%x(%d)."
         , _poMainAppl->u16GetAppId(), _poMainAppl->u16GetAppId()
         , u16GetServiceID(), u16GetServiceID()));

   if (OSAL_NULL != m_cpoISourceVFsm)
   {
      (tVoid)m_cpoISourceVFsm->bServiceAvailability(u16GetServiceID());
   }  // if (OSAL_NULL != m_cpoISourceVFsm)
}  // tVoid arl_tclBaseClienthandler::vOnServiceAvailable()

/******************************************************************************
** FUNCTION:  virtual tVoid arl_tclBaseClienthandler::vOnServiceUnavailable()
******************************************************************************/

/*virtual*/
tVoid arl_tclBaseClienthandler::vOnServiceUnavailable()
{
   ETG_TRACE_COMP(("Service Unavailable for AppId: 0x%x(%d), Service Id: 0x%x(%d)."
         , _poMainAppl->u16GetAppId(), _poMainAppl->u16GetAppId()
         , u16GetServiceID(), u16GetServiceID()));

   if (OSAL_NULL != m_cpoISourceVFsm)
   {
      (tVoid)m_cpoISourceVFsm->bServiceAvailability(u16GetServiceID(), FALSE);
   }  // if (OSAL_NULL != m_cpoISourceVFsm)
}  // tVoid arl_tclBaseClienthandler::vOnServiceUnavailable()

/******************************************************************************
** FUNCTION:  tBool arl_tclBaseClienthandler::bSendMessage(const fi_tclMessag..
******************************************************************************/

tBool arl_tclBaseClienthandler::bSendMessage
(
   const fi_tclMessageBase& rfcoMsgBase
   , tCU16 cu16CmdCtr
) const
{
   tBool bRetVal  =  TRUE;

   // Create the Visitor Message
   fi_tclVisitorMessage oOutVisitorMsg(rfcoMsgBase.corfoGetTypeBase(), m_u16SrvMajVer);

   // Initialize the service data.
   ahl_tclBaseOneThreadClientHandler::vInitServiceData(oOutVisitorMsg, cu16CmdCtr, rfcoMsgBase.u16GetFunctionID()
      , rfcoMsgBase.u8GetOpCode());

   if (FALSE != oOutVisitorMsg.bIsValid())
   {
      // Post the message to message queue
      ail_tenCommunicationError enCommError =
         _poMainAppl->enPostMessage(&oOutVisitorMsg, TRUE);

      if (AIL_EN_N_NO_ERROR == enCommError)
      {
         ETG_TRACE_USR1(("Message sent from AppId: 0x%x(%d)>>>ServerAppId: 0x%x(%d)\
                         Opcode: %d, FID:0x%x(%d), RegId: %d, CmdCounter: %d"
            , oOutVisitorMsg.u16GetSourceAppID(), oOutVisitorMsg.u16GetSourceAppID()
            , oOutVisitorMsg.u16GetTargetAppID(), oOutVisitorMsg.u16GetTargetAppID()
            , oOutVisitorMsg.u8GetOpCode(), oOutVisitorMsg.u16GetFunctionID()
            , oOutVisitorMsg.u16GetFunctionID(), oOutVisitorMsg.u16GetRegisterID()
            , oOutVisitorMsg.u16GetCmdCounter()));
      }
      else
      {
         bRetVal  =  FALSE;

         ETG_TRACE_ERR(("Communication Error : %d, could not post message from\
            AppId: 0x%x(%d)>>>ServerAppId: 0x%x(%d)"
            , static_cast<tU16> (enCommError), _poMainAppl->u16GetAppId()
            , _poMainAppl->u16GetAppId(), ahl_tclBaseOneThreadClientHandler::u16GetServerAppID(), ahl_tclBaseOneThreadClientHandler::u16GetServerAppID()));

      }  // if (AIL_EN_N_NO_ERROR != enCommError)

   }  //if( FALSE != oOutVisitorMsg.bIsValid())
   else
   {
      bRetVal  =  FALSE;
      ETG_TRACE_ERR(("Invalid message!!!"));
   }  //End of if-else; if( FALSE != poServiceData->bIsValid())

   return bRetVal;

}  // tBool arl_tclBaseClienthandler::bSendMessage(const fi_tclMessageBase& rf..

/******************************************************************************
** FUNCTION:  tVoid arl_tclBaseClienthandler::vOnError(tU16 u16FID,amt_tclSer..
******************************************************************************/

/*virtual*/
tVoid arl_tclBaseClienthandler::vOnError(tU16 u16FID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_ERR(("vOnError message for service %d FID %d received from \
      ServerAppId: 0x%x(%d)>>>AppId: 0x%x(%d)"
      , (tU16)u16GetServiceID(), u16FID
      , poMessage->u16GetTargetAppID(), poMessage->u16GetTargetAppID()
      , poMessage->u16GetSourceAppID(), poMessage->u16GetSourceAppID()));

   if (OSAL_NULL != m_cpoISourceVFsm)
   {
      if (FALSE == m_cpoISourceVFsm->bOnMessage(poMessage))
      {
         vOnUnknownMessage(poMessage);

      }  // if (FALSE == m_cpoISourceVFsm->bOnMessage(poMessage))

   }  // if (OSAL_NULL != m_cpoISourceVFsm)

}  // tVoid arl_tclBaseClienthandler::vOnError(tU16 u16FID, amt_tclServiceData..

/******************************************************************************
** FUNCTION:  tVoid arl_tclBaseClienthandler::vOnMethodResult(tU16 u16FID,am..
******************************************************************************/

/*virtual*/
tVoid arl_tclBaseClienthandler::vOnMethodResult(tU16 u16FID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("vOnMethodResult message for service %d FID %d received from \
      ServerAppId: 0x%x(%d)>>>AppId: 0x%x(%d)"
      , ETG_ENUM(ail_u16ServiceId, (tU16)u16GetServiceID()), u16FID
      , poMessage->u16GetTargetAppID(), poMessage->u16GetTargetAppID()
      , poMessage->u16GetSourceAppID(), poMessage->u16GetSourceAppID()));

   if (OSAL_NULL != m_cpoISourceVFsm)
   {
      if (FALSE == m_cpoISourceVFsm->bOnMessage(poMessage))
      {
         vOnUnknownMessage(poMessage);

      }  // if (FALSE == m_cpoISourceVFsm->bOnMessage(poMessage))

   }  // if (OSAL_NULL != m_cpoISourceVFsm)

}  // tVoid arl_tclBaseClienthandler::vOnMethodResult(tU16 u16FID, amt_tclServ..

////////////////////////////////////////////////////////////////////////////////

// <EOF>
