

#include "arl_ISourceTypes.h"
#include "arl_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_ARL_ISOURCE
#include "trcGenProj/Header/arl_ISourceTypes.cpp.trc.h"
#endif
/*******************************************************************************
** FUNCTION:  arl_rISrcProp& arl_rISrcProp:: operator= (const arl_rISrcE..
*******************************************************************************/

arl_rISrcProp& arl_rISrcProp::operator= (const arl_rISrcProp& rfcoISrcProp)
{
   // Self check.
   if (this != &rfcoISrcProp)
   {
      m_u16Ucid         =  rfcoISrcProp.m_u16Ucid;
      m_bIsSelfTrig     =  rfcoISrcProp.m_bIsSelfTrig;
      m_u8SourceFBlock  =  rfcoISrcProp.m_u8SourceFBlock;
      m_u8SourceInstID  =  rfcoISrcProp.m_u8SourceInstID;
      m_u8AudioChannels =  rfcoISrcProp.m_u8AudioChannels;
      m_bAllocOnStartUp =  rfcoISrcProp.m_bAllocOnStartUp;

      m_u16Sink         =  rfcoISrcProp.m_u16Sink;
   }  // if (this != &rfcoISrcProp)

   return *this;

}  // arl_rISrcProp& arl_rISrcProp::operator= (const arl_rISrcProp& rfcoIS..

/*******************************************************************************
** Below code was added to remove the dependency to ihl in di_middleware_server/components/audio
** see JIRA Task Gen3 Generic CMG3G-9569 IS2691_BASE: Remove IHL@AudioRouting Lib
*******************************************************************************/

arl_tclISrcAllocStart::arl_tclISrcAllocStart(amt_tclServiceData &rfoServData)
  : arl_tclMsgIdentifiers(rfoServData), m_bValid(FALSE)
{
  ETG_TRACE_USR1(("arl_tclISrcAllocStart"));
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    ETG_TRACE_USR1(("arl_tclISrcAllocStart -> m_bValid=TRUE"));
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tclISrcAllocStart message."));
  }
};

arl_tclISrcAllocStart::~arl_tclISrcAllocStart()
{
  this->vDestroy();
};

tBool arl_tclISrcAllocStart::bIsValid()
{
  return m_bValid;
};

arl_tclISrcDeallocStart::arl_tclISrcDeallocStart(amt_tclServiceData &rfoServData)
  : arl_tclMsgIdentifiers(rfoServData), m_bValid(FALSE)
{
  ETG_TRACE_USR1(("arl_tclISrcDeallocStart"));
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    ETG_TRACE_USR1(("arl_tclISrcDeallocStart -> m_bValid=TRUE"));
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tclISrcDeallocStart message."));
  }
};

arl_tclISrcDeallocStart::~arl_tclISrcDeallocStart()
{
  this->vDestroy();
};

tBool arl_tclISrcDeallocStart::bIsValid()
{
  return m_bValid;
};

arl_tclISrcActivityStart::arl_tclISrcActivityStart(amt_tclServiceData &rfoServData)
: arl_tclMsgIdentifiers(rfoServData), m_bValid(FALSE)
{
  ETG_TRACE_USR1(("arl_tclISrcActivityStart"));
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    ETG_TRACE_USR1(("arl_tclISrcActivityStart -> m_bValid=TRUE"));
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tclISrcActivityStart message."));
  }
};

arl_tclISrcActivityStart::~arl_tclISrcActivityStart()
{
  this->vDestroy();
};

tBool arl_tclISrcActivityStart::bIsValid()
{
  return m_bValid;
};

arl_tclISrcActTimerExpiryStart::arl_tclISrcActTimerExpiryStart(amt_tclServiceData &rfoServData)
: arl_tclMsgIdentifiers(rfoServData), m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tclISrcActTimerExpiryStart message."));
  }
};

arl_tclISrcActTimerExpiryStart::~arl_tclISrcActTimerExpiryStart()
{
  this->vDestroy();
};

tBool arl_tclISrcActTimerExpiryStart::bIsValid()
{
  return m_bValid;
};

arl_tAllocRouteResult::arl_tAllocRouteResult(amt_tclServiceData &rfoServData)
: m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tAllocRouteResult message."));
  }
};

arl_tAllocRouteResult::~arl_tAllocRouteResult()
{
  this->vDestroy();
};

tBool arl_tAllocRouteResult::bIsValid()
{
  return m_bValid;
};

arl_tDeAllocRouteStart::arl_tDeAllocRouteStart(amt_tclServiceData &rfoServData)
: m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tDeAllocRouteStart message."));
  }
};

arl_tDeAllocRouteStart::arl_tDeAllocRouteStart()
: m_bValid(FALSE)
{
  ETG_TRACE_USR1(("arl_tDeAllocRouteStart empty constructor"));
};

arl_tDeAllocRouteStart::~arl_tDeAllocRouteStart()
{
  this->vDestroy();
};

tBool arl_tDeAllocRouteStart::bIsValid()
{
  return m_bValid;
};

arl_tDeAllocRouteResult::arl_tDeAllocRouteResult(amt_tclServiceData &rfoServData)
: m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tDeAllocRouteResult message."));
  }
};

arl_tDeAllocRouteResult::~arl_tDeAllocRouteResult()
{
  this->vDestroy();
};

tBool arl_tDeAllocRouteResult::bIsValid()
{
  return m_bValid;
};

arl_tSetPlayStart::arl_tSetPlayStart(amt_tclServiceData &rfoServData)
: m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tSetPlayStart message."));
  }
};

arl_tSetPlayStart::arl_tSetPlayStart()
: m_bValid(FALSE)
{
  ETG_TRACE_USR1(("arl_tSetPlayStart empty constructor"));
};

arl_tSetPlayStart::~arl_tSetPlayStart()
{
  this->vDestroy();
};

tBool arl_tSetPlayStart::bIsValid()
{
  return m_bValid;
};

arl_tSetPlayResult::arl_tSetPlayResult(amt_tclServiceData &rfoServData)
: m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tSetPlayResult message."));
  }
};

arl_tSetPlayResult::~arl_tSetPlayResult()
{
  this->vDestroy();
};

tBool arl_tSetPlayResult::bIsValid()
{
  return m_bValid;
};

arl_tSrcActTimerExpiryStart::arl_tSrcActTimerExpiryStart(amt_tclServiceData &rfoServData)
: m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tSrcActTimerExpiryStart message."));
  }
};


arl_tSrcActTimerExpiryStart::arl_tSrcActTimerExpiryStart()
: m_bValid(FALSE)
{
};

arl_tSrcActTimerExpiryStart::~arl_tSrcActTimerExpiryStart()
{
  this->vDestroy();
};

tBool arl_tSrcActTimerExpiryStart::bIsValid()
{
  return m_bValid;
};

arl_tSetStopStart::arl_tSetStopStart(amt_tclServiceData &rfoServData)
: m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tSetStopStart message."));
  }
};

arl_tSetStopStart::arl_tSetStopStart()
: m_bValid(FALSE)
{
  ETG_TRACE_USR1(("arl_tSetStopStart empty constructor"));
};


arl_tSetStopStart::~arl_tSetStopStart()
{
  this->vDestroy();
};

tBool arl_tSetStopStart::bIsValid()
{
  return m_bValid;
};

arl_tSetStopResult::arl_tSetStopResult(amt_tclServiceData &rfoServData)
: m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tSetStopResult message."));
  }
};

arl_tSetStopResult::arl_tSetStopResult()
: m_bValid(FALSE)
{
};


arl_tSetStopResult::~arl_tSetStopResult()
{
  this->vDestroy();
};

tBool arl_tSetStopResult::bIsValid()
{
  return m_bValid;
};

arl_tRouteState::arl_tRouteState(amt_tclServiceData &rfoServData)
: m_bValid(FALSE)
{
  if(OSAL_ERROR != fi_tclVisitorMessage(&rfoServData).s32GetData(*this))
  {
    m_bValid=TRUE;
  }
  else
  {
    ETG_TRACE_ERR(("Failed to extract data from arl_tRouteState message."));
  }
};

arl_tRouteState::arl_tRouteState()
: m_bValid(FALSE)
{
};

arl_tRouteState::~arl_tRouteState()
{
  this->vDestroy();
};

tBool arl_tRouteState::bIsValid()
{
  return m_bValid;
};
// <EOF>
