/*!
********************************************************************************
* \file              arl_tclStrClienthandler.h
********************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:
*  - COPYRIGHT:      &copy; 2011 Robert Bosch Car Multimedia Gmbh
********************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 08.02.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

#ifndef ARL_TCLSTRCLIENTHANDLER_H_
#define ARL_TCLSTRCLIENTHANDLER_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#include "arl_tclBaseClienthandler.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| forward declarations
|----------------------------------------------------------------------------*/


/*!
 * \class arl_tclStrClienthandler
 * \brief Stream router client handler - based on eXtended CCA
 *
 */

class arl_tclStrClienthandler: public arl_tclBaseClienthandler
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  arl_tclStrClienthandler::arl_tclStrClienthandler(ahl_tclBa..
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor, based on Dependency Injection
    *          Principle (DIP)
    * \param   [cpoApp]:         (->I) Pointer to the main application
    * \param   [cpoISourceVFsm]: (->I) Pointer to ISource VFSM
    * \param   [u16ServiceID]:   (I) Service Id
    * \param   [u16SrvMajVer]:   (I) Service Major version
    * \param   [u16SrvMinVer]:   (I) Service Minor version
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclStrClienthandler
   (
      ahl_tclBaseOneThreadApp* const cpoApp
      , arl_tclISourceVFsm* const cpoISourceVFsm
      , tU16 u16ServiceID
      , tU16 u16SrvMajVer
      , tU16 u16SrvMinVer
   );

   /***************************************************************************
   ** FUNCTION:  virtual arl_tclStrClienthandler::~arl_tclStrClienthandler()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~arl_tclStrClienthandler();

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual tVoid arl_tclStrClienthandler::vOnStatus(tU16..
   ***************************************************************************/
   /*!
    * \brief   Overloaded function called by the "FWK"
    * \param   [u16FID]:         (I) Function Id
    * \param   [poMessage]:      (->I) Incoming message
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vOnStatus(tU16 u16FID, amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  arl_tclStrClienthandler::arl_tclStrClienthandler()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \note    Default constructor is declared protected to disable it. So
    *          that any attempt to create without parameter will be caught by
    *          the compiler.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclStrClienthandler();    // No definition exists.

   /***************************************************************************
   ** FUNCTION:  arl_tclStrClienthandler::arl_tclStrClienthandler(con..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoBaseClient]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared protected to disable it. So
    *          that any attempt to copy will be caught by the compiler.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclStrClienthandler(const arl_tclStrClienthandler &rfcoBaseClient);

   /***************************************************************************
   ** FUNCTION:  arl_tclStrClienthandler& arl_tclStrClienthandler::operator..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoBaseClient]: (I) Const reference to object to be copied
    * \retval  [arl_tclStrClienthandler&]: Reference to this pointer.
    * \note    Assignment operator is declared protected to disable it. So
    *          that any attempt for assignment will be caught by the compiler.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclStrClienthandler& operator=(const arl_tclStrClienthandler &rfcoBaseClient);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/
}; // class arl_tclStrClienthandler: public ahl_tclBaseOneThreadClientHandler

#endif   // #ifndef ARL_TCLSTRCLIENTHANDLER_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
