/*
 * arl_tclStrClientHandler_AIL.h
 *
 *  Created on: Jul 6, 2012
 *      Author: vo84hi
 */

#ifndef ARL_TCLSTRCLIENTHANDLER_AIL_H_
#define ARL_TCLSTRCLIENTHANDLER_AIL_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#include "arl_tclBaseClienthandler_AIL.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| forward declarations
|----------------------------------------------------------------------------*/


/*!
 * \class arl_tclStrClienthandler
 * \brief Stream router client handler - based on eXtended CCA
 *
 */

class arl_tclStrClientHandler_AIL: public arl_tclBaseClienthandlerAIL
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  arl_tclStrClienthandler::arl_tclStrClienthandler(ahl_tclBa..
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor, based on Dependency Injection
    *          Principle (DIP)
    * \param   [cpoApp]:         (->I) Pointer to the main application
    * \param   [cpoISourceVFsm]: (->I) Pointer to ISource VFSM
    * \param   [u16ServiceID]:   (I) Service Id
    * \param   [u16SrvMajVer]:   (I) Service Major version
    * \param   [u16SrvMinVer]:   (I) Service Minor version
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclStrClientHandler_AIL
   (
        ail_tclAppInterfaceRestricted* const cpoApp
      , arl_tclISourceVFsm* const cpoISourceVFsm
      , tU16 u16ServiceID
      , tU16 u16SrvMajVer
      , tU16 u16SrvMinVer
   );

   /***************************************************************************
   ** FUNCTION:  virtual arl_tclStrClienthandler::~arl_tclStrClienthandler()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~arl_tclStrClientHandler_AIL();

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual tVoid arl_tclStrClienthandler::vOnStatus(tU16..
   ***************************************************************************/
   /*!
    * \brief   Overloaded function called by the "FWK"
    * \param   [u16FID]:         (I) Function Id
    * \param   [poMessage]:      (->I) Incoming message
    * \retval  NONE
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vOnStatus(tU16 u16FID, amt_tclServiceData* poMessage);

   /***************************************************************************
   ** FUNCTION:  arl_tclStrClienthandler::arl_tclStrClienthandler()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \note    Default constructor is declared protected to disable it. So
    *          that any attempt to create without parameter will be caught by
    *          the compiler.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclStrClientHandler_AIL();    // No definition exists.

   /***************************************************************************
   ** FUNCTION:  arl_tclStrClienthandler::arl_tclStrClienthandler(con..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoBaseClient]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared protected to disable it. So
    *          that any attempt to copy will be caught by the compiler.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclStrClientHandler_AIL(const arl_tclStrClientHandler_AIL &rfcoBaseClient);

   /***************************************************************************
   ** FUNCTION:  arl_tclStrClienthandler& arl_tclStrClienthandler::operator..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoBaseClient]: (I) Const reference to object to be copied
    * \retval  [arl_tclStrClienthandler&]: Reference to this pointer.
    * \note    Assignment operator is declared protected to disable it. So
    *          that any attempt for assignment will be caught by the compiler.
    * \date 08.02.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   arl_tclStrClientHandler_AIL& operator=(const arl_tclStrClientHandler_AIL &rfcoBaseClient);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/
}; // class arl_tclStrClienthandler: public ahl_tclBaseOneThreadClientHandler


#endif /* ARL_TCLSTRCLIENTHANDLER_AIL_H_ */
