/*
 * arl_tclISource_AILBase.h
 *
 *  Created on: Jul 5, 2012
 *      Author: vo84hi
 */

#ifndef ARL_TCLISOURCE_AILBASE_H_
#define ARL_TCLISOURCE_AILBASE_H_


#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

/* Inclusion of OSAL Interface */
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

/* use AIL template */
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

/* use Application Help Library */
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"
#include "arl_tclISourceIF.h"

#define ARL_MAX_FUNCTION_TIME 4000

class arl_tclISource_AILBase : public ahl_tclBaseWork, public arl_tclISourceIF {
public:
   arl_tclISource_AILBase(ail_tclAppInterface* pAilAppInterface, tU16 u16ServiceID, tU16 _u16ServiceMajorVersion = 1, tU16 _u16ServiceMinorVersion = 0, tU16 _u16ServicePatchVersion=0);
   tVoid vInitServiceData(amt_tclServiceData& rServiceDataMessage, tU16 u16TargetAppID, tU16 u16RegisterID, tU16 u16CmdCounter, tU16 u16FunctionId, tU8 u8Opcode = AMT_C_U8_CCAMSG_OPCODE_STATUS, tU16 u16TargetSubID = AMT_C_U16_SUBID_DEFAULT) const;
   virtual tVoid vDestroyFactoryStatusMessage(amt_tclServiceData* poMessage);
   virtual ail_tenCommunicationError eUpdateClients(tU16 u16FunctionId, amt_tclServiceData* poMessage =  NULL);
   tBool bGetServiceVersion (tU16 u16ServiceID, tU16 &rfu16MajorVersion, tU16 &rfu16MinorVersion, tU16 &rfu16PatchVersion);
   virtual ail_tenCommunicationError eUpdateRequestingClient(amt_tclServiceData* poMessage);
   virtual ~arl_tclISource_AILBase();

   inline tBool bIfServiceAvailable() const { return _bServiceAvailable; }


   virtual tVoid vOnServiceUnavailable() { };
   virtual tVoid vOnServiceAvailable()   { };
   virtual tVoid vOnNewAppState(tU32 u32OldAppState,  tU32 u32AppState);
   virtual tVoid vOnNewAppStateNotify(tU32 /*u32OldAppState*/, tU32 /*u32AppState*/) {};
   virtual tVoid vOnNewMessage(amt_tclBaseMessage* /*poMessage*/);
   tVoid vSetPrivateServiceAvailableAllowed(tBool fServiceAvailableAllowed);

   tVoid vMyDispatchMessage(amt_tclServiceData *pServiceDataMessage);

protected:
   tVoid vUpdateAllProperties();
   tVoid vSetServiceState();
   tVoid vOnRelUpReg(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   tVoid vOnUpReg(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   tVoid vOnGet(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   tVoid vOnSet(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   tVoid vGenericSetHandler(tU16 u16FunctionId, amt_tclServiceData* poMessage, tU8 u8OpType);
   tVoid vOnMethodStart(tU16 u16FunctionId, amt_tclServiceData* poMessage);
   tVoid vMyPostMessage(amt_tclServiceData* poMessage);

   tU16 _u16ServerAppID;

   /* to store the status variables of Service */
   tBool _bServiceAvailableAllowedOnAppstate;
   tBool _bServiceAvailableAllowedOnPrivateReason;
   tBool                _bServiceAvailable;

   tclServerProperties  _clProperties;
   ahl_tclPairList      _tclRegisterPair;
   ahl_tclPairList      _tclUnregisterPair;
};

#endif /* ARL_TCLISOURCE_AILBASE_H_ */
