/*!
********************************************************************************
* \file              arl_Bitmask.h
********************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:    Typesafe Bitmask implementation
*  - COPYRIGHT:      &copy; 2010 - 2012 Robert Bosch Car Multimedia Gmbh
********************************************************************************
* \date 31.10.2012 \version 1.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* \bug No known bugs
*******************************************************************************/

#ifndef ARL_BITMASK_H_
#define ARL_BITMASK_H_

/// OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

namespace audioroutinglib {

   template <class bitmask_defines>
   class arl_tclBitmask
   {
      tU32 m_bitmask;
   public:
      typedef unsigned int Bits;

      /**
       * Constructor with init
       */
      arl_tclBitmask(bitmask_defines init_value) : m_bitmask(init_value)
      {}

      /**
       * Default Constructor
       */
      arl_tclBitmask() : m_bitmask(0)
      {}

      /**
       * Copy Constructor
       */
      arl_tclBitmask(const arl_tclBitmask<bitmask_defines> &other) : m_bitmask(other.m_bitmask)
      {}

      arl_tclBitmask<bitmask_defines> operator ~() const
      {
         return arl_tclBitmask<bitmask_defines>(~m_bitmask);
      }

      tU32 getValue() const
      {
         return m_bitmask;
      }

      arl_tclBitmask<bitmask_defines>& clear()
      {
         m_bitmask = 0;
         return *this;
      }

      arl_tclBitmask<bitmask_defines>& inverse()
      {
         m_bitmask = ~m_bitmask;
         return *this;
      }

      tU32 operator << (Bits bits) const
         {
            return m_bitmask << bits;
         }

      tU32 operator >> (Bits bits) const
      {
         return m_bitmask >> bits;
      }

      arl_tclBitmask<bitmask_defines>& operator &= (const arl_tclBitmask<bitmask_defines>& other)
         {
            m_bitmask &= other.m_bitmask;
            return *this;
         }

      arl_tclBitmask<bitmask_defines>& operator |= (const arl_tclBitmask<bitmask_defines>& other)
      {
         m_bitmask |= other.m_bitmask;
         return *this;
      }

      arl_tclBitmask<bitmask_defines>& operator ^= (const arl_tclBitmask<bitmask_defines>& other)
      {
         m_bitmask ^= other.m_bitmask;
         return *this;
      }

      arl_tclBitmask<bitmask_defines> operator | (const arl_tclBitmask<bitmask_defines> &other) const
      {
         arl_tclBitmask<bitmask_defines> ret(*this);
         return (ret |= other);
      }

      arl_tclBitmask<bitmask_defines> operator & (const arl_tclBitmask<bitmask_defines> &other) const
      {
         arl_tclBitmask<bitmask_defines> ret(*this);
         return (ret &= other);
      }

      arl_tclBitmask<bitmask_defines> operator ^ (const arl_tclBitmask<bitmask_defines> &other) const
      {
         arl_tclBitmask<bitmask_defines> ret(*this);
         return (ret ^= other);
      }

      arl_tclBitmask<bitmask_defines>& operator = (const arl_tclBitmask<bitmask_defines> &other)
      {
         m_bitmask = other.m_bitmask;
         return *this;
      }

      bool operator == (const arl_tclBitmask<bitmask_defines> &other) const
      {
         return m_bitmask == other.m_bitmask;
      }
   };

   //Nonmember operators:
   template <class bitmask_defines>
   inline arl_tclBitmask<bitmask_defines> operator | (bitmask_defines value, const arl_tclBitmask<bitmask_defines> &e)
   {
      return e | value;
   }

   template <class bitmask_defines>
   inline arl_tclBitmask<bitmask_defines> operator & (bitmask_defines value, const arl_tclBitmask<bitmask_defines> &e)
   {
      return e & value;
   }

   template <class bitmask_defines>
   inline arl_tclBitmask<bitmask_defines> operator ^ (bitmask_defines value, const arl_tclBitmask<bitmask_defines> &e)
   {
      return e ^ value;
   }

   template <class bitmask_defines>
   inline arl_tclBitmask<bitmask_defines> operator | (bitmask_defines a, bitmask_defines b)
   {
      return arl_tclBitmask<bitmask_defines>(a) | arl_tclBitmask<bitmask_defines>(b);
   }

   template <class bitmask_defines>
   inline arl_tclBitmask<bitmask_defines> operator & (bitmask_defines a, bitmask_defines b)
   {
      return arl_tclBitmask<bitmask_defines>(a) & arl_tclBitmask<bitmask_defines>(b);
   }

   template <class bitmask_defines>
   inline arl_tclBitmask<bitmask_defines> operator ^ (bitmask_defines a, bitmask_defines b)
   {
      return arl_tclBitmask<bitmask_defines>(a) ^ arl_tclBitmask<bitmask_defines>(b);
   }
}

#endif
