/*!
********************************************************************************
* \file              arl_Trace.h
********************************************************************************
*  - PROJECT:        LCN2KAI
*  - SW-COMPONENT:   Audio Routing Library (ARL)
*  - DESCRIPTION:    Trace defines
*  - COPYRIGHT:      &copy; 2011 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 26.06.2012 \version 2.0 \author Ruben Volkmer (R.Volkmer@ITB-Solutions.de)
* - Remove AHL inheritance to enable usage by object reference instead of inheritance
* - Remove MOST dependencies
* - Adapt to Project needs
*
* \date 17.02.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

#ifndef ARL_TRACE_H_
#define ARL_TRACE_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

#define TR_COMP_ARL                 (TR_COMP_AUDIOMANAGEMENT + 10)

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/*!
 * \enum arl_tenTraceClass
 * Trace Class Enumeration.
 */

typedef enum
{
   TR_CLASS_ARL_ISOURCE             =  TR_COMP_ARL + 0   ///< Enum value for ISource Service interface.
   , TR_CLASS_ARL_LOOKUP_TABLE      =  TR_COMP_ARL + 1   ///< Enum value for Infotainment Lookup table.
   , TR_CLASS_ARL_BASE_CLIENT       =  TR_COMP_ARL + 2   ///< Enum value for Base client handler.
   , TR_CLASS_ARL_GENERIC_FSM       =  TR_COMP_ARL + 3   ///< Enum value for Generic FSM implementation.
   , TR_CLASS_ARL_ISOURCE_VFSM      =  TR_COMP_ARL + 4   ///< Enum value for ISource VFSM implementation.
   , TR_CLASS_ARL_ISOURCE_FSM       =  TR_COMP_ARL + 5   ///< Enum value for ISource FSM implementation.
   //from prj_overall.trc
   //ARRAY TR_CLASS = 0x7f0F :TR_CLASS_ARL_ISOURCE_FSM
   //ARRAY TR_CLASS = 0x7f10 :TR_CLASS_FC_AUDIOMANAGER_CLIPPING
   //ARRAY TR_CLASS = 0x7f11 :TR_CLASS_FC_AUDIOMANAGER_BEEP
   //ARRAY TR_CLASS = 0x7f12 :TR_CLASS_FC_AUDIOMANAGER_FADING
   //ARRAY TR_CLASS = 0x7f13 :TR_CLASS_FC_AUDIOMANAGER_SDVC
   //ARRAY TR_CLASS = 0x7f14 :TR_CLASS_FC_AUDIOMANAGER_MIC_DIAGNOSIS
   //; 0x7f1e ... 0x7f20 used by FC_AudioCues
   , TR_CLASS_ARL_ASF_CLIENT         =  TR_COMP_ARL + 11   ///< Enum value for ISource FSM implementation.
} arl_tenTraceClass;

#endif   // #ifndef ARL_TRACE_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
