

#ifndef ROUTINGTABLE_HEADER_INCLUDE
#define ROUTINGTABLE_HEADER_INCLUDE

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "FC_StreamRouter_chlst.h"

#define STR_ROUTINGTABLE_LOCK_NAME "STRRTLK"

#if 0
#include <tk/tkernel.h>
#include <adit_trace.h>
#include <extension/extension.h>
#include "stm_types.h"
#include "stm_interface.h"
#include "fg_types.h"
#ifdef __cplusplus
  extern "C" {
#endif
#include "MostSynchronousChannelManager.h"
#ifdef __cplusplus
  }
#endif
#endif

#define STR_STREAMMANAGER_MAX_FG_PER_ROUTE 8

typedef struct ROUTINGENTRY
{
  tU16            appid;
  tU16            ucid;
  tU16            strid;
  tU16            cfgid;
  tBool           playing; // true=playing, false=!playing
  tBool           kill;    // subroute is marked to be killed (error handler)
  tU32            conlabel;
  tU32            bwidth;
}ROUTINGENTRY;

class routingtable
{
public:
  routingtable();
  ~routingtable();

  ROUTINGENTRY* new_entry(int appid, int ucid, int cfgid);
  int free_entry(int appid, int ucid, int cfgid);
  int free_entry(int ucid);
  ROUTINGENTRY* get_next_entry(int ucid, int* idx);

  tBool is_ucid(int ucid);
  int   get_next_ucid(int ucid);
  tBool get_ucid_mostcfg(int ucid, tU16 *connectionlabel, tU16 *mlbid, tU8 *blockwidth);
  tBool get_ucid_routecfg(int ucid, tU32 *strid, tU16 *appid, tBool *play, tBool *kill);
  tBool set_ucid_kill(int ucid, tBool kill);

  ROUTINGENTRY* get_subroute_cfg(int ucid, int cfgid);

  void lock(void);
  void unlock(void);

private:
  chlst m_routestorage;
  OSAL_tSemHandle m_lock;
};

#endif

