
#include "FC_StreamRouter_routingtable.h"

routingtable::routingtable() :
  m_lock(OSAL_C_INVALID_HANDLE)
{
  (void)OSAL_s32SemaphoreCreate(STR_ROUTINGTABLE_LOCK_NAME, &m_lock, 1);
}

routingtable::~routingtable()
{
  OSAL_s32SemaphoreClose(m_lock);
  OSAL_s32SemaphoreDelete(STR_ROUTINGTABLE_LOCK_NAME);
}

ROUTINGENTRY* routingtable::new_entry(int appid, int ucid, int cfgid)
{
  ROUTINGENTRY *rentry = (ROUTINGENTRY*)OSAL_pvMemoryAllocate(sizeof(ROUTINGENTRY));
  if(rentry == NULL) return NULL;
  OSAL_pvMemorySet(rentry, 0, sizeof(ROUTINGENTRY));
  rentry->ucid  = (tU16)ucid;
  rentry->appid = (tU16)appid;
  rentry->cfgid = (tU16)cfgid;
  rentry->playing  = false;
  rentry->kill = false;
  m_routestorage.add_entry(ucid, cfgid, (void*)rentry);
  return rentry;
}

int routingtable::free_entry(int appid, int ucid, int cfgid)
{
  (void)appid;
  return m_routestorage.del_entry(ucid, cfgid);
}

int routingtable::free_entry(int ucid)
{
  return m_routestorage.del_entry(ucid);
}

ROUTINGENTRY* routingtable::get_next_entry(int ucid, int *idx)
{
  return (ROUTINGENTRY*)m_routestorage.get_data(ucid, idx);
}

tBool routingtable::is_ucid(int ucid)
{
  return m_routestorage.is_entry(ucid);
}

int routingtable::get_next_ucid(int ucid)
{
  return m_routestorage.get_next_pkey(ucid);
}

tBool routingtable::get_ucid_mostcfg(int ucid, tU16 *connectionlabel, tU16 *mlbid, tU8 *blockwidth)
{
  (void)mlbid;

  int i = 0;
  ROUTINGENTRY* data = (ROUTINGENTRY*)m_routestorage.get_data(ucid, &i);
  while(data != NULL)
  {
    if(data->conlabel != 0 /* && (data->direction == 0)*/)
    {
      if(connectionlabel != NULL) *connectionlabel = (tU16)data->conlabel;
      if(blockwidth != NULL)      *blockwidth = (tU8)data->bwidth;
      return true;
    }
    ++i;
    data = (ROUTINGENTRY*)m_routestorage.get_data(ucid, &i);
  }
  return false;
}

tBool routingtable::get_ucid_routecfg(int ucid, tU32 *strid, tU16 *appid, tBool *play, tBool *kill)
{
  int i = 0;
  ROUTINGENTRY* data = (ROUTINGENTRY*)m_routestorage.get_data(ucid, &i);
  if(data != NULL)
  {
    if(strid != NULL)     *strid = data->strid;
    if(appid != NULL)     *appid = data->appid;
    if(play != NULL)      *play = data->playing;
    if(kill != NULL)      *kill = data->kill;
    return true;
  }
  return false;
}

ROUTINGENTRY* routingtable::get_subroute_cfg(int ucid, int cfgid)
{
  return (ROUTINGENTRY*)m_routestorage.get_data(ucid, cfgid);
}



tBool routingtable::set_ucid_kill(int ucid, tBool kill)
{
  int i = 0;
  ROUTINGENTRY* data = (ROUTINGENTRY*)m_routestorage.get_data(ucid, &i);
  while(data != NULL)
  {
    data->kill = kill;
    ++i;
    data = (ROUTINGENTRY*)m_routestorage.get_data(ucid, &i);
  }
  return true;
}

void routingtable::lock(void)
{
  OSAL_s32SemaphoreWait(m_lock, OSAL_C_TIMEOUT_FOREVER);
}

void routingtable::unlock(void)
{
  OSAL_s32SemaphorePost(m_lock);
}

