
#ifndef _FC_STREAMROUTER_MOSTWRP_H_
#define _FC_STREAMROUTER_MOSTWRP_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#ifdef VARIANT_S_FTR_ENABLE_GM_STR

#define MWRP_LOCK_NAME  "STRMWL"
#define MWRP_OP_TIMEOUT /*OSAL_C_TIMEOUT_FOREVER*/ 5000

#define MWRP_MASK_SUCCESS 1
#define MWRP_MASK_FAIL    2

#define MWRP_REQ_INVALID    0
#define MWRP_REQ_ALLOCATE   1
#define MWRP_REQ_DEALLOCATE 2
#define MWRP_REQ_MUTE       3
#define MWRP_REQ_DEMUTE     4

#include <acsapplication.h>
#include <TCPLib.h>
#include <TCPIPSocket.h>
#include <MEPA.h>



//const uint16_t EVENT_CHANNEL_SYNC_STATUS = 32;
#define EVENT_CHANNEL_SYNC_STATUS NSWNHISYNC_EVENT_CHANNEL_SYNC_STATUS
//const uint16_t EVENT_ID_SYNC_STATUS = 1;
#define EVENT_ID_SYNC_STATUS NSWNHISYNC_EVENT_ID_SYNC_STATUS
//const uint16_t EVENT_ID_SYNC_ERROR = 2;
#define EVENT_ID_SYNC_ERROR NSWNHISYNC_EVENT_ID_SYNC_ERROR

//const uint8_t NHISYNC_ERROR_OPEN_FAILED_HI   = 0x80;
#define NHISYNC_ERROR_OPEN_FAILED_HI NSWNHISYNC_ERROR_OPEN_FAILED_HI
//const uint8_t NHISYNC_ERROR_OPEN_FAILED_LO   = 0x01;
#define NHISYNC_ERROR_OPEN_FAILED_LO NSWNHISYNC_ERROR_OPEN_FAILED_LO
//const uint8_t NHISYNC_ERROR_CLOSE_FAILED_HI  = 0x80;
#define NHISYNC_ERROR_CLOSE_FAILED_HI NSWNHISYNC_ERROR_CLOSE_FAILED_HI
//const uint8_t NHISYNC_ERROR_CLOSE_FAILED_LO  = 0x02;
#define NHISYNC_ERROR_CLOSE_FAILED_LO NSWNHISYNC_ERROR_CLOSE_FAILED_LO

//const uint16_t EVENT_CHANNEL_SYNC_CONTROL = 33;
#define EVENT_CHANNEL_SYNC_CONTROL NSWNHISYNC_EVENT_CHANNEL_SYNC_CONTROL
//const uint16_t EVENT_ID_SYNC_CONTROL_OPEN = 1;
#define EVENT_ID_SYNC_CONTROL_OPEN NSWNHISYNC_EVENT_ID_SYNC_CONTROL_OPEN
//const uint16_t EVENT_ID_SYNC_CONTROL_CLOSE = 2;
#define EVENT_ID_SYNC_CONTROL_CLOSE NSWNHISYNC_EVENT_ID_SYNC_CONTROL_CLOSE
//const uint16_t EVENT_ID_SYNC_CONTROL_MUTE = 3;
#define EVENT_ID_SYNC_CONTROL_MUTE NSWNHISYNC_EVENT_ID_SYNC_CONTROL_MUTE
//const uint16_t EVENT_ID_SYNC_CONTROL_DEMUTE = 4;
#define EVENT_ID_SYNC_CONTROL_DEMUTE NSWNHISYNC_EVENT_ID_SYNC_CONTROL_DEMUTE
//const uint16_t EVENT_ID_SYNC_CONTROL_GET_STATUS = 5;
#define EVENT_ID_SYNC_CONTROL_GET_STATUS NSWNHISYNC_EVENT_ID_SYNC_CONTROL_GET_STATUS

const uint8_t NHI_SCS_CONNECTION_ESTABLISHED = 10;
const uint8_t NHI_SCS_NO_CONNECTION = 0;
const uint8_t NHI_SCS_MUTE_SOCKET = 19;
const uint8_t NHI_SCS_DEMUTE_SOCKET = 20;
const uint8_t NHI_SCS_SOME_ERROR_INDICATION = 16;

class fc_streamrouter_tclApp;
class CMEPAEventListener;

class fc_streamrouter_mostwrp: public k2l::acs::protocols::events::IACSEventListener
{
  public:
    fc_streamrouter_mostwrp();
    virtual ~fc_streamrouter_mostwrp();

    int allocate(unsigned int blockwidth, bool direction, unsigned int connectionlabel, int opt);
    int deallocate(unsigned int connectionlabel, int opt);
    int mute(unsigned int connectionlabel, int opt);
    int demute(unsigned int connectionlabel, int opt);

    void OnEvent(uint8_t channel, uint8_t eventID, uint32_t payloadLength, const uint8_t *pPayload);

    int get_connectionlabel(void);
    void set_connectionlabel(int connectionlabel);

    tBool _bIsRunning;

  private:
    int init(void);
    int deinit(void);

    int initlock(void);
    int lock(void);
    int unlock(int mask);

    OSAL_tEventHandle m_event;

    k2l::acs::protocols::events::CACSEventConnector _eventProtocol;
    k2l::networking::tcplib::CTCPIPSocket _socket;
    k2l::acs::client::CPassiveMessageDispatcher* _pDispatcher;

    int _connectionlabel;
    int _bandwidth;
    uint32_t _configuration;
    uint32_t _error;
    uint32_t _request;

    static tVoid Dispatcher(tPVoid pvArg);

    OSAL_tThreadID _tDispatcherThreadID;

    const void dumpPayload(const unsigned char* pPayload, tU32 payloadLength, tU32 event);
};


class fc_streamrouter_most_fastev: public k2l::acs::protocols::events::IACSEventListener
{
public:
  fc_streamrouter_most_fastev(fc_streamrouter_tclApp* app);
  virtual ~fc_streamrouter_most_fastev();

  static fc_streamrouter_most_fastev* _pMFEv;
  fc_streamrouter_tclApp* _pMain;

  tBool bInit();
  tVoid vClose();
  tVoid postEv(int ev);

  tBool _bIsRunning;

  // IACSEventListener implementation
  virtual void OnEvent(uint8_t channel, uint8_t eventID, uint32_t payloadLength, const uint8_t *pPayload);

private:
  k2l::acs::client::CPassiveMessageDispatcher* _pDispatcher;
  OSAL_tThreadID _tDispatcherThreadID;

  static tVoid Dispatcher(tPVoid pvArg);
};


class CMEPAEventListener : public k2l::acs::protocols::events::IACSEventListener
{
private:
   void OnEvent(uint8_t channelID, uint8_t eventID, uint32_t payloadLength, const uint8_t *payload);

   //fc_streamrouter_most_fastev * pMFEInstance;
   CMEPAEventListener(); //Singleton

public:
   static CMEPAEventListener* _pMEPALstInstance;
   static CMEPAEventListener* GetInstance();
   tVoid Initialize();
   ~CMEPAEventListener();

protected:
   void handleCumulativeMsg( const uint8_t *payload, uint16_t payloadLength );
};

#else // -------------------------------------------------------------------------------------------------------------

class fc_streamrouter_mostwrp
{
  public:
    fc_streamrouter_mostwrp()
    {
      return;
    }
    ~fc_streamrouter_mostwrp()
    {
      return;
    }

    int allocate(unsigned int blockwidth, bool direction, unsigned int connectionlabel, int opt)
    {
      (void)blockwidth;
      (void)direction;
      (void)connectionlabel;
      (void)opt;
      return 0;
    }
    int deallocate(unsigned int connectionlabel, int opt)
    {
      (void)connectionlabel;
      (void)opt;
      return 0;
    }
    int mute(unsigned int connectionlabel, int opt)
    {
      (void)connectionlabel;
      (void)opt;
      return 0;
    }
    int demute(unsigned int connectionlabel, int opt)
    {
      (void)connectionlabel;
      (void)opt;
      return 0;
    }

    void OnEvent(uint8_t channel, uint8_t eventID, uint32_t payloadLength, const uint8_t *pPayload);

    int get_connectionlabel(void)
    {
      return 0;
    }
    void set_connectionlabel(int connectionlabel)
    {
      (void)connectionlabel;
      return;
    }

    //tBool _bIsRunning;
};


class fc_streamrouter_most_fastev
{
public:
  fc_streamrouter_most_fastev(fc_streamrouter_tclApp* app)
  {
    (void)app;
    return;
  }
  ~fc_streamrouter_most_fastev()
  {
    return;
  }

  //static fc_streamrouter_most_fastev* _pMFEv;
  //fc_streamrouter_tclApp* _pMain;

  //tBool bInit();
  //tVoid vClose();
  //tVoid postEv(int ev);

  //tBool _bIsRunning;

  // IACSEventListener implementation
  // ?? virtual void OnEvent(uint8_t channel, uint8_t eventID, uint32_t payloadLength, const uint8_t *pPayload);

private:
  //k2l::acs::client::CPassiveMessageDispatcher* _pDispatcher;
  //OSAL_tThreadID _tDispatcherThreadID;

  //static tVoid Dispatcher(tPVoid pvArg);
};


class CMEPAEventListener
{
private:
   void OnEvent(uint8_t channelID, uint8_t eventID, uint32_t payloadLength, const uint8_t *payload);

   //fc_streamrouter_most_fastev * pMFEInstance;
   CMEPAEventListener(); //Singleton

public:
   //static CMEPAEventListener* _pMEPALstInstance;
   //static CMEPAEventListener* GetInstance();
   //tVoid Initialize();
   ~CMEPAEventListener();

protected:
   //void handleCumulativeMsg( const uint8_t *payload, uint16_t payloadLength );
};

#endif

#endif

