
#ifdef VARIANT_S_FTR_ENABLE_GM_STR

#include "FC_StreamRouter_mostwrp.h"
#include "FC_StreamRouter_trace_def.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_STREAMROUTER_APPLICATION
#include "trcGenProj/Header/FC_StreamRouter_mostwrp.cpp.trc.h"
#endif

#include "FC_StreamRouter_main.h"

// K2L ACS framework
#include <K2LSystem.h>
#include <K2LACSClient.h>
#include <ACSStreams.h>
#include <K2LACSMOST.h>
#include <MOSTProtocolDefinitions.h>
#include <IMAC.h>
#include <K2LEventDefines.h>

using namespace k2l::acs::protocols::most;
using namespace k2l::acs::client;
using namespace k2l::acs::base::most;
using namespace k2l::acs::protocols::events;
using namespace k2l::platform::system;

#ifdef K2L_S_UNIX_DOMAIN_SOCKETS
  #define MWRP_SERVER_IP    K2L_C_UNIX_DOMAIN_FILE
  #define MWRP_SERVER_PORT  0
  #define MWRP_NODE_ID      42
#else
  #define MWRP_SERVER_IP    "127.0.0.1"
  #define MWRP_SERVER_PORT  5287
  #define MWRP_NODE_ID      42
#endif

fc_streamrouter_mostwrp::fc_streamrouter_mostwrp(): IACSEventListener()
{
  m_event = OSAL_C_INVALID_HANDLE;
  if(OSAL_s32EventCreate(MWRP_LOCK_NAME, &m_event) == OSAL_ERROR)
  {
    ETG_TRACE_FATAL(("fc_streamrouter_mostwrp::fc_streamrouter_mostwrp() Unable to create event!"));
  }
  init();
}

fc_streamrouter_mostwrp::~fc_streamrouter_mostwrp()
{
  deinit();
  OSAL_s32EventClose(m_event);
  OSAL_s32EventDelete(MWRP_LOCK_NAME);
  m_event = OSAL_C_INVALID_HANDLE;
}

int fc_streamrouter_mostwrp::init(void)
{
  int ret = 0;

  // set configuration to invalid value
  _configuration = (uint32_t)-1;
  _error = 0;
  _request = MWRP_REQ_INVALID;
  set_connectionlabel((int)0);

  // setup thread for dispatcher
  OSAL_trThreadAttribute rThAttr;
  char sThreadName[]   = "STR_MSTLst";
  rThAttr.szName       = sThreadName;
  rThAttr.u32Priority  = OSAL_C_U32_THREAD_PRIORITY_NORMAL;
  rThAttr.s32StackSize = 1024;
  rThAttr.pfEntry      = Dispatcher;
  rThAttr.pvArg        = (tVoid*)this;

  _tDispatcherThreadID = OSAL_ThreadCreate(&rThAttr);

  if(OSAL_s32ThreadActivate(_tDispatcherThreadID) == OSAL_ERROR)
  {
    ETG_TRACE_FATAL(("fc_streamrouter_mostwrp::init() thread creation failed!"))
    return -1;
  }

  ETG_TRACE_USR1(("fc_streamrouter_mostwrp::init() thread created"))
  return ret;
}

int fc_streamrouter_mostwrp::deinit(void)
{
  if(_pDispatcher != NULL) {
    _pDispatcher->Shutdown();
  }
  _bIsRunning = FALSE;
  _configuration = (uint32_t)-1;
  _error = 0;
  _request = MWRP_REQ_INVALID;
  set_connectionlabel((int)0);

  return 0;
}

int fc_streamrouter_mostwrp::allocate(unsigned int blockwidth, bool direction, unsigned int connectionlabel, int opt)
{
  ETG_TRACE_USR4(("allocating most channel... (bwidth=%d, dir=%d, conlabel=0x%x, opt=%d)", blockwidth, direction, connectionlabel, opt));

  int ret = 0;

  // store configuration in member variable. Configuration has to be compared in OnEvent function
  _configuration = opt;
  _request = MWRP_REQ_ALLOCATE;
  uint8_t eventPayload[] = {(uint8_t)_configuration};
  initlock();
  _eventProtocol.Send(EVENT_CHANNEL_SYNC_CONTROL, EVENT_ID_SYNC_CONTROL_OPEN, sizeof(eventPayload), eventPayload);
  if(lock() != 0)
  {
    _eventProtocol.Send(EVENT_CHANNEL_SYNC_CONTROL, EVENT_ID_SYNC_CONTROL_CLOSE, sizeof(eventPayload), eventPayload);
    ret = 1;
  }
  return ret;
}

int fc_streamrouter_mostwrp::deallocate(unsigned int connectionlabel, int opt)
{
  ETG_TRACE_USR4(("deallocating most channel... (conlabel=0x%x, opt=%d)", connectionlabel, opt));

  // store configuration in member variable. Configuration has to be compared in OnEvent function
  _configuration = opt;
  _request = MWRP_REQ_DEALLOCATE;
  uint8_t eventPayload[] = {(uint8_t)_configuration};
  initlock();
  _eventProtocol.Send(EVENT_CHANNEL_SYNC_CONTROL, EVENT_ID_SYNC_CONTROL_CLOSE, sizeof(eventPayload), eventPayload);
  if(lock() != 0)
  {
    _eventProtocol.Send(EVENT_CHANNEL_SYNC_CONTROL, EVENT_ID_SYNC_CONTROL_CLOSE, sizeof(eventPayload), eventPayload);
    ETG_TRACE_ERR(("fc_streamrouter_mostwrp::deallocate() timed out"));
  }
  set_connectionlabel((int)0);
  return 0;
}

int fc_streamrouter_mostwrp::mute(unsigned int connectionlabel, int opt)
{
  ETG_TRACE_USR4(("muting most channel... (conlabel=0x%x, opt=%d)", connectionlabel, opt));

  // store configuration in member variable. Configuration has to be compared in OnEvent function
  _configuration = opt;
  _request = MWRP_REQ_MUTE;
  uint8_t eventPayload[] = {(uint8_t)_configuration};
  initlock();
  _eventProtocol.Send(EVENT_CHANNEL_SYNC_CONTROL, EVENT_ID_SYNC_CONTROL_MUTE, sizeof(eventPayload), eventPayload);
  if(lock() != 0)
  {
    _eventProtocol.Send(EVENT_CHANNEL_SYNC_CONTROL, EVENT_ID_SYNC_CONTROL_CLOSE, sizeof(eventPayload), eventPayload);
    ETG_TRACE_ERR(("fc_streamrouter_mostwrp::mute() timed out"));
  }
  return 0;
}

int fc_streamrouter_mostwrp::demute(unsigned int connectionlabel, int opt)
{
  ETG_TRACE_USR4(("demuting most channel... (conlabel=0x%x, opt=%d)", connectionlabel, opt));

  // store configuration in member variable. Configuration has to be compared in OnEvent function
  _configuration = opt;
  _request = MWRP_REQ_DEMUTE;
  uint8_t eventPayload[] = {(uint8_t)_configuration};
  initlock();
  _eventProtocol.Send(EVENT_CHANNEL_SYNC_CONTROL, EVENT_ID_SYNC_CONTROL_DEMUTE, sizeof(eventPayload), eventPayload);
  if(lock() != 0)
  {
    _eventProtocol.Send(EVENT_CHANNEL_SYNC_CONTROL, EVENT_ID_SYNC_CONTROL_CLOSE, sizeof(eventPayload), eventPayload);
    ETG_TRACE_ERR(("fc_streamrouter_mostwrp::demute() timed out"));
  }
  return 0;
}

int fc_streamrouter_mostwrp::initlock(void)
{
  OSAL_tEventMask mask = MWRP_MASK_SUCCESS | MWRP_MASK_FAIL;
  OSAL_s32EventPost(m_event, ~mask, OSAL_EN_EVENTMASK_AND);
  return 0;
}

int fc_streamrouter_mostwrp::lock(void)
{
  OSAL_tEventMask rcv_mask = 0;
  OSAL_tEventMask mask = MWRP_MASK_SUCCESS | MWRP_MASK_FAIL;
  int ret = 0;

  if(OSAL_s32EventWait(m_event, mask, OSAL_EN_EVENTMASK_OR, MWRP_OP_TIMEOUT, &rcv_mask) != OSAL_OK)
  {
    ret = 2;
    ETG_TRACE_FATAL(("fc_streamrouter_mostwrp::lock(void) Returned an error!"));
    ETG_TRACE_ERRMEM(("fc_streamrouter_mostwrp: ACS didn't answer within %d ms!", (int)MWRP_OP_TIMEOUT));
  }
  else
  {
    ETG_TRACE_USR4(("fc_streamrouter_mostwrp::lock(void) rcv_mask = %d", (int)rcv_mask))
    if(rcv_mask & MWRP_MASK_FAIL)
    {
      ret = 1;
    }
    //OSAL_s32EventPost(m_event, ~rcv_mask, OSAL_EN_EVENTMASK_AND);
  }

  return ret;
}

int fc_streamrouter_mostwrp::unlock(int mask)
{
  OSAL_s32EventPost(m_event, (OSAL_tEventMask)mask, OSAL_EN_EVENTMASK_OR);
  return 0;
}

int fc_streamrouter_mostwrp::get_connectionlabel(void)
{
  return _connectionlabel;
}

// tbd: race condition
void fc_streamrouter_mostwrp::set_connectionlabel(int connectionlabel)
{
  _connectionlabel = connectionlabel;
}

const void fc_streamrouter_mostwrp::dumpPayload(const unsigned char* pPayload, tU32 payloadLength, tU32 event)
{

  if((payloadLength > 0) && (pPayload != NULL))
  {
    char* outbuf=NULL;
    tU32 outbuf_size=(payloadLength*3)+1;
    outbuf=(char*)OSAL_pvMemoryAllocate(outbuf_size);

    if(outbuf!=NULL)
    {
      OSAL_pvMemorySet((void*)outbuf, 0, outbuf_size);
      unsigned int i=0;
      for(i=0; (i<payloadLength); ++i)
      {
        snprintf(outbuf+(3*i), outbuf_size, "%02x ", pPayload[i]);
      }
      ETG_TRACE_USR4(("--- CHNL: SYNC STATUS | EVENT: 0x%x | PAYLOAD: %s", event, outbuf));
      OSAL_vMemoryFree(outbuf);
    }
    else
    {
      ETG_TRACE_USR4(("dumpPayload(): outbuf is NULL!"));
    }
  }
  else
  {
    ETG_TRACE_USR4(("dumpPayload(): invalid args!"));
  }
}

void fc_streamrouter_mostwrp::OnEvent(uint8_t channel, uint8_t eventID, uint32_t payloadLength, const uint8_t *pPayload)
{
  if((channel == EVENT_CHANNEL_SYNC_STATUS) && (payloadLength > 0) && (pPayload != NULL))
  {
    //ETG_TRACE_USR4(("fc_streamrouter_mostwrp::OnEvent() EVENT_CHANNEL_SYNC_STATUS (eventID %d) received", eventID));
    dumpPayload((const unsigned char*)pPayload, payloadLength, (tU32)eventID);

    // check first if received configuration is equal to requested configuration
    if((pPayload[0] == _configuration) && (payloadLength > 3))
    {
      switch(eventID)
      {
      case EVENT_ID_SYNC_STATUS:
        if((_request == MWRP_REQ_ALLOCATE) && (pPayload[3] == NHI_SCS_SOME_ERROR_INDICATION))
        {
          _error = 1;
        }

        if((pPayload[3] == NHI_SCS_NO_CONNECTION) || (pPayload[3] == NHI_SCS_CONNECTION_ESTABLISHED))
        {
          if((payloadLength < 10) || (_error == 1))
          {
            ETG_TRACE_FATAL(("> ERR: CFG=%u, PAYLOAD LENGTH=%d! ", pPayload[0], payloadLength));
            _configuration = (uint32_t)-1;
            _error = 0;
            _request = MWRP_REQ_INVALID;
            unlock(MWRP_MASK_FAIL);
          }
          else
          {
            int connectionlabel = (int)((pPayload[8] << 8) | pPayload[9]);
            if((connectionlabel == 0) || (connectionlabel == 255))
            {
              ETG_TRACE_FATAL(("> ERR: CONNECTION LABEL IS 0x%x (cfg %u)! ", connectionlabel, pPayload[0]));
              // hold the lock (do nothing)... wait for a valid connection label
            }
            else
            {
              ETG_TRACE_USR4(("> SYNC STATUS: cfg=%u, conlabel=0x%x", pPayload[0], connectionlabel));
              set_connectionlabel((int)connectionlabel);
              // request was answered succesfully. Set configuration to invalid
              _configuration = (uint32_t)-1;
              _error = 0;
              _request = MWRP_REQ_INVALID;
              unlock(MWRP_MASK_SUCCESS);
            }
          }
        }
        break;
      case EVENT_ID_SYNC_ERROR:
        //ETG_TRACE_USR4(("SYNC ERROR: cfg=%u, conlabel=0x%x - payload[3] == %d", pPayload[0], ((pPayload[8] << 8) | pPayload[9]), pPayload[3]));
        switch(pPayload[3])
        {
        case NSWNHISYNC_ERROR_OPEN_FAILED_LO:
          ETG_TRACE_FATAL(("> SYNC ERROR: cfg=%u - open failed!", pPayload[0]));
          set_connectionlabel((int)0);
          break;

        case NSWNHISYNC_ERROR_CLOSE_FAILED_LO:
          ETG_TRACE_FATAL(("> SYNC ERROR: cfg=%u - close failed!", pPayload[0]));
          set_connectionlabel((int)0);
          break;

        case NSWNHISYNC_ERROR_MUTE_FAILED_LO:
          ETG_TRACE_FATAL(("> SYNC ERROR: cfg=%u - mute failed!", pPayload[0]));
          break;

        case NSWNHISYNC_ERROR_DEMUTE_FAILED_LO:
          ETG_TRACE_FATAL(("> SYNC ERROR: cfg=%u - demute failed!", pPayload[0]));
          break;

        default:
          ETG_TRACE_FATAL(("> SYNC ERROR: cfg=%u - unhandled (payload[3] == %d)", pPayload[0], pPayload[3]));
          set_connectionlabel((int)0);
        }
        // request was answered not succesfully. Set configuration to invalid
        _configuration = (uint32_t) -1;
        unlock(MWRP_MASK_FAIL);

        break;
      default:
        //ETG_TRACE_USR4(("received eventid %u on channel EVENT_CHANNEL_SYNC_STATUS", eventID));
        break;
      }
    }
#if 0
    else
    {
      ETG_TRACE_USR4(("On Event: Received configuration=%u != requested configuration=%u", pPayload[0], _configuration));
    }
#endif
  }
#if 0
  else
  {
    ETG_TRACE_USR4(("On Event: Received channel ID is %d and event ID is %d (payload length: %d)", channel, eventID, payloadLength));
  }
#endif
}

tVoid fc_streamrouter_mostwrp::Dispatcher(tVoid* pvArg)
{
  if (pvArg == NULL)
  {
    ETG_TRACE_FATAL(("fc_streamrouter_mostwrp::Dispatcher() invalid argument!"))
    return;
  }

  fc_streamrouter_mostwrp* pListener = (fc_streamrouter_mostwrp*)pvArg;

  pListener->_pDispatcher = OSAL_NEW CPassiveMessageDispatcher();
  if(pListener->_pDispatcher == OSAL_NULL)
  {
    ETG_TRACE_FATAL(("fc_streamrouter_mostwrp::Dispatcher() failed to create dispatcher!"))
    return;
  }

  CACSClient client;

#ifndef K2L_S_UNIX_DOMAIN_SOCKETS
  client.SetSocketImpl(&pListener->_socket);
#endif
  pListener->_pDispatcher->SetClient(&client);
  pListener->_eventProtocol.SetListener(pListener);
  pListener->_pDispatcher->AddListener(&pListener->_eventProtocol);

  if(!(client.ConnectApplicationToNode(MWRP_SERVER_IP, MWRP_SERVER_PORT, MWRP_NODE_ID)))
  {
    ETG_TRACE_FATAL(("fc_streamrouter_mostwrp::Dispatcher() connection failed!"))
  }
  else
  {
    OSAL_s32ThreadWait(30);

    const uint8_t channels[] = {(uint8_t)EVENT_CHANNEL_SYNC_STATUS};
    pListener->_eventProtocol.JoinChannels(sizeof(channels), channels);

    pListener->_bIsRunning = TRUE;

    ETG_TRACE_USR1(("fc_streamrouter_mostwrp::Dispatcher() dispatch loop ready..."))

    while(pListener->_bIsRunning)
    {
      if(!pListener->_pDispatcher->Dispatch())
      {
        ETG_TRACE_FATAL(("fc_streamrouter_mostwrp::Dispatcher() failed. aborting..."))
        pListener->_bIsRunning = FALSE;
        break;
      }
    }
    client.Disconnect();
  }

  if(pListener->_pDispatcher != NULL)
  {
    OSAL_DELETE pListener->_pDispatcher;
    pListener->_pDispatcher = NULL;
  }
  ETG_TRACE_USR4(("fc_streamrouter_mostwrp::Dispatcher() dispatch loop exited"))
}

// MEPA Listener ===============================================================================
CMEPAEventListener* CMEPAEventListener::_pMEPALstInstance = NULL;

CMEPAEventListener::CMEPAEventListener()
{
}

tVoid CMEPAEventListener::Initialize()
{
}

CMEPAEventListener * CMEPAEventListener::GetInstance()
{
  if(CMEPAEventListener::_pMEPALstInstance == NULL)
  {
    _pMEPALstInstance = OSAL_NEW CMEPAEventListener();
    _pMEPALstInstance->Initialize();
    if(_pMEPALstInstance == NULL)
    {
      ETG_TRACE_FATAL(("CMEPAEventListener: Singleton instance not created!"))
    }
  }
  return CMEPAEventListener::_pMEPALstInstance;
}

CMEPAEventListener::~CMEPAEventListener()
{
  if(_pMEPALstInstance != NULL) {
    OSAL_DELETE _pMEPALstInstance;
    CMEPAEventListener::_pMEPALstInstance = NULL;
  }
}

void CMEPAEventListener::OnEvent(uint8_t channelID, uint8_t eventID, uint32_t payloadLength,const uint8_t *payload)
{
  if(fc_streamrouter_most_fastev::_pMFEv == NULL)
  {
    ETG_TRACE_FATAL(("CMEPAEventListener::OnEvent() - Ptr to FastEV is NULL"));
    return;
  }

  if(fc_streamrouter_most_fastev::_pMFEv->_pMain == NULL)
  {
    ETG_TRACE_FATAL(("CMEPAEventListener::OnEvent() - Ptr to STR core is NULL"));
    return;
  }

  if((payloadLength > 0) && (payload != NULL))
  {
    if(channelID == NSWMES_EVENT_CHANNEL_NETWORK_EVENTS)
    {
      ETG_TRACE_USR4(("CMEPAEventListener::OnEvent() NSWMES_EVENT_CHANNEL_NETWORK_EVENTS (channelid: %d, eventid: %d, payloadlength: %d", channelID, eventID, payloadLength));
      switch(eventID)
      {
      case NSWMES_EVENT_ID_SHUTDOWN_REQUEST_RECEIVED:
          break;
      case NSWMES_EVENT_ID_CRITICAL_UNLOCK:
        ETG_TRACE_FATAL(("CMEPAEventListener::OnEvent() - CRITICAL UNLOCK"));
        fc_streamrouter_most_fastev::_pMFEv->postEv(STR_EV_CRITICALUNLOCK);
        break;
      case NSWMES_EVENT_ID_NET_ON_OFF:
        if(payload[0] == NSWMES_PAYLOAD_NET_ON)
        {
          ETG_TRACE_FATAL(("CMEPAEventListener::OnEvent() - NET ON"));
        }
        else
        {
          ETG_TRACE_FATAL(("CMEPAEventListener::OnEvent() - NET OFF"));
          fc_streamrouter_most_fastev::_pMFEv->postEv(STR_EV_NETOFF);
        }
        break;
      case NSWMES_EVENT_ID_INIC_STATE:
        if(payload[0] == NSWMES_PAYLOAD_INIC_PROTECTED)
        {
          ETG_TRACE_FATAL(("CMEPAEventListener::OnEvent() - INIC PROTECTED"));
          fc_streamrouter_most_fastev::_pMFEv->postEv(STR_EV_INICPROTECTED);
        }
        break;
      default:
        ETG_TRACE_USR4(("CMEPAEventListener::OnEvent() eventID %d received", eventID));
      }
    }
  }

}

void CMEPAEventListener::handleCumulativeMsg( const uint8_t *payload, uint16_t payloadLength )
{
  //Received MOST Network Status message
  /* Note:
  * Payload consists of Google Protocol Buffer-like structure:
  * [tag][sizeOfData][data] (repeatable sequence of tag-sizeOfData-data-triples)
  */
  uint32_t pos = 0;
  while( pos+3 <= payloadLength )
  {
    const uint8_t tag         = payload[pos];
    const uint16_t sizeOfData = static_cast<uint16_t>((static_cast<uint16_t>(payload[pos+1]) << 8) | payload[pos+2]);
    //const uint8_t *data       = &payload[pos+3];

    // increase pos by "tag" and "sizeOfData" size
    pos += sizeof(uint8_t) + sizeof(sizeOfData);

    if( pos + sizeOfData <= payloadLength )
    {
       // Add functionality if needs to be handled in CMA
       switch( tag )
       {
       case NSWMES_CUMULATIVE_STATUS_TAG_NWM_CENTRAL_REG_STATUS: // NWM centralRegistry
           break;
       case NSWMES_CUMULATIVE_STATUS_TAG_CONFIGURATION_STATUS: // NWM Config State
           break;
       case NSWMES_CUMULATIVE_STATUS_TAG_NWM_DEVICE_ID: // NWM deviceID
           break;
       case NSWMES_CUMULATIVE_STATUS_TAG_MPR_DELAY: // MPR Event
           break;
       case NSWMES_CUMULATIVE_STATUS_TAG_NET_ON_OFF: // NetOn/Off
           break;
       case NSWMES_CUMULATIVE_STATUS_TAG_INIC_STATE: //Inic State
           break;
       case NSWMES_CUMULATIVE_STATUS_TAG_LOCK_STATE: //MOST Lock State
           break;
       case NSWMES_CUMULATIVE_STATUS_TAG_SYSTEM_STATE:
           break;
       default:
         //Received garbage!
         return;
         break;
       }
    }
    pos += sizeOfData; // increase by number of bytes for this tag
  }
}

// ===================================================================================================
fc_streamrouter_most_fastev * fc_streamrouter_most_fastev::_pMFEv = NULL;
fc_streamrouter_most_fastev::fc_streamrouter_most_fastev(fc_streamrouter_tclApp* app)
   : _bIsRunning(FALSE)
   , _tDispatcherThreadID(OSAL_ERROR)
   , _pDispatcher(NULL)

{
   _pMain = app;
   _pMFEv = this;
   bInit();
}

fc_streamrouter_most_fastev::~fc_streamrouter_most_fastev()
{
  vClose();
  if(_pDispatcher != NULL) {
    OSAL_DELETE _pDispatcher;
    _pDispatcher = NULL;
  }
  _pMain = NULL;
  fc_streamrouter_most_fastev::_pMFEv = NULL;
}

void fc_streamrouter_most_fastev::OnEvent(uint8_t channel, uint8_t eventID, uint32_t payloadLength, const uint8_t *pPayload)
{
  (void)channel;
  (void)eventID;
  (void)payloadLength;
  (void)pPayload;
  ETG_TRACE_USR4(("fc_streamrouter_most_fastev::OnEvent() - entered."))
}

tBool fc_streamrouter_most_fastev::bInit()
{
  OSAL_trThreadAttribute rThAttr;
  char sThreadName[]   = "STR_fastev";
  rThAttr.szName       = sThreadName;
  rThAttr.u32Priority  = OSAL_C_U32_THREAD_PRIORITY_NORMAL;
  rThAttr.s32StackSize = 1024;
  rThAttr.pfEntry      = Dispatcher;
  rThAttr.pvArg        = (tVoid*)this;

  _tDispatcherThreadID = OSAL_ThreadCreate(&rThAttr);

  if(OSAL_s32ThreadActivate(_tDispatcherThreadID) == OSAL_ERROR)
  {
    ETG_TRACE_FATAL(("fc_streamrouter_most_fastev::bInit() - thread creation failed (%08X)", _tDispatcherThreadID))
    return FALSE;
  }

  ETG_TRACE_USR4(("fc_streamrouter_most_fastev::bInit() - thread %8X created", _tDispatcherThreadID))
  return TRUE;
}

void fc_streamrouter_most_fastev::vClose()
{
  _bIsRunning = FALSE;
}

tVoid fc_streamrouter_most_fastev::Dispatcher(tVoid* pvArg)
{
  if (OSAL_NULL == pvArg)
  {
    ETG_TRACE_FATAL(("fc_streamrouter_most_fastev::Dispatcher() - invalid argument"))
    return;
  }

  fc_streamrouter_most_fastev* pListener = (fc_streamrouter_most_fastev*)pvArg;

  CACSClient fastEventClient;

  CMEPAEventListener * poMEPAEventLst = CMEPAEventListener::GetInstance();
  if(poMEPAEventLst == NULL)
  {
    ETG_TRACE_FATAL(("poMEPAEventLst is NULL"))
    return;
  }

#ifndef K2L_S_UNIX_DOMAIN_SOCKETS
  k2l::networking::tcplib::CTCPIPSocket tcpSocket;
  fastEventClient.SetSocketImpl(&tcpSocket);
#endif

  if(!fastEventClient.ConnectApplicationToNode(MWRP_SERVER_IP, MWRP_SERVER_PORT, MWRP_NODE_ID))
  {
    ETG_TRACE_FATAL(("FastEv Listener - connectiontion failed"))
    return;
  }

  CMEPARx MepaRx(fastEventClient, *poMEPAEventLst);

  //Channel NSWMES_EVENT_CHANNEL_NETWORK_EVENTS is used for fast events in this concrete case.
  //Check if channels MOST_NWMEVT_CHANNEL and EVENT_CHANNEL_NETBLOCK are not needed any more.
  const uint8_t channels[] = {NSWMES_EVENT_CHANNEL_NETWORK_EVENTS/*, CMA_REG_MAN_EVENT_CHANNEL*/};
  MepaRx.joinChannels(channels, sizeof(channels));
  MepaRx.Run(k2l::platform::system::CActiveObject::GetThreadPriorityApplicationMax());

  OSAL_s32ThreadWait(30);
  pListener->_bIsRunning = TRUE;
  ETG_TRACE_USR4(("FastEv Listener - dispatcher loop ready"))

  while(pListener->_bIsRunning)
  {
    if(MepaRx.eventMsgDispatcher.Dispatch() == false)
    {
      ETG_TRACE_FATAL(("FastEv listener - Dispatch() failed. Aborting application."))
      pListener->_bIsRunning = FALSE;
      break;
    }
  }

  fastEventClient.Disconnect();
  MepaRx.Stop(); // call this after Disconnect()

  ETG_TRACE_USR4(("FastEv Listener - Dispatch loop exited"))
}

tVoid fc_streamrouter_most_fastev::postEv(int ev)
{
  if(_pMain != NULL)
  {
    (fc_streamrouter_tclApp*)_pMain->bPostEvent((OSAL_tEventMask)ev);
  }
}

#endif

