
#ifndef VARIANT_S_FTR_ENABLE_GM_STR
/*******************************************************************************
*
* FILE:          FC_StreamRouter_clienthandler_AudioMgmt.h
*
* SW-COMPONENT:  FC_StreamRouter application
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the service AudioMgmt.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_STREAMROUTER_CLIENTHANDLER_AUDIOMGMT_H_
#define _FC_STREAMROUTER_CLIENTHANDLER_AUDIOMGMT_H_

#define ARRAY_COUNT(arrayName) (sizeof(arrayName)/sizeof(arrayName[0]))

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;

class fc_streamrouter_tclClientHandler_audiomgmt
      : public ahl_tclBaseOneThreadClientHandler
{
  private:
    // the function IDs this client registers for
    static const tU16 _au16FIDs[];
  tVoid vRegisterForAllFIDs(tVoid);
  public:

    fc_streamrouter_tclClientHandler_audiomgmt(tVoid);
    fc_streamrouter_tclClientHandler_audiomgmt(fc_streamrouter_tclApp* poMainAppl);
    virtual ~fc_streamrouter_tclClientHandler_audiomgmt();


    fc_streamrouter_tclApp* m_poMainAppl;

    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_streamrouter_tclClientHandler_audiomgmt' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_streamrouter_tclClientHandler_audiomgmt& operator=
      (const fc_streamrouter_tclClientHandler_audiomgmt &oClientHandler);

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vProcessTimer(tU16 u16TimerId) const;

  //tBool bSendAmpDevAudioRoute(tU8 u8SrcNr, tU32 adrStreamNr);
  tBool bSendAmpDevAudioRoute(tU8 u8SrcNr, tU32 adrStreamNr, const char* audProcAdev, void* ccainfo, tU8 action);
  tBool bSendAmpDevAudioRoute(tU8 u8SrcNr, tU16 u16Sink, tU32 adrStreamNr, const char* audProcAdev, void* ccainfo, tU8 action);

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

  virtual tU16 u16GetServerServiceID(tVoid) const
    {
       // the ServiceId this client has registered for
       return CCA_C_U16_SRV_AUDIOFUNC;
    }
  // inbox for TTFis
    //virtual tVoid vTraceRx(tPCUChar pcu8Data);
    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

    // Add your CCA message handler function prototypes here.
    tVoid vHandleAmpDevAudioRoute_MethodResult(amt_tclServiceData* poMessage) const;

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

   DECLARE_MSG_MAP(fc_streamrouter_tclClientHandler_audiomgmt)
};

#endif // _FC_STREAMROUTER_CLIENTHANDLER_AUDIOMGMT_H_

#endif


