
#ifdef DEBUG_COUT
  #include <iostream>
  using namespace std;
#endif

class chlst{
  typedef struct{
    int pkey;
    int skey;
    void *data;
    void *next;
  }DSENTRY;

private:
  DSENTRY *_dslst;

  void cleanup(void){
    DSENTRY *pI = NULL;
    while(_dslst != NULL){
      pI = _dslst;
      _dslst = (DSENTRY*)_dslst->next;
      if(pI->data != NULL) OSAL_vMemoryFree(pI->data);
      OSAL_vMemoryFree(pI);
    }
  }

public:
  chlst(){
    _dslst = NULL;
  }

  ~chlst(){
    cleanup();
  }

  int del_entry(int pkey){
    int c = 0;
    DSENTRY *pC = _dslst; //current entry
    DSENTRY *pI = NULL;   //next entry
    DSENTRY *pD = NULL;   //previous entry
    while((pC != NULL) && (pC->pkey <= pkey)){
      if(pC->pkey == pkey){
        pI = (DSENTRY*)pC->next;
        if(pC == _dslst){
          _dslst = pI;
        }
        if(pD != NULL){
          pD->next = (void*)pI;
        }
        if(pC->data != NULL){
          OSAL_vMemoryFree(pC->data);
        }
        OSAL_vMemoryFree(pC);
        ++c;
        pC = pI;
      }
      else{
        pD = pC;
        pC = (DSENTRY*)pC->next;
      }
    }
    return c;
  }

  int del_entry(int pkey, int skey){
    int c = 0;
    DSENTRY *pC = _dslst; //current entry
    DSENTRY *pI = NULL;   //next entry
    DSENTRY *pD = NULL;   //previous entry
    while((pC != NULL) && (pC->pkey <= pkey)){
      if((pC->pkey == pkey) && (pC->skey == skey)){
        pI = (DSENTRY*)pC->next;
        if(pC == _dslst){
          _dslst = pI;
        }
        if(pD != NULL){
          pD->next = (void*)pI;
        }
        if(pC->data != NULL){
          OSAL_vMemoryFree(pC->data);
        }
        OSAL_vMemoryFree(pC);
        ++c;
        pC = pI;
      }
      else{
        pD = pC;
        pC = (DSENTRY*)pC->next;
      }
    }
    return c;
  }

  void add_entry(int pkey, int skey, void *data){
    DSENTRY *entry = (DSENTRY*)OSAL_pvMemoryAllocate(sizeof(DSENTRY));
    if(entry == NULL) return;

    entry->pkey = pkey;
    entry->skey = skey;
    entry->data = data;
    entry->next = NULL;

    if(_dslst == NULL){
      _dslst = entry;
    }
    else{
      DSENTRY *pC = _dslst;
      DSENTRY *pI = _dslst;
      while(pC != NULL){
        if(pkey < pC->pkey){
          if(pC == _dslst){
            entry->next = (void*)pC;
            _dslst = entry;
          }
          else{
            entry->next = (void*)pC;
            pI->next = (void*)entry;
          }
          return;
        }
        pI = pC;
        pC = (DSENTRY*)pC->next;
      }
      pI->next = (void*)entry;
    }
  }

  bool is_entry(int pkey){
    DSENTRY* pC = _dslst;
    while((pC != NULL) && (pC->pkey <= pkey)){
      if(pC->pkey == pkey) return true;
      pC = (DSENTRY*)pC->next;
    }
    return false;
  }

  bool is_entry(int pkey, int skey){
    DSENTRY* pC = _dslst;
    while((pC != NULL) && (pC->pkey <= pkey)){
      if((pC->pkey == pkey) && (pC->skey == skey)) return true;
      pC = (DSENTRY*)pC->next;
    }
    return false;
  }

  void *get_data(int pkey, int *idx){
    if(idx == NULL) return NULL;
    int i = 0;
    DSENTRY *pC = _dslst;
    while((pC != NULL) && (pC->pkey <= pkey)){
      if(pC->pkey == pkey){
        if(i == (*idx)) return pC->data;
        ++i;
      }
      pC = (DSENTRY*)pC->next;
    }
    return NULL;
  }

  void *get_data(int pkey, int skey){
    DSENTRY *pC = _dslst;
    while((pC != NULL) && (pC->pkey <= pkey)){
      if((pC->pkey == pkey) && (pC->skey == skey)) return pC->data;
      pC = (DSENTRY*)pC->next;
    }
    return NULL;
  }

  int get_next_pkey(int pkey){
    DSENTRY *pC = _dslst;
    while(pC != NULL){
      if(pC->pkey > pkey) return pC->pkey;
      pC = (DSENTRY*)pC->next;
    }
    return -1;
  }

  void debug_printvect(void){
#ifdef DEBUG_COUT
    DSENTRY *pC = _dslst;
    cout << "DEBUG:" << endl;
    while(pC != NULL){
      cout << " key: " << pC->pkey << ", " << pC->skey <<  endl;
      pC = (DSENTRY*)pC->next;
    }
    cout << endl;
#endif
  }

};

