
/*!
*******************************************************************************
* Filename          : FC_StreamRouter.cpp
*******************************************************************************
*  - PROJECT:       : G3 GMMY16
*  - SW-COMPONENT   : FC_StreamRouter
*  - DESCRIPTION    : FC_StreamRouter Start up module
*  - COPYRIGHT      : &copy; 2013 Robert Bosch Engineering & Business Solutions
*  - Documents      : <<Give link of relevant documents >>
*******************************************************************************
* \date 27.5.2013 \version <<Enter Version No>> \author (RBEI/ECV1)
* <<Write History >>
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AIL_S_IMPORT_INTERFACE_TRACE
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"




#define USE_NO_BUILDVERSION 1
#ifndef USE_NO_BUILDVERSION
#include "buildversion_if.h"
#endif

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"


/******************************************************************************
|      defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/
// The name used for the OSAL shutdown event
#define FC_STREAMROUTER_SHUTDOWN_EVENT_NAME "FC_STREAMROUTER_SHUTDOWN"

/******************************************************************************
|      typedefs  (scope: module-local)
|----------------------------------------------------------------------------*/

// template class definition for starting and stopping CCA applications
template <class CCA_Class> CCA_Class *pCreateCcaApp(CCA_Class *, const char *, int);
#define CCA_CREATE_APP(CCA_ClassName, poCCA_Class, ccaId) (pCreateCcaApp<CCA_ClassName>(poCCA_Class, #CCA_ClassName, ccaId))
template <class CCA_Class> CCA_Class *vDestroyCcaApp(CCA_Class *, const char *);
#define CCA_DESTROY_APP(CCA_ClassName, poCCA_Class) (vDestroyCcaApp<CCA_ClassName>(poCCA_Class, #CCA_ClassName))


/******************************************************************************
|      variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

// FC_StreamRouter Application:
#define FC_STREAMROUTER_S_IMPORT_INTERFACE_GENERIC
#include "FC_StreamRouter_if.h"
static fc_streamrouter_tclApp* poFcStreamRouterApp = NULL;

// Shutdown event handle.
static OSAL_tEventHandle hProcStreamRouterShutdown = OSAL_C_INVALID_HANDLE;

/******************************************************************************
|        function prototype (scope: module-local)
|----------------------------------------------------------------------------*/
#if 0
#ifdef SYSTEM_S_USE_BPSTL
extern tBool exh_bInitExceptionHandling(tVoid); // lint
#endif
#endif
static tBool ProcFcStreamRouter_bStart(tVoid);
static tVoid ProcFcStreamRouter_vWaitForShutdown(tVoid);

/******************************************************************************
|      function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: modul-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
* FUNCTION:    ProcFcStreamRouter_bStart(tVoid)
* Description: Starts the FC_Streamrouter process. Should be called only once after
*               startup of the process in which the FC_Streamrouter module runs.
*               The function creates a shutdown event as well.
******************************************************************************/
tBool ProcFcStreamRouter_bStart(tVoid)
{
   tBool bResult = FALSE;

   et_vTraceOpen();

   bResult = amt_bInit();

   if(FALSE == bResult)
   {
      printf("amt_bInit failed");
   }

   bResult = scd_init();

   if(FALSE == bResult)
   {
      printf("scd_init failed");
   }
#ifdef SYSTEM_S_USE_BPSTL
   bResult = 1;

   if(bResult == FALSE)
   {
      printf("exh_bInitExceptionHandling failed");
   }
#endif
   //Start CCA Component FC_StreamRouter
   //if(scd_bAppRegistryAvailable(CCA_C_U16_APP_FC_STREAMROUTER))
   {
      poFcStreamRouterApp = CCA_CREATE_APP(fc_streamrouter_tclApp, poFcStreamRouterApp, CCA_C_U16_APP_STREAMROUTER);
   }

   if (OSAL_ERROR ==OSAL_s32EventCreate(FC_STREAMROUTER_SHUTDOWN_EVENT_NAME, &hProcStreamRouterShutdown))
   {
      /*tU32 u32ErrorCode  =*/ OSAL_u32ErrorCode();
     /* HMI_TraceError(TR_CLASS_HMI_COMMON, ET_EN_T16 _ E_HMI_STARTUP_OSAL_ERRORCODE _
         ET_EN_T32 _ u32ErrorCode _ ET_EN_DONE);
            */
      NORMAL_M_ASSERT_ALWAYS();
   }
   else
   {

      printf("---------------------------------------------------");

#ifndef USE_NO_BUILDVERSION
      printf("FC_StreamRouter:  Version: %s", (tCString)BuildVersion_szLabel);
      printf("FC_StreamRouter:  Builddate: %8.8s  %2.2s:%2.2s:%2.2s",
         BuildVersion_szTimestamp, BuildVersion_szTimestamp+8,
         BuildVersion_szTimestamp+10, BuildVersion_szTimestamp+12 );
      printf("FC_StreamRouter:       User: %s on %s",
         (tCString)BuildVersion_szBuildUser,
         (tCString)BuildVersion_szBuildMachine);
      if ((BuildVersion_szBuildType[0] == 'd') &&
         (BuildVersion_szBuildType[1] == 'e') &&
         (BuildVersion_szBuildType[2] == 'v'))
      {
         printf("FC_StreamRouter:       Type: Development build");
      }
      else
      {
         printf("FC_StreamRouter:       Type: Integration build");
      }
#ifdef __DEBUG_BUILD__
      printf("FC_StreamRouter:        Mode: Debug  ");
#else
      printf("FC_StreamRouter:        Mode: Release  ");
#endif

      printf("---------------------------------------------------");
#endif //ifndef USE_NO_BUILDVERSION

#ifdef BUILDENV_LINUX // TritonLinuxMake
      printf("\n---------------------------------------------------\n");
      printf("                    FC_StreamRouter\n");
      printf("---------------------------------------------------\n");
#endif

   }

   if (!bResult && (hProcStreamRouterShutdown != OSAL_C_INVALID_HANDLE))
   {
      // tU32 u32ErrorCode  = 0xFFFF;

      /*HMI_TraceError(TR_CLASS_HMI_COMMON, ET_EN_T16 _ E_HMI_STARTUP_OSAL_ERRORCODE _
         ET_EN_T32 _ u32ErrorCode _ ET_EN_DONE);*/
      NORMAL_M_ASSERT_ALWAYS();
      OSAL_s32EventClose(hProcStreamRouterShutdown);
      OSAL_s32EventDelete(FC_STREAMROUTER_SHUTDOWN_EVENT_NAME);
      hProcStreamRouterShutdown = OSAL_C_INVALID_HANDLE;
   }

   return bResult;
}//ProcFcStreamRouter_bStart(tVoid)


/******************************************************************************
* FUNCTION:    ProcFcStreamRouter_vWaitForShutdown(tVoid)
* Description: Function waits on the shutdown event created in the
*              ProcFcStreamRouter_bStart. After the event is signalled, this function
*              shuts the FC_StreamRouter process down. Should be called only after
*              ProcFcStreamRouter_bStart returns TRUE.
******************************************************************************/
tVoid ProcFcStreamRouter_vWaitForShutdown(tVoid)
{
   OSAL_tEventMask tShutdownMask = 1;

   if (hProcStreamRouterShutdown != OSAL_C_INVALID_HANDLE)
   {
      /*HMI_TraceUser4(TR_CLASS_HMI_COMMON,
         ET_EN_T16 _ I_HMI_STARTUP_WAITING_FOR_SHUTDOWN
         _ ET_EN_DONE);*/

      (void)OSAL_s32EventWait(hProcStreamRouterShutdown, tShutdownMask,
         OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &tShutdownMask);

      // Stop CCA Component FC_StreamRouter
      //if(scd_bAppRegistryAvailable(CCA_C_U16_APP_STREAMROUTER))
      {
     poFcStreamRouterApp  = CCA_DESTROY_APP(fc_streamrouter_tclApp, poFcStreamRouterApp);
      }

      OSAL_s32EventClose(hProcStreamRouterShutdown);

      OSAL_s32EventDelete(FC_STREAMROUTER_SHUTDOWN_EVENT_NAME);

      hProcStreamRouterShutdown = OSAL_C_INVALID_HANDLE;
   }


   scd_exit();

   et_vTraceClose();

}//ProcFcStreamRouter_vWaitForShutdown(tVoid)


#ifdef VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS
extern "C" OSAL_DECL tS32 vStartApp(tS32 cPar, tString aPar[])
#else
extern "C" OSAL_DECL tS32 OSAL_s32Boot(tS32 cPar, tString aPar[])
#endif
{
  (void)cPar;
  (void)aPar;
    if(ProcFcStreamRouter_bStart())
    {
       ProcFcStreamRouter_vWaitForShutdown();
    }
    return 0;
}


// template classes for creating and destroying a CCA Service
template <class CCA_Class>
CCA_Class *pCreateCcaApp(CCA_Class *poCcsApp, char *pCCA_ClassName, int iCcaId)
{
   if (poCcsApp == NULL)
   {
      ET_TRACE_INFO1(TR_COMP_SYSTEM, (const tChar*)"%s: create application", pCCA_ClassName);

      poCcsApp = new CCA_Class();
      if (poCcsApp != NULL)
      {
         if ( !poCcsApp->bInitInstance( 0, (tU16)iCcaId))
         {
            ET_TRACE_ERROR1(TR_COMP_SYSTEM, (const tChar*)"%s: init failed", pCCA_ClassName);
         }
         else
         {
           ET_TRACE_INFO2(TR_COMP_SYSTEM, (const tChar*)"%s: create application for ccaId=0x%x", pCCA_ClassName, iCcaId);
         }
      }
      else
      {
         ET_TRACE_ERROR1(TR_COMP_SYSTEM, (const tChar*)"%s: construction failed", pCCA_ClassName);
      }
   }
   else
   {
     ET_TRACE_INFO1(TR_COMP_SYSTEM, (const tChar*)"%s: already initialized.", pCCA_ClassName);
   }

   return poCcsApp;
}

template <class CCA_Class>
CCA_Class *vDestroyCcaApp(CCA_Class *poCcsApp, char *pCCA_ClassName)
{
   ET_TRACE_INFO1(TR_COMP_SYSTEM, (const tChar*)"%s: delete", pCCA_ClassName);

   if(poCcsApp != NULL)
   {
      poCcsApp->vDeinitInstance();

      delete poCcsApp;
   }

   return NULL;
}


///////////////////////////////////////////////////////////////////////////////
// <EOF>
