

#ifdef VARIANT_S_FTR_ENABLE_GM_STR
/*******************************************************************************
* FILE:          FC_StreamRouter_Diagnosis.cpp
* PROJECT:
* SW-COMPONENT:  FC_StreamRouter class for Diagnosis
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   General class of diagnosis
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 06.04.11  | TMS Gaidatzi-Lken      | Inital version
*******************************************************************************/

#include "FC_StreamRouter_Diagnosis.h"
#include "../FC_StreamRouter_trace_def.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_STREAMROUTER_DIAGLIB
#include "trcGenProj/Header/FC_StreamRouter_Diagnosis.cpp.trc.h"
#endif

#include "../FC_StreamRouter_main.h"

/* DIAGLIB beginn */
#include "FC_StreamRouter_DiaglibSetPhantomvoltageMic1Handler.h"
#include "FC_StreamRouter_DiaglibSetPhantomvoltageMic2Handler.h"
#include "FC_StreamRouter_DiaglibGetADValueMic1Handler.h"
#include "FC_StreamRouter_DiaglibGetADValueMic2Handler.h"
/* DIAGLIB end */


/* DIAGLOG beginn */
#include "FC_StreamRouter_clienthandler_DiaglogMic.h"
/* DIAGLOG end */




/*******************************************************************************
                  Methods of class
*******************************************************************************/

/*******************************************************************************
**  FUNCTION:
*   fc_streamrouter_tclDiagnosis(fc_streamrouter_tclApp* pFc_streamrouter_MainApp)
*   Constructor
*******************************************************************************/
fc_streamrouter_tclDiagnosis::fc_streamrouter_tclDiagnosis(fc_streamrouter_tclApp* pFc_streamrouter_MainApp)
{

  /* DIAGLIB beginn */
  m_pDiaglibService = NULL;
  m_pDglibPVMic1Handler = NULL;
  m_pDglibPVMic2Handler = NULL;
  m_pDglibADValueMic1Handler = NULL;
  m_pDglibADValueMic2Handler = NULL;

  if (pFc_streamrouter_MainApp == NULL)
  {
      ETG_TRACE_FATAL(( "bOnInit: FC_Streamrouter pointer is NULL" ));
      FATAL_M_ASSERT_ALWAYS();
      return;
  }

   // Generate Diaglib Framework
  m_pDiaglibService = OSAL_NEW diaglib::tclServiceDiaglib((ahl_tclBaseOneThreadApp*)pFc_streamrouter_MainApp, 1);
  if (m_pDiaglibService == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib service failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }

   // Generate "Phantom voltage MIC1 handler" for Diaglib IF (Diagnostic)
   m_pDglibPVMic1Handler = OSAL_NEW fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler(m_pDiaglibService,
                  (fc_streamrouter_tclConfigMic*)pFc_streamrouter_MainApp->m_poConfigMic);
   if (m_pDglibPVMic1Handler == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Phanton voltage Mic1 handler for Diagnostic failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }

   // Generate "Phantom voltage MIC2 handler" for Diaglib IF (Diagnostic)
   m_pDglibPVMic2Handler = OSAL_NEW fc_streamrouter_DiaglibSetPhantomvoltageMic2Handler(m_pDiaglibService,
                  (fc_streamrouter_tclConfigMic*)pFc_streamrouter_MainApp->m_poConfigMic);
   if (m_pDglibPVMic2Handler == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib Phanton voltage Mic1 handler for Diagnostic failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }

   // Generate "readADValue MIC1 handler" for Diaglib IF (Diagnostic)
   m_pDglibADValueMic1Handler = OSAL_NEW fc_streamrouter_DiaglibGetADValueMic1Handler(m_pDiaglibService);
   if (m_pDglibADValueMic1Handler == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib readADValue Mic1 handler for Diagnostic failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }

   // Generate "readADValue MIC2 handler" for Diaglib IF (Diagnostic)
   m_pDglibADValueMic2Handler = OSAL_NEW fc_streamrouter_DiaglibGetADValueMic2Handler(m_pDiaglibService);
   if (m_pDglibADValueMic2Handler == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib readADValue Mic2 handler for Diagnostic failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }
   /* DIAGLIB end */


   /* DIAGLOG beginn */

   m_pDglogMicClientHandler = NULL;

   // Generate "readADvalue clientHandler" for Diaglog IF (DTC Diagnostic)

   m_pDglogMicClientHandler = OSAL_NEW fc_streamrouter_tclClientHandler_diaglogMic(pFc_streamrouter_MainApp);
   if (m_pDglogMicClientHandler == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglog Mic ClientHandler for Diagnostic failed" ));
      FATAL_M_ASSERT_ALWAYS();
   }

  /* DIAGLOG end */

}


/*******************************************************************************
**  FUNCTION:
*   ~fc_streamrouter_tclDiagnosis(tVoid)
*   Destructor
*******************************************************************************/
fc_streamrouter_tclDiagnosis::~fc_streamrouter_tclDiagnosis(tVoid)
{
  /* DIAGLIB beginn */

  // delete Diaglib Framework
   if (m_pDiaglibService != NULL)
   {
    OSAL_DELETE m_pDiaglibService;
    m_pDiaglibService = NULL;
   }

   // delete "Phantom voltage MIC1 handler" for Diagnostic
   if (m_pDglibPVMic1Handler != NULL)
   {
     OSAL_DELETE m_pDglibPVMic1Handler;
     m_pDglibPVMic1Handler = NULL;
   }

   // delete "Phantom voltage MIC2 handler" for Diagnostic
   if (m_pDglibPVMic2Handler != NULL)
   {
    OSAL_DELETE m_pDglibPVMic2Handler;
    m_pDglibPVMic2Handler = NULL;
   }

   // delete "readADValue MIC1 handler" for Diagnostic
   if (m_pDglibADValueMic1Handler != NULL)
   {
     OSAL_DELETE m_pDglibADValueMic1Handler;
     m_pDglibADValueMic1Handler = NULL;
   }

   // delete "readADValue MIC2 handler" for Diagnostic
   if (m_pDglibADValueMic2Handler != NULL)
   {
     OSAL_DELETE m_pDglibADValueMic2Handler;
     m_pDglibADValueMic2Handler = NULL;
   }
   /* DIAGLIB end */


   /* DIAGLOG beginn */

   // delete "readADvalue clientHandler" for Diaglog IF (DTC Diagnostic)

   if (m_pDglogMicClientHandler != NULL)
   {
     OSAL_DELETE m_pDglogMicClientHandler;
     m_pDglogMicClientHandler = NULL;
   }

  /* DIAGLOG end */

}
#endif


