

#ifdef VARIANT_S_FTR_ENABLE_GM_STR
/************************************************************************
* FILE:         FC_StreamRouter_DiaglibSetPhantomvoltageMic1Handler.cpp
* PROJECT:
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: Implementation of a RoutineControl listener.
* This handler sets the Nav Route Calculation value for a Routecalculation
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 12.11.10  | TMS Plischke       | Inital version
* 11.03.11  | TMS Gaidatzi-Lken | integrate the microphone functions
*
*************************************************************************/
// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_IO_CONTROL
#include "diaglib_if.h"

#include "FC_StreamRouter_DiaglibSetPhantomvoltageMic1Handler.h"

#include "../FC_StreamRouter_trace_def.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_STREAMROUTER_DIAGLIB
#include "trcGenProj/Header/FC_StreamRouter_DiaglibSetPhantomvoltageMic1Handler.cpp.trc.h"
#endif

#include "../FC_StreamRouter_configMic.h"




/*******************************************************************************
**  FUNCTION:
*   fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler(
*  diaglib::tclServiceDiaglib* pDiaglibService, fc_streamrouter_tclConfigMic* pConfigMicAppl
*   Constructor
*******************************************************************************/

fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler(
  diaglib::tclServiceDiaglib* pDiaglibService, fc_streamrouter_tclConfigMic* pConfigMicAppl)
  : mpDiaglibService(pDiaglibService)
{
   if(mpDiaglibService != NULL)
   {
      mpDiaglibService->poGetIoCtrl()->vRegisterListener(IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1, this);
   }

   if (pConfigMicAppl != NULL)
   {
    mpConfigMic = pConfigMicAppl;
   }
   else
   {
     mpConfigMic = NULL;
     ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler => ERROR: fc_streamrouter Config Mic pointer is NULL"));
   }
}



/*******************************************************************************
**  FUNCTION:
*   ~fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler()
*   Destructor
*******************************************************************************/
fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::~fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler()
{
   mpDiaglibService = NULL;
   mpConfigMic = NULL;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControl(tU32 u32IoControlId, diaglib::tenIoControlAction enActionId,
*                 const diaglib::tclParameterVector& oParameterVector,diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for set Phantom Voltage request
*******************************************************************************/
tU32 fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl (
                                                             tU32 u32IoControlId,
                                                             diaglib::tenIoControlAction enActionId,
                                                             const diaglib::tclParameterVector& oParameterVector,
                                                             diaglib::tContext MsgContext
                                                           )
{
   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_NOT_OK;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( enActionId );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( oParameterVector )
   // check for expected Routine ID

   switch(u32IoControlId)
   {
      case IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1:
      {
         ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1"));

         // create object for response
         diaglib::tclParameterVector oTmpVec;

         // answer beginn

         if(diaglib::bCheckParameterSignature(oParameterVector,
                                              IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_SET_LEN,
                                              IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_SET_PARAM1) == FALSE)
         {
            ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => ERROR: bCheckParameterSignature FAILED"));
            oCtrlResult = diaglib::EN_IO_CONTROL_NOT_OK; // Control failed

            diaglib::trParameter paramaError;
            paramaError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
            paramaError.u8Value        = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
            oTmpVec.push_back(paramaError);
         }// if(diaglib::bCheckParameterSignature(oParamVector, ...
         else
         {

            // get Data
            tBool bStatus = oParameterVector[IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_SET_bStatus].u8Value; //True=On, False=Off for Mic1
      tBool bret = TRUE;
      //tU32  u32storeMask = 0, u32errMask = 0;

            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => Status =%d",bStatus));


      if (mpConfigMic != NULL)
      {
        if (bStatus == 1) //1 = Microphone 1 ON
        {
          /*
          u32errMask = mpConfigMic->setMicGPIOs((STR_MICCFG_POWER | STR_MICCFG_SELECT | STR_MICCFG_DIAG1), (unsigned int*)(&u32storeMask));
          if (u32errMask != 0)
          {
            ETG_TRACE_ERR(("--- fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::Streamrouter->setMicGPIOs => Error =%d", u32errMask));
            bret = FALSE;
          }
          */
          if(mpConfigMic->setGPIO(TRUE, OSAL_EN_MIC_HW_POWER_CTRL, NULL) != 0)
          {
            bret = FALSE;
            ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => ERROR: UNABLE TO SET MIC HW POWER GPIO!"));
          }
          else
          {
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler => GPIO MIC HW POWER is seted High"));
          }

          if(mpConfigMic->setGPIO(TRUE, OSAL_EN_MIC_SELECT_CTRL, NULL) != 0)
          {
            bret = FALSE;
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => ERROR: UNABLE TO SET MIC SELECT CTRL GPIO!"));
          }
          else
          {
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler => GPIO MIC SELECT CTR is seted High"));
          }

          if(mpConfigMic->setGPIO(TRUE, OSAL_EN_MIC_DIAG1_ENABLE, NULL) != 0)
          {
            bret = FALSE;
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => ERROR: UNABLE TO SET MIC DIAG1 ENABLE GPIO!"));
          }
          else
          {
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler => GPIO MIC DIAG1 ENABLE is seted High"));
          }


        }
        else if (bStatus == 0) //0 = Microphone 1 OFF
        {
          /*
          u32errMask = mpConfigMic->setMicGPIOs(STR_MICCFG_POWER, (unsigned int*)(&u32storeMask));
          if (u32errMask != 0)
          {
            ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::Streamrouter->setMicGPIOs => Error =%d", u32errMask));
            bret = FALSE;
          }
          */
          if(mpConfigMic->setGPIO(TRUE, OSAL_EN_MIC_HW_POWER_CTRL, NULL) != 0)
          {
            bret = FALSE;
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => ERROR: UNABLE TO SET MIC HW POWER GPIO!"));
          }
          else
          {
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler => GPIO MIC HW POWER is seted High"));
          }

          if(mpConfigMic->setGPIO(FALSE, OSAL_EN_MIC_SELECT_CTRL, NULL) != 0)
          {
            bret = FALSE;
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => ERROR: UNABLE TO SET MIC SELECT CTRL GPIO!"));
          }
          else
          {
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler => GPIO MIC SELECT CTRL is seted Low"));
          }

        }
        else //bStatus is not 1 or 0
        {
          bret = FALSE;
          ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler => ERROR: invalid status value (only 0 or 1 is allowed) "));
        }

      }//if (mpConfigMic != NULL)
      else
      {
        bret = FALSE;
        ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler => ERROR: fc_streamrouter Config Mic pointer is NULL"));
      }

            if(bret)
            {
               oCtrlResult = diaglib::EN_IO_CONTROL_OK; // data valid
               diaglib::trParameter paramaStatus;
               paramaStatus.enType         = static_cast<diaglib::tenParameterType>(IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_1_RESULT_PARAM1);
               paramaStatus.u8Value        = bStatus;
               oTmpVec.push_back(paramaStatus);
            }
            else
            {
               oCtrlResult = diaglib::EN_IO_CONTROL_NOT_OK; // Control failed

               diaglib::trParameter paramaError;
               paramaError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
               paramaError.u8Value        = diaglib::EN_ERROR_FATAL_INTERNAL;
               oTmpVec.push_back(paramaError);
            }
         }
         // example for answer end


         // send message back to diagnosis
         if(mpDiaglibService != OSAL_NULL)
         {
            if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlMethodResult( oCtrlResult,
                                                                                      enActionId,
                                                                                      oTmpVec,
                                                                                      MsgContext) )
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
               ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => bSendIoCtrlMethodResult successfull"));
            }// if(TRUE == mpDiaglibService->poGetIoCtrl()
            else
            {
               u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
               ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => ERROR : bSendRoutineCtrlMethodResult failed"));
            }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
         }// if(mpDiaglibService != OSAL_NULL)
         else
         {
            u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
            ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl => ERROR : mpDiaglibService == OSAL_NULL"));
         }// else // if(mpDiaglibService != OSAL_NULL)
         break;

      }// case IOCONTROLID_MIC_PHANTOMVOLTAGE_MIC_2:

      default:
      {
         break;
      }// default:
   }// switch(u32IoControlId)

   ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControl(%x)",u32Return));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlFreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Freeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlFreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR3_THR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlFreeze"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlFreezeResult( oCtrlResult,
                                                                                MsgContext) )
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlFreeze => bSendIoCtrlFreezeResult successfull"));
      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlFreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlFreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlFreeze(%x)",u32Return));

   return u32Return;
}



/*******************************************************************************
**  FUNCTION:
*   vOnIoControlUnfreeze ( tU32 u32IoControlId, diaglib::tContext MsgContext)
*   DESCRIPTION: Command from Diagnosis for Unfreeze the State before the Diagnosis Request
*                (not implemented in the diagnosis)
*******************************************************************************/
tU32 fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlUnfreeze (
                                              tU32 u32IoControlId,
                                              diaglib::tContext MsgContext
                                            )
{
  (void)u32IoControlId;
   ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlUnfreeze"));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_OK;

   if(mpDiaglibService != OSAL_NULL)
   {
      if(TRUE == mpDiaglibService->poGetIoCtrl()->bSendIoCtrlUnfreezeResult( oCtrlResult,
                                                                                MsgContext) )
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
         ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlUnfreeze => bSendIoCtrlFreezeResult successfull"));
      }// if(TRUE == mpDiaglibService->poGetIoCtrl()
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlUnfreeze => ERROR : bSendRoutineCtrlMethodResult failed"));
      }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
   }// if(mpDiaglibService != OSAL_NULL)
   else
   {
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
      ETG_TRACE_ERR(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlUnfreeze => ERROR : mpDiaglibService == OSAL_NULL"));
   }// else // if(mpDiaglibService != OSAL_NULL)

   ETG_TRACE_USR4(("fc_streamrouter_DiaglibSetPhantomvoltageMic1Handler::vOnIoControlUnfreeze(%x)",u32Return));
   return u32Return;

}
#endif

