

#ifdef VARIANT_S_FTR_ENABLE_GM_STR
/************************************************************************
* FILE:         FC_StreamRouter_DiaglibGetADValueMic1Handler.cpp
* PROJECT:
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: Implementation of a RoutineControl listener.
* This handler sets the Nav Route Calculation value for a Routecalculation
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                 | Modification
* 12.11.10  | TMS Plischke           | Inital version
* 15.03.11  | TMS Gaidatzi-Lken     | integrate the microphone functions
*
*************************************************************************/
// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_DIAGNOSIS_DATA
#include "diaglib_if.h"

#include "FC_StreamRouter_DiaglibGetADValueMic1Handler.h"

/* OSAL Device header */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../FC_StreamRouter_trace_def.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_STREAMROUTER_DIAGLIB
#include "trcGenProj/Header/FC_StreamRouter_DiaglibGetADValueMic1Handler.cpp.trc.h"
#endif


/*******************************************************************************
**  FUNCTION:
*   fc_streamrouter_DiaglibGetADValueMic1Handler(
*  diaglib::tclServiceDiaglib* pDiaglibService): mpDiaglibService(pDiaglibService)
*   Constructor
*******************************************************************************/

fc_streamrouter_DiaglibGetADValueMic1Handler::fc_streamrouter_DiaglibGetADValueMic1Handler(
  diaglib::tclServiceDiaglib* pDiaglibService): mpDiaglibService(pDiaglibService)
{
   if(mpDiaglibService != NULL)
   {
      mpDiaglibService->poGetDiagData()->vRegisterListener(DATAID_MIC_AD_VALUE_MIC_1, this);
   }


}

/*******************************************************************************
**  FUNCTION:
*   ~fc_streamrouter_DiaglibGetADValueMic1Handler()
*   Destructor
*******************************************************************************/

fc_streamrouter_DiaglibGetADValueMic1Handler::~fc_streamrouter_DiaglibGetADValueMic1Handler()
{
   mpDiaglibService = NULL;

}


/*******************************************************************************
**  FUNCTION:
*   vOnDiagnosisDataRead(tU32 u32DiagDataId, diaglib::tContext MsgContext);
*   DESCRIPTION: Command from Diagnosis for Read request
*******************************************************************************/

tU32 fc_streamrouter_DiaglibGetADValueMic1Handler::vOnDiagnosisDataRead (
                                                                    tU32 u32DiagDataId,
                                                                    diaglib::tContext MsgContext)
{
   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;

   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );

   /***************************************************************************/
   /* DATAID_DISPLAY_TYPE (read)                                              */
   /*                                                                         */
   /* \param[in]  none                                                        */
   /*                                                                         */
   /* \param[out] oDataResult                                                 */
   /*             u8Type                                                      */
   /***************************************************************************/
   if(u32DiagDataId == DATAID_MIC_AD_VALUE_MIC_1)
   {
      ETG_TRACE_USR4(("fc_streamrouter_DiaglibGetADValueMic1Handler::vOnDiagnosisDataRead() => DATAID_MIC_AD_VALUE_MIC_1"));
      // create object for response
      diaglib::tclParameterVector oTmpVec;
      diaglib::tenDiagDataResult oDataResult = diaglib::EN_DIAGDATA_NOT_OK;

      tU32 u32ADCValue;
    tBool bRet = TRUE;


    // Read ADCValue, the function is from the basis class fc_streamrouter_DiagCommonADCRead
    bRet = bReadMicADCMidValue(MIC1, &u32ADCValue);

      if(bRet)
      {

 #ifdef READ_ADC_REFVOL_FROM_KDS
         tU32 u32MicADCrefV = u32ReadADCRefVfromKDS(); //Read ADC Reference Voltage from KDS
 #else
         tU32 u32MicADCrefV = MIC_ADC_REFVOL_DEFAULT;
 #endif
         ETG_TRACE_USR4(("fc_streamrouter_DiaglibGetADValueMic1Handler(): => ADC reference Voltage = %d mV", u32MicADCrefV));

         oDataResult = diaglib::EN_DIAGDATA_OK; // Read Data succesfully

         diaglib::trParameter paramMicAdValue;

         paramMicAdValue.enType       = static_cast<diaglib::tenParameterType>(DATAID_MIC_AD_VALUE_MIC_1_READ_RESULT_PARAM1);
         paramMicAdValue.u32Value     = (tU32)(u32ADCValue * u32MicADCrefV / MAX_ADC_VALUE ); //the ADCValue in mVolt
         ETG_TRACE_USR4(("fc_streamrouter_DiaglibGetADValueMic1Handler::vOnDiagnosisDataRead => Mic1 ADCValue = %d mV", paramMicAdValue.u32Value));

          oTmpVec.push_back(paramMicAdValue);
      }
      else
      {
         oDataResult = diaglib::EN_DIAGDATA_NOT_OK; // Control failed

         diaglib::trParameter paramaError;
         paramaError.enType         = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
         paramaError.u8Value        = diaglib::EN_ERROR_FATAL_INTERNAL;
         oTmpVec.push_back(paramaError);
      }
      // example for answer end

      // send message back to diagnosis
      if(mpDiaglibService != OSAL_NULL)
      {
         if(TRUE == mpDiaglibService->poGetDiagData()->bSendDiagnosisDataResult( oDataResult,oTmpVec,MsgContext) )
         {
            u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
            ETG_TRACE_USR4(("fc_streamrouter_DiaglibGetADValueMic1Handler::vOnDiagnosisDataRead => bSendDiagnosisDataResult successfull"));
         }// if(TRUE == mpDiaglibService->poGetIoCtrl()
         else
         {
            u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
            ETG_TRACE_ERR(("!!! fc_streamrouter_DiaglibGetADValueMic1Handler::vOnDiagnosisDataRead => ERROR : bSendDiagnosisDataResult failed"));
         }// else // if(TRUE == mpDiaglibService->poGetIoCtrl()
      }// if(mpDiaglibService != OSAL_NULL)
      else
      {
         u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
         ETG_TRACE_ERR(("fc_streamrouter_DiaglibGetADValueMic1Handler::vOnDiagnosisDataRead => ERROR : mpDiaglibService == OSAL_NULL"));
      }// else // if(mpDiaglibService != OSAL_NULL)
   }// if(u32DiagDataId == DATAID_DISPLAY_TYPE)

   ETG_TRACE_USR4(("fc_streamrouter_DiaglibGetADValueMic1Handler::vOnDiagnosisDataRead(%x)",u32Return));

   return u32Return;
}


/***********************************************************************//**
 * \brief CCA Service vOnDiagDataWrite
 *
 * Command from Diagnosis for simple Write request
 *
 *//************************************************************************/
tU32 fc_streamrouter_DiaglibGetADValueMic1Handler::vOnDiagnosisDataWrite (
                                                        tU32 u32DiagDataId,
                                                        const diaglib::tclParameterVector& oParamVector,
                                                        diaglib::tContext MsgContext
                                                        )
{
   ETG_TRACE_ERR(("fc_streamrouter_DiaglibGetADValueMic1Handler::vOnDiagDataWrite => ERROR : not supported"));
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32DiagDataId );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( oParamVector );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );
   return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
}
#endif


