

#ifdef VARIANT_S_FTR_ENABLE_GM_STR
/*******************************************************************************
* FILE:          FC_StreamRouter_DiagCommonADCRead.cpp
* PROJECT:
* SW-COMPONENT:  FC_StreamRouter application
*-------------------------------------------------------------------------------
*
* DESCRIPTION:   Diagnostic basic class to Read the ADC Value from ADC Device
*
*-------------------------------------------------------------------------------
*
* COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 21.04.11  | TMS Gaidatzi-Lken      | Inital version
*******************************************************************************/

/* OSAL Device header */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "FC_StreamRouter_DiagCommonADCRead.h"

#include "../FC_StreamRouter_trace_def.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_STREAMROUTER_DIAGLIB
#include "trcGenProj/Header/FC_StreamRouter_DiagCommonADCRead.cpp.trc.h"
#endif


#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF
#include "system_pif.h"

#define KDS_ADC_REF_LEN 4



/*******************************************************************************
** FUNCTION:   tVoid bReadMicADCValue();
* Read a lot of adc values of the  Microphone from ADC-device and calculate the average of them.
* This ADCValue is in ADC Steps (not in Volt or mVolt)
* This function is used from several classes (fc_streamrouter_DiaglibGetADValueMic1Handler,
*                        fc_streamrouter_DiaglibGetADValueMic2Handler and
*                                             fc_streamrouter_tclClientHandler_diaglogMic)
*******************************************************************************/

tBool fc_streamrouter_DiagCommonADCRead::bReadMicADCMidValue(tU16 tU16Mic, tU32* u32ADCValue)
{

  OSAL_tIODescriptor adcDevice = OSAL_ERROR; // for mic adc
    tPU16 pu16ADCdata = NULL ;
  tU32 u32ReadSize = 0; //, u32ADCValueLen = 0;
  tBool bRet = TRUE;
  tCString tCSMicDeviceName;
    tU32 NoOfBlocks  = 1;
    //tU32 u32NoOfBlocks = 1;
    tU32 U32_minblksize =2;

  //adc device open and read the value from Mic

    if (u32ADCValue == NULL)
    {
    ETG_TRACE_ERR(("bReadMicADCMidValue(): =>ERROR: u32ADCValue pointer is NULL"));
        return FALSE;
    }

  if (tU16Mic == MIC1)
  {
    tCSMicDeviceName = (tCString)OSAL_C_STRING_DEVICE_ADC_MIC_DIAG;
  }
  else if (tU16Mic == MIC2)
  {
    tCSMicDeviceName = (tCString)OSAL_C_STRING_DEVICE_ADC_MIC_DIAG_2;
  }
  else
  {
    ETG_TRACE_ERR(("bReadMicADCMidValue(): =>ERROR: device is not Mic1 or Mic2, Mic =%d", tU16Mic));
    return FALSE;
  }

    /* Channel Open */
  adcDevice = OSAL_IOOpen(tCSMicDeviceName, OSAL_EN_READWRITE);
  if(adcDevice != OSAL_ERROR)
  {
        /*
        if(OSAL_ERROR == OSAL_s32IOControl(adcDevice, OSAL_C_S32_IOCTRL_ADC_VC_GET_BLOCKSIZE,(tS32)&u32ADCValueLen))
        {
      ETG_TRACE_ERR(("bReadMicADCMidValue(): =>ERROR: OSAL_s32IOControl for mic adc device failed"));
      bRet = FALSE;
        }
        if(u32ADCValueLen > 0)
        {
        */
            pu16ADCdata = (tPU16)OSAL_pvMemoryAllocate((tU32)U32_minblksize* NoOfBlocks);
            if (pu16ADCdata != NULL)
            {
                tPS8 ps8ADCdata = (tPS8)(tVoid *)pu16ADCdata;

                u32ReadSize = (tU32)OSAL_s32IORead(adcDevice, (tPS8)(ps8ADCdata), (tU32)U32_minblksize* NoOfBlocks);
        if( ((tS32)u32ReadSize == OSAL_ERROR) || ( ((tU32)U32_minblksize* NoOfBlocks) != u32ReadSize) )
        {
          ETG_TRACE_ERR(("bReadMicADCMidValue(): =>ERROR: can't read mic adc device, readLen =%d", u32ReadSize));
          bRet = FALSE;
        }

        ETG_TRACE_USR4(("bReadMicADCValue(): => read ADC Len =%d", u32ReadSize));
  /*
        tPU16 pu16ADCdata2 = pu16ADCdata;
                tU32 u32ADCValueMid = 0;
        unsigned int i = 0;

        for(; (i < COUNT_MAX) && (i < u32ReadSize); i++)
        {
          u32ADCValueMid += (tU16)(*pu16ADCdata2)& 0x0fff;
          //ETG_TRACE_USR4(("bReadMicADCMidValue(): => read Mic ADCValue =%d", (tU16)(*pu16ADCdata2)& 0x0fff));
          pu16ADCdata2++;

        }
        *u32ADCValue = u32ADCValueMid / i; //This ADCValue is in ADC Steps (not in Volt or mVolt)
  */
                *u32ADCValue = (tU16)(*pu16ADCdata) & 0x03ff;
        ETG_TRACE_USR4(("bReadMicADCMidValue(): => Mic ADCValue 16 = %d ADC Steps", *u32ADCValue));

/*              //This is tha same as above but is perhaps better?
                tPU8 pu8Data = (tPU8)(pu16ADCdata);
                tU16 u16MicAdcValue = (tU16)(pu8Data[0]) | (tU16)(pu8Data[1] << 8);
                ETG_TRACE_USR4(("bReadMicADCMidValue(): => Mic ADCValue << 8 = %d ADC Steps", u16MicAdcValue));
*/
                OSAL_vMemoryFree(pu16ADCdata);
      }
      else
      {
        ETG_TRACE_ERR(("bReadMicADCMidValue(): => ERROR: can't Allocate Memory for ADCData"));
      }
    //} if
    OSAL_s32IOClose(adcDevice);
  }
  else
  {
    ETG_TRACE_ERR(("bReadMicADCMidValue(): =>ERROR: can't open mic adc device"));
    bRet = FALSE;
  }

  return bRet;
}
/*
tU32 u32ADCRead()
{
   OSAL_tIODescriptor hFd = 0;
   OSAL_tenAccess enAccess = OSAL_EN_READWRITE;
   tU32 u32Ret = 0;
   tU16 *tU16ADCdata = NULL ;
   tPS8 ps8ADCdata = NULL;
   tU32 NoOfBlocks  = 1;
   tU32 u32NoOfBlocks = 1;
   tU32 U32_minblksize =2;

   // Channel Open
   hFd = OSAL_IOOpen(Gen3_ADC_CHANNEL_43, enAccess);
   if(OSAL_ERROR != hFd)
   {
      tU16ADCdata = (tU16 *)OSAL_pvMemoryAllocate((tU32)U32_minblksize* NoOfBlocks);
      if (tU16ADCdata != NULL)
      {
         ps8ADCdata = (tPS8)(tVoid *)tU16ADCdata;
         u32NoOfBlocks = (tU32)OSAL_s32IORead(hFd,(tPS8)ps8ADCdata, (tU32)U32_minblksize* NoOfBlocks);

         if((OSAL_ERROR == (tS32)u32NoOfBlocks) ||( ((tU32)U32_minblksize* NoOfBlocks)  !=  u32NoOfBlocks))
         {
            u32Ret += 100;
         }
         // Get 12 bit ADC data
         else
         {
            tU16ADCdata = (tU16*)(tVoid*)ps8ADCdata;
         }
         // Channel Close
         if(OSAL_ERROR  == OSAL_s32IOClose ( hFd ) )
         {
            u32Ret += 1000;
         }
      }
      else
      {
         u32Ret += 10000;
      }
   }
   else
   {
      u32Ret = 1;
   }
   OSAL_vMemoryFree(tU16ADCdata);
   tU16ADCdata = NULL;
   ps8ADCdata = NULL;

   return u32Ret;
}
*/

/*******************************************************************************
** FUNCTION:   tVoid ReadADCRefVfromKDS();
* Read ADC Reference Voltage from KDS.
*
*******************************************************************************/

tU32 fc_streamrouter_DiagCommonADCRead::u32ReadADCRefVfromKDS(tVoid)
{

  tU32 u32MicADCrefV = MIC_ADC_REFVOL_DEFAULT; //Defaultvalue
  OSAL_tIODescriptor IOKdsHandle = OSAL_ERROR;

  //Open KDS
  IOKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS, OSAL_EN_READWRITE);

  if ( OSAL_ERROR == IOKdsHandle)
  {
    ETG_TRACE_ERR(("ReadADCRefVfromKDS(): =>ERROR: can't open KDS device"));
  }
    else
    {
        // Read Data from KDS
      tS32 s32ErrorValue = OSAL_ERROR;
      tU16 u16Entry = 0;

      tsKDSEntry sKDSEntryData;

      u16Entry  = M_KDS_ENTRY(KDS_TARGET_DEVICE, KDS_TYPE_ADC_REFERENCE_VOL);

        sKDSEntryData.u16Entry = u16Entry;
        sKDSEntryData.u16EntryLength = KDS_ADC_REF_LEN;
        sKDSEntryData.u16EntryFlags = M_KDS_ENTRY_FLAG_NONE;
      sKDSEntryData.au8EntryData[0] = 0;

      if (OSAL_ERROR != (s32ErrorValue = OSAL_s32IORead(IOKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)))))
      {

          tU8 u8data[KDS_ADC_REF_LEN] = {0, 0, 0, 0};
          for (tU16 n=0; (n<KDS_ADC_REF_LEN); n++)
          {
        u8data[n] = sKDSEntryData.au8EntryData[n];
                //ETG_TRACE_COMP_THR(( "ReadADCRefVfromKDS(): ADC Reference voltage from KDS u8data[n] x = %x", u8data[n]));
            }

      tU32 u32Data = (u8data[0] << 24) + (u8data[1] << 16) + (u8data[2] << 8) + (u8data[3]);
            u32MicADCrefV = u32Data; //the ADC Refvalue is in MilliVolt

/*
      The sourcecode if the ADC Ref Voltage is in Volt (a float e.g. 3.3)

          for (tU16 n=0; (n<KDS_ADC_REF_LEN); n++)
          {
                u8data[n] = sKDSEntryData.au8EntryData[KDS_ADC_REF_LEN-(n+1)];
                ETG_TRACE_COMP_THR(( "ReadADCRefVfromKDS(): ADC Reference voltage from KDS u8data[n] x = %x", u8data[n]));
            }
            tFloat* pf = (tFloat*)(u8data);
            fMicADCrefV = (*pf);
*/
      }
      else
      {
         s32ErrorValue = (tS32) OSAL_u32ErrorCode();
           ETG_TRACE_ERR(("ReadADCRefVfromKDS() ERROR: KDS Read ADC Reference value FAILED %d", s32ErrorValue));
      }

       //Close KDS
       OSAL_s32IOClose(IOKdsHandle);
    }

  if (u32MicADCrefV == 0) //TODO Auch maximale Grenze hier setzen
  {
    u32MicADCrefV = MIC_ADC_REFVOL_DEFAULT; //Defaultvalue
  }

    ETG_TRACE_COMP_THR(( "ReadADCRefVfromKDS(): ADC Reference voltage from KDS = %d mV", u32MicADCrefV));
    return u32MicADCrefV;
}
#endif

