/******************************************************************************
 * FILE        : ecnr-qwa-handler.c
 * PROJECT     : Gen3
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2013 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 19.08.2013  | Patrick Rey            | initial version
 * 04.03.2014  | Patrick Rey            | QWA engine feature handling
 *****************************************************************************/

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_GMG3_LINUX

#include <glib.h>
#include "bpcl.h"


#include "qwa.h"
#include "qwa_defs.h"
#include "qwa_err.h"
#include "qwa_rcs.h"
#include "qwa_rcs_err.h"


#include "ecnr-error.h"
#include "ecnr-common-defs.h"
#include "ecnr-object.h"
#include "ecnr-service.h"
#include "ecnr-alsa.h"
#include "ecnr-engine-handler.h"
#include "ecnr-qwa-handler.h"
#include "ecnr-qwa-rcs-handler.h"
#include "ecnr-diag-eol-access.h"
#include "ecnr-configuration.h"

#define ECNR_S_IMPORT_INTERFACE_DP
#include "ecnr-datapool-default.h"
#include "ecnr-configuration-data.h"
#include <EOLLib.h>

/*******************************************************************************
              VERSION COMPILER
*******************************************************************************/

/*******************************************************************************
              DEFINES
*******************************************************************************/
#define QWA_STANDARD_SERVER_DATA             163
#define QWA_CAR_SPECIFIC                     72
#define QWA_ON                               2
//#define QWA_OFF 1
#define NARROW_BAND_SPEECH                   1
#define WIDE_BAND_SPEECH                     2
#define QWA_RECVAGCAMP_TGTS_CNT              2
#define QWA_RECVAGC_MAXRATE_CNT              2
#define QWA_SENDAGCAMP_TGTS_CNT              2
#define QWA_SENDAGC_MAXRATE_CNT              2
#define QWA_NC_PARAMS_CNT                    5
#define QWA_RECVAGC_GAINVAL_CNT              3
#define QWA_RECVPARAM_EQNODES_CNT            15
#define QWA_SENDAGC_GAINVALS_CNT             3
#define QWA_SEND_DYNEQ_MINMAXSNR_CNT         2
#define QWA_SEND_PARAMEQNODES2_CNT           15
#define QWA_SEND_EQNODES_CNT                 15
#define ECNR_QWA_PARAM_INVALID              (gint)0
#define ECNR_QWA_PARAM_CHANNEL_INVALID      (gint)0
#define ECNR_QWA_ARRAY_START_OFFSET_INVALID (gint)0
#define EOL_TYPE_INVALID                    (enum param_eol_type)0
#define ECNR_QWA_PARAM_LENGTH_INVALID       (gint)0
#define PARAM_TYPE_INVALID                  (enum param_init_type)0
#define ECNR_QWA_POINTER_INVALID            (void*)0
#define  ECNR_NUMBER_CONFIG_MAX              5

/*******************************************************************************
              Constant defintion
*******************************************************************************/
//#define D_EOL_DBG
#define D_SET_FRAME_SHIFT_8_MS_FOR_TEST

#define RAISE_ERR(err,param)  if(err) \
                                goto error_out;


#define error_out CATCH_ERR


#define RAISE_ERR_0(err,param)  if(err) \
                                    return err;
/*******************************************************************************
              STRUCTURE DEFINITION
*******************************************************************************/

struct ecnr_qwa_dev_desc
{
    enum ecnr_audio dev_ch;
    unsigned char*  adev_name;
};


struct ecnr_qwa_cfg
{
    tQwaCfg         ecnr_qwa_cfg_file;
    unsigned short  ecnr_config_id;

    /* new */
    int ecnr_dev_desc_size;
    struct ecnr_qwa_dev_desc* devdesc;

};


struct ecnr_qwa_param_set
{
    int setqwaRecvInCnt;
    int setqwaNRSwitch;
    int setqwaAECSwitch;
    int setqwaRECSwitch;
    int setqwaHFESwitch;
    int setqwaAGCSwitch;
    int setqwaDiagSwitch;
    int setqwaSampleRateIn;
    int setqwaMaxFreqProc;
    int setqwaFrameShiftIn;
    int setqwaMicInCnt;
    int setqwaLFRSwitch;
    int setqwaRecvAGCSwitch;
    int setqwaRecvBWESwitch;
    int setqwaRecvDLCSwitch;
    int setqwaRecvENSSwitch;
    int setqwaRecvEQSwitch;
    int setqwaSendDynEQSwitch;
    int setqwaSendEQSwitch;
    int setqwaWNDBSwitch;
    int setqwaAECFiltLen;
};


/*******************************************************************************
              VARIABLE DECLARATIONS
*******************************************************************************/

static tQwa            qwa_handler = NULL;              /* pointer to QWA main data struct    */
static gboolean        qwa_init = FALSE;
static unsigned short  m_CurrConfigId = 0;
//static tQwaRcs         qwa_rcs_handler;
static enum param_init_type ecnr_qwa_handler_eol_select_type = ECNR_PARAM_PRE_INIT;

static struct ecnr_qwa_cfg *qwa_cfg;
//static tQwaCfg         qwa_cfg;


/*******************************************************************************
              STATIC FUNCTION  DECLARATIONS
*******************************************************************************/


/*****************************************************************************/
/*   Device Configuration Table for Handfree Phone                           */
/*****************************************************************************/


static struct ecnr_qwa_parameter ecnr_phftr_cs_coef_pre_init_param_set[] = {
    {"qwaAECSwitch"         ,qwaAECSwitch             ,ECNR_TYPE_SELECT           ,0                             ,0                                ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaAGCSwitch"         ,qwaAGCSwitch             ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF2 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaDiagSwitch"        ,qwaDiagSwitch            ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF3 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
//    {"qwaHFESwitch"         ,qwaHFESwitch             ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF4 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNRSwitch"          ,qwaNRSwitch              ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF5 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaOpMode"            ,qwaOpMode                ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF6 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
//    {"qwaRECSwitch"         ,qwaRECSwitch             ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF7 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvAGCSwitch"     ,qwaRecvAGCSwitch         ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF8 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWESwitch"     ,qwaRecvBWESwitch         ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF9 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvDLCSwitch"     ,qwaRecvDLCSwitch         ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF10 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSSwitch"     ,qwaRecvENSSwitch         ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF11 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvEQSwitch"      ,qwaRecvEQSwitch          ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF12 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendDynEQSwitch"   ,qwaSendDynEQSwitch       ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF13 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendEQSwitch"      ,qwaSendEQSwitch          ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF14 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaWNDBMode"          ,qwaWNDBMode              ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF15 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaWNDBSwitch"        ,qwaWNDBSwitch            ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF16 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaAECFiltLen"        ,qwaAECFiltLen            ,ECNR_TYPE_U16              ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF17 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
#ifndef D_SET_FRAME_SHIFT_8_MS_FOR_TEST
    {"qwaFrameShiftIn"      ,qwaFrameShiftIn          ,ECNR_TYPE_U16              ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF18 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U16,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
#endif
    {"qwaRecvInCnt"         ,qwaRecvInCnt             ,ECNR_TYPE_U16              ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF26 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaLFRSwitch"         ,qwaLFRSwitch             ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF37 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID                           ,EOL_TYPE_INVALID ,ECNR_QWA_PARAM_LENGTH_INVALID,PARAM_TYPE_INVALID      ,ECNR_QWA_POINTER_INVALID}
};



/*new*/
static struct ecnr_qwa_parameter ecnr_hf_nb_pre_init_param_set[] = {
    {"qwaHFESwitch"         ,qwaHFESwitch             ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF4 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRECSwitch"         ,qwaRECSwitch             ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF7 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};
/*new*/


/*new*/
static const gint ecnr_qwa_set_call_hfe_switch_value = 0; //1; ticket GMMY17-15068
static struct ecnr_qwa_parameter ecnr_hf_wb_pre_init_param_set[] = {
    {"qwaHFESwitch"         ,qwaHFESwitch             ,ECNR_TYPE_SELECT,0,0                                                             ,ECNR_EOL_TYPE_UNDEF,1 ,ECNR_PARAM_SET_CONST_VALUE,(void*)&ecnr_qwa_set_call_hfe_switch_value},
    {"qwaRECSwitch"         ,qwaRECSwitch             ,ECNR_TYPE_SELECT,0,(EOLLIB_OFFSET_PHFTR_CS_COEF7 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8   ,1 ,ECNR_PARAM_SET_EOL_VALUE  ,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};
/*new*/

/*new*/
static const gint ecnr_qwa_set_voice_nb_rce_switch_value = 0; // 1;  ticket GMMY17-15235
static struct ecnr_qwa_parameter ecnr_voice_nb_pre_init_param_set[] = {
    {"qwaHFESwitch"         ,qwaHFESwitch             ,ECNR_TYPE_SELECT,0,(EOLLIB_OFFSET_PHFTR_CS_COEF4 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8   ,1 ,ECNR_PARAM_SET_EOL_VALUE   ,0},
    {"qwaRECSwitch"         ,qwaRECSwitch             ,ECNR_TYPE_SELECT,0,0                                                             ,ECNR_EOL_TYPE_UNDEF,1 ,ECNR_PARAM_SET_CONST_VALUE,(void*)&ecnr_qwa_set_voice_nb_rce_switch_value},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};
/*new*/


/*new*/
static const gint ecnr_qwa_set_voice_hfe_switch_value = 0; //1; ticket GMMY17-15068
static const gint ecnr_qwa_set_voice_wb_rce_switch_value = 0; // 1;  ticket GMMY17-15235
static struct ecnr_qwa_parameter ecnr_voice_wb_pre_init_param_set[] = {
    {"qwaHFESwitch"         ,qwaHFESwitch             ,ECNR_TYPE_SELECT,0,0                                                             ,ECNR_EOL_TYPE_UNDEF ,1 ,ECNR_PARAM_SET_CONST_VALUE,(void*)&ecnr_qwa_set_voice_hfe_switch_value },
    {"qwaRECSwitch"         ,qwaRECSwitch             ,ECNR_TYPE_SELECT,0,0                                                             ,ECNR_EOL_TYPE_UNDEF ,1 ,ECNR_PARAM_SET_CONST_VALUE,(void*)&ecnr_qwa_set_voice_wb_rce_switch_value},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};
/*new*/

static const guint16 ecnr_qwa_set_max_freq_proc_nb_value = 4000;
static struct ecnr_qwa_parameter ecnr_phftr_cs_coef_sr_nb_pre_init_param_set[] = {
    {"qwaRecvSampleRateIn"    ,qwaRecvSampleRateIn      ,ECNR_TYPE_U16,0,(EOLLIB_OFFSET_PHFTR_CS_COEF28 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_EOL_VALUE   ,0},
    {"qwaRefSampleRateIn"     ,qwaRefSampleRateIn       ,ECNR_TYPE_U16,0,(EOLLIB_OFFSET_PHFTR_CS_COEF30 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_EOL_VALUE   ,0},
    {"qwaMaxFreqProc"         ,qwaMaxFreqProc           ,ECNR_TYPE_U16,0,0                                                             ,ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_CONST_VALUE,(void*)&ecnr_qwa_set_max_freq_proc_nb_value },
    {"qwaRefMaxDelay"         ,qwaRefMaxDelay           ,ECNR_TYPE_I32,0,(EOLLIB_OFFSET_PHFTR_CS_COEF29 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_EOL_VALUE   ,0},
    {"qwaSampleRateIn"        ,qwaSampleRateIn          ,ECNR_TYPE_U16,0,(EOLLIB_OFFSET_PHFTR_CS_COEF31 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_EOL_VALUE   ,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};

static const guint16 ecnr_qwa_set_recv_sr_in_wb_value    = 16000;
static const guint16 ecnr_qwa_set_ref_sr_in_wb_value     = 16000;
static const guint16 ecnr_qwa_set_max_freq_proc_wb_value = 8000;
static struct ecnr_qwa_parameter ecnr_phftr_cs_coef_sr_wb_pre_init_param_set[] = {
    {"qwaRecvSampleRateIn"    ,qwaRecvSampleRateIn      ,ECNR_TYPE_U16,0,0                                                             ,ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_CONST_VALUE,(void*)&ecnr_qwa_set_recv_sr_in_wb_value    },
    {"qwaRefSampleRateIn"     ,qwaRefSampleRateIn       ,ECNR_TYPE_U16,0,0                                                             ,ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_CONST_VALUE,(void*)&ecnr_qwa_set_ref_sr_in_wb_value     },
    {"qwaMaxFreqProc"         ,qwaMaxFreqProc           ,ECNR_TYPE_U16,0,0                                                             ,ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_CONST_VALUE,(void*)&ecnr_qwa_set_max_freq_proc_wb_value },
    {"qwaRefMaxDelay"         ,qwaRefMaxDelay           ,ECNR_TYPE_I32,0,(EOLLIB_OFFSET_PHFTR_CS_COEF29 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_EOL_VALUE  ,0                                           },
    {"qwaSampleRateIn"        ,qwaSampleRateIn          ,ECNR_TYPE_U16,0,(EOLLIB_OFFSET_PHFTR_CS_COEF31 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U16,1 ,ECNR_PARAM_SET_EOL_VALUE  ,0                                           },
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};

static struct ecnr_qwa_parameter ecnr_phftr_cs_coef_post_init_param_set[] = {
    {"qwaRecvAGCAmpTgts"        ,qwaRecvAGCAmpTgts      ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_CS_COEF22 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_I16,QWA_RECVAGCAMP_TGTS_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvAGCMaxRates"       ,qwaRecvAGCMaxRates     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_CS_COEF24 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_I16,QWA_RECVAGC_MAXRATE_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvLimitThresh"       ,qwaRecvLimitThresh     ,ECNR_TYPE_U16          ,0 ,(EOLLIB_OFFSET_PHFTR_CS_COEF27 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U16,1                      ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendAGCAmpTgts"        ,qwaSendAGCAmpTgts      ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_CS_COEF32 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_I16,QWA_SENDAGCAMP_TGTS_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendAGCMaxRates"       ,qwaSendAGCMaxRates     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_CS_COEF34 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_I16,QWA_SENDAGC_MAXRATE_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendLimitThresh"       ,qwaSendLimitThresh     ,ECNR_TYPE_U16          ,0 ,(EOLLIB_OFFSET_PHFTR_CS_COEF36 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U16,1                      ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};

static struct ecnr_qwa_parameter ecnr_phftr_pp1_coef_post_init_param_set[] = {
    {"qwaHFEExtent"             ,qwaHFEExtent           ,ECNR_TYPE_I16          ,0 ,0                                ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNCParams"              ,qwaNCParams            ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF2 - EOLLIB_OFFSET_PHFTR_PP1_COEF1) ,ECNR_EOL_TYPE_I16,QWA_NC_PARAMS_CNT           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNRAtten"               ,qwaNRAtten             ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF7 - EOLLIB_OFFSET_PHFTR_PP1_COEF1) ,ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRECSuppress"           ,qwaRECSuppress         ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF8 - EOLLIB_OFFSET_PHFTR_PP1_COEF1) ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvAGCGainVals"       ,qwaRecvAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF9 - EOLLIB_OFFSET_PHFTR_PP1_COEF1) ,ECNR_EOL_TYPE_I16,QWA_RECVAGC_GAINVAL_CNT     ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEBrightness"     ,qwaRecvBWEBrightness   ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF12 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEWarmth"         ,qwaRecvBWEWarmth       ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF13 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSActivityRatio"  ,qwaRecvENSActivityRatio,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF14 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSSuppress"       ,qwaRecvENSSuppress     ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF15 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvGain"              ,qwaRecvGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF16 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvParamEQNodes"      ,qwaRecvParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF17 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_I16,QWA_RECVPARAM_EQNODES_CNT   ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRefDelay"              ,qwaRefDelay            ,ECNR_TYPE_I32          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF32 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendAGCGainVals"       ,qwaSendAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF33 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_I16,QWA_SENDAGC_GAINVALS_CNT    ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendDynEQMinMaxSNR"    ,qwaSendDynEQMinMaxSNR  ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF36 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_DYNEQ_MINMAXSNR_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendGain"              ,qwaSendGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF38 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQ2Nodes"     ,qwaSendParamEQ2Nodes   ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF39 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_PARAMEQNODES2_CNT  ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQNodes"      ,qwaSendParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF54 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_EQNODES_CNT        ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaWNDBSuppress"          ,qwaWNDBSuppress        ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF69 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaLFINRMaxFreq"          ,qwaLFINRMaxFreq        ,ECNR_TYPE_U16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP1_COEF70 - EOLLIB_OFFSET_PHFTR_PP1_COEF1),ECNR_EOL_TYPE_U16 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};

static struct ecnr_qwa_parameter ecnr_phftr_pp2_coef_post_init_param_set[] = {
    {"qwaHFEExtent"             ,qwaHFEExtent           ,ECNR_TYPE_I16          ,0 ,0                                ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNCParams"              ,qwaNCParams            ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF2 - EOLLIB_OFFSET_PHFTR_PP2_COEF1) ,ECNR_EOL_TYPE_I16,QWA_NC_PARAMS_CNT           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNRAtten"               ,qwaNRAtten             ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF7 - EOLLIB_OFFSET_PHFTR_PP2_COEF1) ,ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRECSuppress"           ,qwaRECSuppress         ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF8 - EOLLIB_OFFSET_PHFTR_PP2_COEF1) ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvAGCGainVals"       ,qwaRecvAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF9 - EOLLIB_OFFSET_PHFTR_PP2_COEF1) ,ECNR_EOL_TYPE_I16,QWA_RECVAGC_GAINVAL_CNT     ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEBrightness"     ,qwaRecvBWEBrightness   ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF12 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEWarmth"         ,qwaRecvBWEWarmth       ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF13 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSActivityRatio"  ,qwaRecvENSActivityRatio,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF14 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSSuppress"       ,qwaRecvENSSuppress     ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF15 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvGain"              ,qwaRecvGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF16 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_I16,2                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvParamEQNodes"      ,qwaRecvParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF17 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_I16,QWA_RECVPARAM_EQNODES_CNT   ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRefDelay"              ,qwaRefDelay            ,ECNR_TYPE_I32          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF32 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendAGCGainVals"       ,qwaSendAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF33 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_I16,QWA_SENDAGC_GAINVALS_CNT    ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendDynEQMinMaxSNR"    ,qwaSendDynEQMinMaxSNR  ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF36 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_DYNEQ_MINMAXSNR_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendGain"              ,qwaSendGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF38 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQ2Nodes"     ,qwaSendParamEQ2Nodes   ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF39 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_PARAMEQNODES2_CNT  ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQNodes"      ,qwaSendParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF54 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_EQNODES_CNT        ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaWNDBSuppress"          ,qwaWNDBSuppress        ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF69 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaLFINRMaxFreq"          ,qwaLFINRMaxFreq        ,ECNR_TYPE_U16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP2_COEF70 - EOLLIB_OFFSET_PHFTR_PP2_COEF1),ECNR_EOL_TYPE_U16 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};

static struct ecnr_qwa_parameter ecnr_phftr_voice_server1_coef_post_init_param_set[] = {
    {"qwaHFEExtent"             ,qwaHFEExtent           ,ECNR_TYPE_I16          ,0 ,0                                          ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNCParams"              ,qwaNCParams            ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF2 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1) ,ECNR_EOL_TYPE_I16,QWA_NC_PARAMS_CNT           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNRAtten"               ,qwaNRAtten             ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF7 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1) ,ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRECSuppress"           ,qwaRECSuppress         ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF8 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1) ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvAGCGainVals"       ,qwaRecvAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF9 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1) ,ECNR_EOL_TYPE_I16,QWA_RECVAGC_GAINVAL_CNT     ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEBrightness"     ,qwaRecvBWEBrightness   ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF12 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEWarmth"         ,qwaRecvBWEWarmth       ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF13 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSActivityRatio"  ,qwaRecvENSActivityRatio,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF14 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSSuppress"       ,qwaRecvENSSuppress     ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF15 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvGain"              ,qwaRecvGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF16 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvParamEQNodes"      ,qwaRecvParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF17 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_I16,QWA_RECVPARAM_EQNODES_CNT   ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRefDelay"              ,qwaRefDelay            ,ECNR_TYPE_I32          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF32 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendAGCGainVals"       ,qwaSendAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF33 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_I16,QWA_SENDAGC_GAINVALS_CNT    ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendDynEQMinMaxSNR"    ,qwaSendDynEQMinMaxSNR  ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF36 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_DYNEQ_MINMAXSNR_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendGain"              ,qwaSendGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF38 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQ2Nodes"     ,qwaSendParamEQ2Nodes   ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF39 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_PARAMEQNODES2_CNT  ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQNodes"      ,qwaSendParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF54 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_EQNODES_CNT        ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaWNDBSuppress"          ,qwaWNDBSuppress        ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF69 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaLFINRMaxFreq"          ,qwaLFINRMaxFreq        ,ECNR_TYPE_U16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF70 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1),ECNR_EOL_TYPE_U16 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};

static struct ecnr_qwa_parameter ecnr_phftr_voice_server2_coef_post_init_param_set[] = {
    {"qwaHFEExtent"             ,qwaHFEExtent           ,ECNR_TYPE_I16          ,0 ,0                                          ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNCParams"              ,qwaNCParams            ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF2 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1) ,ECNR_EOL_TYPE_I16,QWA_NC_PARAMS_CNT           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNRAtten"               ,qwaNRAtten             ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF7 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1) ,ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRECSuppress"           ,qwaRECSuppress         ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF8 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1) ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvAGCGainVals"       ,qwaRecvAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF9 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1) ,ECNR_EOL_TYPE_I16,QWA_RECVAGC_GAINVAL_CNT     ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEBrightness"     ,qwaRecvBWEBrightness   ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF12 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEWarmth"         ,qwaRecvBWEWarmth       ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF13 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSActivityRatio"  ,qwaRecvENSActivityRatio,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF14 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSSuppress"       ,qwaRecvENSSuppress     ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF15 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvGain"              ,qwaRecvGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF16 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvParamEQNodes"      ,qwaRecvParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF17 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_I16,QWA_RECVPARAM_EQNODES_CNT   ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRefDelay"              ,qwaRefDelay            ,ECNR_TYPE_I32          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF32 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendAGCGainVals"       ,qwaSendAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF33 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_I16,QWA_SENDAGC_GAINVALS_CNT    ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendDynEQMinMaxSNR"    ,qwaSendDynEQMinMaxSNR  ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF36 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_DYNEQ_MINMAXSNR_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendGain"              ,qwaSendGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF38 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQ2Nodes"     ,qwaSendParamEQ2Nodes   ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF39 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_PARAMEQNODES2_CNT  ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQNodes"      ,qwaSendParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF54 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_EQNODES_CNT        ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaWNDBSuppress"          ,qwaWNDBSuppress        ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF69 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaLFINRMaxFreq"          ,qwaLFINRMaxFreq        ,ECNR_TYPE_U16          ,0 ,(EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF70 - EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1),ECNR_EOL_TYPE_U16 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};



static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_call_nb =
{
    .dataset_pre_nb  = 2,
    .dataset_post_nb = 2,
  .pre_init_desc =
  {
      [PRE_INIT_DATASET_IND_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_pre_init_param_set"
      },
      /*new*/
      [PRE_INIT_DATASET_IND_CALL_NB_SPEC] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_hf_nb_pre_init_param_set,
          .descriptor_name = "ecnr_hf_nb_pre_init_param_set"
      }
  },
/*new*/
  .post_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_post_init_param_set"
      },
      /*    PHFTR_PP1_Coef1-80 should reflect the narrow bands HF tuning CAls.*/
      [POST_INIT_DATASET_IND_PP1_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_PP1_COEF1,
          .buf_length      = QWA_STANDARD_SERVER_DATA,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_pp1_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_pp1_coef_post_init_param_set"
      }
  }
};


/* PHFTR_PP2_Coef1-80 should reflect the WB HF Tuning CALs.*/
static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_call_wb =
{
    .dataset_pre_nb  = 2, /*new*/
    .dataset_post_nb = 2,
  .pre_init_desc =
  {
      [PRE_INIT_DATASET_IND_CALL_WB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_pre_init_param_set"
      },
      /*new*/
      [PRE_INIT_DATASET_IND_CALL_WB_SPEC] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_hf_wb_pre_init_param_set,
          .descriptor_name = "ecnr_hf_wb_pre_init_param_set"
      }
  },
/*new*/
  .post_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_post_init_param_set"
      },
      /* PHFTR_PP2_Coef1-80 should reflect the WB HF Tuning CALs.*/
      [POST_INIT_DATASET_IND_PP2_CALL_WB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_PP2_COEF1,
          .buf_length      = QWA_STANDARD_SERVER_DATA,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_pp2_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_pp2_coef_post_init_param_set"
      }
  }
};

static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_server_nb =
{
    .dataset_pre_nb  = 2,
    .dataset_post_nb = 2,
  .pre_init_desc =
  {
      [PRE_INIT_DATASET_IND_VOICE_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_pre_init_param_set"
      },
      /*new*/
      [PRE_INIT_DATASET_IND_VOICE_NB_SPEC] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_voice_nb_pre_init_param_set,
          .descriptor_name = "ecnr_voice_nb_pre_init_param_set"
      }
  },
/*new*/
  .post_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_post_init_param_set"
      },
      [POST_INIT_DATASET_IND_SERV1_VOICE_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_VOICE_SERVER1_COEF1,
          .buf_length      = QWA_STANDARD_SERVER_DATA,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_voice_server1_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_voice_server1_coef_post_init_param_set"
      }
  }
};

static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_server_wb =
{
    .dataset_pre_nb  = 2,
    .dataset_post_nb = 2,
  .pre_init_desc =
  {
      [PRE_INIT_DATASET_IND_VOICE_WB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_pre_init_param_set"
      },
      /*new*/
      [PRE_INIT_DATASET_IND_VOICE_WB_SPEC] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_voice_wb_pre_init_param_set,
          .descriptor_name = "ecnr_voice_wb_pre_init_param_set"
      }
  },
/*new*/
  .post_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_post_init_param_set"
      },
      [POST_INIT_DATASET_IND_SERV2_VOICE_WB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_VOICE_SERVER2_COEF1,
          .buf_length      = QWA_STANDARD_SERVER_DATA,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_voice_server2_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_voice_server2_coef_post_init_param_set"
      }
  }
};

/*****************************************************************************/
/*   Device Configuration Table for CarPlay                                  */
/*****************************************************************************/

/*
    PHFTR_PP1_Coef1-80 should reflect the narrow bands HF tuning CAls.
    PHFTR_PP2_Coef1-80 should reflect the WB HF Tuning CALs.
    PHFTR_PP3_Coef1-80 should reflect the USB HF tuning CALs. ??
    PHFTR_PP4_Coef1-80 Should reflect the Facetime Tuning Cals ??
*/

/* new - spi - PP3 */
static struct ecnr_qwa_parameter ecnr_phftr_pp3_coef_post_init_param_set[] = {
    {"qwaHFEExtent"             ,qwaHFEExtent           ,ECNR_TYPE_I16          ,0 ,0                                ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNCParams"              ,qwaNCParams            ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF2 - EOLLIB_OFFSET_PHFTR_PP3_COEF1) ,ECNR_EOL_TYPE_I16,QWA_NC_PARAMS_CNT           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNRAtten"               ,qwaNRAtten             ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF7 - EOLLIB_OFFSET_PHFTR_PP3_COEF1) ,ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRECSuppress"           ,qwaRECSuppress         ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF8 - EOLLIB_OFFSET_PHFTR_PP3_COEF1) ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvAGCGainVals"       ,qwaRecvAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF9 - EOLLIB_OFFSET_PHFTR_PP3_COEF1) ,ECNR_EOL_TYPE_I16,QWA_RECVAGC_GAINVAL_CNT     ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEBrightness"     ,qwaRecvBWEBrightness   ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF12 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEWarmth"         ,qwaRecvBWEWarmth       ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF13 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSActivityRatio"  ,qwaRecvENSActivityRatio,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF14 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSSuppress"       ,qwaRecvENSSuppress     ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF15 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvGain"              ,qwaRecvGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF16 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_I16,2                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvParamEQNodes"      ,qwaRecvParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF17 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_I16,QWA_RECVPARAM_EQNODES_CNT   ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRefDelay"              ,qwaRefDelay            ,ECNR_TYPE_I32          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF32 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendAGCGainVals"       ,qwaSendAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF33 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_I16,QWA_SENDAGC_GAINVALS_CNT    ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendDynEQMinMaxSNR"    ,qwaSendDynEQMinMaxSNR  ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF36 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_DYNEQ_MINMAXSNR_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendGain"              ,qwaSendGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF38 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQ2Nodes"     ,qwaSendParamEQ2Nodes   ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF39 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_PARAMEQNODES2_CNT  ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQNodes"      ,qwaSendParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF54 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_EQNODES_CNT        ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaWNDBSuppress"          ,qwaWNDBSuppress        ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF69 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaLFINRMaxFreq"          ,qwaLFINRMaxFreq        ,ECNR_TYPE_U16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP3_COEF70 - EOLLIB_OFFSET_PHFTR_PP3_COEF1),ECNR_EOL_TYPE_U16 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};


/* new - spi - PP4*/
static struct ecnr_qwa_parameter ecnr_phftr_pp4_coef_post_init_param_set[] = {
    {"qwaHFEExtent"             ,qwaHFEExtent           ,ECNR_TYPE_I16          ,0 ,0                                ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNCParams"              ,qwaNCParams            ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF2 - EOLLIB_OFFSET_PHFTR_PP4_COEF1) ,ECNR_EOL_TYPE_I16,QWA_NC_PARAMS_CNT           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNRAtten"               ,qwaNRAtten             ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF7 - EOLLIB_OFFSET_PHFTR_PP4_COEF1) ,ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRECSuppress"           ,qwaRECSuppress         ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF8 - EOLLIB_OFFSET_PHFTR_PP4_COEF1) ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvAGCGainVals"       ,qwaRecvAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF9 - EOLLIB_OFFSET_PHFTR_PP4_COEF1) ,ECNR_EOL_TYPE_I16,QWA_RECVAGC_GAINVAL_CNT     ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEBrightness"     ,qwaRecvBWEBrightness   ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF12 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEWarmth"         ,qwaRecvBWEWarmth       ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF13 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSActivityRatio"  ,qwaRecvENSActivityRatio,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF14 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSSuppress"       ,qwaRecvENSSuppress     ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF15 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvGain"              ,qwaRecvGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF16 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_I16,2                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvParamEQNodes"      ,qwaRecvParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF17 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_I16,QWA_RECVPARAM_EQNODES_CNT   ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRefDelay"              ,qwaRefDelay            ,ECNR_TYPE_I32          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF32 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendAGCGainVals"       ,qwaSendAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF33 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_I16,QWA_SENDAGC_GAINVALS_CNT    ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendDynEQMinMaxSNR"    ,qwaSendDynEQMinMaxSNR  ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF36 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_DYNEQ_MINMAXSNR_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendGain"              ,qwaSendGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF38 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQ2Nodes"     ,qwaSendParamEQ2Nodes   ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF39 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_PARAMEQNODES2_CNT  ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQNodes"      ,qwaSendParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF54 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_EQNODES_CNT        ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaWNDBSuppress"          ,qwaWNDBSuppress        ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF69 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaLFINRMaxFreq"          ,qwaLFINRMaxFreq        ,ECNR_TYPE_U16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP4_COEF70 - EOLLIB_OFFSET_PHFTR_PP4_COEF1),ECNR_EOL_TYPE_U16 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};

/* new - spi - pp6 - 20.01.2015 for caplay telephone nb */
static struct ecnr_qwa_parameter ecnr_phftr_pp6_coef_post_init_param_set[] = {
    {"qwaHFEExtent"             ,qwaHFEExtent           ,ECNR_TYPE_I16          ,0 ,0                                ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNCParams"              ,qwaNCParams            ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF2 - EOLLIB_OFFSET_PHFTR_PP6_COEF1) ,ECNR_EOL_TYPE_I16,QWA_NC_PARAMS_CNT           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaNRAtten"               ,qwaNRAtten             ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF7 - EOLLIB_OFFSET_PHFTR_PP6_COEF1) ,ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRECSuppress"           ,qwaRECSuppress         ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF8 - EOLLIB_OFFSET_PHFTR_PP6_COEF1) ,ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvAGCGainVals"       ,qwaRecvAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF9 - EOLLIB_OFFSET_PHFTR_PP6_COEF1) ,ECNR_EOL_TYPE_I16,QWA_RECVAGC_GAINVAL_CNT     ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEBrightness"     ,qwaRecvBWEBrightness   ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF12 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvBWEWarmth"         ,qwaRecvBWEWarmth       ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF13 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSActivityRatio"  ,qwaRecvENSActivityRatio,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF14 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvENSSuppress"       ,qwaRecvENSSuppress     ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF15 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvGain"              ,qwaRecvGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF16 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_I16,2                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRecvParamEQNodes"      ,qwaRecvParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF17 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_I16,QWA_RECVPARAM_EQNODES_CNT   ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRefDelay"              ,qwaRefDelay            ,ECNR_TYPE_I32          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF32 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendAGCGainVals"       ,qwaSendAGCGainVals     ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF33 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_I16,QWA_SENDAGC_GAINVALS_CNT    ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendDynEQMinMaxSNR"    ,qwaSendDynEQMinMaxSNR  ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF36 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_DYNEQ_MINMAXSNR_CNT,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendGain"              ,qwaSendGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF38 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQ2Nodes"     ,qwaSendParamEQ2Nodes   ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF39 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_PARAMEQNODES2_CNT  ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaSendParamEQNodes"      ,qwaSendParamEQNodes    ,ECNR_TYPE_ARRAY_I16    ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF54 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_I16,QWA_SEND_EQNODES_CNT        ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaWNDBSuppress"          ,qwaWNDBSuppress        ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF69 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_U8 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaLFINRMaxFreq"          ,qwaLFINRMaxFreq        ,ECNR_TYPE_U16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP6_COEF70 - EOLLIB_OFFSET_PHFTR_PP6_COEF1),ECNR_EOL_TYPE_U16 ,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};


/*PHFTR_PP3_Coef1-80 should reflect the USB HF tuning CALs.*/
static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_cp_call_nb =
{
    .dataset_pre_nb  = 2,
    .dataset_post_nb = 2,
  .pre_init_desc =
  {
      [PRE_INIT_DATASET_IND_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_pre_init_param_set"
      },
      /*new*/
      [PRE_INIT_DATASET_IND_CALL_NB_SPEC] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_hf_nb_pre_init_param_set,
          .descriptor_name = "ecnr_hf_nb_pre_init_param_set"
      }
  },
/*new*/
  .post_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_post_init_param_set"
      },
      /*PHFTR_PP3_Coef1-80 should reflect the USB HF tuning CALs.
      P:Rey, 21012015: change bank PP3 t0 PP6
       */
      [POST_INIT_DATASET_IND_PP6_CALL_UF] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_PP6_COEF1,   /* 23012015, PR: here the offset was change tp PP6 bank too */
          .buf_length      = QWA_STANDARD_SERVER_DATA,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_pp6_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_pp6_coef_post_init_param_set"
      }
  }
};


static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_cp_call_wb =
{
    .dataset_pre_nb  = 2,
    .dataset_post_nb = 2,
  .pre_init_desc =
  {
      [PRE_INIT_DATASET_IND_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_pre_init_param_set"
      },
      /*new*/
      [PRE_INIT_DATASET_IND_CALL_WB_SPEC] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_hf_wb_pre_init_param_set,
          .descriptor_name = "ecnr_hf_wb_pre_init_param_set"
      }
  },
  /*new*/
  .post_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_post_init_param_set"
      },
      /*PHFTR_PP3_Coef1-80 should reflect the USB HF tuning CALs.*/
      [POST_INIT_DATASET_IND_PP3_CALL_UF] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_PP3_COEF1,
          .buf_length      = QWA_STANDARD_SERVER_DATA,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_pp3_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_pp3_coef_post_init_param_set"
      }
  }
};


static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_cp_voice_nb =
{
    .dataset_pre_nb  = 2,
    .dataset_post_nb = 2,
  .pre_init_desc =
  {
      [PRE_INIT_DATASET_IND_VOICE_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_pre_init_param_set"
      },
      /*new*/
      [PRE_INIT_DATASET_IND_VOICE_NB_SPEC] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_voice_nb_pre_init_param_set,
          .descriptor_name = "ecnr_voice_nb_pre_init_param_set"
      }
  },
  /*new*/
  .post_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_post_init_param_set"
      },
      /*PHFTR_PP4_Coef1-80 Should reflect the Facetime Tuning Cals*/
      [POST_INIT_DATASET_IND_PP4_CALL_FT] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_PP4_COEF1,
          .buf_length      = QWA_STANDARD_SERVER_DATA,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_pp4_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_pp4_coef_post_init_param_set"
      }
  }
};

/*PHFTR_PP4_Coef1-80 Should reflect the Facetime Tuning Cals*/
static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_cp_voice_wb =
{
    .dataset_pre_nb  = 2,
    .dataset_post_nb = 2,
  .pre_init_desc =
  {
      [PRE_INIT_DATASET_IND_VOICE_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_pre_init_param_set"
      },
      /*new*/
      [PRE_INIT_DATASET_IND_VOICE_NB_SPEC] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_voice_wb_pre_init_param_set,
          .descriptor_name = "ecnr_voice_wb_pre_init_param_set"
      }
  },
  /*new*/
  .post_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_post_init_param_set"
      },
      /*PHFTR_PP4_Coef1-80 Should reflect the Facetime Tuning Cals*/
      [POST_INIT_DATASET_IND_PP4_CALL_FT] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_PP4_COEF1,
          .buf_length      = QWA_STANDARD_SERVER_DATA,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_pp4_coef_post_init_param_set,
          .descriptor_name = "ecnr_phftr_pp4_coef_post_init_param_set"
      }
  }
};



/*****************************************
  android auto microphone only setting
  Android Auto
******************************************/

static struct ecnr_qwa_param_set ecnr_aa_param_uc_vr_set =
{
    .setqwaRecvInCnt = 0,
    .setqwaNRSwitch  = 0,
    .setqwaAECSwitch = 0,
    .setqwaRECSwitch = 0,
    .setqwaHFESwitch = 0,
    .setqwaAGCSwitch = 0,
    .setqwaDiagSwitch = 0,
    .setqwaSampleRateIn = 16000,
    .setqwaMaxFreqProc = 8000,
    .setqwaFrameShiftIn = 128,
    .setqwaMicInCnt = 1,
    .setqwaRecvAGCSwitch = 0,
    .setqwaRecvBWESwitch = 0,
    .setqwaRecvDLCSwitch = 0,
    .setqwaRecvENSSwitch = 0,
    .setqwaRecvEQSwitch = 0,
    .setqwaSendDynEQSwitch = 0,
    .setqwaSendEQSwitch = 0,
    .setqwaWNDBSwitch = 0,
    .setqwaAECFiltLen = 0
};


static struct ecnr_qwa_parameter ecnr_aa_cs_coef_pre_init_param_set[] = {
    {"qwaAECSwitch"         ,qwaAECSwitch             ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaAECSwitch},
    {"qwaAGCSwitch"         ,qwaAGCSwitch             ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaAGCSwitch},
    {"qwaDiagSwitch"        ,qwaDiagSwitch            ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaDiagSwitch},
    {"qwaHFESwitch"         ,qwaHFESwitch             ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaHFESwitch},
    {"qwaNRSwitch"          ,qwaNRSwitch              ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaNRSwitch},
    {"qwaOpMode"            ,qwaOpMode                ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF6 - EOLLIB_OFFSET_PHFTR_CS_COEF1) ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaRECSwitch"         ,qwaRECSwitch             ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaRECSwitch},
    {"qwaRecvAGCSwitch"     ,qwaRecvAGCSwitch         ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaRecvAGCSwitch},
    {"qwaRecvBWESwitch"     ,qwaRecvBWESwitch         ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaRecvBWESwitch},
    {"qwaRecvDLCSwitch"     ,qwaRecvDLCSwitch         ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaRecvDLCSwitch},
    {"qwaRecvENSSwitch"     ,qwaRecvENSSwitch         ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaRecvENSSwitch},
    {"qwaRecvEQSwitch"      ,qwaRecvEQSwitch          ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaRecvEQSwitch},
    {"qwaSendDynEQSwitch"   ,qwaSendDynEQSwitch       ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaSendDynEQSwitch},
    {"qwaSendEQSwitch"      ,qwaSendEQSwitch          ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaSendEQSwitch},
    {"qwaWNDBMode"          ,qwaWNDBMode              ,ECNR_TYPE_SELECT           ,0                             ,(EOLLIB_OFFSET_PHFTR_CS_COEF15 - EOLLIB_OFFSET_PHFTR_CS_COEF1),ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_EOL_VALUE, 0},
    {"qwaWNDBSwitch"        ,qwaWNDBSwitch            ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaWNDBSwitch},
    {"qwaAECFiltLen"        ,qwaAECFiltLen            ,ECNR_TYPE_U16              ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaAECFiltLen},
    {"qwaFrameShiftIn"      ,qwaFrameShiftIn          ,ECNR_TYPE_U16              ,0                             ,0                                                             ,ECNR_EOL_TYPE_U16,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaFrameShiftIn},
    {"qwaSampleRateIn"      ,qwaSampleRateIn          ,ECNR_TYPE_U16              ,0                             ,0                                                             ,ECNR_EOL_TYPE_U16,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaSampleRateIn},
    {"qwaMaxFreqProc"       ,qwaMaxFreqProc           ,ECNR_TYPE_U16              ,0                             ,0                                                             ,ECNR_EOL_TYPE_U16,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaMaxFreqProc},
    {"qwaRecvInCnt"         ,qwaRecvInCnt             ,ECNR_TYPE_U16              ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaRecvInCnt},
    {"qwaMicInCnt"          ,qwaMicInCnt              ,ECNR_TYPE_U16              ,0                             ,0                                                             ,ECNR_EOL_TYPE_U16,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaMicInCnt},
    {"qwaLFRSwitch"         ,qwaLFRSwitch             ,ECNR_TYPE_SELECT           ,0                             ,0                                                             ,ECNR_EOL_TYPE_U8 ,1                            ,ECNR_PARAM_SET_CONST_VALUE, (void*)&ecnr_aa_param_uc_vr_set.setqwaLFRSwitch},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID                           ,EOL_TYPE_INVALID ,ECNR_QWA_PARAM_LENGTH_INVALID,PARAM_TYPE_INVALID         ,ECNR_QWA_POINTER_INVALID}
};

static struct ecnr_qwa_parameter ecnr_aa_coef_post_init_param_set[] = {

    {"qwaSendGain"          ,qwaSendGain            ,ECNR_TYPE_I16          ,0 ,(EOLLIB_OFFSET_PHFTR_PP5_COEF38 - EOLLIB_OFFSET_PHFTR_PP5_COEF1),ECNR_EOL_TYPE_I16,1                           ,ECNR_PARAM_SET_EOL_VALUE,0},
    {"qwaInvalidParam"      ,ECNR_QWA_PARAM_INVALID   ,ECNR_QWA_PARAM_TYPE_INVALID ,ECNR_QWA_PARAM_CHANNEL_INVALID,ECNR_QWA_ARRAY_START_OFFSET_INVALID,EOL_TYPE_INVALID,ECNR_QWA_PARAM_LENGTH_INVALID ,PARAM_TYPE_INVALID,ECNR_QWA_POINTER_INVALID}
};

static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_aa_voice_wb =
{
    .dataset_pre_nb  = 1,
    .dataset_post_nb = 1,
  .pre_init_desc =
  {
      [PRE_INIT_DATASET_IND_CALL_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_aa_cs_coef_pre_init_param_set,
          .descriptor_name = "ecnr_aa_cs_coef_pre_init_param_set"
      }
  },
    /*PHFTR_PP3_Coef1-80 should reflect the USB HF tuning CALs.*/
    .post_init_desc =
    {
        [POST_INIT_DATASET_IND_CS_AA_VR] =
        {
            .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_PP5_COEF1,
          .buf_length      = QWA_STANDARD_SERVER_DATA,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_aa_coef_post_init_param_set,
          .descriptor_name = "ecnr_aa_coef_post_init_param_set"
        }
    }
};

/*****************************************************************************/
/*   General description  table                                              */
/*****************************************************************************/


static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_sr_nb =
{
    .dataset_pre_nb  = 1,
  .pre_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_SR_NB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_sr_nb_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_sr_nb_pre_init_param_set"
      }
  }
};

static struct ecnr_qwa_paramter_configuration_descriptor ecnr_dataset_desc_sr_wb =
{
    .dataset_pre_nb  = 1,
  .pre_init_desc =
  {
      [POST_INIT_DATASET_IND_CS_CALL_SR_WB] =
      {
          .dataset_table   = EOLLIB_TABLE_ID_HAND_FREE_TUNING,
          .dataset_offset  = EOLLIB_OFFSET_PHFTR_CS_COEF1,
          .buf_length      = QWA_CAR_SPECIFIC,
          .dataset         = (struct ecnr_qwa_parameter*)&ecnr_phftr_cs_coef_sr_wb_pre_init_param_set,
          .descriptor_name = "ecnr_phftr_cs_coef_sr_wb_pre_init_param_set"
      }
  }
};

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
static unsigned int ecnr_qwa_handler_load_eol_configuration(struct ecnr_qwa_paramter_configuration_descriptor* desc, enum param_init_type select )
{
    int err = ECNR_ERR_OK;
    guint8* au8Data= (guint8*)NULL;
    struct ecnr_qwa_paramter_configuration_descriptor* pdesc = (struct ecnr_qwa_paramter_configuration_descriptor*)NULL;
    struct ecnr_qwa_paramter_dataset_descriptor* pds =(struct ecnr_qwa_paramter_dataset_descriptor*)NULL;
    guint8 i = 0;
    guint8 dataset_nb = 0;

    if(!desc)
    {
        pr_debug("eol parameter set descriptor is not available\n");
        return ECNR_ERR_NULL_POINTER;
    }

    if (!ecnr_diag_eol_is_open())
    {
        if(!ecnr_diag_eol_open())
        {
            pr_critical("fail to open the eol device \n");
            return ECNR_ERR_CONFIG_EOL_IO_ERROR;
        }
    }

    if(select == ECNR_PARAM_POST_INIT)
    {
        pr_debug("set eol post init parameter set\n");
    }
    else if(select == ECNR_PARAM_PRE_INIT)
    {
        pr_debug("set eol pre init parameter set\n");
    }
    else
    {
        pr_debug("invalid init parameter type\n");
    }

    /***********************
    * set init values
    ***********************/
    pdesc = desc;

    if(select == ECNR_PARAM_POST_INIT)
    {
        dataset_nb = pdesc->dataset_post_nb;
        if(dataset_nb > MAX_PRE_DATASET_DESC)
        {
            pr_warning("configured number (%d) of data set is bigger of the max value( %d)\n",dataset_nb, MAX_PRE_DATASET_DESC);
            dataset_nb = MAX_PRE_DATASET_DESC;
            err = ECNR_ERR_TBL_IDX_NB_CFG_VALUE_TRANSGRESSION;
        }
    }
    else if(select == ECNR_PARAM_PRE_INIT)
    {
        dataset_nb = pdesc->dataset_pre_nb;
        if(dataset_nb > MAX_POST_DATASET_DESC)
        {
            pr_warning("configured number (%d) of data set is bigger of the max value( %d)\n",dataset_nb, MAX_POST_DATASET_DESC);
            dataset_nb = MAX_POST_DATASET_DESC;
            err = ECNR_ERR_TBL_IDX_NB_CFG_VALUE_TRANSGRESSION;
        }
    }

    if(err == ECNR_ERR_OK)
    {
        for( i = 0; i < dataset_nb; i++)
        {
            if(select == ECNR_PARAM_POST_INIT)
                pds = &pdesc->post_init_desc[i];
            else if(select == ECNR_PARAM_PRE_INIT)
                pds = &pdesc->pre_init_desc[i];

            if(pds)
            {
                /* alloc buffer */
                au8Data = g_malloc0(pds->buf_length);
                if(!au8Data)
                    err = ECNR_ERR_NULL_POINTER;
                else
                {
                    if(FALSE == ecnr_diag_eol_Read_qwa_values(pds->dataset_table, pds->dataset_offset, pds->buf_length, au8Data))
                    {
                        pr_critical("!!! ERROR:[%d] Failed to read hands free tuning values" , ecnr_diag_eol_get_last_Error_code());
                        err = ECNR_ERR_OSAL_ERROR;
                    }
                }

                /* set parameter */
                if(!err)
                {
                    pr_message("Set parameter from data set descriptor(%s)\n", pds->descriptor_name);
                    err = ecnr_diag_eol_access_set_param(pds->dataset, au8Data);
                }

                if(au8Data)
                    free(au8Data);
                au8Data = NULL;
            }
        }
    }


    /* close eol Osal device */
    if (ecnr_diag_eol_is_open())
    {
        if(!ecnr_diag_eol_close())
        {
            pr_critical("fail to close the eol device \n");
            return ECNR_ERR_CONFIG_EOL_IO_ERROR;
        }
    }

    return err;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_create_instance
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_create_instance(void)
{
  int err = ECNR_ERR_OK;

    pr_debug("ENTERED\n");

    /* create new instance of qwa engine*/
    err = ecnr_qwa_handler_create();
    if(err != QWA_OK)
    {
        ecnr_critical(err, "ecnr_qwa_handler_create_instance");
        return err;
    }
    else
    {
        qwa_init = TRUE;
        pr_debug("a new instance of qwa was successfully created, qwa_init : %d ", qwa_init);
    }

    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_hf_phone_Configuration_from_eol_data_pre_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
static guint16 ecnr_qwa_handler_byte_to_ushort(const guint8 u8valB1, const guint8 u8valB0)
{
  guint16 u16Val;
  u16Val = u8valB1 << 8;
  u16Val |= u8valB0;

  return u16Val;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_hf_phone_Config
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
unsigned int ecnr_qwa_handler_load_configuration_dummy(void)
{
    pr_debug("no parametrization is done here");
    return ECNR_ERR_OK;
}
/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_hf_phone_Config
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
unsigned int ecnr_qwa_handler_load_hfp_test_configuration_pre_init(void)
{
    int err = ECNR_ERR_OK;
    int vQwaOn = QWA_ON;
    guint16 u16val = 0;


    /*--- Sample rate = 8000 */
    #define DEFAULT_SR 8000 /* sample rate */

    u16val = (guint16)DEFAULT_SR;
    err = ecnr_qwa_handler_set_data(qwaSampleRateIn,0,sizeof(u16val),&u16val);
    pr_message("qwa param:qwaSampleRateIn set to :%d\n", u16val);
    RAISE_ERR_0(err,qwaSampleRateIn)

    /*--- frame shift In */
    u16val = 128;
    err = ecnr_qwa_handler_set_data(qwaFrameShiftIn,0,sizeof(u16val),&u16val);
    RAISE_ERR_0(err,qwaFrameShiftIn)


    /*--- NR On */
    err = ecnr_qwa_handler_set_data(qwaNRSwitch,0, sizeof(vQwaOn),&vQwaOn);
    RAISE_ERR_0(err,qwaNRSwitch)

    /*--- AEC On */
    err = ecnr_qwa_handler_set_data(qwaAECSwitch,0, sizeof(vQwaOn),&vQwaOn);
    RAISE_ERR_0(err,qwaAECSwitch)

    /*--- Residual AEC On */
    err = ecnr_qwa_handler_set_data(qwaRECSwitch,0, sizeof(vQwaOn),&vQwaOn);
    RAISE_ERR_0(err,qwaRECSwitch)

    /*--- AGC On */
    err = ecnr_qwa_handler_set_data(qwaAGCSwitch,0, sizeof(vQwaOn),&vQwaOn);
    RAISE_ERR_0(err,qwaAGCSwitch)

    /*--- Receive channel count is 1 */
    /* set qwaRecvInCnt parameter */
    u16val = 1;
    err = ecnr_qwa_handler_set_data(qwaRecvInCnt,0, sizeof(guint16),&u16val);
    RAISE_ERR_0(err,qwaRecvInCnt)

     /* set micro count in qwa engine*/
    u16val = 1;

    err = ecnr_qwa_handler_set_data(qwaMicInCnt,0,sizeof(u16val),&u16val);
    RAISE_ERR_0(err,qwaMicInCnt)


    return 0;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_hfp_set_8_ms_frame_size
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
static int  ecnr_qwa_handler_load_eol_hfp_set_8_ms_frame_size(void)
{
    int err = ECNR_ERR_OK;
    guint8 au8Data[QWA_CAR_SPECIFIC] = {0};
    guint16 bufLen = QWA_CAR_SPECIFIC;
    int qwa_sr_in_value = 0;
    int qwaValue = 0;

    pr_debug("ENTERED\n");

    if (!ecnr_diag_eol_is_open())
    {
        if(!ecnr_diag_eol_open())
        {
            pr_critical("failed while open the eol device \n");
            return ECNR_ERR_CONFIG_EOL_IO_ERROR;
        }
    }


    /***********************
     * set 8 ms frame size
     ***********************/
    if(FALSE == ecnr_diag_eol_Read_qwa_values(EOLLIB_TABLE_ID_HAND_FREE_TUNING, EOLLIB_OFFSET_PHFTR_CS_COEF1, bufLen, au8Data))
    {
        pr_critical("!!! ERROR:[%d] Failed to read hands free tuning values" , ecnr_diag_eol_get_last_Error_code());
        return ECNR_ERR_OSAL_ERROR;
    }

    /* get qwaSampleRateIn parameter */
    qwa_sr_in_value = ecnr_qwa_handler_byte_to_ushort(au8Data[(EOLLIB_OFFSET_PHFTR_CS_COEF31 - EOLLIB_OFFSET_PHFTR_CS_COEF1) + 1],\
                                                      au8Data[(EOLLIB_OFFSET_PHFTR_CS_COEF31 - EOLLIB_OFFSET_PHFTR_CS_COEF1)]);

    pr_message("qwaSampleRateIn for qwaFrameShiftIn setting is:%d\n", qwa_sr_in_value);

    if(qwa_sr_in_value == 16000 )
        qwaValue = (tQwaU16)128;
    else if(qwa_sr_in_value == 8000 )
        qwaValue = (tQwaU16)64;
    else
    {
        pr_critical("invalid qwaSampleRateIn value(%d)\n", qwa_sr_in_value);
        qwaValue = (tQwaU16)0;
    }

    /* set qwaFrameShiftIn parameter */
    err = ecnr_qwa_handler_set_data(qwaFrameShiftIn,0, sizeof(guint16),&qwaValue);
    pr_message("qwa param:qwaFrameShiftIn set to :%d\n", qwaValue);
    RAISE_ERR(err,qwaFrameShiftIn)


    /* close eol Osal device */
    if (ecnr_diag_eol_is_open())
    {
        if(!ecnr_diag_eol_close())
        {
            pr_critical("fail to close the eol device \n");
            return ECNR_ERR_CONFIG_EOL_IO_ERROR;
        }
    }

    return 0;


CATCH_ERR:
    ecnr_diag_eol_close();
    return err;

}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_set_pre_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
static void  ecnr_qwa_handler_load_eol_set_pre_init(void)
{
    ecnr_qwa_handler_eol_select_type = ECNR_PARAM_PRE_INIT;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_set_post_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
static void  ecnr_qwa_handler_load_eol_set_post_init(void)
{
    ecnr_qwa_handler_eol_select_type = ECNR_PARAM_POST_INIT;
}



/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
static int  ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(guint8 u8BandSelection)
{
    int     err = ECNR_ERR_OK;

    pr_debug("ENTERED\n");

    /***********************
     * set pre-init values
     ***********************/
    if( u8BandSelection == NARROW_BAND_SPEECH)
        err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_sr_nb, ECNR_PARAM_PRE_INIT);
    else if( u8BandSelection == WIDE_BAND_SPEECH)
        err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_sr_wb, ECNR_PARAM_PRE_INIT);
    else
    {
            /*do nothing*/
    }
#ifdef D_SET_FRAME_SHIFT_8_MS_FOR_TEST
    err = ecnr_qwa_handler_load_eol_hfp_set_8_ms_frame_size();
#else
#endif

    return err;

}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_hfp_configuration_mic_select
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
static unsigned int ecnr_qwa_handler_load_eol_hfp_configuration_mic_select(void)
{
    int     err = ECNR_ERR_OK;
    guint16 MicInCnt = 0;
    guint8  u8Value = 0;
    gint32  qwaSelect= (gint32)qwaOff;


    if (!ecnr_diag_eol_is_open())
    {
        if(!ecnr_diag_eol_open())
        {
            pr_critical("failed while open the eol device \n");
            return ECNR_ERR_CONFIG_EOL_IO_ERROR;
        }
    }

    /* Set QWA-Parameters "qwaMixSwitch and qwaMicInCnt" depends of the Mic1 and Mic2 settings */
    if (TRUE == ecnr_diag_eol_Read(EOLLIB_TABLE_ID_COUNTRY, EOLLIB_OFFSET_MICROPHONE_1_CONFIG, &u8Value))
    {
        pr_message("EOLLIB_OFFSET_MICROPHONE_1_CONFIG param:%d\n", u8Value);
        if (u8Value > 0 )
        {
            MicInCnt++;
            pr_message("MICROPHONE_1 is selected\n");
        }
    }
    else
    {
        pr_critical("!!! ERROR:[%d] Failed to read Mic1 setting value" , ecnr_diag_eol_get_last_Error_code());
        return ECNR_ERR_OSAL_ERROR;
    }

    if (TRUE == ecnr_diag_eol_Read(EOLLIB_TABLE_ID_DISPLAY_INTERFACE, EOLLIB_OFFSET_MICROPHONE_2_CONFIG, &u8Value))
    {
        pr_message("EOLLIB_OFFSET_MICROPHONE_2_CONFIG param:%d\n", u8Value);
        if (u8Value > 0)
        {
            MicInCnt++;
            pr_message("MICROPHONE_2 is selected\n");
        }
    }
    else
    {
        pr_critical("!!! ERROR:[%d] Failed to read Mic2 setting value" , ecnr_diag_eol_get_last_Error_code());
        return ECNR_ERR_OSAL_ERROR;
    }

    /* set micro count in qwa engine*/
    err = ecnr_qwa_handler_set_data(qwaMicInCnt,0,sizeof(MicInCnt),&MicInCnt);
    pr_message("qwa param:qwaMicInCnt set to :%d\n", MicInCnt);
    RAISE_ERR(err,qwaMicInCnt)

    if(MicInCnt>1)
        qwaSelect = (gint32)qwaOn;
    err = ecnr_qwa_handler_set_data(qwaMixSwitch,0, sizeof(gint32),&qwaSelect);
    pr_message("qwa param:qwaMixSwitch set to :%d\n", qwaSelect);
    RAISE_ERR(err,qwaMixSwitch)


CATCH_ERR:

    /* close eol Osal device */
    if (ecnr_diag_eol_is_open())
    {
        if(!ecnr_diag_eol_close())
        {
            pr_critical("fail to close the eol device \n");
            return ECNR_ERR_CONFIG_EOL_IO_ERROR;
        }
    }

    return err;
}



/************************ public interface function definition  ***************************************/



/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_hfp_call_nb_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_load_eol_hfp_call_nb_configuration(void)
{
    int                  err    = ECNR_ERR_OK;
    enum param_init_type select = ecnr_qwa_handler_eol_select_type;

    pr_message("set %s parameter set(%s)\n",\
        (ecnr_qwa_handler_eol_select_type == ECNR_PARAM_PRE_INIT)?"pre_init_paramter":"post_init_paramter",\
        "ecnr_dataset_desc_call_nb");

    if ( select == ECNR_PARAM_PRE_INIT)
    {
        /* Microphone setting */
        err = ecnr_qwa_handler_load_eol_hfp_configuration_mic_select();

        /* set pre-init values */
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_call_nb, ECNR_PARAM_PRE_INIT);

        /* set nb sample rate*/
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(NARROW_BAND_SPEECH);
    }

    else if( select == ECNR_PARAM_POST_INIT)
    {
        err =  ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_call_nb, ECNR_PARAM_POST_INIT);
    }

    else
        pr_warning(" no setting available\n");


    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_hfp_call_wb_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_load_eol_hfp_call_wb_configuration(void)
{
    int                  err    = ECNR_ERR_OK;
    enum param_init_type select = ecnr_qwa_handler_eol_select_type;


    pr_message("set %s parameter set(%s)\n",\
        (ecnr_qwa_handler_eol_select_type == ECNR_PARAM_PRE_INIT)?"pre_init_paramter":"post_init_paramter",\
        "ecnr_dataset_desc_call_wb");

    if ( select == ECNR_PARAM_PRE_INIT)
    {
        /* Microphone setting */
        err = ecnr_qwa_handler_load_eol_hfp_configuration_mic_select();

        /* set pre-init values */
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_call_wb, ECNR_PARAM_PRE_INIT);

        /* set nb sample rate*/
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(WIDE_BAND_SPEECH);
    }

    else if( select == ECNR_PARAM_POST_INIT)
    {
        err =  ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_call_wb, ECNR_PARAM_POST_INIT);
    }

    else
        pr_warning(" no setting available\n");


    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_hfp_voice_nb_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_load_eol_hfp_voice_nb_configuration(void)
{
    int                  err    = ECNR_ERR_OK;
    enum param_init_type select = ecnr_qwa_handler_eol_select_type;

    pr_message("set %s parameter set(%s)\n",\
        (ecnr_qwa_handler_eol_select_type == ECNR_PARAM_PRE_INIT)?"pre_init_paramter":"post_init_paramter",\
        "ecnr_dataset_desc_server_nb");

    if ( select == ECNR_PARAM_PRE_INIT)
    {
        /* Microphone setting */
        err = ecnr_qwa_handler_load_eol_hfp_configuration_mic_select();

        /* set pre-init values */
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_server_nb, ECNR_PARAM_PRE_INIT);

        /* set nb sample rate*/
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(NARROW_BAND_SPEECH);
    }

    else if( select == ECNR_PARAM_POST_INIT)
    {
        err =  ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_server_nb, ECNR_PARAM_POST_INIT);
    }

    else
        pr_warning(" no setting available\n");


    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_hfp_voice_wb_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_load_eol_hfp_voice_wb_configuration(void)
{
    int                  err    = ECNR_ERR_OK;
    enum param_init_type select = ecnr_qwa_handler_eol_select_type;

    pr_message("set %s parameter set(%s)\n",\
        (ecnr_qwa_handler_eol_select_type == ECNR_PARAM_PRE_INIT)?"pre_init_paramter":"post_init_paramter",\
        "ecnr_dataset_desc_server_wb");

    if ( select == ECNR_PARAM_PRE_INIT)
    {
        /* Microphone setting */
        err = ecnr_qwa_handler_load_eol_hfp_configuration_mic_select();

        /* set pre-init values */
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_server_wb, ECNR_PARAM_PRE_INIT);

        /* set nb sample rate*/
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(WIDE_BAND_SPEECH);
    }

    else if( select == ECNR_PARAM_POST_INIT)
    {
        err =  ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_server_wb, ECNR_PARAM_POST_INIT);
    }

    else
        pr_warning(" no setting available\n");


    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_cp_call_nb_configuration_pre_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_load_eol_cp_call_nb_configuration(void)
{
    int                  err    = ECNR_ERR_OK;
    enum param_init_type select = ecnr_qwa_handler_eol_select_type;

    pr_message("set %s parameter set(%s)\n",\
        (ecnr_qwa_handler_eol_select_type == ECNR_PARAM_PRE_INIT)?"pre_init_paramter":"post_init_paramter",\
        "ecnr_dataset_desc_cp_call_nb");

    if ( select == ECNR_PARAM_PRE_INIT)
    {
        /* Microphone setting */
        err = ecnr_qwa_handler_load_eol_hfp_configuration_mic_select();

        /* set pre-init values */
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_cp_call_nb, ECNR_PARAM_PRE_INIT);

        /* set nb sample rate*/
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(NARROW_BAND_SPEECH);
    }

    else if( select == ECNR_PARAM_POST_INIT)
    {
        err =  ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_cp_call_nb, ECNR_PARAM_POST_INIT);
    }

    else
        pr_warning(" no setting available\n");


    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_cp_call_wb_configuration_pre_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_load_eol_cp_call_wb_configuration(void)
{
    int                  err    = ECNR_ERR_OK;
    enum param_init_type select = ecnr_qwa_handler_eol_select_type;

    pr_message("set %s parameter set(%s)\n",\
        (ecnr_qwa_handler_eol_select_type == ECNR_PARAM_PRE_INIT)?"pre_init_paramter":"post_init_paramter",\
        "ecnr_dataset_desc_cp_call_wb");

    if ( select == ECNR_PARAM_PRE_INIT)
    {
        /* Microphone setting */
        err = ecnr_qwa_handler_load_eol_hfp_configuration_mic_select();

        /* set pre-init values */
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_cp_call_wb, ECNR_PARAM_PRE_INIT);

        /* set nb sample rate*/
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(WIDE_BAND_SPEECH);
    }

    else if( select == ECNR_PARAM_POST_INIT)
    {
        err =  ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_cp_call_wb, ECNR_PARAM_POST_INIT);
    }

    else
        pr_warning(" no setting available\n");


    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_cp_voice_nb_configuration_pre_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_load_eol_cp_voice_nb_configuration(void)
{
    int                  err    = ECNR_ERR_OK;
    enum param_init_type select = ecnr_qwa_handler_eol_select_type;

    pr_message("set %s parameter set(%s)\n",\
        (ecnr_qwa_handler_eol_select_type == ECNR_PARAM_PRE_INIT)?"pre_init_paramter":"post_init_paramter",\
        "ecnr_dataset_desc_cp_voice_nb");

    if ( select == ECNR_PARAM_PRE_INIT)
    {
        /* Microphone setting */
        err = ecnr_qwa_handler_load_eol_hfp_configuration_mic_select();

        /* set pre-init values */
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_cp_voice_nb, ECNR_PARAM_PRE_INIT);

        /* set nb sample rate*/
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(NARROW_BAND_SPEECH);
    }

    else if( select == ECNR_PARAM_POST_INIT)
    {
        err =  ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_cp_voice_nb, ECNR_PARAM_POST_INIT);
    }

    else
        pr_warning(" no setting available\n");


    return err;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_cp_voice_wb_configuration_pre_init
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_load_eol_cp_voice_wb_configuration(void)
{
    int                  err    = ECNR_ERR_OK;
    enum param_init_type select = ecnr_qwa_handler_eol_select_type;

    pr_message("set %s parameter set(%s)\n",\
        (ecnr_qwa_handler_eol_select_type == ECNR_PARAM_PRE_INIT)?"pre_init_paramter":"post_init_paramter",\
        "ecnr_dataset_desc_cp_voice_wb");

    if ( select == ECNR_PARAM_PRE_INIT)
    {
        /* Microphone setting */
        err = ecnr_qwa_handler_load_eol_hfp_configuration_mic_select();

        /* set pre-init values */
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_cp_voice_wb, ECNR_PARAM_PRE_INIT);

        /* set nb sample rate*/
        if(err == ECNR_ERR_OK)
            err = ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(WIDE_BAND_SPEECH);
    }

    else if( select == ECNR_PARAM_POST_INIT)
    {
        err =  ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_cp_voice_wb, ECNR_PARAM_POST_INIT);
    }

    else
        pr_warning(" no setting available\n");


    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_load_eol_aa_voice_wb_configuration
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_load_eol_aa_voice_wb_configuration(void)
{
    int                  err    = ECNR_ERR_OK;
    enum param_init_type select = ecnr_qwa_handler_eol_select_type;

    pr_message("set %s parameter set(%s)\n",\
        (ecnr_qwa_handler_eol_select_type == ECNR_PARAM_PRE_INIT)?"pre_init_paramter":"post_init_paramter",\
        "ecnr_dataset_desc_aa_voice_wb");

    if ( select == ECNR_PARAM_PRE_INIT)
    {
        /* Microphone setting */
        //err = ecnr_qwa_handler_load_eol_hfp_configuration_mic_select();

        /* set pre-init values */
        err = ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_aa_voice_wb, ECNR_PARAM_PRE_INIT);

        /* set nb sample rate*/
        //if(err == ECNR_ERR_OK)
        //    err = ecnr_qwa_handler_load_eol_hfp_sr_configuration_pre_init(WIDE_BAND_SPEECH);
    }

    else if( select == ECNR_PARAM_POST_INIT)
    {
        err =  ecnr_qwa_handler_load_eol_configuration(&ecnr_dataset_desc_aa_voice_wb, ECNR_PARAM_POST_INIT);
    }

    else
        pr_warning(" no setting available\n");


    return err;
}


/*******************************************************************************
              FUNCTION  DECLARATION
*******************************************************************************/

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_audio_in
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/


int ecnr_qwa_handler_audio_in(stecnr_alsa_state* pstate)
{
    int err = 0;

    if(qwa_handler)
    {
        /*------ signal processing function of the QWA module -*/
        err = qwaAudioIn(   qwa_handler,
                            0,
                            *pstate->MicIn,
                            *pstate->RecvIn,
                            *pstate->RefIn);
    }
    else
    {
        pr_critical("no valid qwa instance \n");
        err = QWA_ERR_NOT_CREATED;
    }

    return err;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_audio_out
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/
int ecnr_qwa_handler_audio_out(stecnr_alsa_state* pstate)
{
    int err = ECNR_ERR_OK;

    if(qwa_handler)
    {
        /*------ signal processing function of the QWA module -*/
        err = qwaAudioOut(  qwa_handler,
                            NULL,
                            *pstate->MicOut,
                            *pstate->RecvOut);
    }
    else
    {
        pr_critical("no valid qwa instance \n");
        err = QWA_ERR_NOT_CREATED;
    }

    return err;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_create
* DESCRIPTION: ..
*
*
* PARAMETER: None.
*
* RETURNVALUE: qwa error
*
*******************************************************************************/

int ecnr_qwa_handler_create(void)
{
    int err = ECNR_ERR_OK;

    pr_debug("ENTERED \n");

    if(qwa_init)
    {
        err = ecnr_qwa_handler_destroy();
        if(err)
        {
            qwa_init = FALSE;
            qwa_handler = NULL;
            ecnr_critical(err,"call qwaDestroy previous to qwaCreate");
            return err;
        }
    }

    err = qwaCreate(&qwa_handler);

    if (err != ECNR_ERR_OK)
    {
        pr_critical("fail to create a qwa instance\n");
    }
    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_get_data
*
* DESCRIPTION: To retrieve the data set
*
* PARAMETER: [IN] Id of the data to be retrieved
*
* RETURNVALUE: int.
*
*******************************************************************************/

int ecnr_qwa_handler_get_data
(
    int              dataId,
    int              channel,
    unsigned int*    psize,
    void*            pdata
)
{
    int err = ECNR_ERR_OK;

    pr_debug("ENTERED");

    if(!qwa_init)
    {
        pr_warning("try to retrieve a qwa engine parameter with no valid qwa instance");
        return ECNR_ERR_NOT_CREATED;
    }

    err = qwaGetData(qwa_handler, (tQwaDataID)dataId, (tQwaInt)channel, (tQwaU32*)psize, pdata );

    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_set_data
*
* DESCRIPTION: To set data in the QWA Engine
*
* PARAMETER: [IN] Id of the data to be retrieved
*
* RETURNVALUE: int.
*
*******************************************************************************/
int ecnr_qwa_handler_set_data
(
    int          dataId,
    int          channel,
    unsigned int size,
    void*        pdata
)
{
    int err = ECNR_ERR_OK;


  pr_debug("dataId:%d, channel:%d, size:%d\n", dataId, channel, size);

    if(!qwa_init)
    {
        pr_warning("try to set a parameter with no valid qwa instance");
        return ECNR_ERR_NOT_CREATED;
    }

    err = qwaSetData(qwa_handler, (tQwaDataID)dataId, (tQwaInt)channel, (tQwaU32)size, pdata );

    if(err)
    {
        pr_debug("qwaSetData for parameter:%d  is filed with error: %d \n", dataId, err);
    }

    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_initialize
*
* DESCRIPTION: To set data in the qwa Engine
*
* PARAMETER: [IN] Id of the data to be retrieved
*
* RETURNVALUE: int.
*
*******************************************************************************/
int ecnr_qwa_handler_initialize(void* pvQwaCfg)
{
    int err = ECNR_ERR_OK;

    pr_debug("ENTERED");

    const tQwaCfg* pQwaCfg = (tQwaCfg*)pvQwaCfg;

    if(qwa_init)
    {
        if(!pQwaCfg)
        {
            pr_debug("qwa initialization without configuration data");
            err = qwaInitialize(qwa_handler,NULL);
        }
        else
        {
            if(!pQwaCfg->pData)
            {
                pr_debug("qwa initialization without configuration data");
                err = qwaInitialize(qwa_handler,NULL);
            }
            else
            {
                pr_debug("qwa initialization with configuration data");
                err = qwaInitialize(qwa_handler, pQwaCfg);
            }
        }
    }
    else
    {
        pr_warning("no valid qwa instance");
        err = ECNR_ERR_NOT_CREATED ;
    }

    pr_debug("EXIT with err: %d\n", err);
    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_SetConfig
*
* DESCRIPTION: To set data in the qwa Engine
*
* PARAMETER: [IN] Id of the data to be retrieved
*
* RETURNVALUE: int.
*
*******************************************************************************/
int ecnr_qwa_handler_set_config(void* pvQwaCfg)
{
    int err = ECNR_ERR_OK;

    const tQwaCfg* pQwaCfg = (tQwaCfg*)pvQwaCfg;

    pr_debug("ENTERED");

    if(!qwa_init)
    {
        pr_warning("try to set a parameter with no valid qwa instance");
        return ECNR_ERR_NOT_CREATED ;
    }

    if(!pQwaCfg)
    {
        pr_debug("QWA initialization without configuration data");
        err = qwaSetConfig(qwa_handler,NULL);
    }
    else
    {
        pr_debug("QWA initialization with configuration data");
        err = qwaSetConfig(qwa_handler,pQwaCfg);

    }

    pr_debug("EXIT");
    return err;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_create_session
*
* DESCRIPTION: THis function initialize the QWA Engine with the passed ConfigId
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/

int ecnr_qwa_handler_create_session(unsigned short ConfigId)
{
  int err = 0;

  pr_debug("ENTERED\n");

  /* initialization from QWA and data structure*/
  err = ecnr_qwa_handler_create_instance();

  if (err)
  {
    pr_warning("failed to create qwa instance");
    return err;
  }

  if(!ConfigId)
  {
    pr_critical("invalid configuration id : %d\n",ConfigId);
    return ECNR_ERR_OK;
  }

  /* set configuration */
  err = ecnr_qwa_handler_set_configuration(ConfigId);

  /* failure while initialization, destroy QWA instance */
  if (err)
  {
    ecnr_critical(err, "ecnr_qwa_handler_set_configuration");
    ecnr_engine_handler_destroy(); // ecnr_qwa_handler_destroy();
  }

  pr_debug("EXIT with err = %d \n", err);

  return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_reset
*
* DESCRIPTION: THis function initialize the QWA Engine with the passed ConfigId
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
int ecnr_qwa_handler_reset(void)
{
  int err = 0;

  pr_debug("ENTERED \n");

  err = qwaReset(qwa_handler);

  return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_destroy
*
* DESCRIPTION: THis function initialize the QWA Engine with the passed ConfigId
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
int ecnr_qwa_handler_destroy(void)
{
    int err = ECNR_ERR_OK;

    pr_debug("ENTERED \n");

    if(!qwa_init)
    {
        pr_warning("try to destroy the qwa engine with no valid qwa instance");
        return ECNR_ERR_NOT_CREATED;
    }

    /* destroy qwa engine instance */
    err = qwaDestroy(&qwa_handler);

    if(err != ECNR_ERR_OK)
        ecnr_critical(err, "fail to destroy qwa instance\n");

    qwa_handler = NULL;
    qwa_init = FALSE;
    m_CurrConfigId = 0;

    return err;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_check_operating_mode
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_check_operating_mode(void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT; //TODO: rsu2kor : check OP mode and ASR mode from QWA library

    return status;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_set_configuration
*
* DESCRIPTION: THis function initialize the QWA Engine with the passed ConfigId
*
* PARAMETER: [check xml file for parameter description]
*
* RETURNVALUE: int
*
*******************************************************************************/
int ecnr_qwa_handler_set_configuration(unsigned short ConfigId)
{
    int                         err = ECNR_ERR_OK;
    guint8                      type = 0;
    const struct EcnrConfig     *pdata = NULL;
    gboolean                    ist_cfg_file = FALSE;
    tQwaCfg                     vQwa_cfg = {0, (tQwaU8*)NULL};

    pr_debug("ENTERED");


    /* Is the qwa initialized ? */
    if(!qwa_init)
    {
        pr_warning("qwa emgine not initialized, call ecnr_initialize first");
        return ECNR_ERR_NOT_CREATED;
    }

    /* the QWA is already initialized with the requested configuration */
    else
    {
        if(ConfigId == m_CurrConfigId)
        {
            pr_warning("qwa engine was already initialized with configuration id %d", m_CurrConfigId);
            return ECNR_ERR_OK;
        }
    }

    pdata = ecnr_configuration_get_config_data(ConfigId);

    if (!pdata)
    {
        pr_warning("no valid configuration available for configuration id : % d", ConfigId);
        return ECNR_ERR_CONFIG_NOT_AVAILABLE;
    }

    pr_debug("configuration id : %d, configuration file : %s\n", pdata->configId, pdata->bsd_str);


    /* load configuration file if available while rcs mode is activated */
    if(ecnr_qwa_rcs_get_active_state())
    {
        /* 06022015 - add setting from device for spi */
      vQwa_cfg.pData = ecnr_qwa_handler_get_binary_config(ConfigId, &vQwa_cfg.usSize);
        if(vQwa_cfg.pData)
            ist_cfg_file = TRUE;
        else
            pr_debug("no rcs configuration file available for cfg id(%d)\n",ConfigId);
    }


    /* only dann EOL configuration if no configuration file available  */
    if(!ist_cfg_file)
    {
        /* Provide correct pointers, depending on use case*/
        type = ecnr_configuration_get_config_type(ConfigId);

        switch(type)
        {
            case CONFIG_TYPE_SET_FCT:
            {
                /* qwa parameter are retrieved from the eol table an set per qwa call to eth engine
                 * an initialization of the engine  is done within the function
                 */

                pr_message("set pre-init parameter previous to qwa initialization");
                ecnr_qwa_handler_load_eol_set_pre_init();
                err = pdata->vsetFunction();

                break;
            }
            case CONFIG_TYPE_FILE:
            case CONFIG_TYPE_TABLE:
            case CONFIG_TYPE_KDS:
            default:
                err = ECNR_ERR_CONFIG_NOT_AVAILABLE;
                break;
        }
    }
    /*********************************************************************/
    /*          process QWALive init parameters                        */
    /*                                                                   */
    /* At this point, any initialization commands sent from QWALive will */
    /* overwrite the startup configuration above                       */
    /*********************************************************************/

    if(ecnr_qwa_rcs_get_active_state())
        err = ecnr_qwa_rcs_handler_process_init();


    /*************************/
    /* initialize QWA module */
    /************************/
    if(err == ECNR_ERR_OK)
    {

        if(ist_cfg_file)
        {
            err = ecnr_qwa_handler_initialize((void*)&vQwa_cfg);

        }
        else
        {
            err = ecnr_qwa_handler_initialize((void*)NULL);

            /* Initialize qwa engine */
            if((err == ECNR_ERR_OK) && (type == CONFIG_TYPE_SET_FCT))
            {
                /* post paramter initilaization ? */
                pr_message("set post-init parameter after qwa initialization");
                ecnr_qwa_handler_load_eol_set_post_init();
                err = pdata->vsetFunction_2();
            }
        }
    }

    if(err == ECNR_ERR_OK)
    {
        /*save current configuration and initialization status */
        m_CurrConfigId = ConfigId;
        pr_debug("save current configuration %d \n", m_CurrConfigId);
    }
    else
    {
        pr_critical("initialization failed with error: %d ",err);
    }

    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_get_version
* DESCRIPTION: ends debug session
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: void
*
*******************************************************************************/
void ecnr_qwa_get_version
(
    const unsigned short*   pVersionArray[4],
    const   signed  char**  ppVersionString,
    const   signed  char**  ppVersionComment
)
{

    qwaGetVersion(pVersionArray,ppVersionString,ppVersionComment);

}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_get_status_message
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
int ecnr_qwa_get_status_message(signed char StatusMessage[ECNR_QWA_MAX_STRING_LEN])
{
  int err = ECNR_ERR_OK;

  err = qwaGetStatusMessage(qwa_handler, StatusMessage);

  return err;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_init
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
void ecnr_qwa_handler_init(void)
{
    /* init file structure */
    qwa_cfg = g_malloc0(sizeof(struct ecnr_qwa_cfg)* ECNR_NUMBER_CONFIG_MAX);
    if(!qwa_cfg)
        pr_critical("memory allocation failure for qwa cfg structure\n");

    return;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_init
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
void ecnr_qwa_handler_close(void)
{
    struct ecnr_qwa_cfg *pp = (struct ecnr_qwa_cfg*) NULL;
    int i = 0;
    int j = 0;

    /* free all file structure */
    if(qwa_cfg)
    {
       for( i = 0; i < ECNR_NUMBER_CONFIG_MAX; i++)
        {
            /* walk though all configuration instances */
            pp = &qwa_cfg[i];
            if(pp->ecnr_qwa_cfg_file.pData)
            {
                if(pp->ecnr_qwa_cfg_file.pData)
                    free(pp->ecnr_qwa_cfg_file.pData);
                pp->ecnr_qwa_cfg_file.pData = NULL;
                pp->ecnr_qwa_cfg_file.usSize = 0;
                pp->ecnr_config_id = 0;

            }
            if(pp->devdesc)
            {
                /*delete device name */
                for(j=0;j<pp->ecnr_dev_desc_size;++j)
                {
                    if(pp->devdesc[j].adev_name)
                        free(pp->devdesc[j].adev_name);
                    pp->devdesc[j].adev_name = NULL;
                }
                pp->ecnr_dev_desc_size = 0;
                free(pp->devdesc);
                pp->devdesc = NULL;
            }
        }
    }

    if(qwa_cfg)
        free(qwa_cfg);
    qwa_cfg = NULL;

    return;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_get_current_config_id
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
unsigned short ecnr_qwa_get_current_config_id(void)
{
  return m_CurrConfigId;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_get_qwa_engine_handler
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
void* ecnr_qwa_get_qwa_engine_handler(void)
{
    return (void*)qwa_handler;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_get_binary_config_intance
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
static tQwaCfg *ecnr_qwa_handler_get_binary_config_intance(unsigned short ecnr_cfg_id, int* idx)
{
    int i = 0;

    for( i = 0; i < ECNR_NUMBER_CONFIG_MAX; i++)
    {
        /* walk though all configuration instances */
        if(qwa_cfg[i].ecnr_config_id == ecnr_cfg_id )
        {
            /* new 06022015*/
            if(idx)
                *idx = i;

            pr_debug("rcs configuration file available for cfg id(%d)\n",ecnr_cfg_id);
            return &qwa_cfg[i].ecnr_qwa_cfg_file;
        }
    }

    return NULL;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_get_binary_config_new_intance
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
static tQwaCfg *ecnr_qwa_handler_get_binary_config_new_intance(unsigned short ecnr_cfg_id)
{
    int i = 0;
    int j = 0;
    struct ecnr_qwa_cfg *pp = (struct ecnr_qwa_cfg*) NULL;

    for( i = 0; i < ECNR_NUMBER_CONFIG_MAX; i++)
    {
        /* remove configuration if still available for the given cfg id */
        if(qwa_cfg[i].ecnr_config_id == ecnr_cfg_id)
        {
            pp = &qwa_cfg[i];

            if(pp->ecnr_qwa_cfg_file.pData)
            {
                if(pp->ecnr_qwa_cfg_file.pData)
                        free(pp->ecnr_qwa_cfg_file.pData);
                pp->ecnr_qwa_cfg_file.pData = NULL;
                pp->ecnr_qwa_cfg_file.usSize = 0;
                pp->ecnr_config_id = 0;

                if(pp->devdesc)
                {
                    /*delete device name */
                    for(j=0;j<pp->ecnr_dev_desc_size;++j)
                    {
                        if(pp->devdesc[j].adev_name)
                            free(pp->devdesc[j].adev_name);
                        pp->devdesc[j].adev_name = NULL;
                    }
                    pp->ecnr_dev_desc_size = 0;
                    free(pp->devdesc);
                    pp->devdesc = NULL;
                }

                pr_debug("delete rcs configuration file for cfg id (%d), element (%d)\n", ecnr_cfg_id, i);

            }

        }

        /* set new configuration instances */
        if(qwa_cfg[i].ecnr_config_id == 0 )
        {
            pr_debug("new rcs configuration file for cfg id(%d)\n",ecnr_cfg_id);
            qwa_cfg[i].ecnr_config_id = ecnr_cfg_id;

            /*store devices */
            qwa_cfg[i].devdesc= g_malloc0(sizeof(struct ecnr_qwa_dev_desc)* 4);
            qwa_cfg[i].ecnr_dev_desc_size = 4;

            qwa_cfg[i].devdesc[0].adev_name=ecnr_alsa_get_dev_name(ECNR_MIC_OUT);
            qwa_cfg[i].devdesc[0].dev_ch=ECNR_MIC_OUT;

            qwa_cfg[i].devdesc[1].adev_name=ecnr_alsa_get_dev_name(ECNR_RECV_IN);
            qwa_cfg[i].devdesc[1].dev_ch=ECNR_RECV_IN;

            qwa_cfg[i].devdesc[2].adev_name=ecnr_alsa_get_dev_name(ECNR_MIC_IN0);
            qwa_cfg[i].devdesc[2].dev_ch=ECNR_MIC_IN0;

            qwa_cfg[i].devdesc[3].adev_name=ecnr_alsa_get_dev_name(ECNR_RECV_OUT);
            qwa_cfg[i].devdesc[3].dev_ch=ECNR_RECV_OUT;

            return &qwa_cfg[i].ecnr_qwa_cfg_file;
        }
    }

    return NULL;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_get_binary_config
* DESCRIPTION: Get a tQwaCfg binary configuration blob.  The caller must free
* the returned tQwaU8 pointer via g_free.  The size of the blob
* is returned in the 'size' parameter.
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/

unsigned char *ecnr_qwa_handler_get_binary_config(unsigned short ecnr_cfg_id, unsigned short* size)
{
    tQwaU8 *cfg = (tQwaU8 *)NULL;
    tQwaCfg *_qwa_cfg =  (tQwaCfg*) NULL;
#if 0  //to resolve lint
    int i = 0;
#endif
    int idx = 0;

    pr_debug("request rcs configuration file for cfg id (%d)\n", ecnr_cfg_id);

    if(!size)
        return (tQwaU8*)NULL;

    _qwa_cfg = ecnr_qwa_handler_get_binary_config_intance(ecnr_cfg_id, &idx);

    if(_qwa_cfg)
    {
        *size = _qwa_cfg->usSize;
        cfg = g_memdup(_qwa_cfg->pData, _qwa_cfg->usSize);

        if(cfg)
        {
#if 0
            /* 06022015 - add setting from device for spi */
            if(idx < ECNR_NUMBER_CONFIG_MAX)
            {
                for(i=0; i < qwa_cfg[idx].ecnr_dev_desc_size; ++i)
                {

                    ecnr_alsa_set_dev_name(qwa_cfg[idx].devdesc[i].dev_ch, qwa_cfg[idx].devdesc[i].adev_name);
                    ecnr_alsa_disable_dev_configuration(qwa_cfg[idx].devdesc[i].dev_ch);

                    pr_message("set device(%s) in channel(%d)",qwa_cfg[idx].devdesc[i].adev_name, qwa_cfg[idx].devdesc[i].dev_ch);
                }
            }
            pr_message("retrieve last loaded rcs configuration binary for cfg id (%d)\n",ecnr_cfg_id );
#endif
        }
        else
            pr_debug("no copy of binary was done for cfg id (%d)\n",ecnr_cfg_id );
    }
    else
        pr_debug("no rcs cfg file available for cfg id (%d)\n",ecnr_cfg_id);

    return (unsigned char*)cfg;
}


/*******************************************************************************
*
* FUNCTION: ecnr_qwa_free_binary_config
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
int ecnr_qwa_free_binary_config(unsigned short ecnr_cfg_id)//void)
{
    struct ecnr_qwa_cfg *pp = (struct ecnr_qwa_cfg*) NULL;
    int i = 0;

    pr_debug("request free rcs binary for cfg id (%d)\n", ecnr_cfg_id);

    /* free all file structure */
    if(qwa_cfg)
    {
       for( i = 0; i < ECNR_NUMBER_CONFIG_MAX; i++)
       {
            /* walk though all configuration instances */
            pp = &qwa_cfg[i];
            if(ecnr_cfg_id == pp->ecnr_config_id)
            {
                if(pp->ecnr_qwa_cfg_file.pData)
                {
                    if(pp->ecnr_qwa_cfg_file.pData)
                        free(pp->ecnr_qwa_cfg_file.pData);
                    pp->ecnr_qwa_cfg_file.pData = NULL;
                    pp->ecnr_qwa_cfg_file.usSize = 0;
                    pp->ecnr_config_id = 0;
                    pr_message("delete rcs configuration file for cfg id (%d), element (%d)\n", ecnr_cfg_id, i);
                    return ECNR_ERR_OK;
                }
            }
        }
    }

    return ECNR_QWA_RCS_ERR_NO_FILE_FOR_CFG_ID;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_set_handler_binary_config
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
int ecnr_qwa_set_handler_binary_config(unsigned short ecnr_cfg_id, const unsigned char* cfg, unsigned short size)
{
    int err = ECNR_ERR_OK;
    tQwaCfg *vQwa_cfg =  (tQwaCfg*) NULL;

    pr_debug("ENTERED\n");

    /* first delete configuration file if exist*/
    err = ecnr_qwa_free_binary_config(ecnr_cfg_id);

    if(!size)
    {
        pr_debug("Null size rcs configuration file\n");
        return ECNR_QWA_RCS_ERR_INVALID_BUFFSIZE;
    }

    if(!cfg)
    {
        pr_debug("configuration file is not available\n");
        return ECNR_QWA_RCS_ERR_INV_POINTER;
    }

    vQwa_cfg = ecnr_qwa_handler_get_binary_config_new_intance(ecnr_cfg_id);

    vQwa_cfg->usSize = (tQwaU16)size;
    vQwa_cfg->pData = g_memdup(cfg, size);

    if(!vQwa_cfg->pData)
    {
        pr_warning("no memory allocated for rcs config file for cfg id(%d)\n",ecnr_cfg_id );
    }
    else
    {
        pr_message("rcs config file was stored for cfg id(%d)\n",ecnr_cfg_id );
    }

    return err;
}

/*******************************************************************************
*
* FUNCTION: ecnr_qwa_handler_print_rcs_configuration
* DESCRIPTION:
*
* PARAMETER: [check xml for details]
*
* RETURNVALUE: int
*
*******************************************************************************/
void ecnr_qwa_handler_print_rcs_configuration(void)
{
    int i = 0;

    if (!qwa_cfg)
        return;

    for( i = 0; i < ECNR_NUMBER_CONFIG_MAX; i++)
    {
        /* set new configuration instances */
        pr_debug("---------------------\n");
        pr_debug("qwa_cfg[%d].ecnr_config_id: %d\n", i,qwa_cfg[i].ecnr_config_id);
        pr_debug("qwa_cfg[%d].ecnr_qwa_cfg_file.usize : %d\n", i,qwa_cfg[i].ecnr_qwa_cfg_file.usSize);
        pr_debug("qwa_cfg[%d].ecnr_qwa_cfg_file.pData : %d\n", i,qwa_cfg[i].ecnr_qwa_cfg_file.pData);
    }

    return;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_micin_count
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_micin_count(guint* qwa_mic_in_cnt)
{
    gint   status = QWA_OK;
    guint    size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaMicInCnt, 0, &size, qwa_mic_in_cnt);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_mic_proc_count
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
extern gint ecnr_qwa_handler_get_mic_proc_count(guint* qwa_mic_proc_cnt)
{
    gint   status = QWA_OK;

    (void)qwa_mic_proc_cnt;
    status = QWA_NO_RESULT; //TODO: rsu2kor : get processed MIC count from QWA library

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_refin_count
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_refin_count(guint* qwa_ref_in_cnt)
{
    gint   status = QWA_OK;

    *qwa_ref_in_cnt = 1;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_recvin_count
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_recvin_count(guint* qwa_recv_in_cnt)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaRecvInCnt, 0, &size, qwa_recv_in_cnt);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_frame_shift_in
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_frame_shift_in(guint* qwa_frame_shift_in)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaFrameShiftIn, 0, &size, qwa_frame_shift_in);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_frame_shift_out
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_frame_shift_out(guint* qwa_frame_shift_out)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaFrameShiftOut, 0, &size, qwa_frame_shift_out);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_recv_frame_shift_in
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_recv_frame_shift_in(guint* qwa_recv_frame_shift_in)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaRecvFrameShiftIn, 0, &size, qwa_recv_frame_shift_in);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_recv_frame_shift_out
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_recv_frame_shift_out(guint* qwa_recv_frame_shift_out)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaRecvFrameShiftOut, 0, &size, qwa_recv_frame_shift_out);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_ref_frame_shift_in
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_ref_frame_shift_in(guint* qwa_ref_frame_shift_in)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaRefFrameShiftIn, 0, &size, qwa_ref_frame_shift_in);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_sample_rate_in
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_sample_rate_in(guint* qwa_sample_rate_in)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaSampleRateIn, 0, &size, qwa_sample_rate_in);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_sample_rate_out
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_sample_rate_out(guint* qwa_sample_rate_out)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaSampleRateOut, 0, &size, qwa_sample_rate_out);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_recv_sample_rate_in
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_recv_sample_rate_in(guint* qwa_recv_sample_rate_in)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaRecvSampleRateIn, 0, &size, qwa_recv_sample_rate_in);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_recv_sample_rate_out
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_recv_sample_rate_out(guint* qwa_recv_sample_rate_out)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaRecvSampleRateOut, 0, &size, qwa_recv_sample_rate_out);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_ref_sample_rate_in
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_ref_sample_rate_in(guint* qwa_ref_sample_rate_in)
{
    gint  status = QWA_OK;
    guint   size = sizeof(guint16);

    status = ecnr_qwa_handler_get_data(qwaRefSampleRateIn, 0, &size, qwa_ref_sample_rate_in);

    return status;
}


/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_audio_type_for_asr
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_audio_type_for_asr(guint32* psize,gchar** pdata)
{
    gint  status = QWA_OK;

    (void*)psize;
    (void*)pdata;

    status = QWA_ERR_INVALID_ID; //TODO: ASR mode from QWA library
    pr_debug("Audio type for ASR mode from QWA library is not supported\n");

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_op_mode
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_op_mode(gint32* qwa_op_mode)
{
    gint  status = QWA_OK;
    guint32   size = sizeof(guint32);

    status = ecnr_qwa_handler_get_data(qwaOpMode, 0, &size, qwa_op_mode);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_asr_mode
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_asr_mode(guint* qwa_asr_mode)
{
    gint  status = QWA_OK;

    status = QWA_ERR_INVALID_ID; //TODO: ASR mode from QWA library
    pr_debug("ASR mode from QWA library is not supported\n");

    (void*)qwa_asr_mode;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_status_message
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
gint ecnr_qwa_handler_get_status_message(char* status_message)
{
    gint  status = QWA_OK;

    status = QWA_NO_RESULT; //TODO: status message from QWA library

    (void*)status_message;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_send_mute_switch
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_set_send_mute_switch(guchar qwa_send_mute_switch)
{
    int  status = QWA_OK;
    int lswitch = (int)qwaOff;

    if(qwa_send_mute_switch)
        lswitch = (int)qwaOn;

    status = ecnr_qwa_handler_set_data(qwaSendMuteSwitch, 0, sizeof(lswitch), (void*)&lswitch);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_send_gain_delta
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_send_gain_delta(int qwa_send_gain_delta_lvl)
{
    int  status = QWA_OK;

    (void)qwa_send_gain_delta_lvl;
    status = QWA_NO_RESULT; //TODO: rsu2kor : set SendGainDelta from QWA library

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_pass_through_mode
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_set_pass_through_mode (guchar qwa_pass_through_mode)
{
    int  status = QWA_OK;
    int iswitch = (int)qwaOff;

    if(qwa_pass_through_mode)
        iswitch = (int)qwaOn;

    pr_message("iswitch -> (%d)\n", iswitch );
    status = ecnr_qwa_handler_set_data(qwaPassThruSwitch, 0, sizeof(iswitch), (void*)&iswitch);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_nr_comb_floor
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_set_nr_comb_floor(int qwa_nr_comb_floor)
{
    int  status = QWA_OK;

    (void)qwa_nr_comb_floor;
    status = QWA_NO_RESULT; //TODO: rsu2kor : set NR Comb Floor from QWA library

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_echo_cancellation
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_set_echo_cancellation(guchar qwa_aec_state)
{
    int  status = QWA_OK;
    int iswitch = (int)qwaOff;

    if(qwa_aec_state)
        iswitch = (int)qwaOn;

    status = ecnr_qwa_handler_set_data(qwaAECSwitch, 0, sizeof(iswitch), (void*)&iswitch);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_noise_reduction
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 19.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_set_noise_reduction(guchar qwa_nr_state)
{
    int  status = QWA_OK;
    int iswitch = (int)qwaOff;

    if(qwa_nr_state)
        iswitch = (int)qwaOn;

    status = ecnr_qwa_handler_set_data(qwaNRSwitch, 0, sizeof(iswitch), (void*)&iswitch);

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_clip_stats
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_get_clip_stats
(
              int  Channel
    ,unsigned int  DataID
    ,unsigned int* ClipFrames
    ,unsigned int* ClipCount
             ,int* MaxAmp
             ,int* MinAmp
)
{
    int  status      = (int)QWA_OK;
    tQwaClipStats ClipStats = {0};
    unsigned int len = sizeof(ClipStats);

    status = ecnr_qwa_handler_get_data(DataID, Channel, &len, (void*)&ClipStats);

    *ClipFrames = ClipStats.ClipFrames;
    *ClipCount  = ClipStats.ClipCount;
    *MaxAmp     = ClipStats.MaxAmp;
    *MinAmp     = ClipStats.MinAmp;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_mic_in_clip_stats
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_get_mic_in_clip_stats
(
              int  Channel
    ,unsigned int* ClipFrames
    ,unsigned int* ClipCount
             ,int* MaxAmp
             ,int* MinAmp
)
{
    int  status      = (int)QWA_OK;

    status = ecnr_qwa_handler_get_clip_stats
             (
                Channel
               ,qwaMicClipStats
               ,ClipFrames
               ,ClipCount
               ,MaxAmp
               ,MinAmp
             );

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_ref_in_clip_stats
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_get_ref_in_clip_stats
(
              int  Channel
    ,unsigned int* ClipFrames
    ,unsigned int* ClipCount
             ,int* MaxAmp
             ,int* MinAmp
)
{
    int  status      = (int)QWA_OK;

    status = ecnr_qwa_handler_get_clip_stats
             (
                Channel
               ,qwaRefClipStats
               ,ClipFrames
               ,ClipCount
               ,MaxAmp
               ,MinAmp
             );

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_rcv_in_clip_stats
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_get_rcv_in_clip_stats
(
              int  Channel
    ,unsigned int* ClipFrames
    ,unsigned int* ClipCount
             ,int* MaxAmp
             ,int* MinAmp
)
{
    int  status      = (int)QWA_OK;

    status = ecnr_qwa_handler_get_clip_stats
             (
                Channel
               ,qwaRecvClipStats
               ,ClipFrames
               ,ClipCount
               ,MaxAmp
               ,MinAmp
             );

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_mic_out_clip_stats
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_get_mic_out_clip_stats
(
              int  Channel
    ,unsigned int* ClipFrames
    ,unsigned int* ClipCount
             ,int* MaxAmp
             ,int* MinAmp
)
{
    int  status      = (int)QWA_OK;

    status = ecnr_qwa_handler_get_clip_stats
             (
                Channel
               ,qwaMicOutClipStats
               ,ClipFrames
               ,ClipCount
               ,MaxAmp
               ,MinAmp
             );

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_get_rcv_out_clip_stats
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int  ecnr_qwa_handler_get_rcv_out_clip_stats
(
              int  Channel
    ,unsigned int* ClipFrames
    ,unsigned int* ClipCount
             ,int* MaxAmp
             ,int* MinAmp
)
{
    int  status      = (int)QWA_OK;

    status = ecnr_qwa_handler_get_clip_stats
             (
                Channel
               ,qwaRecvOutClipStats
               ,ClipFrames
               ,ClipCount
               ,MaxAmp
               ,MinAmp
             );

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_bt_phone_nb_lsim_pre
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_bt_phone_nb_lsim_pre   (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_bt_phone_nb_lsim_post
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_bt_phone_nb_lsim_post  (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_bt_phone_wb_lsim_pre
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_bt_phone_wb_lsim_pre   (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_bt_phone_wb_lsim_post
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_bt_phone_wb_lsim_post  (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_cp_phone_nb_lsim_pre
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_cp_phone_nb_lsim_pre   (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_cp_phone_nb_lsim_post
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_cp_phone_nb_lsim_post  (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_cp_phone_wb_lsim_pre
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_cp_phone_wb_lsim_pre   (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_cp_phone_wb_lsim_post
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_cp_phone_wb_lsim_post  (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_cp_voice_wb_lsim_pre
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_cp_voice_wb_lsim_pre   (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_cp_voice_wb_lsim_post
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_cp_voice_wb_lsim_post  (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_aa_voice_wb_lsim_pre
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_aa_voice_wb_lsim_pre   (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_aa_voice_wb_lsim_post
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_aa_voice_wb_lsim_post  (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_int_voice_wb_lsim_pre
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_int_voice_wb_lsim_pre  (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

/******************************************************************************
 * FUNCTION     : ecnr_qwa_handler_set_config_int_voice_wb_lsim_post
 * DESCRIPTION  :
 * PARAMETER    :
 * RETURN VALUE :
 * HISTORY      :
 * Date         | Author                 | Modification
 * 08.03.2019   | Ranjit Susal(RBEI/ECO) | Initial Revision
 *****************************************************************************/
int ecnr_qwa_handler_set_config_int_voice_wb_lsim_post (void)
{
    int  status = QWA_OK;

    status = QWA_NO_RESULT;

    return status;
}

#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_GMG3_LINUX

