/******************************************************************************
 * FILE        : ecnr-trace.h
 * PROJECT     : Gen3 & Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2017 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 26.04.2017  | Patrick Rey            | initial version
 *             |                        | TTFIS trace class feature handling
 *****************************************************************************/

#ifndef __ECNR_TRACE_H__
#define __ECNR_TRACE_H__

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#define TR_CLASS_ECNR              (TR_COMP_AUDIOSTACK + 0x07)
#define TR_CLASS_ECNR_RTS          (TR_COMP_AUDIOSTACK + 0x09)
#define TR_CLASS_ECNR_ALSA         (TR_COMP_AUDIOSTACK + 0x0A)
#define TR_CLASS_ECNR_CONFIG       (TR_COMP_AUDIOSTACK + 0x0B)
#define TR_CLASS_ECNR_SERVICE      (TR_COMP_AUDIOSTACK + 0x0C)
#define TR_CLASS_ECNR_ENGINE       (TR_COMP_AUDIOSTACK + 0x12)
#define TR_CLASS_ECNR_ENGINE_BE    (TR_COMP_AUDIOSTACK + 0x13)


#endif /* __ECNR_TRACE_H__ */
////////////////////////////////////////////////////////////////////////////////
// <EOF>
