/******************************************************************************
 * FILE        : ecnr-qwa-handler.h
 * PROJECT     : Gen3
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2013 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 19.08.2013  | Patrick Rey            | initial version
 * 04.03.2014  | Patrick Rey            | QWA engine feature handling
 *****************************************************************************/

#ifndef __ECNR_QWA_HANDLER_H__
#define __ECNR_QWA_HANDLER_H__


/** Maximum length of status string (including null termination) */
#define ECNR_QWA_MAX_STRING_LEN    256 /* defined from QWA_MAX_STRING_LEN*/

extern int ecnr_qwa_handler_audio_in(stecnr_alsa_state* pstate);
extern int ecnr_qwa_handler_audio_out(stecnr_alsa_state* pstate);
extern int ecnr_qwa_handler_create(void);
extern int ecnr_qwa_handler_get_data
(
             int  dataId,
             int  channel,
    unsigned int* psize,
            void* pdata
);
extern int ecnr_qwa_handler_set_data
(
             int  dataId,
             int  channel,
    unsigned int  size,
            void* pdata
);
extern int ecnr_qwa_handler_initialize(void* pvQwaCfg);
extern int ecnr_qwa_handler_set_config(void* pvQwaCfg);
extern int ecnr_qwa_handler_create_session(unsigned short ConfigId);
extern int ecnr_qwa_handler_reset(void);
extern int ecnr_qwa_handler_destroy(void);
extern int ecnr_qwa_handler_check_operating_mode(void);
extern int ecnr_qwa_handler_set_configuration(unsigned short ConfigId);
extern int ecnr_qwa_get_status_message(signed char   StatusMessage[ECNR_QWA_MAX_STRING_LEN]);
extern void ecnr_qwa_get_version
(
    const unsigned short*   pVersionArray[4],
    const   signed  char**  ppVersionString,
    const   signed  char**  ppVersionComment
);
extern unsigned short ecnr_qwa_get_current_config_id(void);
extern void* ecnr_qwa_get_qwa_engine_handler(void);

extern unsigned char *ecnr_qwa_handler_get_binary_config(unsigned short ecnr_cfg_id, unsigned short* size);
extern int ecnr_qwa_set_handler_binary_config(unsigned short ecnr_cfg_id, const unsigned char* cfg, unsigned short size);
extern int ecnr_qwa_handler_create_instance(void);
extern int ecnr_qwa_free_binary_config(unsigned short ecnr_cfg_id);
extern void ecnr_qwa_handler_init(void);
extern void ecnr_qwa_handler_close(void);
extern void ecnr_qwa_handler_print_rcs_configuration(void);

extern gint ecnr_qwa_handler_get_micin_count             (guint* qwa_mic_in_cnt);
extern gint ecnr_qwa_handler_get_mic_proc_count          (guint* qwa_mic_proc_cnt);
extern gint ecnr_qwa_handler_get_refin_count             (guint* qwa_ref_in_cnt);
extern gint ecnr_qwa_handler_get_recvin_count            (guint* qwa_recv_in_cnt);
extern gint ecnr_qwa_handler_get_frame_shift_in          (guint* qwa_frame_shift_in);
extern gint ecnr_qwa_handler_get_frame_shift_out         (guint* qwa_frame_shift_out);
extern gint ecnr_qwa_handler_get_recv_frame_shift_in     (guint* qwa_recv_frame_shift_in);
extern gint ecnr_qwa_handler_get_recv_frame_shift_out    (guint* qwa_recv_frame_shift_out);
extern gint ecnr_qwa_handler_get_ref_frame_shift_in      (guint* qwa_ref_frame_shift_in);
extern gint ecnr_qwa_handler_get_sample_rate_in          (guint* qwa_sample_rate_in);
extern gint ecnr_qwa_handler_get_sample_rate_out         (guint* qwa_sample_rate_out);
extern gint ecnr_qwa_handler_get_recv_sample_rate_in     (guint* qwa_recv_sample_rate_in);
extern gint ecnr_qwa_handler_get_recv_sample_rate_out    (guint* qwa_recv_sample_rate_out);
extern gint ecnr_qwa_handler_get_ref_sample_rate_in      (guint* qwa_ref_sample_rate_in);
extern gint ecnr_qwa_handler_get_audio_type_for_asr      (guint32* psize,gchar** pdata);
extern gint ecnr_qwa_handler_get_op_mode                 (gint32* qwa_op_mode);
extern gint ecnr_qwa_handler_get_asr_mode                (guint* qwa_asr_mode);
extern gint ecnr_qwa_handler_get_status_message          (char* status_message);

extern int  ecnr_qwa_handler_get_clip_stats              (          int  Channel
                                                          ,unsigned int  DataID
                                                          ,unsigned int* ClipFrames
                                                          ,unsigned int* ClipCount
                                                                   ,int* MaxAmp
                                                                   ,int* MinAmp);

extern int  ecnr_qwa_handler_get_mic_in_clip_stats       (          int  Channel
                                                          ,unsigned int* ClipFrames
                                                          ,unsigned int* ClipCount
                                                                   ,int* MaxAmp
                                                                   ,int* MinAmp);

extern int  ecnr_qwa_handler_get_ref_in_clip_stats       (          int  Channel
                                                          ,unsigned int* ClipFrames
                                                          ,unsigned int* ClipCount
                                                                   ,int* MaxAmp
                                                                   ,int* MinAmp);

extern int  ecnr_qwa_handler_get_rcv_in_clip_stats       (          int  Channel
                                                          ,unsigned int* ClipFrames
                                                          ,unsigned int* ClipCount
                                                                   ,int* MaxAmp
                                                                   ,int* MinAmp);

extern int  ecnr_qwa_handler_get_mic_out_clip_stats       (          int  Channel
                                                          ,unsigned int* ClipFrames
                                                          ,unsigned int* ClipCount
                                                                   ,int* MaxAmp
                                                                   ,int* MinAmp);

extern int  ecnr_qwa_handler_get_rcv_out_clip_stats       (          int  Channel
                                                          ,unsigned int* ClipFrames
                                                          ,unsigned int* ClipCount
                                                                   ,int* MaxAmp
                                                                   ,int* MinAmp);

extern int  ecnr_qwa_handler_set_send_mute_switch         (guchar qwa_send_mute_switch);
extern int  ecnr_qwa_handler_set_send_gain_delta          (int qwa_send_gain_delta_lvl);
extern int  ecnr_qwa_handler_set_pass_through_mode        (guchar qwa_pass_through_mode);
extern int  ecnr_qwa_handler_set_nr_comb_floor            (int qwa_nr_comb_floor);
extern int  ecnr_qwa_handler_set_echo_cancellation        (guchar qwa_aec_state);
extern int  ecnr_qwa_handler_set_noise_reduction          (guchar qwa_nr_state);


/* functional interface for QWA configuration parameter set for LSIM */

extern int ecnr_qwa_handler_set_config_bt_phone_nb_lsim_pre   (void);
extern int ecnr_qwa_handler_set_config_bt_phone_nb_lsim_post  (void);
extern int ecnr_qwa_handler_set_config_bt_phone_wb_lsim_pre   (void);
extern int ecnr_qwa_handler_set_config_bt_phone_wb_lsim_post  (void);
extern int ecnr_qwa_handler_set_config_cp_phone_nb_lsim_pre   (void);
extern int ecnr_qwa_handler_set_config_cp_phone_nb_lsim_post  (void);
extern int ecnr_qwa_handler_set_config_cp_phone_wb_lsim_pre   (void);
extern int ecnr_qwa_handler_set_config_cp_phone_wb_lsim_post  (void);
extern int ecnr_qwa_handler_set_config_cp_voice_wb_lsim_pre   (void);
extern int ecnr_qwa_handler_set_config_cp_voice_wb_lsim_post  (void);
extern int ecnr_qwa_handler_set_config_aa_voice_wb_lsim_pre   (void);
extern int ecnr_qwa_handler_set_config_aa_voice_wb_lsim_post  (void);
extern int ecnr_qwa_handler_set_config_int_voice_wb_lsim_pre  (void);
extern int ecnr_qwa_handler_set_config_int_voice_wb_lsim_post (void);

#endif /* __ECNR_QWA_HANDLER_H__ */

