/******************************************************************************
 * FILE        : ecnr_ioctrl.h
 * PROJECT     : Gen3 and Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2015 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 13.07.2015  | Patrick Rey            | initial version for Gen3
 *             |                        | GPIO feature handling
 *****************************************************************************/

#ifndef __ECNR_IOCTRL_H__
#define __ECNR_IOCTRL_H__

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>




typedef struct _ecnr_ioctrl_cfg
{
    OSAL_enGpioPins egpio;
    gboolean state;
    gboolean restore;
}ecnr_ioctrl_cfg;


extern gboolean ecnr_ioctrl_create(void);
extern gboolean ecnr_ioctrl_finalize(void);
extern guint32  ecnr_ioctrl_get_last_Error_code(void);
extern gboolean ecnr_ioctrl_set_pin_state(int egpio, gboolean state);




#endif /* __ECNR_IOCTRL_H__ */
