/******************************************************************************
 * FILE        : ecnr-engine-handler.h
 * PROJECT     : Gen3 & Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2013 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 20.08.2013  | Patrick Rey            | initial version
 * 08.03.2019  | Ranjit Susal(RBEI/ECO) | extended set/get functionality
 *****************************************************************************/

#ifndef __ECNR_ENGINE_HANDLER_H__
#define __ECNR_ENGINE_HANDLER_H__


/***********************************/
/*  defintion of ecngine parameter */
/***********************************/




/***********************************/
/*  module function declaration    */
/***********************************/

extern int ecnr_engine_handler_process_audio (stecnr_alsa_state* pstate);
extern int ecnr_engine_handler_process_audio_with_debug_data (stecnr_alsa_state* pstate, gint* restart);
extern int ecnr_engine_handler_create_session(unsigned short ConfigId);
extern int ecnr_engine_handler_set_configuration (unsigned short ConfigId);
extern int ecnr_engine_handler_ecnr_engine_reset(void);
extern int ecnr_engine_handler_destroy(void);
extern int ecnr_engine_handler_check_operating_mode(void);

extern unsigned short ecnr_engine_get_current_config_id(void);
extern int ecnr_engine_end_debug_session(void);
extern int ecnr_engine_start_debug_session(void);
extern gboolean ecnr_engine_is_debug_session_active(void);
extern int ecnr_engine_clean_on_audio_end(void);


extern void ecnr_engine_get_version(unsigned int* pArrayLen,
        const int**         pVersionArray,
        const char**        pVersionString,
        const char**        pVersionComment);

extern void ecnr_engine_load_default_data_set(void);
extern void ecnr_engine_handler_performance_enable(gboolean state);

extern gint ecnr_engine_handler_get_micin_count             (guint* ecnr_mic_in_cnt);
extern gint ecnr_engine_handler_get_mic_proc_count          (guint* ecnr_mic_proc_cnt);
extern gint ecnr_engine_handler_get_refin_count             (guint* ecnr_ref_in_cnt);
extern gint ecnr_engine_handler_get_recvin_count            (guint* ecnr_recv_in_cnt);
extern gint ecnr_engine_handler_get_frame_shift_in          (guint* ecnr_frame_shift_in);
extern gint ecnr_engine_handler_get_frame_shift_out         (guint* ecnr_frame_shift_out);
extern gint ecnr_engine_handler_get_recv_frame_shift_in     (guint* ecnr_recv_frame_shift_in);
extern gint ecnr_engine_handler_get_recv_frame_shift_out    (guint* ecnr_recv_frame_shift_out);
extern gint ecnr_engine_handler_get_ref_frame_shift_in      (guint* ecnr_ref_frame_shift_in);
extern gint ecnr_engine_handler_get_sample_rate_in          (guint* ecnr_sample_rate_in);
extern gint ecnr_engine_handler_get_sample_rate_out         (guint* ecnr_sample_rate_out);
extern gint ecnr_engine_handler_get_recv_sample_rate_in     (guint* ecnr_recv_sample_rate_in);
extern gint ecnr_engine_handler_get_recv_sample_rate_out    (guint* ecnr_recv_sample_rate_out);
extern gint ecnr_engine_handler_get_ref_sample_rate_in      (guint* ecnr_ref_sample_rate_in);
extern gint ecnr_engine_handler_get_audio_type_for_asr      (guint32* psize, gchar** pdata);
extern gint ecnr_engine_handler_get_op_mode                 (gint32* ecnr_op_mode);
extern gint ecnr_engine_handler_get_asr_mode                (guint* ecnr_asr_mode);
extern gint ecnr_engine_handler_get_status_message          (char** status_message);

extern int  ecnr_engine_handler_get_clip_stats              (          int  Channel
                                                             ,unsigned int  DataID
                                                             ,unsigned int* ClipFrames
                                                             ,unsigned int* ClipCount
                                                                      ,int* MaxAmp
                                                                      ,int* MinAmp);

extern int  ecnr_engine_handler_get_mic_in_clip_stats       (          int  Channel
                                                             ,unsigned int* ClipFrames
                                                             ,unsigned int* ClipCount
                                                                      ,int* MaxAmp
                                                                      ,int* MinAmp);

extern int  ecnr_engine_handler_get_ref_in_clip_stats       (          int  Channel
                                                             ,unsigned int* ClipFrames
                                                             ,unsigned int* ClipCount
                                                                      ,int* MaxAmp
                                                                      ,int* MinAmp);

extern int  ecnr_engine_handler_get_rcv_in_clip_stats       (          int  Channel
                                                             ,unsigned int* ClipFrames
                                                             ,unsigned int* ClipCount
                                                                      ,int* MaxAmp
                                                                      ,int* MinAmp);

extern int  ecnr_engine_handler_get_mic_out_clip_stats      (          int  Channel
                                                             ,unsigned int* ClipFrames
                                                             ,unsigned int* ClipCount
                                                                      ,int* MaxAmp
                                                                      ,int* MinAmp);

extern int  ecnr_engine_handler_get_rcv_out_clip_stats      (          int  Channel
                                                             ,unsigned int* ClipFrames
                                                             ,unsigned int* ClipCount
                                                                      ,int* MaxAmp
                                                                      ,int* MinAmp);

extern int ecnr_engine_handler_set_send_mute_switch         (guchar ecnr_send_mute_switch);
extern int ecnr_engine_handler_set_send_gain_delta          (int ecnr_send_gain_delta_lvl);
extern int ecnr_engine_handler_set_pass_through_mode        (guchar ecnr_pass_through_mode);
extern int ecnr_engine_handler_set_nr_comb_floor            (int ecnr_nr_comb_floor);
extern int ecnr_engine_handler_set_echo_cancellation        (guchar ecnr_aec_state);
extern int ecnr_engine_handler_set_noise_reduction          (guchar ecnr_nr_state);


/* functional interface for engine configuration parameter set
 * for AA VOICE WB feature(actual hardware)
 */

extern int ecnr_engine_handler_set_config_aa_voice_wb_pre  (void);
extern int ecnr_engine_handler_set_config_aa_voice_wb_post (void);


/* functional interface for engine configuration parameter set for LSIM */

extern int ecnr_engine_handler_set_config_bt_phone_nb_lsim_pre   (void);
extern int ecnr_engine_handler_set_config_bt_phone_nb_lsim_post  (void);
extern int ecnr_engine_handler_set_config_bt_phone_wb_lsim_pre   (void);
extern int ecnr_engine_handler_set_config_bt_phone_wb_lsim_post  (void);

extern int ecnr_engine_handler_set_config_cp_phone_nb_lsim_pre   (void);
extern int ecnr_engine_handler_set_config_cp_phone_nb_lsim_post  (void);
extern int ecnr_engine_handler_set_config_cp_phone_wb_lsim_pre   (void);
extern int ecnr_engine_handler_set_config_cp_phone_wb_lsim_post  (void);
extern int ecnr_engine_handler_set_config_cp_voice_wb_lsim_pre   (void);
extern int ecnr_engine_handler_set_config_cp_voice_wb_lsim_post  (void);
extern int ecnr_engine_handler_set_config_aa_voice_wb_lsim_pre   (void);
extern int ecnr_engine_handler_set_config_aa_voice_wb_lsim_post  (void);

extern int ecnr_engine_handler_set_config_int_voice_wb_lsim_pre  (void);
extern int ecnr_engine_handler_set_config_int_voice_wb_lsim_post (void);




#endif /* __ECNR_ENGINE_HANDLER_H__ */

