/******************************************************************************
 * FILE        : ecnr-common-defs.h
 * PROJECT     : Gen3 and Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2013 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 30.08.2013  | Patrick Rey            | initial version
 *             |                        | common defines handling
 *****************************************************************************/


#ifndef __ECNR_COMMON_DEFS_H__
#define __ECNR_COMMON_DEFS_H__

#include <stdio.h>
#include <stdint.h>

#include "vd_diaglog_itc_definition.h"
#include "ecnr-error.h"


/***************************
 * DBUS specific defines
 */
#define ECNRSERVICE_SERVER_PATH "/org/bosch/vrns/handsfree/ecnrservice"
#define ECNRSERVICE_SERVER_NAME "org.bosch.vrns.handsfree.ecnrservice"


/****************
 * build defines
 */
//#define D_RESET_ANALYSE
#define D_AUDIO_EXIT_W_JOINED


/*****************************
 * ecnr configuration defines
 */
#define ECNR_APPID_ADMIN 33
#define ECNR_DP_DESC_MAX 7
#define D_SAFE_MAX_LOOP_ECNR_CONFIGURATION 100

/*******************
 * feature defines
 */
#define ECNR_DEBUG_WAIT_DATA (guint)2000   // 2 ms
#define DEBUG_TIGGER_FILE "/opt/bosch/audiomanager/bin/ecnr_sse_debug_enable.txt"
#define TUNING_ENABLE_FILE "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_tuning_enable.txt"

#define D_ECNR_USE_MAX_DP_SIZE 20000
//#define D_TRIGGER_PERFORMANCE_TEST
#define D_LOG_WITH_TIME_STAMP
//#define D_INCREASE_ECNR_START_UP_PERFORMANCE
#define D_ENABLE_DEV_ORDER_CHECK
//#define D_FEAT_ADAPT_PREFILL_TO_BSD_FILE_CONTENT
//#define D_SET_INVIDUAL_PREFILL_PER_DEV
#define D_ENABLE_RTS_LOG_CB

/***********
 * Macro definition
 */


#define ARRAYSIZE(x)  (sizeof(x)/sizeof(x[0]))



#define  ecnr_debug(status, fmtstr, args...) \
         g_debug("%s: %s (%d): " fmtstr, __FUNCTION__, \
         ecnr_error_str(status), status, ##args)

#ifndef D_LOG_WITH_TIME_STAMP
#define pr_message(fmtstr, args...) \
        g_message("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_debug(fmtstr, args...) \
        g_debug("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_warning(fmtstr, args...) \
        g_warning("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_critical(fmtstr, args...) \
        g_critical("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_error(fmtstr, args...) \
        g_error("%s: " fmtstr, __FUNCTION__, ##args)

#else

#define pr_message(fmtstr, args...) {struct timespec ts; \
                        clock_gettime(CLOCK_MONOTONIC, &ts);\
                        g_message("ecnr time [%05u,%lu] - %s: " fmtstr,(unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#define pr_debug(fmtstr, args...) {struct timespec ts; \
                        clock_gettime(CLOCK_MONOTONIC, &ts); \
                        g_debug("ecnr time [%05u,%lu] - %s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#define pr_warning(fmtstr, args...) {struct timespec ts; \
                        clock_gettime(CLOCK_MONOTONIC, &ts); \
                        g_warning("ecnr time [%05u,%lu] - %s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#define pr_critical(fmtstr, args...) {struct timespec ts; \
                        clock_gettime(CLOCK_MONOTONIC, &ts); \
                        g_critical("ecnr time [%05u,%lu] - %s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#define pr_error(fmtstr, args...) {struct timespec ts; \
                        clock_gettime(CLOCK_MONOTONIC, &ts); \
                        g_error("ecnr time [%05u,%lu] - %s: " fmtstr, (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, __FUNCTION__, ##args);}
#endif


#define ecnr_message(status, fmtstr, args...) \
        g_message("%s: %s (%d): " fmtstr, __FUNCTION__, \
    ecnr_error_str(status), status, ##args)
#define ecnr_warning(status, fmtstr, args...) \
        g_warning("%s: %s (%d): " fmtstr, __FUNCTION__, \
    ecnr_error_str(status), status, ##args)
#define ecnr_critical(status, fmtstr, args...) \
        g_critical("%s: %s (%d): " fmtstr, __FUNCTION__, \
    ecnr_error_str(status), status, ##args)
#define ecnr_error(status, fmtstr, args...) \
        g_error("%s: %s (%d): " fmtstr, __FUNCTION__, \
    ecnr_error_str(status), status, ##args)

#define rcs_message(status, fmtstr, args...) \
        g_message("%s: %s (%d): " fmtstr, __FUNCTION__, \
    qwa_rcs_error_str(status), status, ##args)
#define rcs_warning(status, fmtstr, args...) \
        g_warning("%s: %s (%d): " fmtstr, __FUNCTION__, \
    qwa_rcs_error_str(status), status, ##args)
#define rcs_critical(status, fmtstr, args...) \
        g_critical("%s: %s (%d): " fmtstr, __FUNCTION__, \
    qwa_rcs_error_str(status), status, ##args)
#define rcs_error(status, fmtstr, args...) \
        g_error("%s: %s (%d): " fmtstr, __FUNCTION__, \
    qwa_rcs_error_str(status), status, ##args)


#define ECNR_PRINT_TIME(_S_) {struct timespec ts; \
                     clock_gettime(CLOCK_MONOTONIC, &ts); \
                     pr_debug("ecnr time [%05u,%lu] - [%s]", (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, _S_);}


#define ECNR_PRINT_TIME_DBG(_S_) {struct timespec ts; \
                     clock_gettime(CLOCK_MONOTONIC, &ts); \
                     pr_debug("ecnr time [%05u,%lu] - [%s]", (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, _S_);}

#define ECNR_PRINT_TIME_MSG(_S_) {struct timespec ts; \
                     clock_gettime(CLOCK_MONOTONIC, &ts); \
                     pr_message("ecnr time [%05u,%lu] - [%s]", (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, _S_);}

#define ECNR_PRINT_TIME_WARN(_S_) {struct timespec ts; \
                     clock_gettime(CLOCK_MONOTONIC, &ts); \
                     pr_warning("ecnr time [%05u,%lu] - [%s]", (unsigned int)ts.tv_sec, (unsigned long int)ts.tv_nsec, _S_);}



/*****************************
 * Module specific defines
 */

#define D_DP_ALL_INFO_ITEMS_SIZE       20  // nb version (16), nb dpsize (2) , nb crc (2)
#define D_NB_CHAR_VERSION         (int)16
#define D_NB_CHAR_SIZE_DP         (int)2
#define D_NB_CHAR_CRC_DP          (int)2
#define D_POS_VERSION             (int)0
#define D_POS_SIZE_DP             (int)16
#define D_POS_DATASET_DP          (int)18
#define D_POS_CRC_DP              (int)2018 //1618


//#define ECNR_START_STOP_TIMEOUT 3000000
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
    #define ECNR_START_STOP_TIMEOUT 6000 //for psa only 25.04.2017  as workaround 3000 /* 3000 miliseconds = 3 sec */
#else
    #define ECNR_START_STOP_TIMEOUT 3000 // 6000 for psa only 25.04.2017  as workaround 3000 /* 3000 miliseconds = 3 sec */
#endif

#ifdef D_AUDIO_EXIT_W_JOINED
#define ECNR_EXIT_TIMEOUT 0
#else
#define ECNR_EXIT_TIMEOUT 3000
#endif

#define ECNR_DEBUG_START_STOP_TIMEOUT 1000 /* 1000 miliseconds = 1 Sec */


#define ECNR_MIN_SILENCE_WRITE_COUNT_BEFORE_MIC_SIGNAL 5 /*Write 5 silence before switching to Mic data at first prompt, for SDS gen4, To resolve NO_FRAME_SYNC error*/
#define ECNR_MIN_SILENCE_WRITE_COUNT_IN_STATE_SILENCE  4 /*Write 4 silence before switching to Mic data at subsequent prompts, for SDS gen4, To resolve NO_FRAME_SYNC error*/
#define ECNR_MIN_SILENCE_WRITE_COUNT_IN_WAIT_RECOVER   2

/* TASK ID     : CMG3G-12857
 * Description : IS3285_A-IVI DBUS Diaglog client for logical block test@EC/NR
 * ITC definition are available in below path:
 * di_middleware_server/components/vd_diaglog/project/framework/vd_diaglog_itc_definition.h
 */
#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_01
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_01         0x8601 //--> PHONE_ECNR_NBS , 34305
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_02
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_02         0x8602 //--> PHONE_ECNR_WBS
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_03
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_03         0x8603 //--> VR_PARAM
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_04
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_04         0x8604 //--> CARPLAY_PHONE_ECNR_NBS
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_05
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_05         0x8605 //--> CARPLAY_PHONE_ECNR_WBS
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_06
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_06         0x8606 //--> CARPLAY_FACETIME_ECNR_SWB
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_09
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_09         0x8609 //--> BT_VOICE_ECNR_NBS
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0A
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0A         0x860A //--> BT_VOICE_ECNR_WBS
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0B
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0B         0x860B //--> BT_SIRI_ECNR_WBS
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0C
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0C         0x860C //--> CARPLAY_VOICE_ECNR_WBS
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0D
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0D         0x860D //--> ANDROIDAUTO_VOICE_ECNR_WBS
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0E
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0E         0x860E //--> VPA_ECNR_WBS
#endif

#ifndef ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0F
#define ITC_AIVI_CAL_ALGORITHM_BASED_FAILURE_LB_0F         0x860F //--> WUW_ECNR_WBS
#endif

/*ecnr properties definition */

#define ecnrAsrMode         92 //sse_ASRMode          // 92,  SSE specific parameter
#define ecnrAsrDataType     91 //sse_AudioTypeForASR  // 91,  SSE specific parameter
#define ecnrAudioState      100
#define ecnrMicLvlNtfyInterval 101

enum eDataPool{
    ECNR_DP_NOT_DEF = 0,
    ECNR_DP_BT_PHONE_NB,
    ECNR_DP_BT_PHONE_WB,
    ECNR_DP_BT_VOICE_NB,
    ECNR_DP_BT_VOICE_WB,
    ECNR_DP_BT_SIRI_NB,
    ECNR_DP_BT_SIRI_WB,
    ECNR_DP_CP_VOICE_NB,
    ECNR_DP_CP_VOICE_WB,
    ECNR_DP_CP_VOICE_SWB,
    ECNR_DP_CP_PHONE_NB,
    ECNR_DP_CP_PHONE_WB,
    ECNR_DP_CP_PHONE_SWB,
    ECNR_DP_CP_FTIME_SWB,
    ECNR_DP_AA_VOICE_NB,
    ECNR_DP_AA_VOICE_WB,
    ECNR_DP_AA_VOICE_SWB,
    ECNR_DP_AA_PHONE_NB,
    ECNR_DP_AA_PHONE_WB,
    ECNR_DP_AA_PHONE_SWB,
    ECNR_DP_INT_VOICE_NB,
    ECNR_DP_INT_VOICE_WB,
    ECNR_DP_WUW_VOICE_WB,
    ECNR_DP_VPA_VOICE_WB,
    ECNR_DP_LAST
};

enum ecnr_audio {
  ECNR_MIC_IN0                   = 0,
  ECNR_MIC_IN1                   = 1,
  ECNR_MIC_OUT                   = 2,
  ECNR_RECV_IN                   = 3,
  ECNR_RECV_OUT                  = 4,
//  ECNR_REF_IN = 5,
  ECNR_REF_IN0                   = 5,
  ECNR_REF_IN1                   = 6,
  ECNR_MULTI_CHAN_IN_DEV         = 7,
  ECNR_MULTI_CHAN_IN_MIC_0       = 8,
  ECNR_MULTI_CHAN_IN_MIC_1       = 9,
//  ECNR_MULTI_CHAN_IN_REF = 9,
  ECNR_MULTI_CHAN_IN_REF_0       = 10,
  ECNR_MULTI_CHAN_IN_REF_1       = 11,
  ECNR_SET_PLB_DEV_PER_STRING    = 12,
  ECNR_SET_CAP_DEV_PER_STRING    = 13,
  ECNR_DUP_MIC_OUT               = 14,
  NUM_ECNR_AUDIO                 = 15
};

enum eEcnrITCTestResult {
    ECNR_ITC_PASSED     = 0,
    ECNR_ITC_FAILED     = 1,
    ECNR_ITC_NORESULT   = 2
};

struct ecnr_rts_stream_cfg
{
    unsigned int frame_shift;
    unsigned int sample_rate;
    unsigned int prefill_ms;
};


struct ecnr_rts_dev_cfg
{
    enum ecnr_audio rts_dev;
             char*  adev_name;
    unsigned int    num_channel;
    unsigned int    active_channel;
    unsigned int    dev_open_order;
    int             is_default_dev;
};


typedef struct _datapool_descriptor
{
    const char*     dp_class_name;
    enum eDataPool  dp_idx;
}datapool_descriptor;


typedef enum _ecnrAudioState
{
  ECNR_AS_STREAM_UNDEFINED = -1,
  ECNR_AS_STREAM_SILENCE   =  0, //0
  ECNR_AS_STREAM_INIT,           //1
  ECNR_AS_STREAM_WAIT_DATA,      //2
  ECNR_AS_STREAM_RUNNING,        //3
  ECNR_AS_STREAM_WAIT_RECOVER,   //4
  ECNR_AS_STREAM_STOP,           //5
  ECNR_AS_STREAM_TERMINATED,     //6
  ECNR_AS_STREAM_ERROR           //7
}ecnr_audio_state;

typedef struct _AudioStateDesc
{
    ecnr_audio_state    code; // tQwaInt code;
    const  char*         str;
}AudioStateDesc;


typedef enum _log_type
{
  ecnr_log_type_init_from_dp = 0,
  ecnr_log_type_init_from_default,
  ecnr_log_type_load_new_dp
}ecnr_log_type;

#define ECNR_AUDIO_STATE(name) { name, #name }

#endif /* __ECNR_COMMON_DEFS_H__ */
