/******************************************************************************
 * FILE        : ecnr-audio-recording.h
 * PROJECT     : Gen3 & Gen4
 * SW-COMPONENT: ECNR
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION : Echo Cancellation and Noise Reduction Engine
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT   : (c) 2017 RBCM GMBH
 * HISTORY     :
 * Date        | Author                 | Modification
 * 10.11.2017  | Patrick Rey            | initial version
 *             |                        | audio stream recording features
 *****************************************************************************/

#ifndef __ECNR_AUDIO_RECORDING_H__
#define __ECNR_AUDIO_RECORDING_H__


typedef struct _record_desc
{
    FILE*                       file_in_pcm;
    FILE*                       file_out_pcm;
    gchar*                      rec_in_dev;
    gchar*                      rec_out_dev;
    gchar                       rec_file_name[300];
    struct timespec             rec_in_time_start_record;
    struct timespec             rec_in_time_stop_record;
    struct timespec             rec_out_time_start_record;
    struct timespec             rec_out_time_stop_record;
    size_t                      rdata;
    size_t                      wdata;
    long int                    rpos;
    guint8                      in_rec_active;
    guint8                      out_rec_active;
    guint8                      ref_rec_active;
    guint8                      init;

    /*audio buffer */
    guint8**                    AudRamBufChannels_out;
    guint8**                    AudRamBufChannels_in;
    guint                       wr_data_out_ptr;
    gboolean                    start_stop_rec_out;
    guint                       wr_data_in_ptr;
    gboolean                    start_stop_rec_in;
}record_desc;


extern record_desc      mic_rec_desc;
extern record_desc      rcv_rec_desc;
extern record_desc      ref_rec_desc;


/* recording functions */
extern  void    ecnr_audio_recording_new(void);
extern  void    ecnr_audio_recording_init(void);
extern  void    ecnr_audio_recording_stop(void);
extern  void    ecnr_audio_recording_restart(void);
extern  void    ecnr_audio_recording_next_record(void);
extern  int     ecnr_audio_recording_mic_rec_file_reopen(void);
extern  int     ecnr_audio_recording_rcv_rec_file_reopen(void);
extern  void    ecnr_audio_recording_enable_mic_rec(void);
extern  void    ecnr_audio_recording_enable_rcv_rec(void);
extern  void    ecnr_audio_recording_export_rec(enum ecnr_audio ecnr_id);
extern  int     ecnr_audio_recording_is_rec_active(enum ecnr_audio ecnr_id);
extern  int     ecnr_audio_recording_mic_pb_stream_rec_file_write(void);
extern  int     ecnr_audio_recording_rcv_pb_stream_rec_file_write(void);
extern  int     ecnr_audio_recording_mic_cap_stream_rec_file_write(void);
extern  int     ecnr_audio_recording_rcv_cap_stream_rec_file_write(void);






#endif //__ECNR_AUDIO_RECORDING_H__
