                  
                  
// ECNR configuration for the Project inf4cv
// baseline G3G-ECNR-Configurations-v0.26-changes_inf4cv.xlsm
                  
#ifndef __ECNR_CONFIGURATION_DATA_H__           
#define __ECNR_CONFIGURATION_DATA_H__           
                  

#ifdef ECNR_S_IMPORT_INTERFACE_DP_ONLY
static datapool_descriptor dp_info[] =
{
/* definition of symbols related to datapool access class  */
    {
#define dp_tclECNR_BT_PHONE_NB        dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneNB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneNB          ",
        .dp_idx         = ECNR_DP_BT_PHONE_NB                     
    },
    {
#define dp_tclECNR_BT_PHONE_WB        dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneWB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneWB          ",
        .dp_idx         = ECNR_DP_BT_PHONE_WB                     
    },
    {
#define dp_tclECNR_BT_VOICE_NB        dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB          ",
        .dp_idx         = ECNR_DP_BT_VOICE_NB                     
    },
    {
#define dp_tclECNR_BT_VOICE_WB        dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB          ",
        .dp_idx         = ECNR_DP_BT_VOICE_WB                     
    },
    {
#ifdef     ECNR_BT_SIRI_NB                         
#define dp_tclECNR_BT_SIRI_NB         dp_tclDPAID_DatasetEcnrDataEcnrBtSiriNB           
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtSiriNB           ",
#else 
#define dp_tclECNR_BT_SIRI_NB         dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB",
#endif
        .dp_idx         = ECNR_DP_BT_SIRI_NB                      
    },
    {
#ifdef     ECNR_BT_SIRI_WB                         
#define dp_tclECNR_BT_SIRI_WB         dp_tclDPAID_DatasetEcnrDataEcnrBtSiriWB           
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtSiriWB           ",
#else 
#define dp_tclECNR_BT_SIRI_WB         dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB",
#endif
        .dp_idx         = ECNR_DP_BT_SIRI_WB                      
    },
    {
#ifdef     ECNR_CP_PHONE_NB                        
#define dp_tclECNR_CP_PHONE_NB        dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneNB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneNB          ",
#else 
#define dp_tclECNR_CP_PHONE_NB        dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneNB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneNB",
#endif
        .dp_idx         = ECNR_DP_CP_PHONE_NB                     
    },
    {
#ifdef     ECNR_CP_PHONE_WB                        
#define dp_tclECNR_CP_PHONE_WB        dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneWB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneWB          ",
#else 
#define dp_tclECNR_CP_PHONE_WB        dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneWB",
#endif
        .dp_idx         = ECNR_DP_CP_PHONE_WB                     
    },
    {
#ifdef     ECNR_CP_PHONE_SWB                       
#define dp_tclECNR_CP_PHONE_SWB       dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneSWB         
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneSWB         ",
#else 
#define dp_tclECNR_CP_PHONE_SWB       dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneWB",
#endif
        .dp_idx         = ECNR_DP_CP_PHONE_SWB                    
    },
    {
#ifdef     ECNR_CP_VOICE_NB                        
#define dp_tclECNR_CP_VOICE_NB        dp_tclDPAID_DatasetEcnrDataEcnrCpVoiceNB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpVoiceNB          ",
#else 
#define dp_tclECNR_CP_VOICE_NB        dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB",
#endif
        .dp_idx         = ECNR_DP_CP_VOICE_NB                     
    },
    {
#ifdef     ECNR_CP_VOICE_WB                        
#define dp_tclECNR_CP_VOICE_WB        dp_tclDPAID_DatasetEcnrDataEcnrCpVoiceWB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpVoiceWB          ",
#else 
#define dp_tclECNR_CP_VOICE_WB        dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB",
#endif
        .dp_idx         = ECNR_DP_CP_VOICE_WB                     
    },
    {
#ifdef     ECNR_CP_VOICE_SWB                       
#define dp_tclECNR_CP_VOICE_SWB       dp_tclDPAID_DatasetEcnrDataEcnrCpVoiceSWB         
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpVoiceSWB         ",
#else 
#define dp_tclECNR_CP_VOICE_SWB       dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB",
#endif
        .dp_idx         = ECNR_DP_CP_VOICE_SWB                    
    },
    {
#ifdef     ECNR_CP_FACETIME_SWB                    
#define dp_tclECNR_CP_FTIME_SWB       dp_tclDPAID_DatasetEcnrDataEcnrCpFacetimeSWB      
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpFacetimeSWB      ",
#else 
#define dp_tclECNR_CP_FTIME_SWB       dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB",
#endif
        .dp_idx         = ECNR_DP_CP_FTIME_SWB                    
    },
    {
#ifdef     ECNR_AA_VOICE_NB                        
#define dp_tclECNR_AA_VOICE_NB        dp_tclDPAID_DatasetEcnrDataEcnrAaVoiceNB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrAaVoiceNB          ",
#else 
#define dp_tclECNR_AA_VOICE_NB        dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB",
#endif
        .dp_idx         = ECNR_DP_AA_VOICE_NB                     
    },
    {
#ifdef     ECNR_AA_VOICE_WB                        
#define dp_tclECNR_AA_VOICE_WB        dp_tclDPAID_DatasetEcnrDataEcnrAaVoiceWB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrAaVoiceWB          ",
#else 
#define dp_tclECNR_AA_VOICE_WB        dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB",
#endif
        .dp_idx         = ECNR_DP_AA_VOICE_WB                     
    },
    {
#ifdef     ECNR_AA_VOICE_SWB                       
#define dp_tclECNR_AA_VOICE_SWB       dp_tclDPAID_DatasetEcnrDataEcnrAaVoiceSWB         
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrAaVoiceSWB         ",
#else 
#define dp_tclECNR_AA_VOICE_SWB       dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB",
#endif
        .dp_idx         = ECNR_DP_AA_VOICE_SWB                    
    },
    {
#ifdef     ECNR_AA_PHONE_NB                        
#define dp_tclECNR_AA_PHONE_NB        dp_tclDPAID_DatasetEcnrDataEcnrAaPhoneNB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrAaPhoneNB          ",
#else 
#define dp_tclECNR_AA_PHONE_NB        dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneNB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtPhoneNB",
#endif
        .dp_idx         = ECNR_DP_AA_PHONE_NB                     
    },
    {
#ifdef     ECNR_AA_PHONE_WB                        
#define dp_tclECNR_AA_PHONE_WB        dp_tclDPAID_DatasetEcnrDataEcnrAaPhoneWB          
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrAaPhoneWB          ",
#else 
#define dp_tclECNR_AA_PHONE_WB        dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneWB",
#endif
        .dp_idx         = ECNR_DP_AA_PHONE_WB                     
    },
    {
#ifdef     ECNR_AA_PHONE_SWB                       
#define dp_tclECNR_AA_PHONE_SWB       dp_tclDPAID_DatasetEcnrDataEcnrAaPhoneSWB         
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrAaPhoneSWB         ",
#else 
#define dp_tclECNR_AA_PHONE_SWB       dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrCpPhoneWB",
#endif
        .dp_idx         = ECNR_DP_AA_PHONE_SWB                    
    },
    {
#ifdef     ECNR_INT_VOICE_NB                       
#define dp_tclECNR_INT_VOICE_NB       dp_tclDPAID_DatasetEcnrDataEcnrIntVoiceNB         
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrIntVoiceNB         ",
#else 
#define dp_tclECNR_INT_VOICE_NB       dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceNB",
#endif
        .dp_idx         = ECNR_DP_INT_VOICE_NB                    
    },
    {
#ifdef     ECNR_INT_VOICE_WB                       
#define dp_tclECNR_INT_VOICE_WB       dp_tclDPAID_DatasetEcnrDataEcnrIntVoiceWB         
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrIntVoiceWB         ",
#else 
#define dp_tclECNR_INT_VOICE_WB       dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB",
#endif
        .dp_idx         = ECNR_DP_INT_VOICE_WB                    
    },
    {
#ifdef     ECNR_WUW_VOICE_WB
#define dp_tclECNR_WUW_VOICE_WB       dp_tclDPAID_DatasetEcnrDataEcnrWuwVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrWuwVoiceWB         ",
#else
#define dp_tclECNR_WUW_VOICE_WB       dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB",
#endif
        .dp_idx         = ECNR_DP_WUW_VOICE_WB
    },
    {
#ifdef     ECNR_VPA_VOICE_WB                       
#define dp_tclECNR_VPA_VOICE_WB       dp_tclDPAID_DatasetEcnrDataEcnrVpaVoiceWB         
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrVpaVoiceWB         ",
#else 
#define dp_tclECNR_VPA_VOICE_WB       dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB
        .dp_class_name  = "dp_tclDPAID_DatasetEcnrDataEcnrBtVoiceWB",
#endif
        .dp_idx         = ECNR_DP_VPA_VOICE_WB                    
    },
    {
        .dp_class_name  = NULL,
        .dp_idx         = ECNR_DP_LAST
    }
};

#else // ECNR_S_IMPORT_INTERFACE_DP_ONLY

#define CONFIG_CLASS_MASK                       0xF000                                                                          
#define CONFIG_TYPE_MASK                        0x0F00                                                                          
#define CONFIG_FEATURE_MASK                     0x00F0                                                                          
#define CONFIG_INSTANCE_MASK                    0x000F                                                                          

#define CONFIG_TYPE_FILE                        1                                                                               
#define CONFIG_TYPE_SET_FCT                     2                                                                               
#define CONFIG_TYPE_TABLE                       3                                                                               
#define CONFIG_TYPE_KDS                         4                                                                               
#define CONFIG_TYPE_DP                          5                                                                               

#define CONFIG_FEATURE_NA                       0                                                                               
#define CONFIG_FEATURE_NB                       1                                                                               
#define CONFIG_FEATURE_WB                       2                                                                               
#define CONFIG_FEATURE_SWB                      3                                                                               
#define CONFIG_FEATURE_IOCTRL_SEL               4                                                                               
#define CONFIG_FEATURE_DUP_STREAM               8                                                                               
#define CONFIG_FEATURE_IOCTRL_ONLY              (CONFIG_FEATURE_NA | CONFIG_FEATURE_IOCTRL_SEL)                                 
#define CONFIG_FEATURE_NB_IOCTRL                (CONFIG_FEATURE_NB | CONFIG_FEATURE_IOCTRL_SEL)                                 
#define CONFIG_FEATURE_WB_IOCTRL                (CONFIG_FEATURE_WB | CONFIG_FEATURE_IOCTRL_SEL)                                 
#define CONFIG_FEATURE_SWB_IOCTRL               (CONFIG_FEATURE_SWB | CONFIG_FEATURE_IOCTRL_SEL)                                
#define CONFIG_FEATURE_DUPSTR_ONLY              (CONFIG_FEATURE_NA | CONFIG_FEATURE_IOCTRL_SEL | CONFIG_FEATURE_DUP_STREAM)     
#define CONFIG_FEATURE_NB_DUPSTR                (CONFIG_FEATURE_NB | CONFIG_FEATURE_DUP_STREAM)                                 
#define CONFIG_FEATURE_WB_DUPSTR                (CONFIG_FEATURE_WB | CONFIG_FEATURE_DUP_STREAM)                                 
#define CONFIG_FEATURE_SWB_DUPSTR               (CONFIG_FEATURE_SWB | CONFIG_FEATURE_DUP_STREAM)                                
#define CONFIG_FEATURE_NB_IOCTRL_DUPSTR         (CONFIG_FEATURE_NB | CONFIG_FEATURE_IOCTRL_SEL | CONFIG_FEATURE_DUP_STREAM)     
#define CONFIG_FEATURE_WB_IOCTRL_DUPSTR         (CONFIG_FEATURE_WB | CONFIG_FEATURE_IOCTRL_SEL | CONFIG_FEATURE_DUP_STREAM)     
#define CONFIG_FEATURE_SWB_IOCTRL_DUPSTR        (CONFIG_FEATURE_SWB | CONFIG_FEATURE_IOCTRL_SEL | CONFIG_FEATURE_DUP_STREAM)    

#define MAKE_US_CLASS(class)                    (( unsigned short)(class) << 12 )                                               
#define MAKE_US_TYPE(type)                      (( unsigned short)(type)  << 8  )                                               
#define MAKE_US_FEATURE(feature)                (( unsigned short)(feature)   << 4  )                                           
#define MAKE_US_INSTANCE(inst)                  (( unsigned short)(inst))                                                       

#define GET_U8_CONFIG_CLASS(cfgid)              ((guint8)((cfgid & CONFIG_CLASS_MASK ) >> 12))                                  
#define GET_U8_CONFIG_TYPE(cfgid)               ((guint8)((cfgid & CONFIG_TYPE_MASK ) >> 8))                                    
#define GET_U8_CONFIG_FEATURE(cfgid)            ((guint8)((cfgid & CONFIG_FEATURE_MASK ) >> 4))                                 
#define GET_U8_CONFIG_INSTANCE(cfgid)           ((guint8)(cfgid & CONFIG_INSTANCE_MASK ))                                       

// ECNR  audio device configuration define
#define DEV_OPEN_ORDER_1                        1                                                                               
#define DEV_OPEN_ORDER_2                        2                                                                               
#define DEV_OPEN_ORDER_3                        3                                                                               
#define DEV_OPEN_ORDER_4                        4                                                                               
#define DEV_OPEN_ORDER_5                        5                                                                               
#define DEV_FRAME_SHIFT_64                      64                                                                              
#define DEV_FRAME_SHIFT_128                     128                                                                             
#define DEV_FRAME_SHIFT_256                     256                                                                             
#define DEV_SAMPLE_RATE_8000_HZ                 8000                                                                            
#define DEV_SAMPLE_RATE_16000_HZ                16000                                                                           
#define DEV_SAMPLE_RATE_24000_HZ                24000                                                                           
#define DEV_PREFILL_0_MS                        0                                                                               
#define DEV_PREFILL_2_MS                        2                                                                               
#define DEV_PREFILL_4_MS                        4                                                                               
#define DEV_PREFILL_8_MS                        8                                                                               
#define DEV_PREFILL_10_MS                       10                                                                              
#define DEV_PREFILL_16_MS                       16                                                                              
#define DEV_PREFILL_24_MS                       24                                                                              
#define DEV_PERIOD_8_MS                         8                                                                               
#define DEV_PERIOD_10_MS                        10                                                                              
#define DEV_PERIOD_16_MS                        16                                                                              
#define DEV_NUM_CHANNEL_1                       1                                                                               
#define DEV_NUM_CHANNEL_2                       2                                                                               
#define DEV_NUM_CHANNEL_3                       3                                                                               
#define DEV_ACT_CHANNEL_0                       0                                                                               
#define DEV_ACT_CHANNEL_1                       1                                                                               
#define DEV_ACT_CHANNEL_2                       2                                                                               
#define DEV_ACT_CHANNEL_3                       3                                                                               
#define DEV_DEFAULT_TRUE                        TRUE                                                                            
#define DEV_DEFAULT_FALSE                       FALSE                                                                           
#define CONF_DEL_ON_POWER_ON_TRUE               TRUE                                                                            
#define CONF_DEL_ON_POWER_ON_FALSE              FALSE                                                                           
#define FEATURE_SET_DEVICE_TRUE                 TRUE                                                                            
#define FEATURE_SET_DEVICE_FALSE                FALSE                                                                           
#define FEATURE_SET_PREFILL_TRUE                TRUE                                                                            
#define FEATURE_SET_PREFILL_FALSE               FALSE                                                                           
#define FEATURE_SYNC_INFOS_TRUE                 TRUE                                                                            
#define FEATURE_SYNC_INFOS_FALSE                FALSE                                                                           
#define IO_LEVEL_NA                             FALSE                                                                           
#define IO_LEVEL_OPEN                           FALSE                                                                           
#define IO_LEVEL_GND                            TRUE                                                                            
#define IO_GPIO_SELECT_NA                       (int)0                                                                          
#define IO_GPIO_SELECT_92                       (int)92                                                                         

#define CONFIG_CLASS_BT_PHONE         1         
#define CONFIG_CLASS_BT_VOICE         2         
#define CONFIG_CLASS_BT_SIRI          3         
#define CONFIG_CLASS_SPI_CP_PHONE     4         
#define CONFIG_CLASS_SPI_CP_VOICE     5         
#define CONFIG_CLASS_SPI_CP_FACETIME  6         
#define CONFIG_CLASS_SPI_AA_VOICE     7         
#define CONFIG_CLASS_SPI_AA_PHONE     8         
#define CONFIG_CLASS_SDS_VOICE        9         
#define CONFIG_CLASS_WEB_VPA_VOICE    10        
#define CONFIG_CLASS_TEST_PHONE       11        
                  
#define CONFIG_INSTANCE_1             1         
#define CONFIG_INSTANCE_2             2         
#define CONFIG_INSTANCE_3             3         
#define CONFIG_INSTANCE_4             4         
#define CONFIG_INSTANCE_5             5         
                  
/* Definition of the ECNR configuration IDs */                  
#define SSE_CONFIG_BT_PHONE_NB_FROM_FILE            (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_PHONE_NB_FROM_FILE_01         (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_PHONE_NB_FROM_FILE_02         (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_PHONE_NB_FROM_FILE_03         (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_PHONE_NB_FROM_FILE_04         (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_PHONE_NB_FROM_FCT_01          (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_PHONE_WB_FROM_FILE            (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_PHONE_WB_FROM_FILE_01         (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_PHONE_WB_FROM_FILE_02         (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_PHONE_WB_FROM_FILE_03         (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_PHONE_WB_FROM_FILE_04         (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_PHONE_WB_FROM_FCT_01          (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_VOICE_NB_FROM_FILE            (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_VOICE_NB_FROM_FILE_01         (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_VOICE_NB_FROM_FILE_02         (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_VOICE_NB_FROM_FILE_03         (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_VOICE_NB_FROM_FILE_04         (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_VOICE_NB_FROM_FCT_01          (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_VOICE_WB_FROM_FILE            (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_VOICE_WB_FROM_FILE_01         (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_VOICE_WB_FROM_FILE_02         (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_VOICE_WB_FROM_FILE_03         (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_VOICE_WB_FROM_FILE_04         (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_VOICE_WB_FROM_FCT_01          (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_SIRI_NB_FROM_FILE             (MAKE_US_CLASS(CONFIG_CLASS_BT_SIRI)          | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_SIRI_NB_FROM_FILE_01          (MAKE_US_CLASS(CONFIG_CLASS_BT_SIRI)          | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_SIRI_NB_FROM_FCT_01           (MAKE_US_CLASS(CONFIG_CLASS_BT_SIRI)          | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_SIRI_WB_FROM_FILE             (MAKE_US_CLASS(CONFIG_CLASS_BT_SIRI)          | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_SIRI_WB_FROM_FILE_01          (MAKE_US_CLASS(CONFIG_CLASS_BT_SIRI)          | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_SIRI_WB_FROM_FILE_02          (MAKE_US_CLASS(CONFIG_CLASS_BT_SIRI)          | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_BT_SIRI_WB_FROM_FILE_03          (MAKE_US_CLASS(CONFIG_CLASS_BT_SIRI)          | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_SIRI_WB_FROM_FILE_04          (MAKE_US_CLASS(CONFIG_CLASS_BT_SIRI)          | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_BT_SIRI_WB_FROM_FCT_01           (MAKE_US_CLASS(CONFIG_CLASS_BT_SIRI)          | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE        (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_02     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_3)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_03     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_04     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_05     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_4)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_06     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_5)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_07     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_08     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FCT_01      (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE        (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_02     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_3)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_03     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_04     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_05     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_4)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_06     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_5)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_07     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_08     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FCT_01      (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_PHONE_SWB_FROM_FILE       (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_PHONE_SWB_FROM_FILE_01    (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_PHONE_SWB_FROM_FCT_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_VOICE_NB_FROM_FILE        (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_VOICE_NB_FROM_FILE_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_VOICE_NB_FROM_FILE_02     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_3)     )
#define SSE_CONFIG_SPI_CP_VOICE_NB_FROM_FILE_03     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_4)     )
#define SSE_CONFIG_SPI_CP_VOICE_NB_FROM_FCT_01      (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE        (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_02     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_03     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_3)     )
#define SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_04     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_4)     )
#define SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_05     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_5)     )
#define SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_07     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_08     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FCT_01      (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_VOICE_SWB_FROM_FILE       (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_VOICE_SWB_FROM_FILE_01    (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_VOICE_SWB_FROM_FILE_02    (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB_IOCTRL)   | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_VOICE_SWB_FROM_FCT_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_FACETIME_SWB_FROM_FILE    (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_FACETIME)  | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_FACETIME_SWB_FROM_FILE_01 (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_FACETIME)  | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_FACETIME_SWB_FROM_FILE_02 (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_FACETIME)  | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB_IOCTRL)   | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_CP_FACETIME_SWB_FROM_FILE_03 (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_FACETIME)  | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB_IOCTRL)   | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_FACETIME_SWB_FROM_FILE_04 (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_FACETIME)  | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB_IOCTRL)   | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_CP_FACETIME_SWB_FROM_FCT_01  (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_FACETIME)  | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_VOICE_NB_FROM_FILE        (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_VOICE_NB_FROM_FILE_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_AA_VOICE_NB_FROM_FCT_01      (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE        (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_02     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_3)     )
#define SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_03     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_04     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_4)     )
#define SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_05     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_06     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_3)     )
#define SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_07     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_3)     )
#define SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FCT_01      (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_AA_VOICE_SWB_FROM_FILE       (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_VOICE_SWB_FROM_FILE_01    (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_AA_VOICE_SWB_FROM_FCT_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_PHONE_NB_FROM_FILE        (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_PHONE_NB_FROM_FILE_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_AA_PHONE_NB_FROM_FCT_01      (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_PHONE_WB_FROM_FILE        (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_PHONE_WB_FROM_FILE_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_AA_PHONE_WB_FROM_FCT_01      (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_PHONE_SWB_FROM_FILE       (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_SPI_AA_PHONE_SWB_FROM_FILE_01    (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_SPI_AA_PHONE_SWB_FROM_FCT_01     (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_SWB)          | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_INT_VOICE_NB_FROM_FILE           (MAKE_US_CLASS(CONFIG_CLASS_SDS_VOICE)        | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_INT_VOICE_NB_FROM_FILE_01        (MAKE_US_CLASS(CONFIG_CLASS_SDS_VOICE)        | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_INT_VOICE_WB_FROM_FILE           (MAKE_US_CLASS(CONFIG_CLASS_SDS_VOICE)        | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_INT_VOICE_WB_FROM_FILE_01        (MAKE_US_CLASS(CONFIG_CLASS_SDS_VOICE)        | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define SSE_CONFIG_INT_VOICE_WB_FROM_FILE_02        (MAKE_US_CLASS(CONFIG_CLASS_SDS_VOICE)        | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_INT_VOICE_WB_FROM_FILE_03        (MAKE_US_CLASS(CONFIG_CLASS_SDS_VOICE)        | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB_IOCTRL)    | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_INT_VOICE_WB_FROM_FCT_01         (MAKE_US_CLASS(CONFIG_CLASS_SDS_VOICE)        | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_WEB_VPA_VOICE_WB_FROM_FILE       (MAKE_US_CLASS(CONFIG_CLASS_WEB_VPA_VOICE)    | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_WEB_VPA_VOICE_WB_FROM_FILE_01    (MAKE_US_CLASS(CONFIG_CLASS_WEB_VPA_VOICE)    | MAKE_US_TYPE(CONFIG_TYPE_FILE)           | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_2)     )
#define QWA_CONFIG_BT_PHONE_NB_FROM_FCT             (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define QWA_CONFIG_BT_PHONE_WB_FROM_FCT             (MAKE_US_CLASS(CONFIG_CLASS_BT_PHONE)         | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define QWA_CONFIG_BT_VOICE_NB_FROM_FCT             (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define QWA_CONFIG_BT_VOICE_WB_FROM_FCT             (MAKE_US_CLASS(CONFIG_CLASS_BT_VOICE)         | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define QWA_CONFIG_SPI_CP_PHONE_NB_FROM_FCT         (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define QWA_CONFIG_SPI_CP_PHONE_WB_FROM_FCT         (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_PHONE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define QWA_CONFIG_SPI_CP_VOICE_NB_FROM_FCT         (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define QWA_CONFIG_SPI_CP_VOICE_WB_FROM_FCT         (MAKE_US_CLASS(CONFIG_CLASS_SPI_CP_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define QWA_CONFIG_SPI_AA_VOICE_WB_FROM_FCT         (MAKE_US_CLASS(CONFIG_CLASS_SPI_AA_VOICE)     | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_WB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define QWA_CONFIG_TEST_PHONE_NB_FROM_FCT           (MAKE_US_CLASS(CONFIG_CLASS_TEST_PHONE)       | MAKE_US_TYPE(CONFIG_TYPE_SET_FCT)        | MAKE_US_FEATURE(CONFIG_FEATURE_NB)           | MAKE_US_INSTANCE(CONFIG_INSTANCE_1)     )
#define SSE_CONFIG_NA                               0

/* set data function */
                  
/* binary bsd table */
static unsigned char config_data_bt_phone_nb_default_04[]={ECNR_BT_PHONE_NB};                                            
static unsigned char config_data_bt_phone_wb_default_04[]={ECNR_BT_PHONE_WB};                                            
static unsigned char config_data_bt_voice_nb_default_04[]={ECNR_BT_VOICE_NB};                                            
static unsigned char config_data_bt_voice_wb_default_04[]={ECNR_BT_VOICE_WB};                                            
static unsigned char config_data_bt_siri_wb_default_04[]={ECNR_BT_SIRI_WB};                                              
static unsigned char config_data_cp_phone_nb_default_08[]={ECNR_CP_PHONE_NB};                                            
static unsigned char config_data_cp_phone_wb_default_08[]={ECNR_CP_PHONE_WB};                                            
static unsigned char config_data_cp_siri_wb_default_06[]={ECNR_CP_VOICE_WB};                                             
static unsigned char config_data_cp_ftime_swb_default_04[]={ECNR_CP_FACETIME_SWB};                                       
static unsigned char config_data_aa_voice_wb_default_06[]={ECNR_AA_VOICE_WB};                                            
                  
/* table of configuration */
static const struct EcnrConfig ECNR_CONFIG_table[] = {
   {SSE_CONFIG_BT_PHONE_NB_FROM_FILE_04               , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_phone_nb.bsd"                 , "ecnr_bt_phone_nb.txt"                            , NULL                                                                            , NULL                                                                            , {config_data_bt_phone_nb_default_04, sizeof(config_data_bt_phone_nb_default_04)/sizeof(unsigned char)}        , 0       , ECNR_DP_BT_PHONE_NB                     }, 
   {SSE_CONFIG_BT_PHONE_WB_FROM_FILE_04               , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_phone_wb.bsd"                 , "ecnr_bt_phone_wb.txt"                            , NULL                                                                            , NULL                                                                            , {config_data_bt_phone_wb_default_04, sizeof(config_data_bt_phone_wb_default_04)/sizeof(unsigned char)}        , 0       , ECNR_DP_BT_PHONE_WB                     }, 
   {SSE_CONFIG_BT_VOICE_NB_FROM_FILE_04               , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_voice_nb.bsd"                 , "ecnr_bt_voice_nb.txt"                            , NULL                                                                            , NULL                                                                            , {config_data_bt_voice_nb_default_04, sizeof(config_data_bt_voice_nb_default_04)/sizeof(unsigned char)}        , 0       , ECNR_DP_BT_VOICE_NB                     }, 
   {SSE_CONFIG_BT_VOICE_WB_FROM_FILE_04               , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_voice_wb.bsd"                 , "ecnr_bt_voice_wb.txt"                            , NULL                                                                            , NULL                                                                            , {config_data_bt_voice_wb_default_04, sizeof(config_data_bt_voice_wb_default_04)/sizeof(unsigned char)}        , 0       , ECNR_DP_BT_VOICE_WB                     }, 
   {SSE_CONFIG_BT_SIRI_WB_FROM_FILE_04                , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_siri_wb.bsd"                  , "ecnr_bt_siri_wb.txt"                             , NULL                                                                            , NULL                                                                            , {config_data_bt_siri_wb_default_04, sizeof(config_data_bt_siri_wb_default_04)/sizeof(unsigned char)}          , 0       , ECNR_DP_BT_SIRI_WB                      }, 
   {SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_08           , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_cp_phone_nb.bsd"                 , "ecnr_cp_phone_nb.txt"                            , NULL                                                                            , NULL                                                                            , {config_data_cp_phone_nb_default_08, sizeof(config_data_cp_phone_nb_default_08)/sizeof(unsigned char)}        , 0       , ECNR_DP_CP_PHONE_NB                     }, 
   {SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_08           , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_cp_phone_wb.bsd"                 , "ecnr_cp_phone_wb.txt"                            , NULL                                                                            , NULL                                                                            , {config_data_cp_phone_wb_default_08, sizeof(config_data_cp_phone_wb_default_08)/sizeof(unsigned char)}        , 0       , ECNR_DP_CP_PHONE_WB                     }, 
   {SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_08           , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_cp_siri_wb.bsd"                  , "ecnr_cp_siri_wb.txt"                             , NULL                                                                            , NULL                                                                            , {config_data_cp_siri_wb_default_06, sizeof(config_data_cp_siri_wb_default_06)/sizeof(unsigned char)}          , 0       , ECNR_DP_CP_VOICE_WB                     }, 
   {SSE_CONFIG_SPI_CP_FACETIME_SWB_FROM_FILE_04       , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_cp_ftime_swb.bsd"                , "ecnr_cp_facetime_swb.txt"                        , NULL                                                                            , NULL                                                                            , {config_data_cp_ftime_swb_default_04, sizeof(config_data_cp_ftime_swb_default_04)/sizeof(unsigned char)}      , 0       , ECNR_DP_CP_FTIME_SWB                    }, 
   {SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_07           , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_aa_voice_wb.bsd"                 , "ecnr_aa_voice_wb.txt"                            , NULL                                                                            , NULL                                                                            , {config_data_aa_voice_wb_default_06, sizeof(config_data_aa_voice_wb_default_06)/sizeof(unsigned char)}        , 0       , ECNR_DP_AA_VOICE_WB                     }, 
};
                  
                  
/* table of file configuration */
static const struct EcnrConfigFile ECNR_CONFIG_FILE_table[] = {
   {ECNR_DP_BT_PHONE_NB                     , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_phone_nb.bsd"                 , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_BT_PHONE_WB                     , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_phone_wb.bsd"                 , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_BT_VOICE_NB                     , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_voice_nb.bsd"                 , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_BT_VOICE_WB                     , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_voice_wb.bsd"                 , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_BT_SIRI_WB                      , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_bt_siri_wb.bsd"                  , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_CP_PHONE_NB                     , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_cp_phone_nb.bsd"                 , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_CP_PHONE_WB                     , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_cp_phone_wb.bsd"                 , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_CP_VOICE_WB                     , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_cp_siri_wb.bsd"                  , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_CP_FTIME_SWB                    , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_cp_ftime_swb.bsd"                , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_AA_VOICE_WB                     , "/var/opt/bosch/dynamic/audiomanager/ecnr/ecnr_aa_voice_wb.bsd"                 , CONF_DEL_ON_POWER_ON_FALSE    , 4092      , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }, 
   {ECNR_DP_NOT_DEF                         , NULL                                                                            , CONF_DEL_ON_POWER_ON_FALSE    , 0         , IO_GPIO_SELECT_NA   , IO_LEVEL_NA         }  
};
                  

/*------------------------------------*/
/*    device configuration section    */
/*------------------------------------*/
#define FEATURE_CFG_MAX               10                                      

static const struct ecnr_id_spec_feature ECNR_FEATURE_CONF_table[FEATURE_CFG_MAX] =
{
    {
        SSE_CONFIG_BT_PHONE_NB_FROM_FILE_04               ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevBTPhoneTxOut"            ,ECNR_MIC_OUT                  },
                {"AdevBTPhoneRxIn"             ,ECNR_RECV_IN                  },
                {"AdevMicro12AmpRef"           ,ECNR_MULTI_CHAN_IN_DEV        },
                {"AdevVoiceOut"                ,ECNR_RECV_OUT                 },
                {NULL                          ,0                             }
            }
        }
    },
    {
        SSE_CONFIG_BT_PHONE_WB_FROM_FILE_04               ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevBTPhoneTxOut"            ,ECNR_MIC_OUT                  },
                {"AdevBTPhoneRxIn"             ,ECNR_RECV_IN                  },
                {"AdevMicro12AmpRef"           ,ECNR_MULTI_CHAN_IN_DEV        },
                {"AdevVoiceOut"                ,ECNR_RECV_OUT                 },
                {NULL                          ,0                             }
            }
        }
    },
    {
        SSE_CONFIG_BT_VOICE_NB_FROM_FILE_04               ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevBTPhoneTxOut"            ,ECNR_MIC_OUT                  },
                {"AdevBTPhoneRxIn"             ,ECNR_RECV_IN                  },
                {"AdevMicro12AmpRef"           ,ECNR_MULTI_CHAN_IN_DEV        },
                {"AdevVoiceOut"                ,ECNR_RECV_OUT                 },
                {NULL                          ,0                             }
            }
        }
    },
    {
        SSE_CONFIG_BT_VOICE_WB_FROM_FILE_04               ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevBTPhoneTxOut"            ,ECNR_MIC_OUT                  },
                {"AdevBTPhoneRxIn"             ,ECNR_RECV_IN                  },
                {"AdevMicro12AmpRef"           ,ECNR_MULTI_CHAN_IN_DEV        },
                {"AdevVoiceOut"                ,ECNR_RECV_OUT                 },
                {NULL                          ,0                             }
            }
        }
    },
    {
        SSE_CONFIG_BT_SIRI_WB_FROM_FILE_04                ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevBTPhoneTxOut"            ,ECNR_MIC_OUT                  },
                {"AdevBTPhoneRxIn"             ,ECNR_RECV_IN                  },
                {"AdevMicro12AmpRef"           ,ECNR_MULTI_CHAN_IN_DEV        },
                {"AdevVoiceOut"                ,ECNR_RECV_OUT                 },
                {NULL                          ,0                             }
            }
        }
    },
    {
        SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_08           ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevECNRInOut"               ,ECNR_MIC_OUT                  },
                {"AdevECNRInOut"               ,ECNR_RECV_IN                  },
                {"AdevMicro12AmpRef"           ,ECNR_MULTI_CHAN_IN_DEV        },
                {"AdevVoiceOut"                ,ECNR_RECV_OUT                 },
                {NULL                          ,0                             }
            }
        }
    },
    {
        SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_08           ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevECNRInOut"               ,ECNR_MIC_OUT                  },
                {"AdevECNRInOut"               ,ECNR_RECV_IN                  },
                {"AdevMicro12AmpRef"           ,ECNR_MULTI_CHAN_IN_DEV        },
                {"AdevVoiceOut"                ,ECNR_RECV_OUT                 },
                {NULL                          ,0                             }
            }
        }
    },
    {
        SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_08           ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevECNRInOut"               ,ECNR_MIC_OUT                  },
                {"AdevECNRInOut"               ,ECNR_RECV_IN                  },
                {"AdevMicro12AmpRef"           ,ECNR_MULTI_CHAN_IN_DEV        },
                {"AdevAcousticoutSpeech"       ,ECNR_RECV_OUT                 },
                {NULL                          ,0                             }
            }
        }
    },
    {
        SSE_CONFIG_SPI_CP_FACETIME_SWB_FROM_FILE_04       ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevECNRInOut"               ,ECNR_MIC_OUT                  },
                {"AdevECNRInOut"               ,ECNR_RECV_IN                  },
                {"AdevMicro12AmpRef"           ,ECNR_MULTI_CHAN_IN_DEV        },
                {"AdevAcousticoutSpeech"       ,ECNR_RECV_OUT                 },
                {NULL                          ,0                             }
            }
        }
    },
    {
        SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_07           ,
        {
            FEATURE_SET_DEVICE_TRUE       ,
            FEATURE_SET_PREFILL_TRUE      ,
            FEATURE_SYNC_INFOS_FALSE      ,
            DEV_PREFILL_16_MS             ,
            DEV_PERIOD_16_MS              ,
            {
                {"AdevECNRInOut_16"            ,ECNR_MIC_OUT                  },
                {"AdevMicro12AmpRef"           ,ECNR_MIC_IN0                  },
                {NULL                          ,0                             }
            }
        }
    }
};
                  
 
/*------------------------------*/
/*    ecnr user section         */
/*------------------------------*/
 
/* User Application Id */ 
#define ECNR_APPID_NA                           (unsigned char) 0                                 
#define ECNR_APPID_PHONE                        (unsigned char) 1                                 
#define ECNR_APPID_SPI                          (unsigned char) 2                                 
#define ECNR_APPID_SDS                          (unsigned char) 3                                 
#define ECNR_APPID_TEST                         (unsigned char) 4                                 
#define ECNR_APPID_WEB                          (unsigned char) 5                                 
 
#define ECNR_CFG_ID_NA                          (unsigned short) 0xFFFF                           
#define ECNR_CFG_ID_TABLE_SIZE                  (unsigned short) 12                               
 
#define PHONE_DATASET_1                         (unsigned short) 1                                
#define PHONE_DATASET_2                         (unsigned short) 2                                
#define PHONE_DATASET_3                         (unsigned short) 3                                
#define PHONE_DATASET_4                         (unsigned short) 4                                
#define PHONE_DATASET_6                         (unsigned short) 6                                
#define SPI_DATASET_1                           (unsigned short) 201                              
#define SPI_DATASET_2                           (unsigned short) 202                              
#define SPI_DATASET_4                           (unsigned short) 204                              
#define SPI_DATASET_5                           (unsigned short) 205                              
#define SPI_DATASET_7                           (unsigned short) 207                              
#define SPI_DATASET_20                          (unsigned short) 220                              
#define TEST_DATASET_1                          (unsigned short) 601                              
 
static const struct EcnrAppIds ECNR_USER_CONF_table[ECNR_CFG_ID_TABLE_SIZE] =
{ 
    // PHONE, offset 0                                                                              
   {ECNR_APPID_PHONE    , PHONE_DATASET_1     , SSE_CONFIG_BT_PHONE_NB_FROM_FILE_04               },
   {ECNR_APPID_PHONE    , PHONE_DATASET_2     , SSE_CONFIG_BT_PHONE_WB_FROM_FILE_04               },
   {ECNR_APPID_PHONE    , PHONE_DATASET_3     , SSE_CONFIG_BT_VOICE_NB_FROM_FILE_04               },
   {ECNR_APPID_PHONE    , PHONE_DATASET_4     , SSE_CONFIG_BT_VOICE_WB_FROM_FILE_04               },
   {ECNR_APPID_PHONE    , PHONE_DATASET_6     , SSE_CONFIG_BT_SIRI_WB_FROM_FILE_04                },
 
    // SPI, offset 200                                                                              
   {ECNR_APPID_SPI      , SPI_DATASET_1       , SSE_CONFIG_SPI_CP_PHONE_NB_FROM_FILE_08           },
   {ECNR_APPID_SPI      , SPI_DATASET_2       , SSE_CONFIG_SPI_CP_PHONE_WB_FROM_FILE_08           },
   {ECNR_APPID_SPI      , SPI_DATASET_4       , SSE_CONFIG_SPI_CP_VOICE_WB_FROM_FILE_08           },
   {ECNR_APPID_SPI      , SPI_DATASET_5       , SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_07           },
   {ECNR_APPID_SPI      , SPI_DATASET_7       , SSE_CONFIG_SPI_CP_FACETIME_SWB_FROM_FILE_04       },
   {ECNR_APPID_SPI      , SPI_DATASET_20      , SSE_CONFIG_SPI_AA_VOICE_WB_FROM_FILE_07           },
 
    // TEST, offset 600                                                                             
   {ECNR_APPID_TEST     , TEST_DATASET_1      , SSE_CONFIG_BT_PHONE_NB_FROM_FILE_04               },
 
};

/*---------------------------------*/
/*    rts configuration section    */
/*---------------------------------*/
#define DEV_CFG_MAX                   17                                      
#define STREAM_CFG_MAX                3                                       

static const struct ecnr_rts_stream_cfg ECNR_RTS_STREAM_CONF_table[STREAM_CFG_MAX] =
{
   {DEV_FRAME_SHIFT_64   ,DEV_SAMPLE_RATE_8000_HZ    ,DEV_PREFILL_8_MS  },
   {DEV_FRAME_SHIFT_256  ,DEV_SAMPLE_RATE_16000_HZ   ,DEV_PREFILL_16_MS },
   {DEV_FRAME_SHIFT_128  ,DEV_SAMPLE_RATE_16000_HZ   ,DEV_PREFILL_16_MS }
};

static const struct ecnr_rts_dev_cfg ECNR_RTS_DEV_CONF_table[DEV_CFG_MAX] =
{
   {ECNR_RECV_OUT             ,"AdevAcousticoutSpeech"            ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_3  ,DEV_DEFAULT_FALSE   },
   {ECNR_MIC_IN0              ,"AdevMicro1In"                     ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_1  ,DEV_DEFAULT_FALSE   },
   {ECNR_MULTI_CHAN_IN_DEV    ,"AdevMicro12AmpRef"                ,DEV_NUM_CHANNEL_3   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_1  ,DEV_DEFAULT_TRUE    },
   {ECNR_MULTI_CHAN_IN_MIC_0  ,"AdevMicro12AmpRef"                ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_1  ,DEV_DEFAULT_TRUE    },
   {ECNR_MULTI_CHAN_IN_MIC_1  ,"AdevMicro12AmpRef"                ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_1   ,DEV_OPEN_ORDER_1  ,DEV_DEFAULT_FALSE   },
   {ECNR_MULTI_CHAN_IN_REF_0  ,"AdevMicro12AmpRef"                ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_2   ,DEV_OPEN_ORDER_1  ,DEV_DEFAULT_TRUE    },
   {ECNR_MIC_OUT              ,"AdevMicroWithECNROut"             ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_4  ,DEV_DEFAULT_FALSE   },
   {ECNR_RECV_IN              ,"AdevECNRInOut"                    ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_4  ,DEV_DEFAULT_FALSE   },
   {ECNR_MIC_OUT              ,"AdevECNRInOut"                    ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_4  ,DEV_DEFAULT_FALSE   },
   {ECNR_RECV_IN              ,"AdevECNRInOut_8"                  ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_4  ,DEV_DEFAULT_FALSE   },
   {ECNR_MIC_OUT              ,"AdevECNRInOut_8"                  ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_4  ,DEV_DEFAULT_FALSE   },
   {ECNR_RECV_IN              ,"AdevECNRInOut_16"                 ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_4  ,DEV_DEFAULT_FALSE   },
   {ECNR_MIC_OUT              ,"AdevECNRInOut_16"                 ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_4  ,DEV_DEFAULT_FALSE   },
   {ECNR_MIC_OUT              ,"AdevECNRMicroOut"                 ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_4  ,DEV_DEFAULT_FALSE   },
   {ECNR_MIC_OUT              ,"AdevBTPhoneTxOut"                 ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_4  ,DEV_DEFAULT_TRUE    },
   {ECNR_RECV_IN              ,"AdevBTPhoneRxIn"                  ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_5  ,DEV_DEFAULT_TRUE    },
   {ECNR_RECV_OUT             ,"AdevVoiceOut"                     ,DEV_NUM_CHANNEL_1   ,DEV_ACT_CHANNEL_0   ,DEV_OPEN_ORDER_3  ,DEV_DEFAULT_TRUE    }
};
                  
#endif //ECNR_S_IMPORT_INTERFACE_DP_ONLY       
#endif //__ECNR_CONFIGURATION_DATA_H__         
