//
// CCA_TargetBase.h
//
//  Created on: Dec 19, 2014
//      Author: Martin Koch, Fa. ESE
//

#ifndef CCA_TARGETBASE_H_
#define CCA_TARGETBASE_H_


#include "CCA_Node.h"

class amt_tclServiceData;


namespace FIMessaging  { namespace CCA
{

   // --------------------------------------------------------------------------
   //
   //                    C C A - T a r g e t - B a s e
   //
   // Base class for children (Clients/Services) of App,
   // similar to ahl_tclBaseOneThreadObject
   //

   class TargetBase  : public ISender
   {
      friend class Node;  // allow access to _externalTarget

      protected:
         /* constructor */ TargetBase (Node& node, ITarget& externalTarget);

         // member variables
         Node&             _node;
         ITarget&          _externalTarget;
         tU32              _u32AppState;
      public:
         const tU16       u16OwnAppID;
         const tU16       u16OwnSubID;
         const ServiceInfo serviceInfo;

         // methods
         virtual /* destructor */ ~TargetBase ();

         virtual void vOnNewAppState (tU32 u32AppState);

         // callback function for incoming messages
         virtual void vOnNewMessage (amt_tclServiceData& oSvcData);

         // distinguish clients from services:
         virtual bool bIsService ();
   };

   // --------------------------------------------------------------------------

}  }  // namespace FIMessaging::CCA


#endif /* CCA_TARGETBASE_H_ */
