//
// CCA_TargetBase.cpp
//
//  Created on: Dec 19, 2014
//      Author: Martin Koch, Fa. ESE
//



#include "CCA_TargetBase.h"
// - - - - - - - - - - - - -

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include <etg_if.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GENIVI_CCA_NODE
#include "trcGenProj/Header/CCA_TargetBase.cpp.trc.h"



namespace FIMessaging  { namespace CCA
{

   // --------------------------------------------------------------------------
   //
   //                    I M e s s a g e - T a r g e t
   //
   // Base class for children (Clients/Services) of App
   //

   /* constructor */ TargetBase:: TargetBase (Node& node, ITarget& externalTarget)
      : ISender()
      , _node(node)
      , _externalTarget(externalTarget)
      , _u32AppState(AMT_C_U32_STATE_UNINITALIZED)
      , u16OwnAppID(node.u16GetAppId())
      , u16OwnSubID(0)
      , serviceInfo(externalTarget.GetServiceInfo())
   {
      ETG_TRACE_USR1(("CCA_TargetBase<%x, Svc %x> established"
            , u16OwnAppID, serviceInfo.u16ServiceID))
   }

   // --------------------------------------------------------------------------

   /* virtual destructor */ TargetBase:: ~TargetBase ()
   {
      ETG_TRACE_USR1(("CCA_TargetBase<%x, Svc %x> terminating ... "
            , u16OwnAppID, serviceInfo.u16ServiceID))
   }

   // --------------------------------------------------------------------------

   /* virtual */ bool TargetBase:: bIsService ()
   {
      return _externalTarget.bProvidesService();
   }

   // --------------------------------------------------------------------------

   /* virtual */ void TargetBase:: vOnNewAppState (tU32 u32AppState)
   {
      // default implementation - derived classes should override

      _u32AppState = u32AppState;
   }

   // --------------------------------------------------------------------------

   /* virtual */ void TargetBase:: vOnNewMessage (amt_tclServiceData& oSvcData)
   {
      // callback function for incoming messages

      // validate preconditions
      if (oSvcData.u16GetServiceID() != serviceInfo.u16ServiceID)
      {
         ETG_TRACE_FATAL(("CCA_TargetBase<%x, Svc %x>:: vOnNewMessage() - E R R O R : ServiceID of message %x.%x.%x from application %u does not match"
               , u16OwnAppID, serviceInfo.u16ServiceID
               , oSvcData.u16GetServiceID(), oSvcData.u16GetFunctionID(), oSvcData.u8GetOpCode()
               , oSvcData.u16GetSourceAppID()))
         return;
      }

      // check message length
      uint32_t payloadOffset = AMT_C_U32_BASEMSG_ABSMSGSIZE + AMT_C_U32_SVCDATA_RELMSGSIZE; // skip 32 byte message header
      uint8_t* pPayload = oSvcData.pu8GetSharedMemBase() + payloadOffset;
      uint32_t length = oSvcData.u32GetSize();
      if (length >= payloadOffset)
         length -= payloadOffset;
      else
      {
         ETG_TRACE_FATAL(("CCA_TargetBase<%x, Svc %x>:: vOnNewMessage() - E R R O R : ServiceData message %x.%x.%x from application %u too short"
               , u16OwnAppID, serviceInfo.u16ServiceID
               , oSvcData.u16GetServiceID(), oSvcData.u16GetFunctionID(), oSvcData.u8GetOpCode()
               , ETG_ENUM(ail_u16AppId, oSvcData.u16GetSourceAppID())))
         return;
      }

      ETG_TRACE_USR4(("CCA_TargetBase<%x, Svc %x>:: vOnNewMessage(): ServiceData message %x.%x.%x received from Application %x.%u"
               , u16OwnAppID, serviceInfo.u16ServiceID
               , oSvcData.u16GetServiceID(), oSvcData.u16GetFunctionID(), oSvcData.u8GetOpCode()
               , oSvcData.u16GetSourceAppID(), oSvcData.u16GetSourceSubID()))

      // forward to external target
      FIMessage fiMsg(serviceInfo.u16ServiceID, serviceInfo.fiVersion, oSvcData.u16GetFunctionID(), oSvcData.u8GetOpCode(), oSvcData.u8GetACT()
            , pPayload, length);
      _externalTarget.vOnNewMessage(fiMsg);
   }


}  }  // namespace FIMessaging::CCA

// =============================================================================





