//
// CCA_MessageTrackerBase.h
//
//  Created on: Jan 21, 2015
//      Author: kma4hi
//

#ifndef CCA_MESSAGETRACKERBASE_H_
#define CCA_MESSAGETRACKERBASE_H_

#include <vector>



namespace FIMessaging  { namespace CCA
{

   // ==========================================================================
   //
   //                M e s s a g e - T r a c k e r - B a s e
   //

   class MessageTrackerBase
   {
      public:
         struct PendingCall
         {
            uint16_t        u16ResponseID;
            MessageInfo     messageInfo;
            OSAL_tMSecond   invocationTime;

            /* constructor */ PendingCall (const MessageInfo& info, uint16_t respID);
         };

         typedef std::vector<PendingCall> List;
         typedef List::iterator Iterator;

         void vDumpEntries ();

//       tVoid vClearEntries();

      protected:
         const ServiceInfo serviceInfo;
         List _list;

         /* constructor */ MessageTrackerBase (const ServiceInfo& oServiceInfo);
         virtual /* destructor */ ~MessageTrackerBase ();

         void vDropOverdues ();
         uint16_t u16CreateResponseID ();
         static bool bResponseOpCodeMatchesRequest (uint8_t u8ResponseOpCode, uint8_t u8RequestOpCode);
   };

   // --------------------------------------------------------------------------

}  }  // namespace FIMessaging::CCA




#endif /* CCA_MESSAGETRACKERBASE_H_ */
