//
// CCA_Client.h
//
//  Created on: Dec 18, 2014
//      Author: Martin Koch, Fa. ESE
//

#ifndef CCA_CLIENT_H_
#define CCA_CLIENT_H_

#include "CCA_TargetBase.h"



namespace FIMessaging  { namespace CCA
{

   // --------------------------------------------------------------------------

   class Client : public TargetBase
   {
      public:
         /* constructor */ Client (Node& node, ITarget& externalTarget);
         virtual /* destructor */ ~Client ();

         tU16 u16GetRegisterID () const;

         virtual void vOnNewAppState (tU32 u32AppState);

         // callback function for incoming messages
         virtual void vOnNewMessage (amt_tclServiceData& oSvcData);

         // connection-related stuff
         void vConnectToService ();
         void vDisconnectFromService ();
//         bool bIsServiceConnected (Client& client);
         virtual void vOnAsyncRegisterConfExt (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId, tU8 u8AsyncRegisterConfStatus);
         virtual tVoid vOnServiceState (tU8 u8ServiceState);


         // ISender implementation - send outgoing message
         // - client messages (MethodStart, Get, Set, Upreg/RelUpreg)
         virtual uint16_t u16PostFICommand (const fi_tclMessageBase& fiMsg);
         // - dummy implementations
         virtual void    vSetServiceAvailable (bool bIsAvailable);
         virtual bool     bPostFIResult (const fi_tclMessageBase& fiMsg, uint16_t responseID);
         virtual bool     bNotifyClients (const fi_tclMessageBase& fiMsg);

      private:
         class MessageTracker;

         // member variables
         tU16              _u16ServerAppID;
         tU16              _u16RegID;
         bool              _bServiceAvailable;
         MessageTracker*   _pMessageTracker;

         // prohibit copy - implementation intentionally missing
         /* copy constructor */ Client (const Client&);
         Client& /* assignment */ operator= (const Client&);
   };

   // --------------------------------------------------------------------------

}  }  // namespace FIMessaging::CCA






#endif // CCA_CLIENT_H_
