//
// Types.h
//
//  Created on: Jan 22, 2015
//      Author: Martin Koch, Fa. ESE
//

#ifndef TYPES_H_
#define TYPES_H_



// trace class for this component
#define TR_CLASS_GENIVI_CCA_NODE           (TR_COMP_AUDIOSTACK + 0x06)




namespace FIMessaging
{

// --------------------------------------------------------------------------

   enum tenOpCode
   {
      enSet = 0x00,
      enGet = 0x01,
      enMethodStart = 0x02,
      enUpreg = 0x03,
      enRelUpreg = 0x04,
      enMethodAbort = 0x05,
      enStatus = 0x06,
      enMethodResult = 0x07,
      enError = 0x08,
      enAbortResult  = 0x09,
      enMethodResultFirst = 0x0A,
      enMethodResultMiddle = 0x0B,
      enMethodResultLast = 0x0C,
//      enClientPortAck = 0x0D,
//      enServerPortAck = 0x0E,
      enIncrement = 0x10,
      enDecrement = 0x11,
      enPureSet = 0x12
   };

   // --------------------------------------------------------------------------

   struct ServiceInfo
   {
      tU16 u16ServiceID;
      tFIVersionInfo fiVersion;

      // - - - - - - - - - - - -

      inline /* default constructor */ ServiceInfo ()
         : u16ServiceID(0xFFFF)
      {
         fiVersion.u16MajorVersion = 0xffff;
         fiVersion.u16MinorVersion = 0xffff;
      }

      inline /* copy constructor */ ServiceInfo (const ServiceInfo& rhs)
         : u16ServiceID(rhs.u16ServiceID)
         , fiVersion(rhs.fiVersion)
      {  }

      inline /* constructor */ ServiceInfo (tU16 svcID, tFIVersionInfo version)
         : u16ServiceID(svcID)
         , fiVersion(version)
      {  }
   };

   // --------------------------------------------------------------------------

   struct FunctionInfo
   {
      ServiceInfo service;
      tU16        u16FunctionID;
      tU8         u8OpCode;

      // - - - - - - - - - - - -

      inline /* default constructor */ FunctionInfo ()
         : service(ServiceInfo ())
         , u16FunctionID(0xffff)
         , u8OpCode(0xff)
      {  }

      inline /* copy constructor */ FunctionInfo (const FunctionInfo& rhs)
         : service(rhs.service)
         , u16FunctionID(rhs.u16FunctionID)
         , u8OpCode(rhs.u8OpCode)
      {  }

      inline /* constructor */ FunctionInfo (ServiceInfo svc, tU16 functionID, tU8 opCode)
         : service(svc)
         , u16FunctionID(functionID)
         , u8OpCode(opCode)
      {  }

      inline /* constructor */ FunctionInfo (ServiceInfo svc, tU16 functionID, tenOpCode opCode)
         : service(svc)
         , u16FunctionID(functionID)
         , u8OpCode((tU8)opCode)
      {  }

      inline /* constructor */ FunctionInfo (const fi_tclMessageBase& fiMsg, tFIVersionInfo fiVersion)
         : service(ServiceInfo (fiMsg.u16GetServiceID(), fiVersion))
         , u16FunctionID(fiMsg.u16GetFunctionID())
         , u8OpCode(fiMsg.u8GetOpCode())
      {  }
   };

   // --------------------------------------------------------------------------

}  // namespace FIMessaging


#endif /* TYPES_H_ */
