//
// Node_if.h
//
//  Created on: Jan 22, 2015
//      Author: martin Koch, Fa. ESE
//

#ifndef NODE_IF_H_
#define NODE_IF_H_


// import declaration of version struct
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include <fi_msgfw_if.h>  // implicitly links generic <osal_if.h>

// Special types to be used with this messaging system
#include "Types.h"
#include "MessageTypes.h"

// Interface services and clients (message targets) have to implement.
//
// Targets deal with FI-objects only and need no knowledge on
// underlying transportation mechanism
#include "ITarget.h"

// Targets (clients and services) obtain a pointer to an ISender instance
// when adding themselves to the node.
// They use it for their outgoing messages
#include "ISender.h"

// transportation-independent interface of messaging node / connector
#include "INode.h"

// Interface to be provided by users (Clients/Services) of INode
// in case their own intrinsic Rx-loop shall manage message polling
#include "IRxPollingThread.h"


// Specialization of INode for CCA transportation.
namespace FIMessaging
{
   namespace CCA
   {
      // All special knowledge on CCA-specifics (like AIL and SCD)
      // is encapsulated in the object returned by this factory function

      INode* pGetNodeInstance (uint16_t u16CCAApplicationID, const char* pRegistry, IRxPollingThread& externalWorkerThread);
   }


   // specialization if INode for INC transportation
   //      #include "INC_Node.h"  // t. b. d.



   // specialization if INode for dbus transportation
   //      #include "dbus_Node.h"  // t. b. d.

}


#endif /* NODE_IF_H_ */
