//
// ISender.h
//
//  Created on: Jan 22, 2015
//      Author: Martin Koch, Fa. ESE
//

#ifndef ISENDER_H_
#define ISENDER_H_

namespace FIMessaging
{

   // --------------------------------------------------------------------------
   //
   //                    I M e s s a g e - S e n d e r
   //
   // Interface provided by INode and handed over to users (Clients/Services)
   // as return value of poAddTarget()
   //

   /* provided interface */ class ISender
   {
      protected:
         /* constructor */ ISender ()  {}
         virtual /* destructor */ ~ISender ()  {}

      public:
         // outgoing client messages (MethodStart, Get, Set, Upreg/RelUpreg)
         virtual uint16_t u16PostFICommand (const fi_tclMessageBase& fiMsg) = 0;

         // outgoing service availability notice
         virtual void    vSetServiceAvailable (bool bIsAvailable) = 0;
         //  outgoing server responses (MethodResult, Status, Error) - must echo the responseID from command
         virtual bool     bPostFIResult (const fi_tclMessageBase& fiResultMsg, uint16_t responseID) = 0;
         //  outgoing spontaneous server notifications (Status) for registered clients
         virtual bool     bNotifyClients (const fi_tclMessageBase& fiStatusMsg) = 0;
   };

   // --------------------------------------------------------------------------


}  // namespace FIMessaging

#endif /* ISENDER_H_ */
